/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.fi.arap.billValidator.AbstractBillValidateConfigInfo;
import com.kingdee.eas.fi.arap.billValidator.CompareBillFilterEntryCollection;
import com.kingdee.eas.fi.arap.billValidator.CompareBillFilterEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.MatchFieldEntryCollection;
import com.kingdee.eas.fi.arap.billValidator.ValidateBillFilterEntryCollection;
import com.kingdee.eas.fi.arap.billValidator.ValidateBillFilterEntryInfo;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BillValidateConfigInfo
extends AbstractBillValidateConfigInfo
implements Serializable {
    public static String VAL = "valField";
    public static String COMP = "compField";
    public static String PK_FIELD = "id";

    public BillValidateConfigInfo() {
    }

    protected BillValidateConfigInfo(String pkField) {
        super(pkField);
    }

    public FilterInfo getValFilter(IObjectValue billInfo) throws BOSException {
        FilterInfo filter = new FilterInfo();
        MatchFieldEntryCollection matchEntryColl = this.getMatchFieldEntry();
        for (int i = 0; i < matchEntryColl.size(); ++i) {
            CompareType compareType;
            Object compareValue;
            String valueField = matchEntryColl.get(i).getValidateField();
            if (valueField.indexOf(".") > -1) {
                compareValue = ArApBillUtil.getFieldSetFromBill(billInfo, valueField);
                compareType = CompareType.INCLUDE;
            } else {
                compareValue = billInfo.get(valueField);
                compareType = CompareType.EQUALS;
            }
            FilterItemInfo filterItem = new FilterItemInfo(valueField, compareValue, compareType);
            filter.getFilterItems().add(filterItem);
        }
        filter.getFilterItems().add(new FilterItemInfo(billInfo.getPKField(), billInfo.get(billInfo.getPKField()), CompareType.NOTEQUALS));
        filter.setMaskString(QueryUtil.processMaskString((int)filter.getFilterItems().size(), null));
        FilterInfo exFilter = this.getValidateEntryFilter();
        if (exFilter.getFilterItems() != null && exFilter.getFilterItems().size() > 0) {
            filter.mergeFilter(exFilter, "AND");
        }
        return filter;
    }

    public FilterInfo getCompFilter(IObjectValue billInfo) throws BOSException {
        FilterInfo filter = new FilterInfo();
        MatchFieldEntryCollection matchEntryColl = this.getMatchFieldEntry();
        for (int i = 0; i < matchEntryColl.size(); ++i) {
            CompareType compareType;
            Object compareValue;
            String valueField = matchEntryColl.get(i).getValidateField();
            if (valueField.indexOf(".") > -1) {
                compareValue = ArApBillUtil.getFieldSetFromBill(billInfo, valueField);
                compareType = CompareType.INCLUDE;
            } else {
                compareValue = billInfo.get(valueField);
                compareType = CompareType.EQUALS;
            }
            FilterItemInfo filterItem = new FilterItemInfo(matchEntryColl.get(i).getCompareField(), compareValue, compareType);
            filter.getFilterItems().add(filterItem);
        }
        filter.setMaskString(QueryUtil.processMaskString((int)filter.getFilterItems().size(), null));
        CompareBillFilterEntryCollection filterEntryColl = this.getCompareBillFilterEntry();
        StringBuilder oql = new StringBuilder();
        oql.append("where ");
        for (int i = 0; i < filterEntryColl.size(); ++i) {
            CompareBillFilterEntryInfo filterEntry = filterEntryColl.get(i);
            oql.append(filterEntry.getLeftBrackets());
            oql.append(filterEntry.getField());
            oql.append(filterEntry.getCompareType().getValue());
            oql.append(filterEntry.getCompareValue());
            oql.append(filterEntry.getRightBrackets());
            oql.append(filterEntry.getLogicSign().getValue());
        }
        if (filterEntryColl.size() > 0) {
            try {
                EntityViewInfo ev = new EntityViewInfo(oql.toString());
                FilterInfo exFilter = ev.getFilter();
                filter.mergeFilter(exFilter, "AND");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return filter;
    }

    public FilterInfo getValidateEntryFilter() throws BOSException {
        FilterInfo filter = new FilterInfo();
        ValidateBillFilterEntryCollection filterEntryColl = this.getValidateBillFilterEntry();
        StringBuilder oql = new StringBuilder();
        oql.append("where ");
        for (int i = 0; i < filterEntryColl.size(); ++i) {
            ValidateBillFilterEntryInfo filterEntry = filterEntryColl.get(i);
            oql.append(filterEntry.getLeftBrackets());
            oql.append(filterEntry.getField());
            oql.append(filterEntry.getCompareType().getValue());
            oql.append(filterEntry.getCompareValue());
            oql.append(filterEntry.getRightBrackets());
            if (filterEntry.getLogicSign() == null) continue;
            oql.append(filterEntry.getLogicSign().getValue());
        }
        if (filterEntryColl.size() > 0) {
            try {
                EntityViewInfo ev = new EntityViewInfo(oql.toString());
                FilterInfo exFilter = ev.getFilter();
                return exFilter;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return filter;
    }

    public Map getValEntryPrefix(Context ctx) throws BOSException {
        PropertyInfo prop;
        String field;
        int i;
        HashMap<String, String> res = new HashMap<String, String>();
        EntityObjectInfo valEntity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)new BOSObjectType(this.getValidateBill().getValue()));
        EntityObjectInfo comEntity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)new BOSObjectType(this.getCompareBill().getValue()));
        HashSet<String> valSet = new HashSet<String>();
        HashSet<String> comSet = new HashSet<String>();
        for (i = 0; i < this.getValidateConfigEntry().size(); ++i) {
            field = this.getValidateConfigEntry().get(i).getValidateField();
            if (field.indexOf(".") > -1 && this.isEntryField(prop = valEntity.getPropertyByName(field = field.split("\\.")[0])).booleanValue()) {
                valSet.add(field);
                res.put(VAL, field);
            }
            if ((field = this.getValidateConfigEntry().get(i).getCompareField()).indexOf(".") <= -1 || !this.isEntryField(prop = comEntity.getPropertyByName(field = field.split("\\.")[0])).booleanValue()) continue;
            comSet.add(field);
            res.put(VAL, field);
        }
        for (i = 0; i < this.getMatchFieldEntry().size(); ++i) {
            field = this.getMatchFieldEntry().get(i).getValidateField();
            if (field.indexOf(".") > -1 && this.isEntryField(prop = valEntity.getPropertyByName(field = field.split("\\.")[0])).booleanValue()) {
                valSet.add(field);
                res.put(VAL, field);
            }
            if ((field = this.getMatchFieldEntry().get(i).getCompareField()).indexOf(".") <= -1 || !this.isEntryField(prop = comEntity.getPropertyByName(field = field.split("\\.")[0])).booleanValue()) continue;
            comSet.add(field);
            res.put(COMP, field);
        }
        for (i = 0; i < this.getValidateBillFilterEntry().size(); ++i) {
            field = this.getValidateBillFilterEntry().get(i).getField();
            if (field.indexOf(".") <= -1 || !this.isEntryField(prop = valEntity.getPropertyByName(field = field.split("\\.")[0])).booleanValue()) continue;
            valSet.add(field);
            res.put(VAL, field);
        }
        for (i = 0; i < this.getCompareBillFilterEntry().size(); ++i) {
            field = this.getCompareBillFilterEntry().get(i).getField();
            if (field.indexOf(".") <= -1 || !this.isEntryField(prop = valEntity.getPropertyByName(field = field.split("\\.")[0])).booleanValue()) continue;
            comSet.add(field);
            res.put(COMP, field);
        }
        if (valSet.size() > 1 || comSet.size() > 1) {
            throw new BOSException("\u4e0d\u652f\u6301\u5173\u8054\u591a\u79cd\u5206\u5f55\uff0c\u5206\u5f55\u6570\u636e\u4e0d\u76f8\u5173\u67e5\u8be2\u6709\u95ee\u9898");
        }
        return res;
    }

    private Boolean isEntryField(PropertyInfo prop) {
        CardinalityType supplierType;
        if (prop instanceof LinkPropertyInfo && ((supplierType = ((LinkPropertyInfo)prop).getRelationship().getSupplierCardinality()).equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || supplierType.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED))) {
            return true;
        }
        return false;
    }
}

