/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.arap.BosTypeEnum;
import com.kingdee.eas.fi.arap.billValidator.BillActionEnum;
import com.kingdee.eas.fi.arap.billValidator.BillValidateConfigFactory;
import com.kingdee.eas.fi.arap.billValidator.BillValidateConfigInfo;
import com.kingdee.eas.fi.arap.billValidator.CompareBillFilterEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.CompareTypeEnum;
import com.kingdee.eas.fi.arap.billValidator.MatchFieldEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.ValicateLevelEnum;
import com.kingdee.eas.fi.arap.billValidator.ValidateBillFilterEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigStatus;
import com.kingdee.eas.fi.arap.billValidator.client.AbstractBillValidateConfigEditUI;
import com.kingdee.eas.fi.arap.billValidator.client.CheckListCellRenderer;
import com.kingdee.eas.fi.arap.billValidator.client.EntityFieldSelector;
import com.kingdee.eas.fi.arap.billValidator.client.MultiSelectComboBox;
import com.kingdee.eas.fi.arap.billValidator.client.SelectEntityFieldUI;
import com.kingdee.eas.fi.arap.client.ArApClientHelper;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BillValidateConfigEditUI
extends AbstractBillValidateConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BillValidateConfigEditUI.class);
    protected EntityObjectInfo validateEntity = null;
    protected EntityObjectInfo compareEntity = null;
    private ItemListener comboCompareBillListener;
    private ItemListener comboValidateBillListener;
    private KDPromptBox comBigDecimalFieldF7 = new KDPromptBox();
    private KDPromptBox valBigDecimalFieldF7 = new KDPromptBox();
    private KDPromptBox comOtherFieldF7 = new KDPromptBox();
    private KDPromptBox valOtherFieldF7 = new KDPromptBox();
    private SelectorListener bigDecimalFieldSelectorListener;
    private SelectorListener otherFieldSelectorListener;
    private MultiSelectComboBox comboBoxValPoint;
    private static String COL_CONFIG_ENTRY_VALIDATE_FIELD = "validateField";
    private static String COL_CONFIG_ENTRY_VALIDATE_NAME = "validateFieldName";
    private static String COL_CONFIG_ENTRY_COMPARE_FIELD = "compareField";
    private static String COL_CONFIG_ENTRY_COMPARE_NAME = "compareFieldName";
    private static String COL_CONFIG_ENTRY_DIFF_RANGE = "diffRange";
    private static String COL_FILTER_ENTRY_FIELD_NAME = "fieldName";
    private static String COL_FILTER_ENTRY_FIELD = "field";
    private static String COL_FILTER_ENTRY_LEFT_BRACKETS = "leftBrackets";
    private static String COL_FILTER_ENTRY_COMPARE_TYPE = "compareType";
    private static String COL_FILTER_ENTRY_RIGHT_BRACKETS = "rightBrackets";
    private static String COL_FILTER_ENTRY_LOGIC_SIGN = "logicSign";
    private static String COL_FILTER_ENTRY_ENTITY = "entity";
    private static String COL_MATCH_ENTRY_COMPARE_SIGN = "compareSign";
    private static String COL_MATCH_ENTRY_MAPPING_NULL = "isMappingNull";
    private static String SEMICOLON = ";";

    protected IObjectValue createNewData() {
        BillValidateConfigInfo config = new BillValidateConfigInfo();
        config.setOrgUnit((FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit());
        config.setStatus(ValidateConfigStatus.SAVE);
        config.setIsPreSet(false);
        config.setValidateLevel(ValicateLevelEnum.ERROR);
        config.getValidateConfigEntry().add(new ValidateConfigEntryInfo());
        config.getMatchFieldEntry().add(new MatchFieldEntryInfo());
        config.getCompareBillFilterEntry().add(new CompareBillFilterEntryInfo());
        config.getValidateBillFilterEntry().add(new ValidateBillFilterEntryInfo());
        return config;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BillValidateConfigFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void loadFields() {
        this.initBillComponent();
        this.initBillComboBox();
        this.deleteControlListener();
        super.loadFields();
        this.addControlListener();
        this.initEntityObject();
        this.initValidatePoint();
        this.afterLoadFields();
        this.actionSave.setVisible(false);
    }

    protected void afterLoadFields() {
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getValidatePointStr())) {
            String[] validatePointArr = this.editData.getValidatePointStr().split(";");
            for (int i = 0; i < validatePointArr.length; ++i) {
                if (StringUtils.isEmpty((String)validatePointArr[i])) continue;
                this.comboBoxValPoint.getSelectValueMap().put(BillActionEnum.getEnum(validatePointArr[i]), true);
            }
        }
        this.contValidatePointStr.setBoundEditor((JComponent)this.comboBoxValPoint);
        for (int i = 0; i < this.kdtMatchFieldEntry.getRowCount(); ++i) {
            this.kdtMatchFieldEntry.getCell(i, COL_MATCH_ENTRY_COMPARE_SIGN).setValue((Object)"=");
        }
        if (ValidateConfigStatus.SAVE.equals((Object)this.editData.getStatus())) {
            this.actionCancelCancel.setEnabled(true);
        } else if (ValidateConfigStatus.ENABLE.equals((Object)this.editData.getStatus())) {
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else if (ValidateConfigStatus.DISABLE.equals((Object)this.editData.getStatus())) {
            this.actionCancelCancel.setEnabled(true);
            this.actionEdit.setEnabled(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSave.setEnabled(false);
        }
    }

    protected void addControlListener() {
        if (this.comboCompareBillListener == null) {
            this.comboCompareBillListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        BillValidateConfigEditUI.this.comboBill_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        BillValidateConfigEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.comboCompareBill.addItemListener(this.comboCompareBillListener);
        if (this.comboValidateBillListener == null) {
            this.comboValidateBillListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        BillValidateConfigEditUI.this.comboBill_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        BillValidateConfigEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.comboValidateBill.addItemListener(this.comboValidateBillListener);
        if (this.bigDecimalFieldSelectorListener == null) {
            this.bigDecimalFieldSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    BillValidateConfigEditUI.this.initEntryFieldF7(e);
                }
            };
        }
        this.comBigDecimalFieldF7.addSelectorListener(this.bigDecimalFieldSelectorListener);
        this.valBigDecimalFieldF7.addSelectorListener(this.bigDecimalFieldSelectorListener);
        this.comOtherFieldF7.addSelectorListener(this.bigDecimalFieldSelectorListener);
        this.valOtherFieldF7.addSelectorListener(this.bigDecimalFieldSelectorListener);
    }

    protected void deleteControlListener() {
        if (this.comboCompareBillListener != null) {
            this.comboCompareBill.removeItemListener(this.comboCompareBillListener);
        }
        if (this.comboValidateBillListener != null) {
            this.comboValidateBill.removeItemListener(this.comboValidateBillListener);
        }
        if (this.bigDecimalFieldSelectorListener != null) {
            this.comBigDecimalFieldF7.removeSelectorListener(this.bigDecimalFieldSelectorListener);
            this.valBigDecimalFieldF7.removeSelectorListener(this.bigDecimalFieldSelectorListener);
            this.comOtherFieldF7.removeSelectorListener(this.bigDecimalFieldSelectorListener);
            this.valOtherFieldF7.removeSelectorListener(this.bigDecimalFieldSelectorListener);
        }
    }

    private void initEntryFieldF7(SelectorEvent e) {
        ArrayList<DataType> dataTypeList = new ArrayList<DataType>();
        if (this.comBigDecimalFieldF7.equals(e.getSource())) {
            dataTypeList.add(DataType.DECIMAL);
            EntityFieldSelector selector = new EntityFieldSelector(this.getUIWindow(), this.compareEntity, dataTypeList);
            this.comBigDecimalFieldF7.setSelector((KDPromptSelector)selector);
        } else if (this.valBigDecimalFieldF7.equals(e.getSource())) {
            dataTypeList.add(DataType.DECIMAL);
            EntityFieldSelector selector = new EntityFieldSelector(this.getUIWindow(), this.validateEntity, dataTypeList);
            this.valBigDecimalFieldF7.setSelector((KDPromptSelector)selector);
        } else if (this.comOtherFieldF7.equals(e.getSource())) {
            EntityFieldSelector selector = new EntityFieldSelector(this.getUIWindow(), this.compareEntity, dataTypeList);
            this.comOtherFieldF7.setSelector((KDPromptSelector)selector);
        } else if (this.valOtherFieldF7.equals(e.getSource())) {
            EntityFieldSelector selector = new EntityFieldSelector(this.getUIWindow(), this.validateEntity, dataTypeList);
            this.valOtherFieldF7.setSelector((KDPromptSelector)selector);
        }
    }

    protected void comboBill_itemStateChanged(ItemEvent e) throws Exception {
        this.initEntityObject();
        if (e.getSource().equals(this.comboCompareBill)) {
            this.clearEntryValue(this.kdtValidateConfigEntry, new String[]{COL_CONFIG_ENTRY_COMPARE_FIELD, COL_CONFIG_ENTRY_COMPARE_NAME});
        } else if (e.getSource().equals(this.comboValidateBill)) {
            this.clearEntryValue(this.kdtValidateConfigEntry, new String[]{COL_CONFIG_ENTRY_VALIDATE_FIELD, COL_CONFIG_ENTRY_VALIDATE_NAME});
            this.initValidatePoint();
        }
    }

    protected void initValidatePoint() {
        this.contValidatePointStr.remove((Component)this.txtValidatePoint);
        if (this.comboBoxValPoint == null) {
            this.comboBoxValPoint = new MultiSelectComboBox();
            this.comboBoxValPoint.setRenderer(new CheckListCellRenderer());
        }
        this.comboBoxValPoint.setEnabled(this.comboValidateBill.getSelectedItem() != null);
        this.comboBoxValPoint.removeActionListener(this.comboBoxValPoint.getListener());
        this.comboBoxValPoint.removeAllItems();
        ((CheckListCellRenderer)this.comboBoxValPoint.getRenderer()).selectValueMap.clear();
        if (this.validateEntity != null) {
            this.comboBoxValPoint.addItem(BillActionEnum.SAVE);
            this.comboBoxValPoint.addItem(BillActionEnum.SUBMIT);
            this.comboBoxValPoint.addItem(BillActionEnum.AUDIT);
            if (BosTypeEnum.PAYMENT_BILL.getValue().equals(this.validateEntity.getType().toString())) {
                this.comboBoxValPoint.addItem(BillActionEnum.PAY);
            }
        }
        this.comboBoxValPoint.addActionListener(this.comboBoxValPoint.getListener());
    }

    protected void clearEntryValue(KDTable entry, String[] columns) {
        if (entry == null) {
            return;
        }
        if (columns == null || columns.length == 0) {
            entry.removeRows();
            return;
        }
        for (int i = 0; i < entry.getRowCount(); ++i) {
            for (int j = 0; j < columns.length; ++j) {
                entry.getCell(i, columns[j]).setValue(null);
            }
        }
    }

    protected void initEntityObject() {
        BosTypeEnum bosType = (BosTypeEnum)((Object)this.comboCompareBill.getSelectedItem());
        if (bosType == null) {
            this.compareEntity = null;
        } else if (this.compareEntity == null || !this.compareEntity.getType().toString().equals(bosType.getValue())) {
            this.compareEntity = MetaDataLoader.getEntity(null, (BOSObjectType)new BOSObjectType(bosType.getValue()));
        }
        bosType = (BosTypeEnum)((Object)this.comboValidateBill.getSelectedItem());
        if (bosType == null) {
            this.validateEntity = null;
        } else if (this.validateEntity == null || !this.validateEntity.getType().toString().equals(bosType.getValue())) {
            this.validateEntity = MetaDataLoader.getEntity(null, (BOSObjectType)new BOSObjectType(bosType.getValue()));
        }
    }

    private void initBillComponent() {
        this.comboStatus.setEnabled(false);
        this.kdtValidateConfigEntry.checkParsed();
        this.kdtMatchFieldEntry.checkParsed();
        this.kdtValBillFilterEntry.checkParsed();
        this.kdtCompBillFilterEntry.checkParsed();
        this.chkIsPreSet.setEnabled(false);
        this.comBigDecimalFieldF7.setEditable(false);
        this.valBigDecimalFieldF7.setEditable(false);
        this.comOtherFieldF7.setEditable(false);
        this.valOtherFieldF7.setEditable(false);
        this.kdtValidateConfigEntry.getColumn(COL_CONFIG_ENTRY_COMPARE_NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.comBigDecimalFieldF7));
        this.kdtValidateConfigEntry.getColumn(COL_CONFIG_ENTRY_VALIDATE_NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.valBigDecimalFieldF7));
        this.kdtMatchFieldEntry.getColumn(COL_CONFIG_ENTRY_COMPARE_NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.comOtherFieldF7));
        this.kdtMatchFieldEntry.getColumn(COL_CONFIG_ENTRY_VALIDATE_NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.valOtherFieldF7));
        this.kdtValBillFilterEntry.getColumn(COL_FILTER_ENTRY_FIELD_NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.valOtherFieldF7));
        this.kdtCompBillFilterEntry.getColumn(COL_FILTER_ENTRY_FIELD_NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.comOtherFieldF7));
        KDTDefaultCellEditor bigDecimalEditor = ArApBillUIUtil.getMaxValueEditor(new BigDecimal("0.05"), 4);
        this.kdtValidateConfigEntry.getColumn(COL_CONFIG_ENTRY_DIFF_RANGE).setEditor((ICellEditor)bigDecimalEditor);
        this.kdtMatchFieldEntry.getColumn(COL_MATCH_ENTRY_COMPARE_SIGN).getStyleAttributes().setLocked(true);
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor cbEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.kdtMatchFieldEntry.getColumn(COL_MATCH_ENTRY_MAPPING_NULL).setEditor((ICellEditor)cbEditor);
        KDComboBox cbCompareType = ArApClientHelper.getComboBoxByList(CompareTypeEnum.getEnumList());
        KDTDefaultCellEditor edCompareType = new KDTDefaultCellEditor((JComboBox)cbCompareType);
        this.kdtValBillFilterEntry.getColumn(COL_FILTER_ENTRY_COMPARE_TYPE).setEditor((ICellEditor)edCompareType);
        this.kdtCompBillFilterEntry.getColumn(COL_FILTER_ENTRY_COMPARE_TYPE).setEditor((ICellEditor)edCompareType);
        KDComboBox cbLeftBrackets = ArApClientHelper.getComboBoxByList(LeftBracketSignEnum.getEnumList());
        KDTDefaultCellEditor edLeftBrackets = new KDTDefaultCellEditor((JComboBox)cbLeftBrackets);
        this.kdtValBillFilterEntry.getColumn(COL_FILTER_ENTRY_LEFT_BRACKETS).setEditor((ICellEditor)edLeftBrackets);
        this.kdtCompBillFilterEntry.getColumn(COL_FILTER_ENTRY_LEFT_BRACKETS).setEditor((ICellEditor)edLeftBrackets);
        KDComboBox cbRightBrackets = ArApClientHelper.getComboBoxByList(RightBracketSignEnum.getEnumList());
        KDTDefaultCellEditor edRightBrackets = new KDTDefaultCellEditor((JComboBox)cbRightBrackets);
        this.kdtValBillFilterEntry.getColumn(COL_FILTER_ENTRY_RIGHT_BRACKETS).setEditor((ICellEditor)edRightBrackets);
        this.kdtCompBillFilterEntry.getColumn(COL_FILTER_ENTRY_RIGHT_BRACKETS).setEditor((ICellEditor)edRightBrackets);
        KDComboBox cbLogicSign = ArApClientHelper.getComboBoxByList(LogicSignEnum.getEnumList());
        KDTDefaultCellEditor edLogicSign = new KDTDefaultCellEditor((JComboBox)cbLogicSign);
        this.kdtValBillFilterEntry.getColumn(COL_FILTER_ENTRY_LOGIC_SIGN).setEditor((ICellEditor)edLogicSign);
        this.kdtCompBillFilterEntry.getColumn(COL_FILTER_ENTRY_LOGIC_SIGN).setEditor((ICellEditor)edLogicSign);
    }

    protected void initBillComboBox() {
        this.comboValidateBill.removeAllItems();
        this.comboValidateBill.addItem((Object)BosTypeEnum.AP_OTHER_BILL);
        this.comboValidateBill.addItem((Object)BosTypeEnum.PAY_REQUEST_BILL);
        this.comboValidateBill.addItem((Object)BosTypeEnum.PAYMENT_BILL);
        this.comboCompareBill.removeAllItems();
        this.comboCompareBill.addItem((Object)BosTypeEnum.AP_OTHER_BILL);
        this.comboCompareBill.addItem((Object)BosTypeEnum.PAY_REQUEST_BILL);
        this.comboCompareBill.addItem((Object)BosTypeEnum.PAYMENT_BILL);
        this.comboCompareBill.addItem((Object)BosTypeEnum.AR_OTHER_BILL);
        this.comboCompareBill.addItem((Object)BosTypeEnum.RECEIVE_BILL);
        this.comboCompareBill.addItem((Object)BosTypeEnum.PUR_CONTRACT);
        this.comboCompareBill.addItem((Object)BosTypeEnum.PUR_ORDER);
        this.comboCompareBill.addItem((Object)BosTypeEnum.PUR_INWAREHS);
    }

    @Override
    public void storeFields() {
        this.fillEntityField(this.kdtValidateConfigEntry, COL_CONFIG_ENTRY_COMPARE_NAME, COL_CONFIG_ENTRY_COMPARE_FIELD);
        this.fillEntityField(this.kdtValidateConfigEntry, COL_CONFIG_ENTRY_VALIDATE_NAME, COL_CONFIG_ENTRY_VALIDATE_FIELD);
        this.fillEntityField(this.kdtMatchFieldEntry, COL_CONFIG_ENTRY_VALIDATE_NAME, COL_CONFIG_ENTRY_VALIDATE_FIELD);
        this.fillEntityField(this.kdtMatchFieldEntry, COL_CONFIG_ENTRY_COMPARE_NAME, COL_CONFIG_ENTRY_COMPARE_FIELD);
        this.fillEntityField(this.kdtCompBillFilterEntry, COL_FILTER_ENTRY_FIELD_NAME, COL_FILTER_ENTRY_FIELD);
        this.fillEntityField(this.kdtValBillFilterEntry, COL_FILTER_ENTRY_FIELD_NAME, COL_FILTER_ENTRY_FIELD);
        Map validatePointMap = this.comboBoxValPoint.getSelectValueMap();
        String validatePointTxt = "";
        String validatePoint = "";
        for (BillActionEnum key : validatePointMap.keySet()) {
            if (!((Boolean)validatePointMap.get((Object)key)).booleanValue()) continue;
            validatePointTxt = validatePointTxt + key.getValue() + SEMICOLON;
            validatePoint = validatePoint + key.getAlias() + SEMICOLON;
        }
        this.txtValidatePoint.setText(validatePoint);
        this.txtValidatePointStr.setText(validatePointTxt);
        ArApClientHelper.setTableColumnValue(this.kdtCompBillFilterEntry, COL_FILTER_ENTRY_ENTITY, this.compareEntity.getType());
        ArApClientHelper.setTableColumnValue(this.kdtValBillFilterEntry, COL_FILTER_ENTRY_ENTITY, this.validateEntity.getType());
        super.storeFields();
    }

    protected void fillEntityField(KDTable entry, String entityCol, String fieldCol) {
        for (int i = 0; i < entry.getRowCount(); ++i) {
            IRow row = entry.getRow(i);
            Object cellValue = row.getCell(entityCol).getValue();
            if (cellValue == null || !(cellValue instanceof SelectEntityFieldUI.SelectFieldInfo)) continue;
            row.getCell(fieldCol).setValue((Object)((SelectEntityFieldUI.SelectFieldInfo)cellValue).getValue());
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable entry = this.getSelectedEntry(e);
        if (entry == null) {
            return;
        }
        int rowIndex = entry.getSelectManager().getActiveRowIndex();
        entry.addRow(rowIndex + 1);
        if (entry == this.kdtMatchFieldEntry) {
            entry.getCell(rowIndex + 1, COL_MATCH_ENTRY_COMPARE_SIGN).setValue((Object)"=");
            entry.getCell(rowIndex + 1, COL_MATCH_ENTRY_MAPPING_NULL).setValue((Object)false);
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable entry = this.getSelectedEntry(e);
        if (entry == null) {
            return;
        }
        int rowIndex = entry.getSelectManager().getActiveRowIndex();
        entry.removeRow(rowIndex);
    }

    private KDTable getSelectedEntry(ActionEvent e) {
        KDTable entry = null;
        KDWorkButton button = (KDWorkButton)e.getSource();
        if (button.getParent().equals(this.kDPanel4)) {
            entry = this.kdtValidateConfigEntry;
        } else if (button.getParent().equals(this.kDPanel1)) {
            entry = this.kdtMatchFieldEntry;
        } else if (button.getParent().equals(this.kDPanel2)) {
            entry = this.kdtValBillFilterEntry;
        } else if (button.getParent().equals(this.kDPanel3)) {
            entry = this.kdtCompBillFilterEntry;
        }
        return entry;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.getBizInterface().cancel((IObjectPK)pk, (CoreBaseInfo)this.editData);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
        this.setOprtState(OprtState.VIEW);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.getBizInterface().cancelCancel((IObjectPK)pk, (CoreBaseInfo)this.editData);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
        this.setOprtState(OprtState.VIEW);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }
}

