/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.search.lucene.bean.PageResult;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.fi.arap.BosTypeEnum;
import com.kingdee.eas.fi.arap.billValidator.IPaySecurityLog;
import com.kingdee.eas.fi.arap.billValidator.PaySecurityLogFactory;
import com.kingdee.eas.fi.arap.billValidator.ScheduleFunctionEnum;
import com.kingdee.eas.fi.arap.billValidator.ValidateResultEnum;
import com.kingdee.eas.fi.arap.billValidator.client.AbstractPaySecurityLogRptUI;
import com.kingdee.eas.fi.arap.billValidator.client.PaySecurityQueryUI;
import com.kingdee.eas.fi.arap.billValidator.client.util.ScheduleHepler;
import com.kingdee.eas.fi.arap.billValidator.util.PaySecurityParam;
import com.kingdee.eas.framework.report.util.RptParams;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PaySecurityLogRptUI
extends AbstractPaySecurityLogRptUI {
    private static final long serialVersionUID = -7450755340646591418L;
    private static final Logger logger = CoreUIObject.getLogger(PaySecurityLogRptUI.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public PaySecurityLogRptUI() throws Exception {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getDataRequestManager().setPageRowCount(50);
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new PaySecurityQueryUI();
    }

    @Override
    protected void initQueryDialog(CommonQueryDialog queryDialog) {
        queryDialog.setMaxReturnCountVisible(true);
        queryDialog.setShowFilter(true);
        queryDialog.setOnlyShowInCurrentOrg(true);
    }

    protected IMetaDataPK getQueryMetaDataPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.fi.arap.billValidator.app", (String)"PaySecurityLogQuery");
    }

    protected String getUIFullName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected void prepareParamForQuery(QueryPanelCollection queryPanelInfo) throws Exception {
        CustomerQueryPanel panel = this.getCustomerQueryPanel();
        panel.setCustomerParams(CustomerParams.getCustomerParams2((String)queryPanelInfo.get(0).getCustomerParams()));
        this.params = new RptParams();
        this.params.setObject("qryParam", (Object)((PaySecurityQueryUI)panel).getPaySecurityParam());
    }

    protected IPaySecurityLog getBizInterface() throws Exception {
        return PaySecurityLogFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void query() {
        try {
            this.getTable().removeRows();
            KDTDataRequestEvent e = new KDTDataRequestEvent(this.getTable());
            e.setFirstRow(0);
            e.setLastRow(this.getTable().getDataRequestManager().getPageRowCount());
            this.getData(e);
        }
        catch (Exception e) {
            logger.error((Object)"PaySecurityLogRptUI query", (Throwable)e);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        Map oldParams = this.params.toMap();
        int oldInsertRowCount = this.insertRowCount;
        boolean oldFirstLoad = this.fFirstLoad;
        this.fFirstLoad = true;
        this.insertRowCount = 0;
        this.params.clear();
        if (this.showQueryDialog(false)) {
            this.query();
        } else {
            this.params.putAll(oldParams);
            this.insertRowCount = oldInsertRowCount;
            this.fFirstLoad = oldFirstLoad;
        }
    }

    public void getData(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        try {
            PaySecurityParam param = (PaySecurityParam)((Object)this.params.getObject("qryParam"));
            param.setStartIndex(start);
            param.setPageCount(length);
            IPaySecurityLog iRpt = this.getBizInterface();
            PageResult page = iRpt.pageSearchSolr(param);
            int pageCount = page.getCount().intValue();
            if (pageCount == 0) {
                return;
            }
            this.insertRows(page.getDataList(), this.insertRowCount, this.tblMain);
        }
        catch (Exception ex) {
            logger.error((Object)"getData error", (Throwable)ex);
            this.processException(ex);
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    public void insertRows(List<Map<String, Object>> rows, int insertRowIndex, KDTable table) {
        if (rows.size() == 0) {
            return;
        }
        int rowIndex = insertRowIndex;
        this.insertRowCount += rows.size();
        this.tblMain.setRefresh(false);
        IRow row = null;
        ICell cell = null;
        Object value = null;
        Object userObj = null;
        for (int i = 0; i < rows.size(); ++i) {
            Map<String, Object> rowData = rows.get(i);
            row = table.addRow(rowIndex++);
            int j = 0;
            while (j < table.getColumnCount()) {
                String key = this.tblMain.getColumn(i).getKey();
                cell = row.getCell(key);
                Object obj = rowData.get(key);
                if (null == obj) {
                    userObj = obj;
                    value = obj;
                } else {
                    if ("ctrlBillType".equals(key)) {
                        userObj = BosTypeEnum.getEnum(obj.toString());
                        value = ((BosTypeEnum)((Object)userObj)).getAlias();
                    }
                    if ("executeTime".equals(key)) {
                        userObj = obj.toString();
                        value = this.sdf.format(userObj);
                    }
                    if ("executeResult".equals(key)) {
                        userObj = ValidateResultEnum.getEnum(obj.toString());
                        value = ((ValidateResultEnum)((Object)userObj)).getAlias();
                    }
                    if ("userType".equals(key)) {
                        userObj = UserType.getEnum((String)obj.toString());
                        value = ((UserType)obj).getAlias();
                    }
                }
                cell.setValue(value);
                cell.setUserObject(userObj);
                ++i;
            }
        }
        this.tblMain.setRowCount(this.insertRowCount);
        this.tblMain.setRefresh(true);
        table.reLayoutAndPaint();
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    @Override
    public void actionSetSchedule_actionPerformed(ActionEvent e) throws Exception {
        String functionClass = "com.kingdee.eas.fi.arap.ArapScheduleFunction";
        String method = "clearPaySecurityLog";
        ScheduleHepler.setActionSchedule((Object)this, false, ScheduleFunctionEnum.PaySecurityLogClear, functionClass, method);
    }
}

