/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.arap.BosTypeEnum;
import com.kingdee.eas.fi.arap.billValidator.client.AbstractPaySecurityQueryUI;
import com.kingdee.eas.fi.arap.billValidator.util.PaySecurityParam;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.IRptParamConvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.PaySecurityParamConnvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.RptParamConvertorFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class PaySecurityQueryUI
extends AbstractPaySecurityQueryUI {
    private static final long serialVersionUID = 5239602897626257838L;
    private static final Logger logger = CoreUIObject.getLogger(PaySecurityQueryUI.class);
    protected transient IObjectPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    protected CompanyOrgUnitInfo currentCompany = null;
    protected transient SCMRptMultiOrgsF7 compF7 = null;
    protected transient Object[] defaultCompArr = null;
    protected transient CompanyOrgUnitCollection selectedCompInfos = null;
    protected transient Object[] selectedComps = null;
    public static final String CRTL = " \r\n ";
    public final long ONE_DAY = 86400000L;
    private PaySecurityParam paySecurityParam = null;

    public PaySecurityParam getPaySecurityParam() {
        return this.paySecurityParam;
    }

    public void onLoad() throws Exception {
        this.initComponents();
        super.onLoad();
    }

    protected void initComponents() throws Exception {
        this.initCompanysF7();
        this.initExecuteDateTime();
        this.initUserType();
        this.initCtrlBillComboBox();
    }

    protected void initCompanysF7() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        String title = EASResource.getString((String)"com.kingdee.eas.fi.arap.ArApRptResource", (String)"CompanysSelection");
        this.compF7 = new SCMRptMultiOrgsF7(this.prmtCompany, OrgType.Company, this.getPermissionItem(), title);
        this.prmtCompany.setEnabledMultiSelection(false);
        FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
        orgInfo.setId(this.currentCompany.getId());
        orgInfo.setName(this.currentCompany.getName());
        orgInfo.setNumber(this.currentCompany.getNumber());
        this.defaultCompArr = new Object[]{orgInfo};
        this.selectedCompInfos = ArApQueryUIUtil.getFullPermCompany(this.userPK, this.defaultCompArr, this.getPermissionItem());
        this.setRealValueForCompanyF7(true);
    }

    protected void setRealValueForCompanyF7(boolean isNotify) {
        List<FullOrgUnitInfo> fullOrgUnits = CollectionUtil.toList(this.selectedCompInfos);
        Object[] currentCompArr = null != fullOrgUnits ? fullOrgUnits.toArray() : null;
        this.selectedComps = currentCompArr;
        if (currentCompArr != null && currentCompArr.length > 0) {
            if (isNotify) {
                this.prmtCompany.setValue((Object)currentCompArr);
            } else {
                this.prmtCompany.setDataNoNotify((Object)currentCompArr);
            }
        } else {
            this.prmtCompany.setValue(null);
        }
    }

    private void initUserType() {
        DefaultComboBoxModel<UserType> model = new DefaultComboBoxModel<UserType>();
        model.addElement(null);
        Iterator iter = UserType.iterator();
        while (iter.hasNext()) {
            UserType type = (UserType)iter.next();
            model.addElement(type);
        }
        this.comboUserType.setModel(model);
        this.comboUserType.setSelectedIndex(0);
    }

    private void initExecuteDateTime() {
        long currentTimeMillis = System.currentTimeMillis();
        Date currentDate = new Date(currentTimeMillis);
        this.dateFrom.setValue((Object)new Date(currentTimeMillis - 86400000L));
        this.dateTo.setValue((Object)currentDate);
    }

    protected void initCtrlBillComboBox() {
        DefaultComboBoxModel<BosTypeEnum> model = new DefaultComboBoxModel<BosTypeEnum>();
        model.addElement(null);
        model.addElement(BosTypeEnum.AP_OTHER_BILL);
        model.addElement(BosTypeEnum.PAY_REQUEST_BILL);
        model.addElement(BosTypeEnum.PAYMENT_BILL);
        this.comboCtrlBill.setModel(model);
        this.comboCtrlBill.setSelectedIndex(0);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams biRptParam = new RptParams();
        biRptParam.setObject("qryParam", (Object)this.getRptParam());
        return biRptParam;
    }

    public CustomerParams getCustomerParams() {
        IRptParamConvertor convertor = RptParamConvertorFactory.getConvertor(this.getRptParam());
        return convertor.convertClient();
    }

    public void setCustomerParams(CustomerParams cp) {
        this.paySecurityParam = new PaySecurityParam();
        PaySecurityParamConnvertor convertor = new PaySecurityParamConnvertor();
        convertor.setRptParam(this.paySecurityParam);
        try {
            convertor.read(null, cp);
        }
        catch (Exception e) {
            logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
        }
    }

    public void loadData(EntityViewInfo view) {
        this.loadRptParam(this.paySecurityParam);
    }

    private void loadRptParam(PaySecurityParam param) {
        this.clear();
        if (param == null) {
            return;
        }
        this.prmtCompany.setValue((Object)param.getCompanys());
        this.dateFrom.setValue((Object)param.getDateFrom());
        this.dateTo.setValue((Object)param.getDateTo());
        this.comboUserType.setSelectedItem((Object)param.getUserType());
        this.comboCtrlBill.setSelectedItem((Object)param.getCrtlBillType());
        this.chkPass.setSelected(param.isChkPass());
        this.chkUnpass.setSelected(param.isChkUnPass());
    }

    public void setCustomCondition(RptParams params) {
    }

    public IReportQueryParam getRptParam() {
        PaySecurityParam param = new PaySecurityParam();
        param.setUserPK(this.userPK);
        param.setPermItem(this.getPermissionItem());
        Object obj = this.prmtCompany.getValue();
        FullOrgUnitInfo[] orgUnits = null;
        if (null != obj && obj instanceof Object[]) {
            Object[] objArr = (Object[])obj;
            orgUnits = new FullOrgUnitInfo[objArr.length];
            for (int i = 0; i < objArr.length; ++i) {
                if (!(objArr[i] instanceof FullOrgUnitInfo)) continue;
                orgUnits[i] = (FullOrgUnitInfo)objArr[i];
            }
        }
        param.setCompanys(orgUnits);
        param.setDateFrom((Date)this.dateFrom.getValue());
        param.setDateTo((Date)this.dateTo.getValue());
        param.setUserType((UserType)this.comboUserType.getSelectedItem());
        param.setCrtlBillType((BosTypeEnum)((Object)this.comboCtrlBill.getSelectedItem()));
        param.setChkPass(this.chkPass.isSelected());
        param.setChkUnPass(this.chkUnpass.isSelected());
        return param;
    }

    public boolean verify() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"Company_Not_Null"));
            return false;
        }
        return true;
    }

    protected String getPermissionItem() {
        return "mappingcondition_view";
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.ACCOUNTSPAYABLE;
    }

    public void clear() {
        this.prmtCompany.setValue((Object)this.defaultCompArr);
        this.initExecuteDateTime();
        this.comboUserType.setSelectedIndex(0);
        this.comboCtrlBill.setSelectedIndex(0);
        this.chkPass.setSelected(true);
        this.chkUnpass.setSelected(true);
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitCollection comps;
        if (this.compF7 == null || this.compF7.getFullData() == null) {
            return;
        }
        Object[] oldComps = this.selectedComps;
        this.selectedComps = (Object[])this.compF7.getFullData();
        if (oldComps != null && Arrays.equals(oldComps, this.selectedComps)) {
            return;
        }
        this.selectedCompInfos = comps = ArApQueryUIUtil.getFullPermCompany(this.userPK, this.selectedComps, this.getPermissionItem());
        if (comps == null || comps.size() == 0) {
            this.prmtCompany.setValue(null);
            return;
        }
        this.setRealValueForCompanyF7(false);
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.fi.arap.billValidator.client", "PaySecurityQueryUI");
    }
}

