/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.fi.arap.billValidator.client.AbstractSelectEntityFieldUI;
import com.kingdee.eas.fi.arap.billValidator.client.EntityTreeUtil;
import com.kingdee.eas.fi.arap.billValidator.client.FindTreeNodeUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class SelectEntityFieldUI
extends AbstractSelectEntityFieldUI {
    private static final long serialVersionUID = 1L;
    private boolean isCancel = true;
    private Object fieldValue;
    private EntityObjectInfo entity;
    private List<DataType> dataTypeList;

    public SelectEntityFieldUI() throws Exception {
        this.toolBar.setVisible(false);
        this.btnOK.setEnabled(false);
        this.btnCancel.setEnabled(true);
        this.treeQueryTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SelectEntityFieldUI.this.tree_Changed(e);
            }
        });
        FindTreeNodeUtil util = new FindTreeNodeUtil(this.treeQueryTable);
        this.txtFind = util.getFindNextTxt();
        this.btnFind = util.getFindNextBtn();
        this.btnFind.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnFind.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.barcode.BARCODEAutoGenerateResource", (String)"196_SelectEntityUI"));
    }

    protected void tree_Changed(TreeSelectionEvent e) {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeQueryTable.getLastSelectedPathComponent();
        if (treeNode == null || !treeNode.isLeaf()) {
            return;
        }
        this.btnOK.setEnabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.entity = (EntityObjectInfo)this.getUIContext().get("entity");
        this.dataTypeList = (List)this.getUIContext().get("dataTypeList");
        if (this.entity != null) {
            this.setUITitle(this.entity.getAlias());
        }
        this.initQueryTree();
    }

    private void initQueryTree() {
        DefaultKingdeeTreeNode root = EntityTreeUtil.getDataQueryRoot(this.entity, this.dataTypeList);
        if (root == null) {
            this.treeQueryTable.setModel(null);
        } else {
            this.treeQueryTable.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
            this.treeQueryTable.expandOnLevel(1);
            this.treeQueryTable.setToggleClickCount(1);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void treeQueryTable_mouseClicked(MouseEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeQueryTable.getLastSelectedPathComponent();
        if (e.getClickCount() == 2 && treeNode != null && treeNode.isLeaf()) {
            this.getSelectField();
            this.isCancel = false;
            this.disposeUIWindow();
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectField();
        this.isCancel = false;
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.disposeUIWindow();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Object getData() {
        return this.fieldValue;
    }

    private void getSelectField() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeQueryTable.getLastSelectedPathComponent();
        SelectFieldInfo res = new SelectFieldInfo(treeNode);
        this.fieldValue = res;
    }

    public class SelectFieldInfo {
        private String value;
        private String name;
        private DefaultKingdeeTreeNode treeNode;
        private String POSTFIX = ".";

        public SelectFieldInfo(DefaultKingdeeTreeNode treeNode) {
            this.treeNode = treeNode;
            if (treeNode == null) {
                return;
            }
            for (int i = 1; i < treeNode.getPath().length; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treeNode.getPath()[i];
                if (i == 1) {
                    this.value = node.getUserObject().toString();
                    this.name = node.getText();
                    continue;
                }
                this.value = this.value + this.POSTFIX + node.getUserObject().toString();
                this.name = this.name + this.POSTFIX + node.getText();
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public DefaultKingdeeTreeNode getTreeNode() {
            return this.treeNode;
        }

        public void setTreeNode(DefaultKingdeeTreeNode treeNode) {
            this.treeNode = treeNode;
        }

        public String toString() {
            return this.name;
        }
    }
}

