/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.check.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.check.ICalculateCheck;
import com.kingdee.eas.fi.arap.check.ICheck;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CalculateCheckComposer<T extends CoreBillBaseInfo>
implements ICalculateCheck<T> {
    private final List<ICalculateCheck<T>> checkers;
    private final List<ICalculateCheck<T>> failCheckers = new ArrayList<ICalculateCheck<T>>();

    public CalculateCheckComposer(List<ICalculateCheck<T>> checkers) {
        this.checkers = checkers;
    }

    @Override
    public boolean check(T billInfo) throws BOSException, EASBizException {
        for (ICalculateCheck<T> checker : this.checkers) {
            if (checker.check(billInfo)) {
                return true;
            }
            this.failCheckers.add(checker);
        }
        return false;
    }

    @Override
    public ICheck prepareMessage(final String template, final Map context) {
        return new ICheck(){

            @Override
            public boolean isErrorType() {
                return false;
            }

            @Override
            public String getMsg() {
                if (!CalculateCheckComposer.this.failCheckers.isEmpty()) {
                    return ((ICalculateCheck)CalculateCheckComposer.this.failCheckers.get(0)).prepareMessage(template, context).getMsg();
                }
                return null;
            }
        };
    }
}

