/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.arap.client.AbstractARAPBillTypeSelectorUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class ARAPBillTypeSelectorUI
extends AbstractARAPBillTypeSelectorUI {
    private static final Logger logger = CoreUIObject.getLogger(ARAPBillTypeSelectorUI.class);
    private static final String COL_BILLTYPENAME = "billTypeName";
    private static final String COL_BILLTYPEVALUE = "billTypeValue";
    private static boolean isAR = true;
    private String result = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initTable();
    }

    private void init() {
        Map ctx = this.getUIContext();
        isAR = ctx.get("isAR") != null ? (Boolean)ctx.get("isAR") : true;
        String title = this.getUITitle();
        if (isAR) {
            this.setUITitle(new StringBuilder(title).delete(2, 4).toString());
        } else {
            this.setUITitle(new StringBuilder(title).delete(0, 2).toString());
        }
    }

    private void initTable() {
        if (isAR) {
            this.kdTable.checkParsed();
            this.kdTable.getIndexColumn().getStyleAttributes().setHided(false);
            this.kdTable.setActiveCellStatus(0);
            this.kdTable.getColumn(COL_BILLTYPENAME).setWidth(200);
            this.kdTable.setEditable(false);
            IRow row = this.kdTable.addRow();
            row.getCell(COL_BILLTYPEVALUE).setValue((Object)102);
            row.getCell(COL_BILLTYPENAME).setValue((Object)OtherBillTypeEnum.InvoiceBill.getAlias());
            row = this.kdTable.addRow();
            row.getCell(COL_BILLTYPEVALUE).setValue((Object)103);
            row.getCell(COL_BILLTYPENAME).setValue((Object)OtherBillTypeEnum.ExpenseInvoice.getAlias());
            row = this.kdTable.addRow();
            row.getCell(COL_BILLTYPEVALUE).setValue((Object)101);
            row.getCell(COL_BILLTYPENAME).setValue((Object)OtherBillTypeEnum.OtherReceivable.getAlias());
            row = this.kdTable.addRow();
            row.getCell(COL_BILLTYPEVALUE).setValue((Object)104);
            row.getCell(COL_BILLTYPENAME).setValue((Object)OtherBillTypeEnum.DebitAdjust.getAlias());
            KDTableUtil.setSelectedRow((KDTable)this.kdTable, (int)0);
        } else {
            this.kdTable.checkParsed();
            this.kdTable.getIndexColumn().getStyleAttributes().setHided(false);
            this.kdTable.setActiveCellStatus(0);
            this.kdTable.getColumn(COL_BILLTYPENAME).setWidth(200);
            this.kdTable.setEditable(false);
            IRow row = this.kdTable.addRow();
            row.getCell(COL_BILLTYPEVALUE).setValue((Object)202);
            row.getCell(COL_BILLTYPENAME).setValue((Object)OtherBillType.InvoiceBill.getAlias());
            row = this.kdTable.addRow();
            row.getCell(COL_BILLTYPEVALUE).setValue((Object)203);
            row.getCell(COL_BILLTYPENAME).setValue((Object)OtherBillType.ExpenseInvoice.getAlias());
            row = this.kdTable.addRow();
            row.getCell(COL_BILLTYPEVALUE).setValue((Object)201);
            row.getCell(COL_BILLTYPENAME).setValue((Object)OtherBillType.OtherPay.getAlias());
            row = this.kdTable.addRow();
            row.getCell(COL_BILLTYPEVALUE).setValue((Object)204);
            row.getCell(COL_BILLTYPENAME).setValue((Object)OtherBillType.DebitAdjust.getAlias());
            KDTableUtil.setSelectedRow((KDTable)this.kdTable, (int)0);
        }
        this.kdTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    try {
                        ARAPBillTypeSelectorUI.this.actionOK_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.okButton_actionPerformed(e);
        this.getDataFromTable();
        this.disposeUIWindow();
    }

    private void getDataFromTable() {
        StringBuilder ret = new StringBuilder();
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.kdTable);
        if (selectedRows == null || selectedRows.length <= 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"select_data"));
            SysUtil.abort();
        }
        for (int index = 0; index < selectedRows.length; ++index) {
            IRow iRow = this.kdTable.getRow(selectedRows[index]);
            if (index > 0) {
                ret.append(";");
            }
            ret.append(iRow.getCell(COL_BILLTYPEVALUE).getValue());
        }
        this.result = ret.toString();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public boolean isCanceled() {
        return false;
    }

    public Object getData() {
        return this.result;
    }
}

