/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.util.ApPeriodHelper;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.SummaryRptQueryParam;
import com.kingdee.eas.fi.ar.client.util.ArPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.BizSysPeriodHelper;
import com.kingdee.eas.fi.arap.client.AbstractArApBiRptSumQueryUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.IRptParamConvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.RptParamConvertorFactory;
import com.kingdee.eas.fi.arap.util.paramconvertor.SumRptParamConnvertor;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.sql.Date;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class ArApBiRptSumQueryUI
extends AbstractArApBiRptSumQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(ArApBiRptSumQueryUI.class);
    private transient BizSysPeriodHelper periodHelper = null;
    private PeriodInfo startPeriod = null;
    private PeriodInfo currentPeriod = null;
    private SummaryRptQueryParam rptParam = null;
    private ItemListener chkIsCentralBalanceListener = null;

    public ArApBiRptSumQueryUI() throws Exception {
    }

    public ArApBiRptSumQueryUI(boolean fAr) throws Exception {
        this.isArRpt = fAr;
    }

    @Override
    protected String getPermissionItem() {
        return this.isArRpt ? "fi_arap_ArSumReport_List" : "fi_arap_ApSumReport";
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void initCtrls() throws Exception {
        super.initCtrls();
        this.initPeriod();
        if (!this.isArRpt) {
            this.chkIncludeBizBill.setText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"Lbl_includeBizAP"));
        }
        this.removeControlListener();
        this.addListen();
    }

    private void removeControlListener() {
        if (null != this.chkIsCentralBalanceListener) {
            this.bizcheckBox.removeItemListener(this.chkIsCentralBalanceListener);
        }
    }

    private void addListen() {
        this.chkIsCentralBalanceListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    ArApBiRptSumQueryUI.this.chkIsCentralBalanceChanged(arg0);
                }
                catch (Exception e) {
                    ArApBiRptSumQueryUI.this.handUIException(e);
                }
            }
        };
        this.bizcheckBox.addItemListener(this.chkIsCentralBalanceListener);
    }

    protected void chkIsCentralBalanceChanged(ItemEvent arg0) throws Exception {
        boolean ischeckBox = this.bizcheckBox.isSelected();
        if (ischeckBox) {
            this.contPaymentType.setEnabled(true);
        } else {
            this.contPaymentType.setEnabled(false);
        }
    }

    private void initPeriod() {
        try {
            SystemEnum sysEnum = this.getSystemEnum();
            this.periodHelper = this.isArRpt() ? ArPeriodHelper.getInstance(false) : ApPeriodHelper.getInstance(false);
            this.periodHelper.initPeriodSpinner(this.currentCompany, this.spPeriodYearFrom, this.spPeriodNumFrom, this.spPeriodYearTo, this.spPeriodNumTo, this.sysInfo);
            this.startPeriod = this.currentCompany.isIsOnlyUnion() ? this.periodHelper.getFirstPeriodInfo(this.currentCompany) : this.sysInfo.getStartPeriod(sysEnum);
            this.currentPeriod = this.sysInfo.getCurrentPeriod(sysEnum);
            this.pkDateFrom.setMinimumDate(this.startPeriod.getBeginDate());
            this.pkDateTo.setMinimumDate(this.startPeriod.getBeginDate());
            this.pkDateFrom.setValue((Object)this.currentPeriod.getBeginDate());
            this.pkDateTo.setValue((Object)this.currentPeriod.getEndDate());
        }
        catch (Exception ex) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"periodFail"));
            logger.error((Object)"get periodFail", (Throwable)ex);
            SysUtil.abort();
        }
    }

    @Override
    protected void rdBtnPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.setAccordingPeriod(this.rdBtnPeriod.isSelected());
    }

    @Override
    protected void rdBtnDate_stateChanged(ChangeEvent e) throws Exception {
        this.setAccordingPeriod(!this.rdBtnDate.isSelected());
    }

    private void setAccordingPeriod(boolean fPeriod) {
        this.panelPeriod.setVisible(fPeriod);
        this.panelDate.setVisible(!fPeriod);
    }

    @Override
    protected void spPeriodYearFrom_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spPeriodYearFrom, this.spPeriodNumFrom, this.spPeriodYearTo, this.spPeriodNumTo, false);
        this.periodHelper.setPeriodNum(this.currentCompany, this.spPeriodNumFrom, this.spPeriodYearFrom);
    }

    @Override
    protected void spPeriodNumFrom_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spPeriodYearFrom, this.spPeriodNumFrom, this.spPeriodYearTo, this.spPeriodNumTo, true);
    }

    @Override
    protected void spPeriodYearTo_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spPeriodYearFrom, this.spPeriodNumFrom, this.spPeriodYearTo, this.spPeriodNumTo, false);
        this.periodHelper.setPeriodNum(this.currentCompany, this.spPeriodNumTo, this.spPeriodYearTo);
    }

    @Override
    protected void spPeriodNumTo_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spPeriodYearFrom, this.spPeriodNumFrom, this.spPeriodYearTo, this.spPeriodNumTo, true);
    }

    @Override
    protected boolean isExcludeInnerCust() {
        return this.chkNoInnerCust.isSelected();
    }

    @Override
    protected void chkNoInnerCust_stateChanged(ChangeEvent e) throws Exception {
        boolean fCustSupp;
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        String cussTbl = asstActTypeInfo.getRealtionDataObject();
        if (asstActTypeInfo == null || asstActTypeInfo.getId() == null || StringUtils.isEmpty((String)cussTbl)) {
            return;
        }
        boolean bl = fCustSupp = "t_bd_customer".equalsIgnoreCase(cussTbl) || "T_BD_Supplier".equalsIgnoreCase(cussTbl);
        if (!fCustSupp) {
            return;
        }
        ArApBillUIUtil.setCompsAsstActSelector((CoreUIObject)this, this.prmtCussFrom, this.prmtCussTo, asstActTypeInfo, this.selectedCompInfos, this.sysInfo, this.chkNoInnerCust.isSelected());
    }

    @Override
    public void clear() {
        super.clear();
        this.chkBalZero.setSelected(false);
        this.chkBizZero.setSelected(false);
        this.chkNoInnerCust.setSelected(false);
        this.chkIncludeBizBill.setSelected(false);
        this.rdBtnPeriod.setSelected(true);
        this.rdBtnDate.setSelected(false);
        Integer currYear = new Integer(this.currentPeriod.getPeriodYear());
        Integer currNum = new Integer(this.currentPeriod.getPeriodNumber());
        this.spPeriodYearFrom.setValue((Object)currYear);
        this.spPeriodYearTo.setValue((Object)currYear);
        this.spPeriodNumFrom.setValue((Object)currNum);
        this.spPeriodNumTo.setValue((Object)currNum);
        this.pkDateFrom.setValue((Object)this.currentPeriod.getBeginDate());
        this.pkDateTo.setValue((Object)this.currentPeriod.getEndDate());
    }

    @Override
    protected String getPermissionRes() {
        return this.isArRpt() ? "ForbidenArSummRptQry" : "ForbidenApSummRptQry";
    }

    @Override
    public boolean verify() {
        boolean fDateRange;
        boolean fPeriodRange;
        boolean fValid = super.verify();
        boolean bl = fPeriodRange = this.spPeriodYearFrom.getValue() != null && this.spPeriodNumFrom.getValue() != null && this.spPeriodYearTo.getValue() != null && this.spPeriodNumTo.getValue() != null;
        if (this.rdBtnPeriod.isSelected() && !fPeriodRange) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"periodFail"));
            return false;
        }
        boolean bl2 = fDateRange = this.pkDateFrom.getValue() != null && this.pkDateTo.getValue() != null;
        if (this.rdBtnDate.isSelected() && !fDateRange) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"dateFail"));
            return false;
        }
        return fValid;
    }

    public IReportQueryParam getRptParam() {
        SummaryRptQueryParam param = new SummaryRptQueryParam();
        param.setCompanyId(this.companyId);
        param.setCompanyIds(this.getQueryCompanyIds());
        param.setCuIds(this.getQueryCompanyCuIds());
        param.setCuId(this.currentCompany.getCU().getString("id"));
        param.setIsArRpt(this.isArRpt());
        param.setByPeriod(this.rdBtnPeriod.isSelected());
        if (this.rdBtnPeriod.isSelected()) {
            int periodYearFrom = (Integer)this.spPeriodYearFrom.getValue();
            int periodYearTo = (Integer)this.spPeriodYearTo.getValue();
            int periodNumFrom = (Integer)this.spPeriodNumFrom.getValue();
            int periodNumTo = (Integer)this.spPeriodNumTo.getValue();
            param.setStartPeriodYear(periodYearFrom);
            param.setStartPeriodNum(periodNumFrom);
            param.setEndPeriodYear(periodYearTo);
            param.setEndPeriodNum(periodNumTo);
            try {
                PeriodInfo periodFrom = this.periodHelper.getPeriodInfo(periodYearFrom, periodNumFrom, this.currentCompany);
                PeriodInfo periodTo = this.periodHelper.getPeriodInfo(periodYearTo, periodNumTo, this.currentCompany);
                param.setBeginDate(periodFrom.getBeginDate());
                param.setEndDate(periodTo.getEndDate());
            }
            catch (Exception e) {
                logger.error((Object)"can't get period by year, number", (Throwable)e);
            }
        } else {
            java.util.Date date = (java.util.Date)this.pkDateFrom.getValue();
            Date beginDate = new Date(DateTimeUtils.truncateDate((java.util.Date)date).getTime());
            date = (java.util.Date)this.pkDateTo.getValue();
            Date endDate = new Date(DateTimeUtils.truncateDate((java.util.Date)date).getTime());
            param.setBeginDate(beginDate);
            param.setEndDate(endDate);
        }
        this.setCurrCussAcct2RptParam(param);
        param.setIsBalZero(this.chkBalZero.isSelected());
        param.setIsBizZero(this.chkBizZero.isSelected());
        param.setExcludeInnerCust(this.chkNoInnerCust.isSelected());
        param.setIncludeBizBill(this.chkIncludeBizBill.isSelected());
        param.setBizeIndex(this.comboPaymentType.getSelectedIndex());
        param.setBizeCheckBox(this.bizcheckBox.isSelected());
        param.setBizeIndex(this.comboPaymentType.getSelectedIndex());
        return param;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.rptParam = new SummaryRptQueryParam();
        SumRptParamConnvertor convertor = new SumRptParamConnvertor();
        convertor.setRptParam((IReportQueryParam)this.rptParam);
        try {
            convertor.read(null, cp);
        }
        catch (Exception e) {
            logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        IRptParamConvertor convertor = RptParamConvertorFactory.getConvertor(this.getRptParam());
        CustomerParams cp = convertor.convertClient();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)this.getRptParam());
        return cp;
    }

    @Override
    public void onInit(RptParams initParams) throws Exception {
    }

    @Override
    public RptParams getCustomCondition() {
        RptParams biRptParam = new RptParams();
        biRptParam.setObject("qryParam", (Object)this.getRptParam());
        return biRptParam;
    }

    public void loadData(EntityViewInfo view) {
        this.loadRptParam(this.rptParam);
    }

    private void loadRptParam(SummaryRptQueryParam param) {
        if (param == null) {
            return;
        }
        this.clear();
        this.loadCompanysData(param.getCompanyIds());
        this.loadCurrCussAcctData(param);
        this.rdBtnPeriod.setSelected(param.isByPeriod());
        this.rdBtnDate.setSelected(!param.isByPeriod());
        if (param.isByPeriod()) {
            Integer oInt = new Integer(param.getStartPeriodYear());
            this.spPeriodYearFrom.setValue((Object)oInt);
            oInt = new Integer(param.getStartPeriodNum());
            this.spPeriodNumFrom.setValue((Object)oInt);
            oInt = new Integer(param.getEndPeriodYear());
            this.spPeriodYearTo.setValue((Object)oInt);
            oInt = new Integer(param.getEndPeriodNum());
            this.spPeriodNumTo.setValue((Object)oInt);
        } else {
            this.pkDateFrom.setValue((Object)param.getBeginDate());
            this.pkDateTo.setValue((Object)param.getEndDate());
        }
        this.chkBizZero.setSelected(param.isBizZero());
        this.chkBalZero.setSelected(param.isBalZero());
        this.chkNoInnerCust.setSelected(param.isExcludeInnerCust());
        this.chkIncludeBizBill.setSelected(param.isIncludeBizBill());
        this.bizcheckBox.setSelected(param.isBizeCheckBox());
        this.comboPaymentType.setSelectedIndex(param.getBizeIndex());
        if (this.bizcheckBox.isSelected()) {
            this.contPaymentType.setEnabled(true);
        } else {
            this.contPaymentType.setEnabled(false);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler;
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (this.currentCompany == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"companyFail"));
            SysUtil.abort();
        }
        if ((handler = super.prepareInit()) != null) {
            RequestContext request = new RequestContext();
            request.put("uiParam", (Object)this.getUIParam());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    private HashMap getUIParam() {
        HashMap<String, Object> uiParam = new HashMap<String, Object>();
        uiParam.put("userPK", new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
        uiParam.put("permItemName", this.getPermissionItem());
        uiParam.put("orgTreePK", new ObjectUuidPK("00000000-0000-0000-0000-0000000000024F2827FD"));
        uiParam.put("companyOrgInfo", this.currentCompany);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("isSCM", Boolean.FALSE);
        map.put("sysEnum", (Boolean)this.getSystemEnum());
        uiParam.put("map", map);
        return uiParam;
    }
}

