/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.client.BOTMappingSelectUI;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.RuleItem;
import com.kingdee.eas.fi.arap.client.ArApSelectCombinRuleUI;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Null;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.plaf.ComponentUI;

public abstract class ArApClientHelper {
    public static final BigDecimal BIG_ZERO = new BigDecimal("0.00");
    private static final String COST_CENTER_DISPLAY_FORMAT = "$number$ $displayname$";

    public static boolean isSameBizCode(String topAssactID, String botAssactID) throws BOSException {
        boolean isSameCode = false;
        if (topAssactID != null && botAssactID != null) {
            if (!botAssactID.equals(topAssactID)) {
                String bizCode = "bizAnalysisCode";
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo(bizCode));
                ObjectUuidPK pk = new ObjectUuidPK(topAssactID);
                IObjectValue val1 = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk, selectors);
                pk = new ObjectUuidPK(botAssactID);
                IObjectValue val2 = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk, selectors);
                if (val1 != null && val2 != null && val1.get(bizCode) != null && val1.get(bizCode).equals(val2.get(bizCode))) {
                    isSameCode = true;
                }
            } else {
                isSameCode = true;
            }
        }
        return isSameCode;
    }

    public static void initCostCenterF7(IUIObject owner, KDBizPromptBox prmtCostCenter, String currentOrgId, String companyID) throws EASBizException, BOSException {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7(owner);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setNeedConsiderFaultTree(false);
        costCenterF7.setCurrentCUID(currentOrgId);
        costCenterF7.showCheckBoxOfShowingAllOUs();
        prmtCostCenter.setEditFormat("$number$");
        prmtCostCenter.setCommitFormat("$number$;$name$;$code$;$simpleName$");
        prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtCostCenter.setEnabledMultiSelection(false);
        FilterInfo filterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)companyID)) {
            String paramValue = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(companyID), (String)"AR_041");
            HashSet<String> costCenterSet = new HashSet<String>();
            if ("1".equals(paramValue)) {
                IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getRemoteInstance();
                OrgUnitCollection orgIds = iOrgUnitRel.getFromUnit(companyID, 1, 5);
                for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
                    costCenterSet.add(orgIds.get(i).getId().toString());
                }
            }
            if ("1".equals(paramValue)) {
                FilterItemInfo filterItemInfo = null;
                filterItemInfo = costCenterSet.size() == 0 ? new FilterItemInfo("unit.id", null, CompareType.IS) : new FilterItemInfo("unit.id", costCenterSet, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
                costCenterF7.setOuterFilterInfo(filterInfo);
            } else {
                prmtCostCenter.getQueryAgent().setHandleCUFilter(false);
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo F7filterInfo = new FilterInfo();
            if ("1".equals(paramValue)) {
                FilterItemInfo filterItemInfo = null;
                filterItemInfo = costCenterSet.size() == 0 ? new FilterItemInfo("id", null, CompareType.IS) : new FilterItemInfo("id", costCenterSet, CompareType.INCLUDE);
                F7filterInfo.getFilterItems().add(filterItemInfo);
            }
            F7filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)"false", CompareType.EQUALS));
            viewInfo.setFilter(F7filterInfo);
            prmtCostCenter.setEntityViewInfo(viewInfo);
        }
        prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public static void clearFieldsValue(IRow entryRow, String[] fieldNames) {
        if (fieldNames != null) {
            ICell cell = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                cell = entryRow.getCell(fieldNames[i]);
                if (cell == null) continue;
                cell.setValue(null);
            }
        }
    }

    public static void setFieldsZero(IRow entryRow, String[] fieldNames) {
        if (fieldNames != null) {
            ICell cell = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                cell = entryRow.getCell(fieldNames[i]);
                if (cell == null) continue;
                cell.setValue((Object)BigDecimal.ZERO);
            }
        }
    }

    public static void setLockCells(IRow entryRow, String[] fieldNames, boolean isLock) {
        if (fieldNames != null) {
            ICell cell = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                cell = entryRow.getCell(fieldNames[i]);
                if (cell == null) continue;
                cell.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static BigDecimal calculateLocalAmt(BigDecimal amt, BigDecimal exchangeRate, int basePrecision, boolean isDirectExchange) {
        BigDecimal localAmt = BigDecimal.ZERO;
        if (null == amt || amt.compareTo(BigDecimal.ZERO) == 0) {
            return localAmt;
        }
        localAmt = isDirectExchange ? amt.multiply(exchangeRate).setScale(basePrecision, 4) : amt.divide(exchangeRate, basePrecision, 4);
        return localAmt;
    }

    public static boolean compareValue(Object value1, Object value2) {
        if (value1 instanceof Boolean || value2 instanceof Boolean) {
            Boolean bool1 = value1 == null ? Boolean.FALSE : (Boolean)value1;
            Boolean bool2 = value2 == null ? Boolean.FALSE : (Boolean)value2;
            return bool1.booleanValue() == bool2.booleanValue();
        }
        if (ArApClientHelper.isEmptyObject(value1) && ArApClientHelper.isEmptyObject(value2)) {
            return true;
        }
        if (ArApClientHelper.isEmptyObject(value1) || ArApClientHelper.isEmptyObject(value2)) {
            return false;
        }
        if (value1 instanceof Byte && value2 instanceof Byte) {
            return ((Byte)value1).compareTo((Byte)value2) == 0;
        }
        if (value1 instanceof Short && value2 instanceof Short) {
            return ((Short)value1).compareTo((Short)value2) == 0;
        }
        if (value1 instanceof Integer && value2 instanceof Integer) {
            return ((Integer)value1).compareTo((Integer)value2) == 0;
        }
        if (value1 instanceof Long && value2 instanceof Long) {
            return ((Long)value1).compareTo((Long)value2) == 0;
        }
        if (value1 instanceof Float && value2 instanceof Float) {
            return ((Float)value1).compareTo((Float)value2) == 0;
        }
        if (value1 instanceof Double && value2 instanceof Double) {
            return ((Double)value1).compareTo((Double)value2) == 0;
        }
        if (value1 instanceof BigDecimal && value2 instanceof BigDecimal) {
            return ((BigDecimal)value1).compareTo((BigDecimal)value2) == 0;
        }
        if (value1 instanceof String && value2 instanceof String) {
            return ((String)value1).equals((String)value2);
        }
        if (value1 instanceof Date && value2 instanceof Date) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Time && value2 instanceof Time) {
            return ((Time)value1).compareTo((Time)value2) == 0;
        }
        if (value1 instanceof Timestamp && value2 instanceof Timestamp) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof AsstActTypeInfo && value2 instanceof AsstActTypeInfo) {
            return value1.toString().equals(value2.toString());
        }
        return value1.equals(value2);
    }

    public static boolean isEmptyObject(Object s) {
        if (s instanceof String) {
            return ((String)s).trim().length() == 0;
        }
        return s == null || s == Null.NULL;
    }

    public static void ArApBillUIConfig(CoreBillEditUI ui) {
        Component[] components = ui.getComponents();
        for (int i = 0; i < components.length; ++i) {
            String name = null;
            Object value = null;
            KDLabelContainer kdLB = (KDLabelContainer)components[i];
            name = kdLB.getBoundEditor().getName();
            if (kdLB.getBoundEditor() instanceof KDTextField) {
                value = ((KDTextField)kdLB.getBoundEditor()).getStringValue();
                continue;
            }
            if (kdLB.getBoundEditor() instanceof KDComboBox) {
                value = ((KDComboBox)kdLB.getBoundEditor()).getSelectedItem();
                continue;
            }
            if (kdLB.getBoundEditor() instanceof KDBizPromptBox) {
                value = ((KDBizPromptBox)kdLB.getBoundEditor()).getValue();
                continue;
            }
            if (!(kdLB.getBoundEditor() instanceof KDCheckBox)) continue;
        }
    }

    public static RuleItem getCombinRule(ComponentUI ui, String bosType, FilterInfo extFilter) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"BOSTYPE", (Object)bosType);
        if (extFilter != null) {
            uiContext.put((Object)"EXT_FILTER_INFO", (Object)extFilter);
        }
        String uiClass = "com.kingdee.eas.fi.arap.client.ArApSelectCombinRuleUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        ArApSelectCombinRuleUI ruleUI = (ArApSelectCombinRuleUI)uiWindow.getUIObject();
        if (!ruleUI.isConfirm()) {
            return null;
        }
        RuleItem ruleItem = ruleUI.getRule();
        return ruleItem;
    }

    public static BOTMappingInfo getBotpMapping(ComponentUI ui, String cuId, String srcStrBosType, String destStrBosType) throws UIException, BTPException {
        BOSObjectType srcBosType = BOSObjectType.create((String)srcStrBosType);
        BOSObjectType destBosType = BOSObjectType.create((String)destStrBosType);
        BOTMappingCollection botMappingCol = ArApBillHelper.getBotpMappingCollection(null, srcBosType, destBosType, cuId);
        BOTMappingInfo botMappingInfo = null;
        if (botMappingCol == null || botMappingCol.size() == 0) {
            throw new BTPException(BTPException.GETMAPPINGINFOERROR);
        }
        if (botMappingCol.size() > 1) {
            HashMap<String, ComponentUI> uiContext = new HashMap<String, ComponentUI>();
            uiContext.put("Owner", ui);
            uiContext.put("BOTMappings", (ComponentUI)botMappingCol);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            String mappingSelectUI = "com.kingdee.eas.base.botp.client.BOTMappingSelectUI";
            IUIWindow window = uiFactory.create(mappingSelectUI, uiContext, null);
            window.show();
            if (((BOTMappingSelectUI)window.getUIObject()).isCanceled() || ((BOTMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo() == null) {
                return null;
            }
            botMappingInfo = ((BOTMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo();
        } else {
            botMappingInfo = botMappingCol.get(0);
        }
        return botMappingInfo;
    }

    public static List getSelectRows(KDTable table) {
        LinkedList<Integer> rowList = new LinkedList<Integer>();
        KDTSelectManager selectManager = table.getSelectManager();
        int size = selectManager.size();
        KDTSelectBlock selectBlock = null;
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = selectManager.get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            if (table.getRow(top) == null) {
                return rowList;
            }
            for (int i = top; i <= bottom; ++i) {
                rowList.add(new Integer(i));
            }
        }
        return rowList;
    }

    public static String getStrResource(String key, Object[] params) {
        if (params == null) {
            return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key);
        }
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key, (Object[])params);
    }

    public static KDComboBox getComboBoxByList(List list) {
        KDComboBox comboBox = new KDComboBox();
        for (int i = 0; i < list.size(); ++i) {
            comboBox.addItem(list.get(i));
        }
        return comboBox;
    }

    public static void setTableColumnValue(KDTable table, String column, Object value) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            table.getCell(i, column).setValue(value);
        }
    }
}

