/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.client.ArApRecomputeBalanceUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.Map;

class ArApRecomputeThread
extends Thread {
    private ArApRecomputeBalanceUI ui;

    public ArApRecomputeThread(ArApRecomputeBalanceUI ui) {
        this.ui = ui;
    }

    @Override
    public void run() {
        try {
            this.recomputeForThread();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void recomputeForThread() throws EASBizException, BOSException {
        Object[] params = this.ui.getRecomputeParams();
        StringBuffer sb = new StringBuffer("");
        boolean isAR = (Boolean)params[0];
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params[1];
        ICreateJobFacade createJobFacade = CreateJobFacadeFactory.getRemoteInstance();
        JobConfig jobCfg = this.creteJobCfg(company, isAR);
        if (CreateJobFacadeFactory.getRemoteInstance().checkDuplicateTask(jobCfg.getTaskType())) {
            sb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)((isAR ? "Ar" : "Ap") + "RecomputeIsInQueue")), company.getName()));
            sb.append("\r\n");
        }
        Object objResult = null;
        if (sb.length() == 0) {
            objResult = createJobFacade.executeJob(jobCfg, (Object)params);
            sb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)((isAR ? "Ar" : "Ap") + "RecomputeBalanceInQueue")), company.getName()));
            sb.append("\r\n");
        }
        Map result = null;
        if (objResult instanceof Map) {
            result = (Map)objResult;
        }
        if (result != null && result.get("jobInstExtId") != null) {
            JobMonitorManager.getInstance().addMonitorInfo((String)result.get("jobInstExtId"), jobCfg.getTitle());
        }
        MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)((isAR ? "Ar" : "Ap") + "RecomputeBalanceFinish")), (String)sb.toString(), (int)1);
    }

    private JobConfig creteJobCfg(CompanyOrgUnitInfo company, boolean isAR) {
        String title = "\u3010" + company.getName() + "(" + company.getNumber() + ")\u3011" + EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)((isAR ? "Ar" : "Ap") + "RecomputeBalance"));
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setSyn(true);
        jobCfg.setTaskType("SCM_FI_" + (isAR ? "AR" : "AP") + "_002" + company.getNumber());
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(true);
        jobCfg.setNumber("SCM_FI_" + (isAR ? "AR" : "AP") + "_002");
        jobCfg.setMutex(isAR ? "Arcloseaccount" : "Apcloseaccount");
        return jobCfg;
    }
}

