/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.ReportInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public abstract class ArApReportPrintDelegate
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.client.ArApReportPrintDelegate");
    private String[] cols = null;
    private DecimalFormat amtFormat = null;
    private ArApQueryParam rptParam = null;

    public ArApReportPrintDelegate(ArApQueryParam reportParam) {
        this.rptParam = reportParam;
        this.rptParam.setStartIndex(1);
        this.rptParam.setEndIndex(Integer.MAX_VALUE);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        try {
            return this.getRowSet();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    protected abstract String[] getCols(ArApQueryParam var1);

    protected abstract IReportData getReportData(IReportQueryParam var1) throws BOSException, EASBizException;

    private void initFormatter() {
        if (this.amtFormat != null) {
            return;
        }
        NumberFormat formatter = NumberFormat.getNumberInstance();
        if (formatter instanceof DecimalFormat) {
            this.amtFormat = (DecimalFormat)formatter;
        }
    }

    private void initCols(ArApQueryParam param) {
        if (this.cols == null) {
            this.cols = this.getCols(param);
        }
    }

    protected IRowSet getRowSet() throws BOSException, EASBizException {
        IReportData rptData = this.getReportData((IReportQueryParam)this.rptParam);
        if (rptData == null || rptData.size() == 0) {
            return null;
        }
        this.initFormatter();
        this.initCols(this.rptParam);
        DynamicRowSet drs = null;
        int colsLen = this.cols.length;
        try {
            drs = new DynamicRowSet(colsLen);
            for (int i = 0; i < colsLen; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.cols[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int rptSize = rptData.size();
            for (int i = 0; i < rptSize; ++i) {
                drs.moveToInsertRow();
                ArApReportPrintDelegate.clearRow((IRowSet)drs);
                ReportInfo rptInfo = (ReportInfo)rptData.getReportRowInfo(i);
                this.convert2RowSet((IRowSet)drs, rptInfo, this.rptParam);
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return drs;
    }

    private static void clearRow(IRowSet rs) throws SQLException {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    protected void convert2RowSet(IRowSet rs, ReportInfo rptInfo, ArApQueryParam reportParam) throws SQLException {
        int scale = 2;
        BigDecimal amt = null;
        int n = this.cols.length;
        for (int i = 0; i < n; ++i) {
            String fld = this.cols[i].toString();
            if (rptInfo.get(fld) instanceof BigDecimal) {
                amt = rptInfo.getBigDecimal(fld);
                rs.updateString(fld, this.formatAmt(amt, scale));
                continue;
            }
            rs.updateString(fld, rptInfo.getString(fld));
        }
    }

    protected String formatAmt(BigDecimal amt, int scale) {
        StringBuffer sFormat = new StringBuffer(25);
        sFormat.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            sFormat.append("0");
        }
        this.amtFormat.applyPattern(sFormat.toString());
        return this.amtFormat.format(amt.setScale(scale, 4));
    }
}

