/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.CompanyShutAccountInfo;
import com.kingdee.eas.fi.ar.ShutAccountDetailInfo;
import com.kingdee.eas.fi.arap.IShutAccount;
import com.kingdee.eas.fi.arap.client.AbstractArApShutAccountUI;
import com.kingdee.eas.fi.arap.client.ArApShutAccountTask;
import com.kingdee.eas.scm.cal.client.ShutAccountMsgUI;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ArApShutAccountUI
extends AbstractArApShutAccountUI {
    private static final Logger logger = CoreUIObject.getLogger(ArApShutAccountUI.class);
    private final ArApShutAccountTask shutAccountTask = new ArApManipulateAccountTask(){

        @Override
        protected void doJob() throws BOSException {
            ArApShutAccountUI.this.manipulateAccount(this, true);
        }

        @Override
        public String getActionName() {
            return ArApShutAccountTask.shutAccount;
        }
    };
    private final ArApShutAccountTask disShutAccountTask = new ArApManipulateAccountTask(){

        @Override
        protected void doJob() throws BOSException {
            ArApShutAccountUI.this.manipulateAccount(this, false);
        }

        @Override
        public String getActionName() {
            return ArApShutAccountTask.unShutAccount;
        }
    };
    private ArApShutAccountTask activeTask = null;

    protected void manipulateAccount(ArApShutAccountTask task, boolean isClose) throws BOSException {
        this.activeTask = task;
        HashSet<String> companySet = new HashSet<String>();
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (!this.kdtEntry.getRow(i).getCell("select").getValue().equals(true)) continue;
            String companyID = this.kdtEntry.getRow(i).getCell("companyID").getValue().toString();
            companySet.add(companyID);
            this.kdtEntry.getRow(i).getCell("notes").setValue(null);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
        view.setFilter(filter);
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitCollection companyInfoColl = icompany.getCompanyOrgUnitCollection(view);
        for (int i = 0; i < companyInfoColl.size(); ++i) {
            companyMap.put(companyInfoColl.get(i).getId().toString(), companyInfoColl.get(i));
        }
        IShutAccount shutAccount = this.getShutAccountService();
        if (null == shutAccount) {
            return;
        }
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            boolean isShutAccount = ArApShutAccountTask.shuted.equals(this.kdtEntry.getRow(i).getCell("status").getValue());
            if (!this.kdtEntry.getRow(i).getCell("select").getValue().equals(true)) continue;
            if (isShutAccount ^ isClose) {
                String companyID = this.kdtEntry.getRow(i).getCell("companyID").getValue().toString();
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)companyMap.get(companyID);
                try {
                    if (isClose) {
                        shutAccount.shutAccount(companyInfo, Collections.emptyMap());
                    } else {
                        shutAccount.unshutAccount(companyInfo, Collections.emptyMap());
                    }
                    this.kdtEntry.getRow(i).getCell("notes").setValue((Object)ArApShutAccountTask.success);
                    this.kdtEntry.getRow(i).getCell("status").setValue((Object)(isClose ? ArApShutAccountTask.shuted : ArApShutAccountTask.unshuted));
                    task.addNotes(companyInfo.getId().toString(), ArApShutAccountTask.success);
                    this.kdtEntry.getRow(i).getCell("notes").getStyleAttributes().clearAttributes();
                }
                catch (Exception ex) {
                    this.kdtEntry.getRow(i).getCell("notes").setValue((Object)ArApShutAccountTask.fail);
                    this.kdtEntry.getRow(i).getCell("notes").getStyleAttributes().setFontColor(Color.red);
                    this.kdtEntry.getRow(i).getCell("notes").getStyleAttributes().setUnderline(true);
                    task.addNotes(companyInfo.getId().toString(), ArApShutAccountTask.fail);
                    task.addErrorMsg(companyInfo.getId().toString(), ex.getMessage());
                }
                continue;
            }
            String msg = isClose ? ArApShutAccountTask.shutAccountAlready : ArApShutAccountTask.unshutAccountAlready;
            this.kdtEntry.getRow(i).getCell("notes").setValue((Object)msg);
        }
    }

    protected IShutAccount getShutAccountService() throws BOSException {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtEntry.checkParsed();
        final KDCheckBox cb = new KDCheckBox();
        this.kdtEntry.getHeadRow(0).getCell(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)cb));
        this.kdtEntry.getHeadRow(0).getCell(0).setValue((Object)false);
        this.kdtEntry.getHeadRow(0).getCell(0).getStyleAttributes().setLocked(false);
        cb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                for (int i = 0; i < ArApShutAccountUI.this.kdtEntry.getRowCount(); ++i) {
                    ArApShutAccountUI.this.kdtEntry.getRow(i).getCell(0).setValue((Object)cb.isSelected());
                }
            }
        });
        this.prmtFilter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HashSet<String> companyList = new HashSet<String>();
                Object[] cou = (Object[])ArApShutAccountUI.this.prmtFilter.getValue();
                if (cou != null && cou.length != 0 && cou[0] != null) {
                    for (Object o : cou) {
                        companyList.add(String.valueOf(((CompanyOrgUnitInfo)o).getId()));
                    }
                }
                try {
                    ArApShutAccountUI.this.kdtEntry.getHeadRow(0).getCell(0).setValue((Object)false);
                    ArApShutAccountUI.this.loadRecord(companyList);
                }
                catch (BOSException | EASBizException bosException) {
                    ArApShutAccountUI.this.handleException((Exception)bosException);
                }
            }
        });
        this.kdtEntry.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ArApShutAccountTask activeTask = ArApShutAccountUI.this.getActiveTask();
                if (activeTask == null) {
                    return;
                }
                IRow row = ArApShutAccountUI.this.kdtEntry.getRow(e.getRowIndex());
                String companyID = (String)row.getCell("companyID").getValue();
                if ("notes".equals(ArApShutAccountUI.this.kdtEntry.getColumnKey(e.getColIndex())) && ArApShutAccountTask.fail.equals(activeTask.getNote(companyID))) {
                    String companyName = (String)row.getCell("companyOrgUnitName").getValue();
                    String companyNumber = (String)row.getCell("companyOrgUnitNumber").getValue();
                    ArApShutAccountUI.this.showErrorMsg("\u3010" + companyNumber + "," + companyName + "\u3011" + activeTask.getActionName() + activeTask.getNote(companyID), activeTask.getErrorMsg(companyID));
                }
            }
        });
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        CompanyShutAccountInfo shutInfo = this.getShutAccountService().getCompanyShutInfo(userInfo.getId().toString(), Collections.emptySet());
        List<ShutAccountDetailInfo> list = shutInfo.getList();
        list = null == list ? Collections.emptyList() : list;
        HashSet<String> idSet = new HashSet<String>();
        for (ShutAccountDetailInfo detail : list) {
            if (StringUtils.isEmpty((String)detail.getCompanyId())) continue;
            idSet.add(detail.getCompanyId());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtFilter.setEntityViewInfo(view);
        this.loadData(shutInfo);
    }

    private ArApShutAccountTask getActiveTask() {
        return this.activeTask;
    }

    private void loadRecord(Set<String> companyIds) throws BOSException, EASBizException {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        CompanyShutAccountInfo shutInfo = this.getShutAccountService().getCompanyShutInfo(user.getId().toString(), companyIds);
        this.loadData(shutInfo);
    }

    private void loadData(CompanyShutAccountInfo shutInfo) {
        List<ShutAccountDetailInfo> list = shutInfo.getList();
        list = null == list ? Collections.emptyList() : list;
        this.kdtEntry.removeRows();
        this.kdtEntry.setRowCount(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ShutAccountDetailInfo detail = list.get(i);
            IRow iRow = this.kdtEntry.addRow(i);
            iRow.getCell("select").setValue((Object)false);
            iRow.getCell("companyOrgUnitName").setValue((Object)detail.getCompanyName());
            iRow.getCell("companyOrgUnitNumber").setValue((Object)detail.getCompanyNumber());
            iRow.getCell("period").setValue((Object)detail.getPeriod());
            iRow.getCell("status").setValue((Object)(detail.isStatus() ? ArApShutAccountTask.shuted : ArApShutAccountTask.unshuted));
            iRow.getCell("notes").setValue((Object)"");
            iRow.getCell("companyID").setValue((Object)detail.getCompanyId());
        }
    }

    @Override
    public void actionShutAccount_actionPerformed(ActionEvent e) throws Exception {
        Thread shutAccountThread = new Thread((Runnable)this.shutAccountTask, "\u671f\u672b\u5173\u8d26\u7ebf\u7a0b");
        shutAccountThread.start();
    }

    @Override
    public void actionDisShutAccount_actionPerformed(ActionEvent e) throws Exception {
        Thread shutAccountThread = new Thread((Runnable)this.disShutAccountTask, "\u671f\u672b\u53cd\u5173\u8d26\u7ebf\u7a0b");
        shutAccountThread.start();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    private void showErrorMsg(String errorTitle, String errorMsg) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("errorTitle", errorTitle);
        uiContext.put("errorMsg", errorMsg);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ShutAccountMsgUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
    }

    public boolean destroyWindow() {
        if (this.activeTask != null && this.activeTask.isProcessing()) {
            MsgBox.showInfo((String)ArApShutAccountTask.isClosing);
            return false;
        }
        return super.destroyWindow();
    }

    private boolean isSelected() {
        boolean flag = false;
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (!this.kdtEntry.getRow(i).getCell(0).getValue().equals(true)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void controlButton(boolean enable) {
        this.btnExit.setEnabled(enable);
        this.btnShutAccount.setEnabled(enable);
        this.btnDisShut.setEnabled(enable);
    }

    private abstract class ArApManipulateAccountTask
    extends ArApShutAccountTask {
        private ArApManipulateAccountTask() {
        }

        @Override
        public void run() {
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            ComponentUtil.setWindowsCursorOfWair((Window)window);
            if (!ArApShutAccountUI.this.isSelected()) {
                ComponentUtil.setWindowCursorOfDefault((Window)window);
                ArApShutAccountUI.this.controlButton(true);
                return;
            }
            this.clearResult();
            ArApShutAccountUI.this.controlButton(false);
            this.setProcessing(true);
            try {
                this.doJob();
            }
            catch (Exception e) {
                ArApShutAccountUI.this.handleException(e);
            }
            finally {
                ArApShutAccountUI.this.controlButton(true);
                ComponentUtil.setWindowCursorOfDefault((Window)window);
                this.setProcessing(false);
            }
        }

        protected abstract void doJob() throws BOSException;
    }
}

