/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.IProxyBill;
import com.kingdee.eas.fi.arap.ProxyBillFactory;
import com.kingdee.eas.fi.arap.client.AbstractInitProxyBillListUI;
import com.kingdee.eas.fi.arap.client.ArApProxyQueryProcessor;
import com.kingdee.eas.fi.arap.client.ProxyBillQueryUI;
import com.kingdee.eas.fi.arap.client.util.ArApBatchUtil;
import com.kingdee.eas.fi.arap.util.ArApMutextUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class InitProxyBillListUI
extends AbstractInitProxyBillListUI {
    private static final long serialVersionUID = 2670321916865862186L;
    private static final String ARAP_RESOURCE = "com.kingdee.eas.fi.arap.ArapResource";
    private ProxyBillQueryUI queryPanel = null;
    protected boolean isShowSumRowFlag = false;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public String[] getVisibleFields() {
        return new String[]{"CompanyOrgUnit", "number", "BillStatus", "BillDate", "Businessor", "RecAsstActName", "RecCurrency", "Entry_ReceivableAmt", "Entry_RecVerifyAmt", "Entry_PayAsstActName", "Entry_PayCurrency", "Entry_PayableAmt", "Entry_PayVerifyAmt"};
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            dialog.setShowFilter(true);
            dialog.setShowSorter(true);
            dialog.setHeight(296);
            dialog.setWidth(540);
            dialog.setTitle(EASResource.getString((String)ARAP_RESOURCE, (String)"InitProxyBillQueryTitle"));
            dialog.setProcessor((IProcessor)new ArApProxyQueryProcessor(this.cache));
            dialog.setVisibleTableCols(this.getVisibleFields());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return dialog;
    }

    @Override
    protected CustomerQueryPanel getUserPanel() throws Exception {
        if (this.queryPanel == null) {
            this.queryPanel = new ProxyBillQueryUI(this.cache);
        }
        this.queryPanel.putClientProperty("isInitBill", Boolean.TRUE);
        this.queryPanel.isInitializeBill = true;
        return this.queryPanel;
    }

    @Override
    public void onLoad() throws Exception {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && qfsi.getSystemSolutionItem().getDefaultFilter().size() == 0) {
            Date beforeStartDate = null;
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.cache.getStartPeriod(null).getBeginDate());
            cal.add(13, -1);
            beforeStartDate = cal.getTime();
            qfsi.getSystemSolutionItem().getDefaultFilter().add("CompanyOrgUnit.id", CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add("RecAsstActType.id", CompareType.EQUALS, (Object)String.valueOf(this.cache.getAsstActTypeColl().get(0).getId())).add("Entry.PayAsstActType.id", CompareType.EQUALS, (Object)String.valueOf(this.cache.getApAsstActTypeColl().get(0).getId())).add("BillDate", CompareType.GREATER_EQUALS, (Object)BaseDataUtil.downTimestamp(new Timestamp(beforeStartDate.getTime()))).add("BillDate", CompareType.LESS_EQUALS, (Object)BaseDataUtil.downTimestamp(new Timestamp(beforeStartDate.getTime())));
        }
        super.onLoad();
        this.setOprtState("INITBILLLISTUI");
        this.audit.setVisible(false);
        this.audit.setEnabled(false);
        if (this.cache.isStart(SystemEnum.ACCOUNTSRECEIVABLE) || this.cache.isStart(SystemEnum.ACCOUNTSPAYABLE)) {
            this.setBtnEnabled(false);
        } else {
            this.setBtnEnabled(true);
        }
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.menuBiz.setVisible(true);
        this.menuWorkFlow.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.actionEditVouchers.setEnabled(false);
        this.btnEditVouchers.setEnabled(false);
        this.btnEditVouchers.setVisible(false);
        this.menuItemEditVouchers.setEnabled(false);
        this.menuItemEditVouchers.setVisible(false);
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
        this.tblMain.getColumn("updateUser").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("updateDate").getStyleAttributes().setHided(true);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isInitializeBill", (Object)Integer.valueOf("1"), CompareType.EQUALS));
        FilterInfo endFilter = super.getDefaultFilterForQuery();
        try {
            endFilter.mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return endFilter;
    }

    private void setBtnEnabled(boolean enabled) {
        this.actionImportData.setEnabled(enabled);
        this.actionAddNew.setEnabled(enabled);
        this.actionRemove.setEnabled(enabled);
        this.actionEdit.setEnabled(enabled);
        this.btnAddNew.setEnabled(enabled);
        this.btnRemove.setEnabled(enabled);
        this.btnEdit.setEnabled(enabled);
        this.menuItemAddNew.setEnabled(enabled);
        this.menuItemEdit.setEnabled(enabled);
        this.menuItemRemove.setEnabled(enabled);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"UIClassParam", (Object)"isInitBill");
        super.prepareUIContext(uiContext, e);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("RecCurrency.name"));
        sic.add(new SelectorItemInfo("BillDate"));
        sic.add(new SelectorItemInfo("BillStatus"));
        sic.add(new SelectorItemInfo("RecAsstActName"));
        sic.add(new SelectorItemInfo("CompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("AdminOrgUnit.name"));
        sic.add(new SelectorItemInfo("Businessor.name"));
        sic.add(new SelectorItemInfo("VoucherNumber"));
        sic.add(new SelectorItemInfo("Entry.ReceivableAmt"));
        sic.add(new SelectorItemInfo("Entry.RecVerifyAmt"));
        sic.add(new SelectorItemInfo("Entry.PayAsstActName"));
        sic.add(new SelectorItemInfo("Entry.PayableAmt"));
        sic.add(new SelectorItemInfo("Entry.PayVerifyAmt"));
        sic.add(new SelectorItemInfo("Entry.id"));
        sic.add(new SelectorItemInfo("Entry.RecDiscountAmt"));
        sic.add(new SelectorItemInfo("Entry.PayDiscountAmt"));
        sic.add(new SelectorItemInfo("PayCurrency.name"));
        return sic;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = ArApMutextUtils.getARInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (ArApMutextUtils.requestMutex(null, mutext)) {
            try {
                super.actionAddNew_actionPerformed(e);
            }
            catch (Exception ex) {
                this.handUIExceptionAndAbort(ex);
            }
            finally {
                ArApMutextUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AR_Init"));
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = ArApMutextUtils.getARInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (ArApMutextUtils.requestMutex(null, mutext)) {
            super.actionEdit_actionPerformed(e);
            ArApMutextUtils.releaseMutex(null, mutexID);
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AR_Init"));
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = ArApMutextUtils.getARInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (ArApMutextUtils.requestMutex(null, mutext)) {
            super.actionRemove_actionPerformed(e);
            ArApMutextUtils.releaseMutex(null, mutexID);
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AR_Init"));
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pkIn = LogUtil.beginLog(null, (String)"actionImportData_actionPerformed", (BOSObjectType)this.mainQuery.getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"17_InitOtherBillListUI"));
        super.actionImportData_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pkIn);
    }

    @Override
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pkOut = LogUtil.beginLog(null, (String)"actionExportData_actionPerformed", (BOSObjectType)this.mainQuery.getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"18_InitOtherBillListUI"));
        super.actionExportData_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyTo_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    @Override
    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IProxyBill iProxyBill = ProxyBillFactory.getRemoteInstance();
        String[] billIdlist = this.getSelectedListId();
        Map billNumber = this.getSelectedNumberById();
        ArrayList idList = this.getSelectedIdValues();
        int i = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ar_bill_sureAudit"));
        if (i == 2) {
            return;
        }
        ArApBatchUtil.requestPureMutex(idList);
        StringBuffer errMsg = new StringBuffer();
        for (int j = 0; j < billIdlist.length; ++j) {
            ObjectUuidPK pk = new ObjectUuidPK(billIdlist[j]);
            try {
                iProxyBill.passAudit((IObjectPK)pk, null);
                continue;
            }
            catch (EASBizException ex) {
                String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"199_ArApBillUIUtil"), billNumber.get(billIdlist[j]), this.getBOSEntity().getAlias());
                errMsg.append(msg);
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)ARAP_RESOURCE, (String)"Msg_AuditError"), (String)errMsg.toString(), (int)8188);
        } else {
            this.setMessageText(EASResource.getString((String)ARAP_RESOURCE, (String)"AuditSuccess"));
            this.showMessage();
        }
        this.execQuery();
        ArApBatchUtil.releasePureMutex(idList);
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected boolean isVoucherVisible() {
        return false;
    }

    @Override
    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if (this.cache == null || this.cache.getCompany() == null) {
            try {
                IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
                this.cache = iBillFacade.getSysParams(null, this.getUIParam());
                return this.qfsi.supportSingleMainOrg((OrgUnitInfo)this.cache.getCompany());
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        return this.qfsi;
    }
}

