/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.fi.arap.client.AbstractInvoiceBTPMakeBillFromListUI;
import com.kingdee.eas.fi.arap.client.InvoiceBatchMakeParam;
import com.kingdee.eas.fi.arap.client.InvoiceBatchMakeUI;
import com.kingdee.eas.fi.arap.client.InvoiceBatchMaker;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class InvoiceBTPMakeBillFromListUI
extends AbstractInvoiceBTPMakeBillFromListUI {
    private static final Logger logger = CoreUIObject.getLogger(InvoiceBTPMakeBillFromListUI.class);
    private transient InvoiceBatchMakeParam batchParam = null;
    private boolean fAR = false;
    private boolean fVAT = false;
    private EntityViewInfo lastView = null;
    private boolean fAutoGenerate = false;
    private BTPTransformResult batchTransResult = null;
    private BOTMappingInfo botMappingInfo = null;
    private String destBosType = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAutoMakeInvoice.setIcon(EASResource.getIcon((String)"imgTbtn_autocount"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String sysParam = (String)this.getUIContext().get("isAR");
        this.fAR = sysParam != null && sysParam.equals("true");
        String vatFlag = (String)this.getUIContext().get("isVAT");
        this.fVAT = vatFlag != null && vatFlag.equals("true");
        this.botMappingInfo = (BOTMappingInfo)this.getUIContext().get("mappingInfo");
        this.destBosType = (String)this.getUIContext().get("destBillBOSTypeString");
        this.btnAutoMakeInvoice.setVisible(false);
        this.actionAutoMakeInvoice.setEnabled(false);
    }

    protected CoreBillListUI newTab(EntityObjectInfo srcEntity) throws UIException {
        CoreBillListUI uiObj = super.newTab(srcEntity);
        if (uiObj != null) {
            if (uiObj.getUIContext() != null) {
                uiObj.getUIContext().put("BOTP_Invoice", "true");
            }
            this.lastView = uiObj.getMainQuery();
        }
        return uiObj;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.currentBillListUI != null) {
            this.lastView = this.currentBillListUI.getMainQuery();
        }
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.batchParam == null || this.batchParam.getInvList().size() == 0) {
            super.actionConfirm_actionPerformed(e);
        } else {
            this.batchMakeInvoice();
            this.disposeUIWindow();
        }
    }

    private void batchMakeInvoice() throws Exception {
        if (this.batchParam == null) {
            return;
        }
        CoreBillListUI billListUI = (CoreBillListUI)this.tblPanel.getComponentAt(0);
        this.batchTransResult = new InvoiceBatchMaker(billListUI.getBOTPSelectors(), this.fVAT).batchTransfter(this.botMappingInfo, this.lastView, this.batchParam, this.fAR);
    }

    @Override
    public void actionAutoMakeInvoice_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> uiCtx = new HashMap<String, Object>();
        uiCtx.put("lastView", this.lastView);
        uiCtx.put("autoParam", this.batchParam);
        uiCtx.put("fAR", this.fAR);
        IUIWindow autoInvWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.arap.client.InvoiceAutoMakeUI", uiCtx);
        autoInvWin.show();
        InvoiceBatchMakeUI batchUI = (InvoiceBatchMakeUI)autoInvWin.getUIObject();
        if (batchUI.isConfirm()) {
            this.batchParam = batchUI.getBatchParam();
            if (this.batchParam != null) {
                this.fAutoGenerate = true;
            }
        }
    }

    public boolean isBatchGenInv() {
        return this.fAutoGenerate;
    }

    public BTPTransformResult getBatchGenResult() throws Exception {
        return this.batchTransResult;
    }

    public boolean isPrepareDestroyWindow() {
        return true;
    }

    public IUIActionPostman prepareDestroyWindow() {
        IUIActionPostman handler = super.prepareDestroyWindow();
        if (handler != null) {
            RequestContext request = new RequestContext();
            if (!this.isBatchGenInv()) {
                request.put("srcBillCollection", (Object)this.getSrcBillCollection());
                request.put("destBosType", (Object)this.destBosType);
                request.put("mappingInfo", (Object)this.botMappingInfo);
                handler.setRequestContext((Serializable)request);
            }
        }
        return handler;
    }
}

