/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.arap.InvoiceHelper;
import com.kingdee.eas.fi.arap.client.AbstractInvoiceBTPRuleSelectUI;
import com.kingdee.eas.fi.arap.client.InvoiceBTPMakeBillFromListUI;
import com.kingdee.eas.fi.arap.client.InvoiceBTPUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvoiceBTPRuleSelectUI
extends AbstractInvoiceBTPRuleSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(InvoiceBTPRuleSelectUI.class);
    private String RESNAME = "com.kingdee.eas.base.btp.btpResource";
    private Map srcBillNameToObject;
    private String destBosType;
    protected BOTMappingCollection botMappingCollection = null;
    private String orgUnitPropertyInBill = "companyOrgUnit";
    private OrgType orgType = OrgType.Company;
    private EntityViewInfo botpFilter;
    protected static final String TRANSMITCU = "TRANSMITCU";
    private static final String AROTHERBILL_TYPE = new OtherBillInfo().getBOSType().toString();
    private boolean fVAT = false;

    public void onShow() throws Exception {
        super.onShow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.destBosType = this.getUIContext().get("destBillBOSTypeString").toString();
        Object vatParam = this.getUIContext().get("isVAT");
        if (vatParam != null && vatParam.equals("true")) {
            this.fVAT = true;
        }
        this.fillSrcBosType();
    }

    protected String getDestBosType() {
        return this.destBosType;
    }

    protected BOTMappingCollection getMappingCollection() {
        return this.botMappingCollection;
    }

    protected void fillSrcBosType() throws Exception {
        IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
        String srcBillBosTypeAndAlias = iBOTMapping.getSourceBillTypeListAndAlias(this.destBosType);
        String[] srcBillBosTypeAndAliasArray = StringUtil.split((String)srcBillBosTypeAndAlias, (String)"|");
        if (srcBillBosTypeAndAliasArray.length != 2) {
            MsgBox.showWarning((Component)((Component)this.getUIContext().get("Owner")), (String)EASResource.getString((String)this.RESNAME, (String)"noDestBill"));
            SysUtil.abort();
        }
        String[] srcBillBosTypeArray = StringUtil.split((String)srcBillBosTypeAndAliasArray[0], (String)",");
        String[] srcBillAliasArray = StringUtil.split((String)srcBillBosTypeAndAliasArray[1], (String)",");
        List srcBillBosTypeList = new ArrayList<String>();
        int count = srcBillBosTypeArray.length;
        for (int i = 0; i < count; ++i) {
            srcBillBosTypeList.add(srcBillBosTypeArray[i]);
        }
        CoreBillEditUI billEditUI = (CoreBillEditUI)this.getUIContext().get("billEdit");
        srcBillBosTypeList = billEditUI.getSrcBosTypeForBotp(srcBillBosTypeList);
        if (srcBillBosTypeList == null || srcBillBosTypeList.size() == 0) {
            MsgBox.showWarning((Component)((Component)this.getUIContext().get("Owner")), (String)EASResource.getString((String)this.RESNAME, (String)"noDestBill"));
            SysUtil.abort();
        }
        this.srcBillNameToObject = new HashMap();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        for (int i = 0; i < srcBillBosTypeArray.length; ++i) {
            if (!srcBillBosTypeList.contains(srcBillBosTypeArray[i])) continue;
            EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)srcBillBosTypeArray[i]));
            this.srcBillNameToObject.put(tempObj.getAlias(), srcBillBosTypeArray[i]);
            this.comboSrcBosType.addItem((Object)tempObj.getAlias());
        }
        if (this.comboSrcBosType.getItemCount() > 0) {
            this.comboSrcBosType.setSelectedIndex(0);
        }
    }

    @Override
    protected void comboSrcBosType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        String srcBosType = this.srcBillNameToObject.get(this.comboSrcBosType.getSelectedItem()).toString();
        CoreBillEditUI billEditUI = (CoreBillEditUI)this.getUIContext().get("billEdit");
        OrgUnitInfo orgUnit = billEditUI.getMainOrgInfo();
        if (orgUnit != null) {
            orgUnit = orgUnit.getCU();
        }
        HashMap<String, OrgUnitInfo> transmitCtx = new HashMap<String, OrgUnitInfo>();
        transmitCtx.put(TRANSMITCU, orgUnit);
        this.setValidMappings(srcBosType, transmitCtx);
    }

    protected void setValidMappings(String srcBosType, Map transmitCtx) throws BOSException, EASBizException {
        IBOTMapping iBotMapping = BOTMappingFactory.getRemoteInstance();
        BOTMappingCollection mappings = null;
        try {
            mappings = iBotMapping.getMappingCollectionForSelectWithoutData(srcBosType, this.getDestBosType(), transmitCtx);
        }
        catch (BOTPException botE) {
            if (this.getUIWindow() != null) {
                throw botE;
            }
            logger.error((Object)botE);
        }
        this.comboBotMapping.removeAllItems();
        if (mappings == null || mappings.size() == 0) {
            return;
        }
        BOTMappingCollection filteredColls = new BOTMappingCollection();
        Locale curLocale = SysContext.getSysContext().getLocale();
        int count = mappings.size();
        ArrayList<String> mappingAlias = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            BOTMappingInfo mappingInfo = mappings.get(i);
            boolean isVATRule = this.isVATRule(iBotMapping, mappingInfo);
            if ((!this.fVAT || !isVATRule) && (this.fVAT || isVATRule)) continue;
            filteredColls.add(mappingInfo);
            mappingAlias.add(mappingInfo.getAlias(curLocale));
        }
        this.botMappingCollection = filteredColls;
        this.comboBotMapping.addItems(mappingAlias.toArray());
        if (filteredColls.size() > 0) {
            this.comboBotMapping.setSelectedIndex(0);
        }
    }

    private boolean isVATRule(IBOTMapping botMapping, BOTMappingInfo mappingInfo) throws BOSException, EASBizException {
        BOTMappingInfo infoRules = botMapping.getBOTMappingInfo("select rules.ruleSegments.* where id = '" + mappingInfo.getId() + "'");
        return InvoiceHelper.isVATMapping(infoRules);
    }

    @Override
    protected void comboBotMapping_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        if (this.botMappingCollection != null && this.botMappingCollection.size() > 0) {
            BOTMappingInfo botMappingInfo = this.botMappingCollection.get(this.comboBotMapping.getSelectedIndex());
            this.botpFilter = this.getQueryFilterFromBotMapping(botMappingInfo);
            this.mergeOrgFilterAndSetSrcBizBillFilter();
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.botMappingCollection == null || this.comboBotMapping.getSelectedIndex() < 0) {
            throw new BOTPException(BOTPException.NOMAPPING);
        }
        BOTMappingInfo botMappingInfo = this.botMappingCollection.get(this.comboBotMapping.getSelectedIndex());
        String srcBosType = this.srcBillNameToObject.get(this.comboSrcBosType.getSelectedItem()).toString();
        HashMap uiCtx = this.prepareSrcBillUICtx(srcBosType, botMappingInfo);
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.arap.client.InvoiceBTPMakeBillFromListUI", (Map)uiCtx);
        ((UIModelDialog)uiWin).setResizable(true);
        InvoiceBTPMakeBillFromListUI srcListUI = (InvoiceBTPMakeBillFromListUI)uiWin.getUIObject();
        srcListUI.setSrcBosType(srcBosType);
        uiWin.show();
        if (srcListUI.isCancel()) {
            return;
        }
        this.transSrcObjCollection(botMappingInfo, srcListUI);
    }

    protected void transSrcObjCollection(BOTMappingInfo botMappingInfo, InvoiceBTPMakeBillFromListUI srcListUI) throws BOSException, EASBizException, Exception, BOTPException, DAPException, BTPException {
        BTPTransformResult btpResult = null;
        if (srcListUI.isBatchGenInv()) {
            btpResult = srcListUI.getBatchGenResult();
        } else {
            CoreBillBaseCollection srcBillCollection = srcListUI.getSrcBillCollection();
            if (srcBillCollection != null && srcBillCollection.size() > 0) {
                ArApBillHelper.getSrcDebitAdjCollection(null, srcBillCollection);
                IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
                this.getUIContext().put("ifOk", "NO");
                CoreBillEditUI billEdit = (CoreBillEditUI)this.getUIContext().get("billEdit");
                billEdit.setMakeRelations(null);
                ObjectUuidPK mappingPk = new ObjectUuidPK(botMappingInfo.getId());
                InvoiceBTPUtil.verifyBillAndBotMapping((IObjectCollection)srcBillCollection, (IObjectPK)mappingPk, this.destBosType);
                btpResult = iBTPManager.transformForBotp(srcBillCollection, this.destBosType, (IObjectPK)mappingPk);
            }
        }
        if (btpResult == null) {
            return;
        }
        this.getUIContext().put("ifOk", "NO");
        CoreBillEditUI billEdit = (CoreBillEditUI)this.getUIContext().get("billEdit");
        billEdit.setMakeRelations(null);
        this.getUIContext().put("botMappingInfo", botMappingInfo);
        this.getUIContext().put("destBills", btpResult.getBills());
        this.getUIContext().put("relations", btpResult.getBOTRelationCollection());
        this.getUIContext().put("ifOk", "YES");
        this.disposeUIWindow();
    }

    private HashMap prepareSrcBillUICtx(String srcBosType, BOTMappingInfo botMappingInfo) throws BOSException {
        HashMap<String, Object> uiCtx = new HashMap<String, Object>();
        uiCtx.put("Owner", (Object)this);
        uiCtx.put("mappingInfo", botMappingInfo);
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            uiCtx.put("BTPEDITPARAMETER", this.getUIContext().get("BTPEDITPARAMETER"));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)Integer.valueOf("0"), CompareType.EQUALS));
        this.botpFilter.getFilter().mergeFilter(filter, "AND");
        uiCtx.put("BOTPFilter", this.botpFilter);
        if (srcBosType.equals(AROTHERBILL_TYPE)) {
            uiCtx.put("isAR", "true");
        }
        uiCtx.put("isVAT", this.getUIContext().get("isVAT"));
        uiCtx.put("destBillBOSTypeString", this.destBosType);
        return uiCtx;
    }

    private EntityViewInfo getQueryFilterFromBotMapping(BOTMappingInfo botMappingInfo) throws ParserException, BOSException {
        EntityViewInfo filter = null;
        if (botMappingInfo.getExtRule().getFilter() != null && botMappingInfo.getExtRule().getFilter().length() > 0) {
            filter = new EntityViewInfo(botMappingInfo.getExtRule().getFilter());
        }
        EntityViewInfo dataFilter = null;
        if (botMappingInfo.getExtRule().getDataFilter() != null && botMappingInfo.getExtRule().getDataFilter().length() > 0) {
            dataFilter = new EntityViewInfo(botMappingInfo.getExtRule().getDataFilter());
        }
        return this.mergeEntityFilterAndTransToQueryFilter(filter, dataFilter);
    }

    private EntityViewInfo mergeEntityFilterAndTransToQueryFilter(EntityViewInfo filter, EntityViewInfo dataFilter) throws BOSException {
        EntityViewInfo botpFilter = new EntityViewInfo();
        if (filter == null) {
            botpFilter = dataFilter;
        } else if (dataFilter == null) {
            botpFilter = filter;
        } else {
            FilterInfo billFilter = null;
            if (filter.getFilter() == null || filter.getFilter().getFilterItems().size() == 0) {
                billFilter = dataFilter.getFilter();
            } else if (dataFilter.getFilter() == null || dataFilter.getFilter().getFilterItems().size() == 0) {
                billFilter = filter.getFilter();
            } else {
                billFilter = filter.getFilter();
                billFilter.mergeFilter(dataFilter.getFilter(), "and");
            }
            if (billFilter == null) {
                billFilter = new FilterInfo();
            }
            botpFilter.setFilter(billFilter);
            FilterCollection entryFilterCols = null;
            if (filter.getEntryFilters() == null && filter.getEntryFilters().size() == 0) {
                entryFilterCols = dataFilter.getEntryFilters();
            } else if (dataFilter.getEntryFilters() == null || dataFilter.getEntryFilters().size() == 0) {
                entryFilterCols = filter.getEntryFilters();
            } else {
                entryFilterCols = new FilterCollection();
                entryFilterCols.addObjectCollection((IObjectCollection)filter.getEntryFilters());
                entryFilterCols.addObjectCollection((IObjectCollection)dataFilter.getEntryFilters());
            }
            if (entryFilterCols != null && entryFilterCols.size() > 0) {
                botpFilter.getEntryFilters().addObjectCollection((IObjectCollection)entryFilterCols);
            }
        }
        if (botpFilter == null) {
            botpFilter = new EntityViewInfo();
        }
        if (botpFilter.getFilter() == null) {
            FilterInfo defaultFilter = new FilterInfo();
            botpFilter.setFilter(defaultFilter);
        }
        if (botpFilter.getEntryFilters() != null && botpFilter.getEntryFilters().size() > 0) {
            FilterCollection entryFilterCols = botpFilter.getEntryFilters();
            FilterInfo billFilter = botpFilter.getFilter();
            FilterInfo entryQueryFilter = new FilterInfo();
            if (entryFilterCols != null && entryFilterCols.size() > 0) {
                int size = entryFilterCols.size();
                for (int i = 0; i < size; ++i) {
                    FilterInfo entryFilterInfo = entryFilterCols.get(i);
                    if (entryFilterInfo == null || entryFilterInfo.getFilterItems().size() <= 0) continue;
                    String entryName = entryFilterInfo.getEntryName();
                    int count = entryFilterInfo.getFilterItems().size();
                    for (int j = 0; j < count; ++j) {
                        entryQueryFilter.getFilterItems().add(new FilterItemInfo(entryName + '.' + entryFilterInfo.getFilterItems().get(j).getPropertyName(), entryFilterInfo.getFilterItems().get(j).getCompareValue(), entryFilterInfo.getFilterItems().get(j).getCompareType()));
                    }
                }
            }
            if (entryQueryFilter.getFilterItems().size() > 0) {
                if (billFilter.getFilterItems().size() > 0) {
                    billFilter.mergeFilter(entryQueryFilter, "and");
                } else {
                    billFilter = entryQueryFilter;
                }
            }
            botpFilter.getEntryFilters().clear();
            botpFilter.setFilter(billFilter);
        }
        return botpFilter;
    }

    private void mergeOrgFilterAndSetSrcBizBillFilter() {
        EntityViewInfo bizBillQueryFilter;
        OrgUnitInfo ouInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (this.botpFilter == null) {
            bizBillQueryFilter = new EntityViewInfo();
            bizBillQueryFilter.setFilter(new FilterInfo());
        } else {
            bizBillQueryFilter = (EntityViewInfo)this.botpFilter.clone();
        }
        if (ouInfo == null) {
            ouInfo = SysContext.getSysContext().getCurrentOrgUnit(this.orgType);
        }
        if (ouInfo != null) {
            FilterItemInfo ouFilterItemInfo = new FilterItemInfo(this.orgUnitPropertyInBill + ".id", (Object)ouInfo.getId().toString());
            bizBillQueryFilter.getFilter().getFilterItems().add(ouFilterItemInfo);
            if (bizBillQueryFilter.getFilter().getMaskString() != null && bizBillQueryFilter.getFilter().getMaskString().length() > 0) {
                StringBuffer mask = new StringBuffer();
                mask.append("(");
                mask.append(bizBillQueryFilter.getFilter().getMaskString());
                mask.append(") and #");
                mask.append(bizBillQueryFilter.getFilter().getFilterItems().size() - 1);
                bizBillQueryFilter.getFilter().setMaskString(mask.toString());
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

