/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import java.math.BigDecimal;

public class InvoiceBTPUtil {
    public static final String INV_BTP_FLAG = "BOTP_Invoice";
    public static final BigDecimal HUNDRED = new BigDecimal("100");

    private InvoiceBTPUtil() {
    }

    public static void verifyBillAndBotMapping(IObjectCollection srcBillCols, IObjectPK botMappingPK, String destBosType) throws BOTPException, BOSException, DAPException {
        String botMappingIdStr = botMappingPK.toString();
        boolean isSuitable = false;
        IBOTMapping iBotMapping = BOTMappingFactory.getRemoteInstance();
        BOTMappingCollection botMappingCols = iBotMapping.getMappingCollectionForSelect((CoreBillBaseCollection)srcBillCols, destBosType, DefineSysEnum.BTP);
        if (botMappingCols != null) {
            for (BOTMappingInfo botMappingInfo : botMappingCols) {
                if (!botMappingInfo.getId().toString().equals(botMappingIdStr)) continue;
                isSuitable = true;
                break;
            }
        }
        if (!isSuitable) {
            throw new DAPException(DAPException.BOTMAPPINGNOTSUITABLEFORBILLSELECTED, new Object[]{""});
        }
    }
}

