/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.IInvoice;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.client.AbstractInvoiceListUI;
import com.kingdee.eas.fi.arap.client.InvCommonQueryProcessor;
import com.kingdee.eas.fi.arap.client.InvoiceQueryUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.GTaxHelper;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.arap_tax.TaxBillTypeEnum;
import com.kingdee.eas.fi.arap_tax.TaxRelationInfo;
import com.kingdee.eas.fi.arap_tax.TaxRelationTypeEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class InvoiceListUI
extends AbstractInvoiceListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(InvoiceListUI.class);
    private KDMenuItem vatMenuItem = new KDMenuItem();
    private KDMenuItem vatBtnMenuItem = new KDMenuItem();
    private KDMenuItem generalMenuItem = new KDMenuItem();
    private KDMenuItem generalBtnMenuItem = new KDMenuItem();
    private boolean fVATNew = true;
    public static final String COL_NUM = "number";
    public static final String COL_DATE = "billDate";
    public static final String COL_STATUS = "billStatus";
    public static final String COL_TYPE = "billType";
    public static final String COL_CUSSTYPE = "asstActType.name";
    public static final String COL_CUSSACCT = "asstAcct";
    public static final String COL_CURRENCY_NAME = "currency.name";
    public static final String COL_AMOUNT = "amount";
    public static final String COL_TAXRATE = "taxRate";
    public static final String COL_TOTALAMT = "totalAmount";
    public static final String COL_CUSSADDRESS = "cussAddress";
    public static final String COL_CUSSPHONE = "cussPhone";
    public static final String COL_CUSSBANK = "cussBank";
    public static final String COL_CUSSACCTBANK = "cussAcctBank";
    public static final String COL_TAXREGISTERNO = "taxRegisterNo";
    public static final String COL_ACCOUNTBANK = "accountBank";
    public static final String COL_DESCRIPTION = "description";
    public static final String COL_DRAWER = "drawer";
    public static final String COL_AUDITPERSON = "auditPerson";
    public static final String COL_INVPERSON = "invPerson";
    public static final String COL_CURR_PRECISION = "currency.precision";
    public static final String COL_UNITPRICE_PRECISION = "material.pricePrecision";
    public static final String COL_ENTRY_UNITPRICE = "entries.unitPrice";
    public static final String COL_ENTRY_AMOUNT = "entries.amount";
    public static final String COL_ENTRY_TAXAMOUNT = "entries.taxAmount";
    public static final String COL_ENTRY_ACTUALAMOUNT = "entries.actualamount";
    private static final String[] LOCATE_COLS = new String[]{"number", "asstAcct"};
    public static final String TakeOutZeroFormat = "%{0.##########}f";
    private static final String[] BILL_COUNT_FIELDS = new String[]{"id"};
    public static final String INV_RES = "com.kingdee.eas.fi.arap.InvResource";
    protected KDMenu menuAddNew = new KDMenu();
    protected CompanyOrgUnitInfo companyInfo = null;
    protected CurrencyInfo baseCurrency = null;
    protected int basePrecision = 2;
    protected InvoiceQueryUI queryUI = null;
    protected boolean isSCMBill = false;
    private CommonQueryDialog dialog = null;

    protected boolean isFootVisible() {
        return true;
    }

    protected void initWorkButton() {
        try {
            if (SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)this.getSystemEnumForOA(), (CompanyOrgUnitInfo)this.companyInfo) == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.companyInfo.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.btnBlankout.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.setButtonDefaultStyl(this.btnBlankout);
        this.menuItemBlankout.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnGTaxExport.setIcon(EASResource.getIcon((String)"imgTbtn_createtax"));
        this.menuItemGTaxExport.setIcon(EASResource.getIcon((String)"imgTbtn_createtax"));
        this.setButtonDefaultStyl(this.btnGTaxExport);
    }

    private void setAddNewMenu() {
        String invRes = INV_RES;
        this.vatMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)this.actionAddNew, (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.vatMenuItem.setText(EASResource.getString((String)invRes, (String)"MenuItem_VAT"));
        this.vatBtnMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)this.actionAddNew, (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.vatBtnMenuItem.setText(EASResource.getString((String)invRes, (String)"MenuItem_VAT"));
        this.generalMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionGeneralAddNew), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.generalMenuItem.setText(EASResource.getString((String)invRes, (String)"MenuItem_General"));
        this.generalBtnMenuItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionGeneralAddNew), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.generalBtnMenuItem.setText(EASResource.getString((String)invRes, (String)"MenuItem_General"));
        this.menuFile.removeAll();
        this.menuAddNew.setName("menuAddNew");
        this.menuAddNew.setText(EASResource.getString((String)invRes, (String)"Menu_AddNew"));
        this.menuFile.add((JMenuItem)this.menuAddNew);
        this.menuFile.add((Component)this.separatorFile1);
        this.menuFile.add((JMenuItem)this.menuItemGTaxExport);
        this.menuFile.add((JMenuItem)this.menuItemBlankout);
        this.menuFile.add((JMenuItem)this.MenuItemAttachment);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemPageSetup);
        this.menuFile.add((JMenuItem)this.menuItemPrint);
        this.menuFile.add((JMenuItem)this.menuItemPrintPreview);
        this.menuFile.add((Component)this.kDSeparator2);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuAddNew.add((JMenuItem)this.vatMenuItem);
        this.btnAddNew.addAssistMenuItem((JMenuItem)this.vatBtnMenuItem);
        this.btnAddNew.addAssistMenuItem((JMenuItem)this.generalBtnMenuItem);
    }

    private String getResource() {
        return "com.kingdee.eas.fi.ar.client.ArResource";
    }

    private void checkBeforeLoad() throws Exception {
        this.companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.baseCurrency = CommonClientUtils.getCurrency(String.valueOf(this.companyInfo.getBaseCurrency().getId()));
        if (this.baseCurrency != null) {
            this.basePrecision = this.baseCurrency.getPrecision();
        }
    }

    protected String getEditUIName() {
        if (this.fVATNew) {
            return this.getVATEditUIName();
        }
        return this.getNormalEditUIName();
    }

    @Override
    public void actionGeneralAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.actionAddNew_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        Object source = e.getSource();
        if (source == this.generalMenuItem || source == this.generalBtnMenuItem) {
            this.fVATNew = false;
        }
        super.actionAddNew_actionPerformed(e);
        this.fVATNew = true;
    }

    protected String getEditUIModal() {
        String openModel = UIConfigUtility.getOpenModel();
        if (openModel != null) {
            return openModel;
        }
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "company.id";
    }

    protected String getPropertyOfBizDate() {
        return COL_DATE;
    }

    public void onLoad() throws Exception {
        this.checkBeforeLoad();
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && qfsi.getSystemSolutionItem().getDefaultFilter().size() == 0) {
            boolean fAR = SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.getSystemEnumForOA());
            if (fAR && SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
                qfsi.getSystemSolutionItem().getDefaultFilter().add("drawer.id", CompareType.EQUALS, (Object)String.valueOf(SysContext.getSysContext().getCurrentUserInfo().getPerson().getId()));
            }
            qfsi.getSystemSolutionItem().getDefaultFilter().add("currency.id", CompareType.EQUALS, (Object)String.valueOf(this.companyInfo.getBaseCurrency().getId())).add("asstActType.id", CompareType.EQUALS, (Object)CommonClientUtils.getDefaultAsstTypeId(this.companyInfo.getId(), fAR)).add(this.getPropertyOfBizOrg(this.getMainBizOrgType()), CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add(this.getPropertyOfBizDate(), CompareType.IS, (Object)DateEnum.RECENTONEMONTH);
        }
        super.onLoad();
        this.setAddNewMenu();
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])new String[]{"entries.quantity"}, (String)TakeOutZeroFormat);
        String tRateFormat = PrecisionFormatUtils.getFormatString(2);
        this.tblMain.getColumn("entries.taxRate").getStyleAttributes().setNumberFormat(tRateFormat);
        this.tblMain.getColumn(COL_DATE).getStyleAttributes().setNumberFormat(ArApBillUtil.getDateFormatString());
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                InvoiceListUI.this.tblMain_afterDataFill(e);
            }
        });
        int iFrzInd = this.tblMain.getColumnIndex(COL_TOTALAMT);
        this.tblMain.getViewManager().setFreezeView(-1, iFrzInd + 1);
        this.tblMain.setColumnMoveable(true);
        this.btnAuditResult.setVisible(false);
        this.setCurrPeriod2Status();
        this.btnRemove.setVisible(true);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
    }

    protected void setCurrPeriod2Status() throws Exception {
        if (this.companyInfo == null) {
            return;
        }
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)this.getSystemEnumForOA(), (CompanyOrgUnitInfo)this.companyInfo);
        if (currPeriod == null) {
            return;
        }
        String title = EASResource.getString((String)this.getResource(), (String)"StatusCurrPeriod");
        title = MessageFormat.format(title, String.valueOf(currPeriod.getPeriodYear()), String.valueOf(currPeriod.getPeriodNumber()));
        this.getMainStatusBar().setPerTitle(title);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (SysContext.getSysContext().getSessionID() == null) {
            return;
        }
        String id = this.getSelectedKeyValue();
        if (!StringUtils.isEmpty((String)id)) {
            InvoiceInfo info = (InvoiceInfo)this.getBizInterface().getValue("select billStatus where id = '" + id + "' ");
            boolean fValid = BillStatusEnum.SUBMITED.equals((Object)info.getBillStatus());
            this.actionAttachment.setEnabled(fValid);
            this.actionBlankout.setEnabled(fValid);
            this.actionTraceUp.setEnabled(fValid);
        }
    }

    public void tblMain_afterDataFill(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        for (int i = firstRow; i <= lastRow; ++i) {
            IRow row = this.tblMain.getRow(i);
            int precision = this.getCellPrecision(row, COL_CURR_PRECISION);
            String fmt = PrecisionFormatUtils.getFormatString(precision);
            row.getCell(COL_ENTRY_AMOUNT).getStyleAttributes().setNumberFormat(fmt);
            row.getCell(COL_ENTRY_TAXAMOUNT).getStyleAttributes().setNumberFormat(fmt);
            if (row.getCell(COL_AMOUNT) != null && row.getCell(COL_TAXRATE) != null) {
                row.getCell(COL_AMOUNT).getStyleAttributes().setNumberFormat(fmt);
                row.getCell(COL_TAXRATE).getStyleAttributes().setNumberFormat(fmt);
            }
            row.getCell(COL_TOTALAMT).getStyleAttributes().setNumberFormat(fmt);
            row.getCell(COL_ENTRY_ACTUALAMOUNT).getStyleAttributes().setNumberFormat(fmt);
            row.getCell(COL_ENTRY_ACTUALAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            boolean isMaterialNull = row.getCell("material").getValue() == null || "".equals(row.getCell("material").getValue().toString().trim());
            int unitPrecision = isMaterialNull ? 6 : this.getCellPrecision(row, COL_UNITPRICE_PRECISION);
            ArApBillUIUtil.setPrecision(row.getCell(COL_ENTRY_UNITPRICE), unitPrecision);
        }
    }

    private int getCellPrecision(IRow row, String col) {
        int precision = 2;
        ICell cell = row.getCell(col);
        if (cell != null && cell.getValue() != null) {
            try {
                precision = Integer.parseInt(cell.getValue().toString());
            }
            catch (NumberFormatException ex) {
                logger.error((Object)("error " + col + " precision"), (Throwable)ex);
            }
        }
        return precision;
    }

    protected boolean isAR() {
        return false;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    protected String[] getCountQueryFields() {
        return BILL_COUNT_FIELDS;
    }

    protected String[] getLocateNames() {
        return LOCATE_COLS;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            this.dialog.setVisibleTableCols(this.getVisibleFields());
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        this.dialog.addUserPanel((KDPanel)this.getQueryPanel());
        this.dialog.setWidth(555);
        this.dialog.setHeight(267);
        InvCommonQueryProcessor processor = new InvCommonQueryProcessor();
        this.dialog.setProcessor((IProcessor)processor);
        this.dialog.setVisibleTableCols(this.getVisibleFields());
        return this.dialog;
    }

    protected String[] getVisibleFields() {
        return null;
    }

    protected InvoiceQueryUI getQueryPanel() {
        if (this.queryUI != null) {
            return this.queryUI;
        }
        try {
            this.queryUI = new InvoiceQueryUI(this.isAR());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.queryUI;
    }

    protected String getNormalEditUIName() {
        return null;
    }

    protected String getVATEditUIName() {
        return null;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        this.getMenuParam();
        if (ev == null) {
            return;
        }
        super.beforeExcutQuery(ev);
    }

    private void getMenuParam() {
        String sIsSCMBill = (String)this.getUIContext().get("UIClassParam");
        this.isSCMBill = "isSCMBill".equals(sIsSCMBill);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        InvoiceTypeEnum type = this.getSelectedInvType();
        if (type == null) {
            logger.warn((Object)"the invoice type is strange!");
            return;
        }
        String editUIName = null;
        if (InvoiceTypeEnum.GENERAL.equals((Object)type)) {
            editUIName = this.getNormalEditUIName();
        } else if (InvoiceTypeEnum.VAT.equals((Object)type)) {
            editUIName = this.getVATEditUIName();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow editUI = null;
        editUI = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(editUIName, (Map)uiContext, null, OprtState.VIEW);
        editUI.show();
        if (this.isDoRefresh(editUI)) {
            this.isModify = true;
            this.refresh(e);
        }
    }

    protected boolean hasDiffInvType() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length < 2) {
            return false;
        }
        BizEnumValueInfo firstType = (BizEnumValueInfo)this.tblMain.getRow(selectRows[0]).getCell(COL_TYPE).getValue();
        if (firstType == null) {
            return false;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tblMain.getRow(selectRows[i]);
            BizEnumValueInfo enumVal = (BizEnumValueInfo)row.getCell(COL_TYPE).getValue();
            if (firstType.equals((Object)enumVal)) continue;
            return true;
        }
        return false;
    }

    protected InvoiceTypeEnum getSelectedInvType() {
        int rowIndex;
        IRow row;
        BizEnumValueInfo enumVal;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0 && (enumVal = (BizEnumValueInfo)(row = this.tblMain.getRow(rowIndex = selectRows[0])).getCell(COL_TYPE).getValue()) != null) {
            int type = Integer.parseInt((String)enumVal.getValue());
            return InvoiceTypeEnum.getEnum(type);
        }
        return null;
    }

    @Override
    public void actionBlankout_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedIds = this.getSelectedIdValues();
        if (selectedIds == null) {
            return;
        }
        if (selectedIds.size() == 1) {
            String id = selectedIds.get(0).toString();
            InvoiceInfo info = (InvoiceInfo)this.getBizInterface().getValue("select id, billStatus where id = '" + id + "' ");
            if (BillStatusEnum.DELETED.equals((Object)info.getBillStatus())) {
                logger.warn((Object)"the bill has been blankouted!");
                return;
            }
        }
        HashSet idSet = new HashSet();
        idSet.addAll(selectedIds);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        if (!this.getBizInterface().exists(filter)) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        boolean fRecycleNum = false;
        int iChoice = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)INV_RES, (String)"RecycleNum"));
        if (iChoice == 2) {
            return;
        }
        if (iChoice == 0) {
            fRecycleNum = true;
        }
        int size = selectedIds.size();
        ObjectUuidPK[] pks = new ObjectUuidPK[size];
        for (int i = 0; i < size; ++i) {
            pks[i] = new ObjectUuidPK(selectedIds.get(i).toString());
        }
        ((IInvoice)this.getBizInterface()).blankout((IObjectPK[])pks, fRecycleNum);
        this.refreshList();
    }

    protected TaxRelationInfo getTaxRelationInfo(TaxRelationTypeEnum type) throws BOSException {
        return GTaxHelper.getDefaultRelation(type, TaxBillTypeEnum.SaleInvoice, this.companyInfo.getId());
    }

    @Override
    public void actionGTaxExport_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getOrgFieldName() {
        return "company.id";
    }

    protected void execQuery() {
        if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
            FilterItemCollection filterItemColl = this.mainQuery.getFilter().getFilterItems();
            FilterItemInfo filterItemInfo = null;
            if (filterItemColl != null && filterItemColl.size() > 0) {
                int count = filterItemColl.size();
                for (int i = 0; i < count; ++i) {
                    filterItemInfo = filterItemColl.get(i);
                    if (filterItemInfo == null || !"company.id".equals(filterItemInfo.getPropertyName())) continue;
                    filterItemInfo.setCompareValue((Object)String.valueOf(SysContext.getSysContext().getCurrentFIUnit().getId()));
                }
            }
        }
        super.execQuery();
    }
}

