/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IAddress;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ap.ApInvoiceInfo;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceEntryCollection;
import com.kingdee.eas.fi.arap.InvoiceEntryInfo;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class InvoicePrintDataProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.client.InvoicePrintDataProvider");
    private InvoiceInfo info = null;

    public InvoicePrintDataProvider(InvoiceInfo pInfo) {
        this.info = pInfo;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = this.getRowSet();
        return rs;
    }

    private IRowSet getRowSet() {
        if (this.info == null) {
            return null;
        }
        DynamicRowSet drs = null;
        List cols = this.getCols();
        int colsLen = cols.size();
        try {
            drs = new DynamicRowSet(colsLen);
            for (int i = 0; i < colsLen; ++i) {
                drs.setColInfo(i + 1, (ColInfo)cols.get(i));
            }
            drs.beforeFirst();
            int precision = this.info.getCurrency() != null ? this.info.getCurrency().getPrecision() : 2;
            InvoiceEntryCollection entries = (InvoiceEntryCollection)((Object)this.info.get("entries"));
            InvoiceEntryInfo entryInfo = null;
            int n = entries.size();
            for (int i = 0; i < n; ++i) {
                drs.moveToInsertRow();
                InvoicePrintDataProvider.clearRow((IRowSet)drs);
                entryInfo = entries.get(i);
                this.convertInfo2RowSet((IRowSet)drs, this.info, precision);
                this.convertEntry2RowSet((IRowSet)drs, entryInfo, precision);
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)"exception while convert the info to rowset", (Throwable)e);
        }
        return drs;
    }

    private static void clearRow(IRowSet rs) throws SQLException {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private void convertInfo2RowSet(IRowSet rs, InvoiceInfo info, int precision) throws SQLException {
        rs.updateString("FSeq", info.getNumber());
        CompanyOrgUnitInfo companyInfo = info.getCompany();
        rs.updateString("FCompany", companyInfo.getName());
        rs.updateDate("FInvoicedDate", new Date(info.getBillDate().getTime()));
        rs.updateBigDecimal("FTotalAmount", info.getTotalAmount().setScale(precision));
        if (info.getInvPerson() != null) {
            rs.updateString("FPayeePayer", info.getInvPerson().getName());
        }
        if (info.get("drawer") != null) {
            if (info instanceof ArInvoiceInfo) {
                rs.updateString("FDrawer", ((ArInvoiceInfo)info).getDrawer().getName());
            } else {
                rs.updateString("FDrawer", ((ApInvoiceInfo)info).getDrawer());
            }
        }
        if (info.getAuditPerson() != null) {
            rs.updateString("FAuditor", info.getAuditPerson().getName());
        }
        rs.updateString("FRemark", info.getDescription());
        if (info.getType() == InvoiceTypeEnum.VAT) {
            rs.updateString("FCompTaxRegNum", companyInfo.getTaxNumber());
            String sAddrPhone = this.getCompAddressPhone(companyInfo);
            if (!StringUtils.isEmpty((String)sAddrPhone)) {
                rs.updateString("FCompAddrPhone", sAddrPhone);
            }
            String compBankAcct = this.getCompBankAcct(info);
            rs.updateString("FCompBank_Acct", compBankAcct);
        }
        rs.updateString("FCussAcct", info.getAsstActName());
        rs.updateString("FAddress", info.getCussAddress());
        rs.updateString("FTaxRegNumber", info.getTaxRegisterNo());
        rs.updateString("FPhone", info.getCussPhone());
        rs.updateString("FBank", info.getCussBank());
        rs.updateString("FBankAcct", info.getCussAcctBank());
    }

    private String getCompBankAcct(InvoiceInfo info) {
        String compBankAcct = null;
        if (info.getAccountBank() != null && info.getAccountBank().getBankAccountNumber() != null) {
            compBankAcct = info.getAccountBank().getBankAccountNumber();
        } else if (info.getAccountBank() != null && info.getAccountBank().getId() != null) {
            ObjectUuidPK bankPK = new ObjectUuidPK(info.getAccountBank().getId());
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("bankAccountNumber");
            try {
                IAccountBank iBank = AccountBankFactory.getRemoteInstance();
                AccountBankInfo compAcctBank = iBank.getAccountBankInfo((IObjectPK)bankPK, selectors);
                compBankAcct = compAcctBank.getBankAccountNumber();
            }
            catch (Exception e) {
                logger.error((Object)"can't get the company's bankInfo", (Throwable)e);
            }
        }
        return compBankAcct;
    }

    private String getCompAddressPhone(CompanyOrgUnitInfo companyInfo) {
        if (companyInfo.getAddress() == null) {
            return null;
        }
        String sAddrPhone = null;
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("postalAddress");
        selectors.add("phone");
        try {
            IAddress iAddr = AddressFactory.getRemoteInstance();
            AddressInfo addrInfo = iAddr.getAddressInfo((IObjectPK)new ObjectUuidPK(companyInfo.getAddress().getId()), selectors);
            if (addrInfo != null) {
                sAddrPhone = addrInfo.getPostalAddress() + " " + addrInfo.getPhone();
            }
        }
        catch (Exception e) {
            logger.error((Object)"cannot compAddress info", (Throwable)e);
        }
        return sAddrPhone;
    }

    private void convertEntry2RowSet(IRowSet rs, InvoiceEntryInfo entryInfo, int precision) throws SQLException {
        MaterialInfo materialInfo = entryInfo.getMaterial();
        if (materialInfo == null) {
            return;
        }
        int pricePrecision = 4;
        if (materialInfo.getPricePrecision() != -1) {
            pricePrecision = materialInfo.getPricePrecision();
        }
        int qtyPrecision = this.getQtyPrecision(entryInfo);
        rs.updateString("FMaterial", materialInfo.getName());
        rs.updateString("FMaterailType", materialInfo.getModel());
        rs.updateString("FUnit", entryInfo.getMeasureUnit().getName());
        rs.updateBigDecimal("FQuantity", entryInfo.getQuantity().setScale(qtyPrecision));
        rs.updateBigDecimal("FUnitPrice", entryInfo.getUnitPrice().setScale(pricePrecision));
        rs.updateBigDecimal("FAmount", entryInfo.getAmount().setScale(precision));
        rs.updateBigDecimal("FTaxRate", entryInfo.getTaxRate().setScale(2));
        rs.updateBigDecimal("FTaxAmount", entryInfo.getTaxAmount().setScale(precision));
    }

    private int getQtyPrecision(InvoiceEntryInfo entryInfo) {
        int precision = 6;
        try {
            String materialId = entryInfo.getMaterial().getId().toString();
            String unitId = entryInfo.getMeasureUnit().getId().toString();
            IMultiMeasureUnit iMultUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnitInfo = iMultUnit.getMultiUnit(materialId, unitId);
            if (multiUnitInfo != null) {
                precision = multiUnitInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            logger.error((Object)"cannot get the qtyPrecision", (Throwable)e);
        }
        return precision;
    }

    private List getCols() {
        ArrayList<ColInfo> cols = new ArrayList<ColInfo>();
        ColInfo ci = null;
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FSeq";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FCompany";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 91;
        ci.columnName = "FInvoicedDate";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FCussAcct";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FAddress";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FPhone";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FTaxRegNumber";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FBank";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FBankAcct";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 3;
        ci.columnName = "FTotalAmount";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FTotalAmount_LocStr";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FPayeePayer";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FDrawer";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FAuditor";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FRemark";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FCompTaxRegNum";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FCompAddrPhone";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FCompBank_Acct";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FMaterial";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FMaterailType";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 12;
        ci.columnName = "FUnit";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 3;
        ci.columnName = "FQuantity";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 3;
        ci.columnName = "FUnitPrice";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 3;
        ci.columnName = "FAmount";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 3;
        ci.columnName = "FTaxRate";
        ci.nullable = 1;
        cols.add(ci);
        ci = new ColInfo();
        ci.colType = 3;
        ci.columnName = "FTaxAmount";
        ci.nullable = 1;
        cols.add(ci);
        return cols;
    }
}

