/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.ImportLog;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.VerifyDataFileUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.util.ArApOtherBillImportHelper;
import com.kingdee.eas.fi.ar.util.ImportDataLogUI;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.IProxyBill;
import com.kingdee.eas.fi.arap.ProxyBillCollection;
import com.kingdee.eas.fi.arap.ProxyBillEntryInfo;
import com.kingdee.eas.fi.arap.ProxyBillFactory;
import com.kingdee.eas.fi.arap.ProxyBillInfo;
import com.kingdee.eas.fi.arap.client.AbstractProxyBillListUI;
import com.kingdee.eas.fi.arap.client.ArApBillListUI;
import com.kingdee.eas.fi.arap.client.ArApProxyQueryProcessor;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.ProxyAppointmentSubjectUI;
import com.kingdee.eas.fi.arap.client.ProxyBillEditUI;
import com.kingdee.eas.fi.arap.client.ProxyBillQueryUI;
import com.kingdee.eas.fi.arap.client.util.ArApBatchUtil;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.DefinitionNewDataProvider;
import com.kingdee.eas.fi.arap.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.util.SCMSlaveCommonDataProvider;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditDirectionEnum;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.client.CreditCheck;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ProxyBillListUI
extends AbstractProxyBillListUI {
    private static final long serialVersionUID = -6741177141291103523L;
    private static final Logger logger = CoreUIObject.getLogger(ProxyBillListUI.class);
    private static final String ARAP_RESOURCE = "com.kingdee.eas.fi.arap.ArapResource";
    private File importDataFile = null;
    protected CompanyOrgUnitInfo currentCompany = null;
    private int basePrecision = 2;
    private CommonQueryDialog dialog = null;
    protected ProxyBillQueryUI userPanel = null;
    protected Date sysStartDate = null;
    private PeriodInfo startPeriod = null;
    private final BOSObjectType billBosType = BOSObjectType.create((String)"9B112F80");
    private UserInfo currentUser = null;
    protected ArApSysParamInfo cache = null;
    protected IArApBillFacade iBillFacade;
    protected String[] REC_PRICE_FIELDS = new String[]{"Entry_RecPrice", "Entry_RecTaxPrice", "Entry_RecRealTaxPrice"};
    protected String[] PAY_PRICE_FIELDS = new String[]{"Entry_PayPrice", "Entry_PayTaxPrice", "Entry_PayRealTaxPrice"};
    protected static final String COL_AR_CURRENCY = "RecCurrency";
    protected static final String COL_AP_CURRENCY = "Entry_PayCurrency";
    protected String[] ExchangeRate_Fields = new String[]{"RecExchangeRate", "Entry_PayExchangeRate"};
    protected static final String strTakeOutZeroFormat = "%{0.##########}f";
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public ProxyBillListUI() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
        this.cache = new ArApSysParamInfo();
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ProxyBillListUI.this.tblMain_afterDataFill(e);
            }
        });
        this.actionVoucher.setDaemonRun(true);
    }

    public String[] getQueryShowField() {
        return new String[]{"number", "BillDate", "CompanyOrgUnit", "BillStatus", "RecAsstActName", COL_AR_CURRENCY, "Businessor", "Entry_ReceivableAmt", "Entry_RecVerifyAmt", "Entry_PayAsstActName", COL_AP_CURRENCY, "Entry_PayableAmt", "Entry_PayVerifyAmt"};
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysEnum", this.getSysEnum());
        map.put("isSCM", Boolean.FALSE);
        map.put("permissionItem", this.getPermissionItem());
        return map;
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected String getPermissionItem() {
        return null;
    }

    protected void initWorkButton() {
        try {
            this.cache = this.iBillFacade.getSysParams(this.currentCompany, this.getUIParam());
            if (this.currentUser == null) {
                this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
            }
            if (this.currentCompany.getBaseCurrency() != null) {
                this.basePrecision = ArApBillUIUtil.getBaseCurrency(this.currentCompany).getPrecision();
            } else {
                MsgBox.showError((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("currentBaseCurrencyIsNull"));
                SysUtil.abort();
            }
            this.startPeriod = ArClientUtils.getArStartPeriod(this.currentCompany);
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
            this.sysStartDate = this.startPeriod.getBeginDate();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.btnEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
        this.menuItemEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("alt P"));
        this.menuItemAntiAudit.setAccelerator(KeyStroke.getKeyStroke("alt U"));
        this.btnAudit.addAssistMenuItem((JMenuItem)ArApBillUIUtil.cloneMenuItem(this.menuItemAudit));
        this.btnAudit.addAssistMenuItem((JMenuItem)ArApBillUIUtil.cloneMenuItem(this.menuItemAntiAudit));
        this.btnAntiAudit.setVisible(false);
        this.btnBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.menuItemBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.setButtonDefaultStyl(this.btnAudit);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isAutoIgnoreZero() {
        return false;
    }

    public void onLoad() throws Exception {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && qfsi.getSystemSolutionItem().getDefaultFilter().size() == 0) {
            qfsi.getSystemSolutionItem().getDefaultFilter().add("CompanyOrgUnit.id", CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add("RecAsstActType.id", CompareType.EQUALS, (Object)String.valueOf(this.cache.getAsstActTypeColl().get(0).getId())).add("Entry.PayAsstActType.id", CompareType.EQUALS, (Object)String.valueOf(this.cache.getApAsstActTypeColl().get(0).getId())).add("BillDate", CompareType.IS, (Object)DateEnum.RECENTONEMONTH);
        }
        super.onLoad();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionCopyTo.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionBatchSubmit.setVisible(true);
        this.actionBatchSubmit.setEnabled(true);
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
        this.separatorFW3.setVisible(false);
        this.separatorFW4.setVisible(false);
        this.actionEditVouchers.setEnabled(true);
        this.btnEditVouchers.setEnabled(true);
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
        this.kDMenuAppointAccount.setEnabled(true);
        this.kDMenuAppointAccount.setIcon(EASResource.getIcon((String)"imgTbtn_attributeset"));
        this.tblMain.getColumn("Entry_Qty").getStyleAttributes().setNumberFormat(strTakeOutZeroFormat);
        this.setCollumnFormat(this.REC_PRICE_FIELDS, strTakeOutZeroFormat);
        this.setCollumnFormat(this.PAY_PRICE_FIELDS, strTakeOutZeroFormat);
        this.setCollumnFormat(this.ExchangeRate_Fields, strTakeOutZeroFormat);
        KDTableUtils.setBigDecimalColumnPrecision(this.tblMain, new String[]{"Entry_PayVerifyAmtLocal", "Entry_PayableAmtLocal", "Entry_RecVerifyAmtLocal", "Entry_ReceivableAmtLocal", "Entry_RecTaxRate", "Entry_RecDiscountRate", "Entry_PayTaxRate", "Entry_PayDiscountRate"}, 2);
        String[] dateCols = new String[]{"BillDate", "createTime", "updateDate", "auditDate"};
        String dateFormatStr = ArApBillUtil.getDateFormatString();
        for (int i = 0; i < dateCols.length; ++i) {
            this.tblMain.getColumn(dateCols[i]).getStyleAttributes().setNumberFormat(dateFormatStr);
        }
        this.setDateDisplay();
    }

    private void setDateDisplay() {
        String dateTimeFmt = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(dateTimeFmt);
        this.tblMain.getColumn("updateDate").getStyleAttributes().setNumberFormat(dateTimeFmt);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(dateTimeFmt);
    }

    protected void setCollumnFormat(String[] needAdaptCollumn, String strTakeOutZeroFormat) {
        for (int i = 0; i < needAdaptCollumn.length; ++i) {
            this.tblMain.getColumn(needAdaptCollumn[i]).getStyleAttributes().setNumberFormat(strTakeOutZeroFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet billIdSet = new HashSet(idList);
        ProxyBillFactory.getRemoteInstance().canVoucher(billIdSet);
        ObjectUuidPK pk = new ObjectUuidPK((String)idList.get(0));
        IProxyBill iProxyBill = ProxyBillFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("CompanyOrgUnit.number"));
        ProxyBillInfo info = iProxyBill.getProxyBillInfo((IObjectPK)pk, sic);
        String number = info.getNumber();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList<String> requestIdList = new ArrayList<String>();
        IObjectPK logPK = null;
        try {
            String billId = null;
            boolean isLocked = false;
            Map result = iMutex.batchRequestBizObjIDForUpdate(new ArrayList(billIdSet));
            Iterator it = billIdSet.iterator();
            while (it.hasNext()) {
                billId = it.next().toString();
                if (result.get(billId) != null && ((Boolean)result.get(billId)).booleanValue()) {
                    requestIdList.add(billId);
                    continue;
                }
                isLocked = true;
            }
            if (isLocked) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new String[]{ArApBillUIUtil.getStrResource("DataMutex")});
            }
            logPK = LogUtil.beginLog(null, (String)"voucher", (BOSObjectType)this.billBosType, (IObjectPK)pk, (String)number, (String)"fi_ar_ProxyBill_GenVoucher");
            super.actionVoucher_actionPerformed(e);
            LogUtil.afterLog(null, (IObjectPK)logPK);
            if (requestIdList.size() <= 0) return;
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
            return;
        }
        finally {
            LogUtil.afterLog(null, logPK);
            if (requestIdList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(requestIdList);
            }
        }
        iMutex.batchReleaseObjIDForUpdate(requestIdList);
        return;
    }

    public void afterDAPTrans(BOTMappingInfo mappingInfo, BOTRelationCollection relationCollection) {
        ArrayList<String> requestIdList = new ArrayList<String>();
        int size = relationCollection.size();
        for (int i = 0; i < size; ++i) {
            requestIdList.add(relationCollection.get(i).getSrcObjectID());
        }
        MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(requestIdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEditVouchers_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell("id").getValue().toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("VoucherCannotEdit"));
            SysUtil.abort();
        }
        IIDList voucherIDList = this.arrayList2IIDList(voucherColl);
        String voucherId = voucherColl.get(0).toString();
        if (this.currentUser == null || this.currentUser == null) {
            return;
        }
        boolean hasPermission = BaseDataUtil.checkEditVoucherPermission((IObjectPK)new ObjectUuidPK(this.currentUser.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), "", (IObjectPK)new ObjectUuidPK(voucherId));
        if (!hasPermission) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("NoPermissionCannotEdit"));
            SysUtil.abort();
        }
        IProxyBill iProxyBill = ProxyBillFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CompanyOrgUnit.number"));
        ObjectUuidPK pktem = new ObjectUuidPK(billId);
        ProxyBillInfo infotem = iProxyBill.getProxyBillInfo((IObjectPK)pktem, sic);
        ICreateJobFacade iJob = CreateJobFacadeFactory.getRemoteInstance();
        if (iJob.checkDuplicateTask("SCM_FI_AR_001" + infotem.getCompanyOrgUnit().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        if (iJob.checkDuplicateTask("SCM_FI_AP_001" + infotem.getCompanyOrgUnit().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"ApClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        this.setOprtState("userCustomerStatus");
        ArrayList idList = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(idList);
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)voucherId);
            uiContext.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
            uiContext.put((Object)"IDList", (Object)voucherIDList);
            String uiClass = "com.kingdee.eas.fi.gl.client.VoucherEditUI";
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        finally {
            ArApBatchUtil.releasePureMutex(idList);
        }
    }

    private IIDList arrayList2IIDList(ArrayList al) {
        RealModeIDList List2 = RealModeIDList.getEmptyIDList();
        if (al != null && al.size() != 0) {
            for (int i = 0; i < al.size(); ++i) {
                List2.add(i, (String)al.get(i));
            }
        }
        return List2;
    }

    private boolean isSameStatus(KDTable tTabMain, BillStatusEnum status) {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        boolean isSameStatus = true;
        block0: for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                IRow row = this.tblMain.getRow(rowIndex);
                BizEnumValueInfo billStatus = (BizEnumValueInfo)row.getCell("BillStatus").getValue();
                if (billStatus == null || billStatus.getInt() == status.getValue()) continue;
                isSameStatus = false;
                continue block0;
            }
        }
        return isSameStatus;
    }

    private boolean isContainsVoucheredBill(KDTable tTabMain) throws BOSException, EASBizException {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        boolean isContainsVoucheredBill = false;
        block0: for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ObjectUuidPK pk;
                IRow row = tTabMain.getRow(rowIndex);
                IProxyBill iProxyBill = ProxyBillFactory.getRemoteInstance();
                ProxyBillInfo info = iProxyBill.getProxyBillInfo((IObjectPK)(pk = new ObjectUuidPK(row.getCell("id").getValue().toString())));
                if (!info.isFiVouchered()) continue;
                isContainsVoucheredBill = true;
                continue block0;
            }
        }
        return isContainsVoucheredBill;
    }

    private boolean isContainsArInitBill(KDTable tTabMain) {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        boolean isContainsInitBill = false;
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                IRow row = tTabMain.getRow(rowIndex);
                Date billDate = (Date)row.getCell("BillDate").getValue();
                if (!this.isInitBill(billDate)) continue;
                isContainsInitBill = true;
            }
        }
        return isContainsInitBill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] idList = this.getSelectedListId();
        IProxyBill iProxyBill = ProxyBillFactory.getRemoteInstance();
        ObjectUuidPK pktem = new ObjectUuidPK(idList[0]);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CompanyOrgUnit.number"));
        ProxyBillInfo infotem = iProxyBill.getProxyBillInfo((IObjectPK)pktem, sic);
        ICreateJobFacade iJob = CreateJobFacadeFactory.getRemoteInstance();
        if (iJob.checkDuplicateTask("SCM_FI_AR_001" + infotem.getCompanyOrgUnit().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        if (iJob.checkDuplicateTask("SCM_FI_AP_001" + infotem.getCompanyOrgUnit().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"ApClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        this.setOprtState("userCustomerStatus");
        ArrayList list = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(list);
        try {
            super.actionDelVoucher_actionPerformed(e);
        }
        finally {
            ArApBatchUtil.releasePureMutex(list);
        }
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    @Override
    protected String getEditUIName() {
        return ProxyBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ProxyBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ProxyBillInfo objectValue = new ProxyBillInfo();
        return objectValue;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pkOut = LogUtil.beginLog(null, (String)ArApBillUIUtil.getStrResource("log_import"), (BOSObjectType)this.billBosType, null, (String)ArApBillUIUtil.getStrResource("log_import"));
        File file = this.getImportFile();
        if (file == null) {
            return;
        }
        this.importDataFile = file;
        ArApOtherBillImportHelper invoiceImporter = new ArApOtherBillImportHelper(this.importDataFile);
        ImportLog log = invoiceImporter.importData((CoreUI)this, this.cache, "PROXY");
        UIContext param = new UIContext((Object)this);
        param.put((Object)"Log", (Object)log);
        IUIWindow uiLog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ImportDataLogUI.class.getName(), (Map)param);
        uiLog.show();
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    private File getImportFile() throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"selectedFile", (Object)this.importDataFile);
        IUIWindow uiFile = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VerifyDataFileUI.class.getName(), (Map)uiCtx);
        uiFile.show();
        VerifyDataFileUI fileUI = (VerifyDataFileUI)uiFile.getUIObject();
        return fileUI.getSelectedFile();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            this.dialog.addUserPanel((KDPanel)this.getUserPanel());
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(true);
            this.dialog.setHeight(296);
            this.dialog.setWidth(540);
            this.dialog.setProcessor((IProcessor)new ArApProxyQueryProcessor(this.cache));
            this.dialog.setTitle(EASResource.getString((String)ARAP_RESOURCE, (String)"ProxyBillQueryTitle"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.dialog;
    }

    protected CustomerQueryPanel getUserPanel() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = new ProxyBillQueryUI(this.cache);
        }
        this.userPanel.putClientProperty("isInitBill", Boolean.FALSE);
        return this.userPanel;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public boolean isPrepareActionSetZeroNotDisplay() {
        return true;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean isImportBillCanModify;
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        boolean isAudited = false;
        for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!this.isAuditFromID(row.getCell("id").getValue().toString())) continue;
            isAudited = true;
            break;
        }
        if (isAudited) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ARAP_RESOURCE, (String)"NotEditForAudited"));
            SysUtil.abort();
        }
        if (!(isImportBillCanModify = this.cache.isImportBillModifiable()) && ArApBillListUI.isContainsImportBill(this.tblMain)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ARAP_RESOURCE, (String)"ImportBillCanNotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    private boolean isAuditFromID(String id) throws Exception {
        ObjectUuidPK pk;
        boolean ret = false;
        IProxyBill iProxyBill = ProxyBillFactory.getRemoteInstance();
        ProxyBillInfo info = iProxyBill.getProxyBillInfo((IObjectPK)(pk = new ObjectUuidPK(id)));
        if (info != null && 3 == info.getBillStatus().getValue()) {
            ret = true;
        }
        return ret;
    }

    public String[] getSelectedListId() {
        this.checkSelected();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        ArrayList<Object> idList = new ArrayList<Object>();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue());
            }
        }
        String[] listId = null;
        if (idList != null && idList.size() > 0) {
            Iterator iterat = idList.iterator();
            listId = new String[idList.size()];
            int index = 0;
            while (iterat.hasNext()) {
                listId[index] = (String)iterat.next();
                ++index;
            }
        }
        return listId;
    }

    public Map getSelectedNumberById() {
        this.checkSelected();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        ArrayList<Object> idList = new ArrayList<Object>();
        Iterator iter = blocks.iterator();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        while (iter.hasNext()) {
            KDTSelectBlock block = (KDTSelectBlock)iter.next();
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                ICell cell1 = this.tblMain.getRow(rowIndex).getCell("number");
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue());
                numberMap.put(cell.getValue().toString(), cell1.getValue().toString());
            }
        }
        return numberMap;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("Entry.Custom.Bus"));
        sic.add(new SelectorItemInfo("Entry.Custom.BusLine"));
        return sic;
    }

    private boolean isInitBill(Date billDate) {
        return this.sysStartDate != null && billDate != null && billDate.before(this.sysStartDate);
    }

    public void tblMain_afterDataFill(KDTDataRequestEvent e) {
        try {
            this.changeShowData(e.getFirstRow(), e.getLastRow());
        }
        catch (EASBizException e1) {
            super.handUIException((Throwable)e1);
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
    }

    private void changeShowData(int fistRow, int lastRow) throws EASBizException, BOSException {
        int recPrecision = this.basePrecision;
        int payPrecision = this.basePrecision;
        for (int i = fistRow; i <= lastRow; ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell recCur = row.getCell("RecCurrency.precision");
            ICell payCur = row.getCell("Entry_PayCurrency.precision");
            if (recCur != null && recCur.getValue() != null) {
                try {
                    recPrecision = Integer.parseInt(recCur.getValue().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (payCur != null && payCur.getValue() != null) {
                try {
                    payPrecision = Integer.parseInt(payCur.getValue().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setPrecision(recPrecision, payPrecision, row);
        }
        int colBillStatus = this.tblMain.getColumnIndex("BillStatus");
        this.tblMain.getViewManager().setFreezeView(-1, colBillStatus + 1);
        this.tblMain.setColumnMoveable(true);
    }

    public void setPrecision(int recPrecision, int payPrecision, IRow row) {
        String recFormat = PrecisionFormatUtils.getFormatString(recPrecision);
        String payFormat = PrecisionFormatUtils.getFormatString(payPrecision);
        row.getCell("Entry_ReceivableAmt").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_RecVerifyAmt").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_PayableAmt").getStyleAttributes().setNumberFormat(payFormat);
        row.getCell("Entry_PayVerifyAmt").getStyleAttributes().setNumberFormat(payFormat);
        row.getCell("Entry_RecDiscountAmt").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_RecAmount").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_RecTax").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_RecBadAmount").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_RecUnVerifyAmt").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_PayDiscountAmt").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_PayAmount").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_PayTax").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_PayUnVerifyAmt").getStyleAttributes().setNumberFormat(recFormat);
        row.getCell("Entry_ReceivableAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecVerifyAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayableAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayVerifyAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecDiscountAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("RecExchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_Qty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecTaxRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecDiscountRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecTaxPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecRealTaxPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecTax").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecBadAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_RecUnVerifyAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayExchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayTaxRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayDiscountRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayTaxPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayRealTaxPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayDiscountAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayTax").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("Entry_PayUnVerifyAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public String[] getMergeColumnKeys() {
        String[] mergeCols = new String[]{"id", "number", "BillStatus", "CompanyOrgUnit", "BillDate", "AdminOrgUnit", "Businessor", "description", "saleContractNum", "purContractNum", "voucherNumber", "voucherType", "RecAsstActType", "RecAsstActNum", "RecAsstActName", "RecExchangeRate", "RecSettleType", COL_AR_CURRENCY, "RecCashDiscount", "fiVouchered", "isInitializeBill", "isImportBill", "creator", "createTime", "updateUser", "updateDate", "auditor", "auditDate", "accountant"};
        return mergeCols;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void actionAuditing_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        StringBuffer errMsg = new StringBuffer();
        IProxyBill iProxyBill = ProxyBillFactory.getRemoteInstance();
        String[] billIdlist = this.getSelectedListId();
        Map billNumber = this.getSelectedNumberById();
        ArrayList idList = this.getSelectedIdValues();
        if (ArApBillHelper.isAllInWFOrNotAll(idList)) {
            logger.info((Object)"actionMultiapprove start");
            this.actionMultiapprove_actionPerformed(e);
            this.setMessageText(EASResource.getString((String)ARAP_RESOURCE, (String)"AuditSuccess"));
            this.execQuery();
            return;
        }
        int i = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ar_bill_sureAudit"));
        if (i == 2) {
            return;
        }
        ArApBatchUtil.requestPureMutex(idList);
        for (int j = 0; j < billIdlist.length; ++j) {
            ObjectUuidPK pk = new ObjectUuidPK(billIdlist[j]);
            try {
                iProxyBill.passAudit((IObjectPK)pk, null);
                continue;
            }
            catch (EASBizException ex) {
                String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"199_ArApBillUIUtil"), billNumber.get(billIdlist[j]), this.getBOSEntity().getAlias());
                errMsg.append(msg);
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)ARAP_RESOURCE, (String)"Msg_AuditError"), (String)errMsg.toString(), (int)8188);
        } else {
            this.setMessageText(EASResource.getString((String)ARAP_RESOURCE, (String)"AuditSuccess"));
        }
        this.execQuery();
        ArApBatchUtil.releasePureMutex(idList);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        CreditCtrlResult arResult = null;
        CreditCtrlResult apResult = null;
        this.checkSelected();
        IProxyBill iProxyBill = ProxyBillFactory.getRemoteInstance();
        String[] billIdlist = this.getSelectedListId();
        Map billNumber = this.getSelectedNumberById();
        ArrayList idList = this.getSelectedIdValues();
        StringBuffer errMsg = new StringBuffer();
        int i = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ar_proxybill_sureUnAudit"));
        if (i == 2) {
            return;
        }
        ArApBatchUtil.requestPureMutex(idList);
        Set idSet = FMHelper.Array2Set((String[])billIdlist);
        ProxyBillCollection coll = this.getProxyBillCollByIds(idSet, BizActionEnum.UNAUDIT);
        CoreBillBaseInfo[] arInfos = this.getProxyBills(coll);
        CoreBillBaseInfo[] apInfos = this.getProxyEntryInfos(coll);
        if (arInfos != null && arInfos.length > 0) {
            arResult = CreditCheck.checkArSysBillAtOperation((CoreUI)this, (IObjectValue[])arInfos, (CreditFormulaSceneEnum)CreditFormulaSceneEnum.PROXYBILL, (CreditOperationEnum)CreditOperationEnum.UNAUDIT, (CreditDirectionEnum)CreditDirectionEnum.LESS);
        }
        if (apInfos != null && apInfos.length > 0) {
            apResult = CreditCheck.checkApSysBillAtOperation((CoreUI)this, (IObjectValue[])apInfos, (CreditFormulaSceneEnum)CreditFormulaSceneEnum.PROXYBILL, (CreditOperationEnum)CreditOperationEnum.UNAUDIT, (CreditDirectionEnum)CreditDirectionEnum.ADD);
        }
        int size = billIdlist.length;
        for (int j = 0; j < size; ++j) {
            ObjectUuidPK pk = new ObjectUuidPK(billIdlist[j]);
            try {
                iProxyBill.unpassAudit((IObjectPK)pk, null);
                continue;
            }
            catch (EASBizException ex) {
                String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"199_ArApBillUIUtil"), billNumber.get(billIdlist[j]), this.getBOSEntity().getAlias());
                errMsg.append(msg);
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
        }
        if (arResult != null && arResult.isOverspend()) {
            CreditCheck.addExceptionRecord((CoreBillBaseInfo[])arInfos, (CreditFormulaSceneEnum)CreditFormulaSceneEnum.PROXYBILL, (CreditCtrlResult)arResult, (CreditOperationEnum)CreditOperationEnum.AUDIT);
        }
        if (apResult != null && apResult.isOverspend()) {
            CreditCheck.addExceptionRecord((CoreBillBaseInfo[])apInfos, (CreditFormulaSceneEnum)CreditFormulaSceneEnum.PROXYBILL, (CreditCtrlResult)apResult, (CreditOperationEnum)CreditOperationEnum.AUDIT);
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)ARAP_RESOURCE, (String)"Msg_UnAuditError"), (String)errMsg.toString(), (int)8188);
        } else {
            this.setMessageText(EASResource.getString((String)ARAP_RESOURCE, (String)"UnAuditSuccess"));
        }
        this.execQuery();
        ArApBatchUtil.releasePureMutex(idList);
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String confirmMsg = EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"1_PayRequestBillListUI");
        int ok = MsgBox.showConfirm2((Component)((Object)this), (String)confirmMsg);
        if (ok == 2) {
            return;
        }
        ArrayList idList = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(idList);
        Class[] clz = new Class[]{Set.class};
        ArApBatchUtil.batchOperaction((CoreUI)this, this.getSelectedIdValues(), this.getBizInterface(), this.getBOSEntity().getAlias(), this.menuItemBatchSubmit.getText(), "batchSubmit", clz);
        RequestContext request = new RequestContext();
        String[] selectedListId = new String[idList.size()];
        request.put("selectedListId", (Object)idList.toArray(selectedListId));
        ArApBatchUtil.releasePureMutex(idList);
        this.execQuery();
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pkOut = LogUtil.beginLog(null, (String)ArApBillUIUtil.getStrResource("log_export"), (BOSObjectType)this.billBosType, null, (String)ArApBillUIUtil.getStrResource("log_export"));
        super.actionExportData_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    protected void prepareMutexParameter(ActionEvent e, MutexParameter param) {
        param.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
        super.prepareMutexParameter(e, param);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    public EntityObjectInfo getBOSEntity() throws Exception {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev == null || ev.getFilter() == null) {
            return;
        }
        FilterInfo oldFilter = ev.getFilter();
        Calendar curDate = Calendar.getInstance();
        Object oldCompareType = null;
        String compareName = null;
        int count = ev.getFilter().getFilterItems().size();
        for (int i = 0; i < count; ++i) {
            FilterItemInfo fii = ev.getFilter().getFilterItems().get(i);
            compareName = fii.getPropertyName();
            if (!compareName.equals("createTime") && !compareName.equals("AuditDate") && !compareName.equals("lastUpdateTime")) continue;
            this.getFilterForTime(oldFilter, curDate, fii, compareName);
        }
        ev.setFilter(oldFilter);
        super.beforeExcutQuery(ev);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if (this.cache == null || this.cache.getCompany() == null) {
            try {
                IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
                this.cache = iBillFacade.getSysParams(null, this.getUIParam());
                return this.qfsi.supportSingleMainOrg((OrgUnitInfo)this.cache.getCompany());
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        return this.qfsi;
    }

    protected String getOrgFieldName() {
        return "CompanyOrgUnit.id";
    }

    protected void execQuery() {
        if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
            FilterItemCollection filterItemColl = this.mainQuery.getFilter().getFilterItems();
            FilterItemInfo filterItemInfo = null;
            if (filterItemColl != null && filterItemColl.size() > 0) {
                int count = filterItemColl.size();
                for (int i = 0; i < count; ++i) {
                    filterItemInfo = filterItemColl.get(i);
                    if (filterItemInfo == null || !"CompanyOrgUnit.id".equals(filterItemInfo.getPropertyName())) continue;
                    filterItemInfo.setCompareValue((Object)this.cache.getCompanyId());
                }
            }
        }
        super.execQuery();
    }

    private ProxyBillCollection getProxyBillCollByIds(Set idSet, BizActionEnum bizAction) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        if (BizActionEnum.AUDIT == bizAction) {
            filter.getFilterItems().add(new FilterItemInfo("BillStatus", (Object)new Integer(2)));
        } else if (BizActionEnum.UNAUDIT == bizAction) {
            filter.getFilterItems().add(new FilterItemInfo("BillStatus", (Object)new Integer(3)));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("BillStatus"));
        sic.add(new SelectorItemInfo("CompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("CompanyOrgUnit.number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("RecAsstActId"));
        sic.add(new SelectorItemInfo("RecAsstActNum"));
        sic.add(new SelectorItemInfo("RecAsstActName"));
        sic.add(new SelectorItemInfo("RecAmountLocal"));
        sic.add(new SelectorItemInfo("Entry.id"));
        sic.add(new SelectorItemInfo("Entry.PayableAmtLocal"));
        sic.add(new SelectorItemInfo("Entry.PayAsstActId"));
        sic.add(new SelectorItemInfo("Entry.PayAsstActNum"));
        sic.add(new SelectorItemInfo("Entry.PayAsstActName"));
        sic.add(new SelectorItemInfo("Entry.RecAsstActType.id"));
        view.setSelector(sic);
        ProxyBillCollection coll = ((IProxyBill)this.getBizInterface()).getProxyBillCollection(view);
        return coll;
    }

    private CoreBillBaseInfo[] getProxyBills(ProxyBillCollection coll) {
        CoreBillBaseInfo[] billInfos = null;
        ProxyBillInfo info = null;
        ArrayList<ProxyBillInfo> bills = new ArrayList<ProxyBillInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info == null || StringUtils.isEmpty((String)info.getRecAsstActId()) || !new CustomerInfo().getBOSType().equals((Object)BOSUuid.read((String)info.getRecAsstActId()).getType()) && !new SupplierInfo().getBOSType().equals((Object)BOSUuid.read((String)info.getRecAsstActId()).getType())) continue;
            bills.add(info);
        }
        if (bills != null && bills.size() > 0) {
            billInfos = new CoreBillBaseInfo[bills.size()];
            ProxyBillInfo proxyBillInfo = null;
            int size2 = bills.size();
            for (int i = 0; i < size2; ++i) {
                proxyBillInfo = (ProxyBillInfo)bills.get(i);
                BigDecimal recAmountLocal = proxyBillInfo.getRecAmountLocal();
                String recAsstActId = proxyBillInfo.getRecAsstActId();
                ProxyBillEntryInfo entryInfo = null;
                int count = proxyBillInfo.getEntry().size();
                for (int j = 0; j < count; ++j) {
                    entryInfo = proxyBillInfo.getEntry().get(j);
                    if (entryInfo == null || StringUtils.isEmpty((String)entryInfo.getPayAsstActId()) || !entryInfo.getPayAsstActId().equals(recAsstActId)) continue;
                    recAmountLocal = recAmountLocal.subtract(entryInfo.getPayableAmtLocal());
                }
                proxyBillInfo.setRecAmountLocal(recAmountLocal);
                billInfos[i] = proxyBillInfo;
            }
        }
        return billInfos;
    }

    private CoreBillBaseInfo[] getProxyEntryInfos(ProxyBillCollection coll) {
        int i;
        CoreBillBaseInfo[] billInfos = null;
        ProxyBillInfo proxyInfo = null;
        ProxyBillEntryInfo entryInfo = null;
        PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
        paymentTypeInfo.setId(BOSUuid.read((String)"2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"));
        OtherBillInfo apInfo = null;
        HashMap<String, OtherBillInfo> billInfoMap = new HashMap<String, OtherBillInfo>();
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            proxyInfo = coll.get(i);
            if (proxyInfo == null) continue;
            String recAsstActId = proxyInfo.getRecAsstActId();
            int count = proxyInfo.getEntry().size();
            for (int j = 0; j < count; ++j) {
                entryInfo = proxyInfo.getEntry().get(j);
                if (entryInfo == null || StringUtils.isEmpty((String)entryInfo.getPayAsstActId()) || entryInfo.getPayAsstActId().equals(recAsstActId) || !new CustomerInfo().getBOSType().equals((Object)BOSUuid.read((String)entryInfo.getPayAsstActId()).getType()) && !new SupplierInfo().getBOSType().equals((Object)BOSUuid.read((String)entryInfo.getPayAsstActId()).getType())) continue;
                if (!billInfoMap.containsKey(entryInfo.getPayAsstActId())) {
                    apInfo = new OtherBillInfo();
                    apInfo.setId(entryInfo.getId());
                    apInfo.setNumber(proxyInfo.getNumber());
                    apInfo.setAmountLocal(entryInfo.getPayableAmtLocal());
                    apInfo.setCompany(proxyInfo.getCompanyOrgUnit());
                    apInfo.setAsstActID(entryInfo.getPayAsstActId());
                    apInfo.setAsstActName(entryInfo.getPayAsstActName());
                    apInfo.setAsstActNumber(entryInfo.getPayAsstActNum());
                    apInfo.setPaymentType(paymentTypeInfo);
                    billInfoMap.put(entryInfo.getPayAsstActId(), apInfo);
                    continue;
                }
                apInfo = (OtherBillInfo)billInfoMap.get(entryInfo.getPayAsstActId());
                apInfo.setAmountLocal(entryInfo.getPayableAmtLocal().add(apInfo.getAmountLocal()));
            }
        }
        if (billInfoMap != null && billInfoMap.size() > 0) {
            billInfos = new CoreBillBaseInfo[billInfoMap.size()];
            i = 0;
            Iterator iterator = billInfoMap.keySet().iterator();
            while (iterator.hasNext()) {
                billInfos[i] = (CoreBillBaseInfo)billInfoMap.get(iterator.next());
                ++i;
            }
        }
        return billInfos;
    }

    private void getFilterForTime(FilterInfo oldFilter, Calendar curDate, FilterItemInfo fii, String compareName) {
        CompareType oldCompareType;
        if (fii.getCompareType().equals((Object)CompareType.EQUALS)) {
            fii.setCompareType(CompareType.GREATER_EQUALS);
            oldCompareType = CompareType.EQUALS;
            curDate.setTime((Date)fii.getCompareValue());
            curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo paymentBillFilter = new FilterItemInfo(compareName, (Object)new Date(curDate.getTimeInMillis()), CompareType.LESS_EQUALS);
            filter.getFilterItems().add(paymentBillFilter);
            try {
                oldFilter.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        if (fii.getCompareType().equals((Object)CompareType.LESS_EQUALS)) {
            oldCompareType = CompareType.LESS_EQUALS;
            curDate.setTime((Date)fii.getCompareValue());
            curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
            fii.setCompareValue((Object)new Date(curDate.getTimeInMillis()));
        }
        if (fii.getCompareType().equals((Object)CompareType.NOTEQUALS)) {
            Date oldDate = (Date)fii.getCompareValue();
            curDate.setTime((Date)fii.getCompareValue());
            curDate.set(1949, 1, 1, 0, 0, 0);
            fii.setCompareType(CompareType.GREATER_EQUALS);
            fii.setCompareValue((Object)new Timestamp(curDate.getTimeInMillis()));
            Calendar worldTour = Calendar.getInstance();
            worldTour.setTime(oldDate);
            worldTour.add(5, 1);
            Date endDay = worldTour.getTime();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo paymentBillFilter = new FilterItemInfo(compareName, (Object)oldDate, CompareType.LESS);
            filter.getFilterItems().add(paymentBillFilter);
            FilterItemInfo paymentBillFilter1 = new FilterItemInfo(compareName, (Object)endDay, CompareType.GREATER_EQUALS);
            filter.getFilterItems().add(paymentBillFilter1);
            FilterItemInfo paymentBillFilter2 = new FilterItemInfo(compareName, null, CompareType.EQUALS);
            filter.getFilterItems().add(paymentBillFilter2);
            filter.setMaskString(" #0 OR #1 OR #2 ");
            try {
                oldFilter.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            curDate.setTime(oldDate);
        }
        if (fii.getCompareType().equals((Object)CompareType.GREATER)) {
            curDate.setTime((Date)fii.getCompareValue());
            curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
            fii.setCompareValue((Object)new Timestamp(curDate.getTimeInMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAppointAccount_actionPerformed(ActionEvent e) throws Exception {
        ArrayList billIds = this.getSelectedFieldValues("id");
        ArrayList entryIds = this.getSelectedFieldValues("Entry_id");
        CurrencyInfo arCurrencyInfo = null;
        CurrencyInfo apCurrencyInfo = null;
        ICoreBase iCoreBase = this.getBizInterface();
        if (billIds.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        try {
            this.setOprtState("userCustomerStatus");
            int num = billIds.size();
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(billIds.get(i).toString());
            }
            ObjectUuidPK[] pk = new ObjectUuidPK[billIds.size()];
            ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
            HashSet<Object> arCurrencySet = new HashSet<Object>();
            HashSet<Object> apCurrencySet = new HashSet<Object>();
            for (KDTSelectBlock block : blocks) {
                int top = block.getTop();
                int bottom = block.getBottom();
                for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                    ICell arCurrency = this.tblMain.getRow(rowIndex).getCell(COL_AR_CURRENCY);
                    ICell apCurrency = this.tblMain.getRow(rowIndex).getCell(COL_AP_CURRENCY);
                    if (!arCurrencySet.contains(arCurrency.getValue())) {
                        arCurrencySet.add(arCurrency.getValue());
                    }
                    if (apCurrencySet.contains(apCurrency.getValue())) continue;
                    apCurrencySet.add(apCurrency.getValue());
                }
            }
            if (arCurrencySet.size() > 1 || apCurrencySet.size() > 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"point_subject_difCurrency_not"));
                return;
            }
            for (int i = 0; i < billIds.size(); ++i) {
                pk[i] = new ObjectUuidPK(billIds.get(i).toString());
            }
            ProxyBillInfo billInfo = (ProxyBillInfo)iCoreBase.getValue((IObjectPK)pk[0]);
            arCurrencyInfo = billInfo.getRecCurrency();
            apCurrencyInfo = billInfo.getEntry().get(0).getPayCurrency();
            HashMap<String, Object> uiCtx = new HashMap<String, Object>();
            uiCtx.put("Owner", (Object)this);
            uiCtx.put("ArApSysParamInfo", this.cache);
            uiCtx.put("arCurrencyInfo", arCurrencyInfo);
            uiCtx.put("apCurrencyInfo", apCurrencyInfo);
            uiCtx.put("pk", pk);
            uiCtx.put("iCoreBase", iCoreBase);
            uiCtx.put("alia", this.getBOSEntity().getAlias());
            uiCtx.put("selectedIdValues", billIds);
            uiCtx.put("selectedEntryIds", entryIds);
            IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProxyAppointmentSubjectUI.class.getName(), uiCtx, null, OprtState.EDIT);
            uiWin.show();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int num = billIds.size();
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(billIds.get(i).toString());
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.refresh(e);
    }

    @Override
    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(true);
    }

    @Override
    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(false);
    }

    protected void invokeMultiPrintFunction(boolean isPrint) {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        this.invokeMultiPrintFunction(idList, isPrint);
    }

    protected void invokeMultiPrintFunction(List idList, boolean isPrint) {
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        DefinitionNewDataProvider mainQueryData = new DefinitionNewDataProvider(idList, this.getTDQueryPK());
        data.putAbstractPrint("MainQuery", (AbstractPrintDataProvider)mainQueryData);
        SCMSlaveCommonDataProvider multiApproveViewQueryData = new SCMSlaveCommonDataProvider(idList, this.getMultiApproveViewQuery(), "billId");
        data.put("MultiApproveViewQuery", (BOSQueryDelegate)multiApproveViewQueryData);
        KDNoteHelper appHlp = new KDNoteHelper();
        BOSObjectType bosType = null;
        try {
            bosType = this.getBizInterface().getType();
            if (bosType == null) {
                throw new Exception("bosType is null");
            }
            logger.info((Object)("current bostype:>>" + bosType.toString()));
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.remoteerror"));
            SysUtil.abort();
            return;
        }
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(bosType.toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)bosType, (List)idList, (String)this.getTDFileName(), (String)"com.kingdee.eas.scm.common.SCMResource", (boolean)false);
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getMultiApproveViewQuery() {
        return new MetaDataPK("com.kingdee.eas.base.multiapprove.app.MultiApproveViewQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/FI/AR/ProxyBill";
    }
}

