/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.arap.IQuickInputConfig;
import com.kingdee.eas.fi.arap.QuickInputConfigCollection;
import com.kingdee.eas.fi.arap.QuickInputConfigFactory;
import com.kingdee.eas.fi.arap.QuickInputConfigInfo;
import com.kingdee.eas.fi.arap.client.AbstractQuickInputConfigUI;
import com.kingdee.eas.fi.arap.client.QuickInputUI;
import com.kingdee.eas.fi.arap.util.ArApCommonUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QuickInputConfigUI
extends AbstractQuickInputConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(QuickInputConfigUI.class);
    private static final String CONFIG_TABLE_NAME = "T_ARAP_QuickInputConfig";
    private static String entityPK;
    private static String userId;
    private static Map fieldMap;
    public static final String COL_FIELD_NAME = "fieldName";
    public static final String COL_FIELD_KEY = "fieldKey";
    public static final String COL_IS_GROUP_FIELD = "isGroupField";
    public static final String COL_IS_PRE_SET = "isPreSet";

    public void onLoad() throws Exception {
        this.kDTable1.checkParsed();
        super.onLoad();
        Map uiCtx = this.getUIContext();
        userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        entityPK = (String)uiCtx.get("entityPK");
        fieldMap = (LinkedHashMap)uiCtx.get("fieldMap");
        Set preSetFields = (Set)uiCtx.get("preSetFields");
        Set notGroupFields = (Set)uiCtx.get("notGroupFields");
        QuickInputConfigCollection coll = ArApCommonUtil.getQuickInputConfigColl(null, userId, entityPK);
        for (Object field : fieldMap.keySet()) {
            String key = (String)field;
            if (notGroupFields.contains(key)) continue;
            boolean hasConfig = false;
            for (int i = 0; i < coll.size(); ++i) {
                QuickInputConfigInfo config = coll.get(i);
                if (!key.equals(config.getFieldKey())) continue;
                hasConfig = true;
                this.kDTable1.addRow();
                IRow row = this.kDTable1.getRow(this.kDTable1.getRowCount() - 1);
                row.getCell(COL_FIELD_NAME).setValue((Object)config.getFieldName());
                row.getCell(COL_FIELD_KEY).setValue((Object)config.getFieldKey());
                row.getCell(COL_IS_GROUP_FIELD).setValue((Object)config.isIsGroupField());
                row.getCell(COL_IS_PRE_SET).setValue((Object)config.isIsPreSet());
                if (!config.isIsPreSet()) break;
                row.getCell(COL_IS_GROUP_FIELD).getStyleAttributes().setLocked(true);
                break;
            }
            if (hasConfig) continue;
            this.kDTable1.addRow();
            IRow row = this.kDTable1.getRow(this.kDTable1.getRowCount() - 1);
            row.getCell(COL_FIELD_KEY).setValue((Object)key);
            row.getCell(COL_FIELD_NAME).setValue(fieldMap.get(key));
            row.getCell(COL_IS_GROUP_FIELD).setValue((Object)false);
            if (preSetFields.contains(field)) {
                row.getCell(COL_IS_GROUP_FIELD).getStyleAttributes().setLocked(true);
                row.getCell(COL_IS_PRE_SET).setValue((Object)true);
                row.getCell(COL_IS_GROUP_FIELD).setValue((Object)true);
                continue;
            }
            row.getCell(COL_IS_PRE_SET).setValue((Object)false);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        CoreBaseCollection coll = new CoreBaseCollection();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            QuickInputConfigInfo config = new QuickInputConfigInfo();
            config.setEntityPK(entityPK);
            config.setPersonId(userId);
            config.setFieldName((String)this.kDTable1.getCell(i, COL_FIELD_NAME).getValue());
            config.setFieldKey((String)this.kDTable1.getCell(i, COL_FIELD_KEY).getValue());
            config.setIsGroupField((Boolean)this.kDTable1.getCell(i, COL_IS_GROUP_FIELD).getValue());
            config.setIsPreSet((Boolean)this.kDTable1.getCell(i, COL_IS_PRE_SET).getValue());
            coll.add((CoreBaseInfo)config);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("personId", (Object)userId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("entityPK", (Object)entityPK, CompareType.EQUALS));
        HashSet fields = new HashSet(fieldMap.keySet());
        filter.getFilterItems().add(new FilterItemInfo(COL_FIELD_KEY, fields, CompareType.INCLUDE));
        IQuickInputConfig inputConfig = QuickInputConfigFactory.getRemoteInstance();
        inputConfig.delete(filter);
        inputConfig.addnewBatchData(coll);
        ((QuickInputUI)((Object)this.getUIContext().get("Owner"))).reloadEntry();
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

