/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTTransferAction;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.arap.QuickInputConfigCollection;
import com.kingdee.eas.fi.arap.client.AbstractQuickInputUI;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBaseCalculate;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApCommonUtil;
import com.kingdee.eas.fi.arap.util.ArApSorter;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class QuickInputUI
extends AbstractQuickInputUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(QuickInputUI.class);
    ArApSorter sorter;
    private String[] cols;
    private String entityPK;
    private String userID;
    Map<String, IRow> groupKeyMap;
    Map<String, List> entryKeyMap;
    private KDTable billEntry;
    private BigDecimal ZERO;
    private IRow footRow;
    private Set preSetFields;
    private String[] cellEditorFields;
    private Map groupKeyRowMap;
    private String negativeField;
    private String idField;
    private String[] sumCols;
    private String[] lockCols;
    private String[] hideCols;
    private String[] nullValueCols;
    private String calcRowMethod;
    private EditUI billEditUI;
    protected Set groupFields;

    public QuickInputUI() throws Exception {
        this.sorter = new ArApSorter(this.table);
        this.cols = null;
        this.groupKeyMap = new HashMap<String, IRow>();
        this.entryKeyMap = new HashMap<String, List>();
        this.billEntry = null;
        this.ZERO = new BigDecimal("0.00");
        this.footRow = null;
        this.groupKeyRowMap = new HashMap();
        this.idField = "";
        logger.debug((Object)"quickInput start");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        KDTableHelper.releaseEsc((JComponent)this.table);
        this.billEditUI = (EditUI)this.getUIContext().get("Owner");
        this.billEntry = (KDTable)this.getUIContext().get("table");
        this.entityPK = (String)this.getUIContext().get("entityPK");
        this.negativeField = (String)this.getUIContext().get("negativeField");
        this.idField = (String)this.getUIContext().get("idField");
        this.calcRowMethod = (String)this.getUIContext().get("calcRowMethod");
        this.preSetFields = (Set)this.getUIContext().get("preSetFields");
        this.cellEditorFields = (String[])this.getUIContext().get("cellEditorFields");
        this.sumCols = (String[])this.getUIContext().get("sumCols");
        this.lockCols = (String[])this.getUIContext().get("lockCols");
        this.hideCols = (String[])this.getUIContext().get("hideCols");
        this.nullValueCols = (String[])this.getUIContext().get("nullValueCols");
        this.initGroupFields();
        this.table.checkParsed();
        this.table.removeRows();
        this.table.addColumns(this.billEntry.getColumnCount());
        this.table.addHeadRow(0, (IRow)this.billEntry.getHeadRow(0).clone());
        for (int i = 0; i < this.billEntry.getColumnCount(); ++i) {
            String colKey = this.billEntry.getColumnKey(i);
            this.table.getColumn(i).setKey(colKey);
            this.table.getColumn(i).setStyleAttributes(this.billEntry.getColumn(i).getStyleAttributes());
        }
        KDTFootManager footRowManager = this.table.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.table);
            footRowManager.addFootView();
            this.table.setFootManager(footRowManager);
            this.footRow = footRowManager.addFootRow(0);
            this.footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.table.getIndexColumn().setWidthAdjustMode((short)1);
            this.table.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            this.footRow = footRowManager.getFootRow(0);
        }
        this.footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
        this.loadBillEntryValue();
        this.setCellEditor();
        this.table.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                if (ArApBillHelper.objectEquals(e.getOldValue(), e.getValue())) {
                    return;
                }
                try {
                    int rowNum = e.getRowIndex();
                    IRow row = QuickInputUI.this.table.getRow(rowNum);
                    QuickInputUI.this.entryEditTrigger(e, row);
                    QuickInputUI.this.calculateTotal();
                }
                catch (NoSuchMethodException e1) {
                    logger.error((Object)e1.getMessage());
                }
                catch (Exception e1) {
                    QuickInputUI.this.handUIException(e1);
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    QuickInputUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    QuickInputUI.this.handUIException(exc);
                }
            }
        });
        this.table.getActionMap().put("Paste", (Action)new KDTTransferAction(this.table, "Paste"){

            public void actionPerformed(ActionEvent e) {
                if (this.actionName == null) {
                    return;
                }
                if (this.actionName.equals("Copy")) {
                    this.table.getEditHelper().copy(this.getCopyMode());
                } else if (this.actionName.equals("CopyFID")) {
                    this.table.getEditHelper().copy(22);
                } else if (this.actionName.equals("Paste")) {
                    int top;
                    if (this.table.getUndoManager() != null) {
                        this.table.getUndoManager().createPasteEdit();
                    }
                    this.table.getEditHelper().paste(this.getPasteMode());
                    KDTSelectBlock block = this.table.getSelectManager().get();
                    String ClipBoardText = QuickInputUI.this.getSysClipBoardText();
                    int bottom = 0;
                    if (ClipBoardText != null) {
                        bottom = top + ClipBoardText.split("\\n").length;
                    } else {
                        return;
                    }
                    for (top = block.getTop(); top <= bottom && top < this.table.getRowCount(); ++top) {
                    }
                } else if (this.actionName.equals("Cut")) {
                    if (this.table.getUndoManager() != null) {
                        this.table.getUndoManager().createCutEdit(this.table.getSelectManager().toRange());
                    }
                    this.table.getEditHelper().cut(this.getCutMode());
                }
            }
        });
        if ("com.kingdee.eas.fi.cas.client.PaymentBillUI".equals(this.billEditUI.getClass().getName()) || "com.kingdee.eas.fi.cas.client.ReceivingBillUI".equals(this.billEditUI.getClass().getName())) {
            this.actionGroupFieldConfig.setEnabled(false);
            this.actionGroupFieldConfig.setVisible(false);
        } else {
            this.actionGroupFieldConfig.setEnabled(true);
            this.actionGroupFieldConfig.setVisible(true);
        }
    }

    public void reloadEntry() throws Exception {
        this.groupKeyMap.clear();
        this.initGroupFields();
        this.loadBillEntryValue();
        this.setCellEditor();
    }

    private void setCellEditor() {
        String key;
        int i;
        this.groupKeyRowMap.clear();
        for (i = 0; i < this.billEntry.getRowCount(); ++i) {
            key = this.getKey(this.billEntry.getRow(i));
            if (this.groupKeyRowMap.get(key) != null) continue;
            this.groupKeyRowMap.put(key, this.billEntry.getRow(i));
        }
        for (i = 0; i < this.table.getRowCount(); ++i) {
            key = this.getKey(this.table.getRow(i));
            String[] stringArray = this.cellEditorFields;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String cellName;
                String name = cellName = stringArray[j];
                ICell cell = ((IRow)this.groupKeyRowMap.get(key)).getCell(name);
                this.table.getRow(i).getCell(name).setEditor(cell.getEditor());
                this.table.getRow(i).getCell(name).setRenderer(cell.getRenderer());
                this.table.getRow(i).getCell(name).setStyleAttributes(cell.getStyleAttributes());
            }
        }
        for (i = 0; i < this.table.getColumnCount(); ++i) {
            key = this.table.getColumnKey(i);
            if (this.groupFields.contains(key)) {
                this.table.getColumn(i).getStyleAttributes().setLocked(false);
                this.table.getColumn(i).getStyleAttributes().setLocked(true);
            }
            if (this.table.getColumn(i).getStyleAttributes().isHided()) continue;
            this.table.getColumn(i).setEditor(this.billEntry.getColumn(key).getEditor());
            this.table.getColumn(i).setRenderer(this.billEntry.getColumn(key).getRenderer());
        }
        if (this.lockCols != null) {
            for (i = 0; i < this.lockCols.length; ++i) {
                if (this.table.getColumn(this.lockCols[i]) == null) continue;
                this.table.getColumn(this.lockCols[i]).getStyleAttributes().setLocked(false);
                this.table.getColumn(this.lockCols[i]).getStyleAttributes().setLocked(true);
            }
        }
        if (this.hideCols != null) {
            for (i = 0; i < this.hideCols.length; ++i) {
                if (this.table.getColumn(this.hideCols[i]) == null) continue;
                this.table.getColumn(this.hideCols[i]).getStyleAttributes().setHided(false);
                this.table.getColumn(this.hideCols[i]).getStyleAttributes().setHided(true);
            }
        }
    }

    public Set initGroupFields() throws Exception {
        this.groupFields = new LinkedHashSet();
        if (this.preSetFields.size() > 0) {
            this.groupFields.addAll(this.preSetFields);
        }
        if (!StringUtils.isEmpty((String)this.entityPK)) {
            QuickInputConfigCollection coll = ArApCommonUtil.getQuickInputConfigColl(null, this.userID, this.entityPK);
            for (int i = 0; i < coll.size(); ++i) {
                if (!coll.get(i).isIsGroupField()) continue;
                this.groupFields.add(coll.get(i).getFieldKey());
            }
        }
        return this.groupFields;
    }

    public String getSysClipBoardText() {
        String ret = "";
        Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipTf = sysClip.getContents(null);
        if (clipTf != null && clipTf.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                ret = (String)clipTf.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() != 0) {
            return;
        }
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.table.getColumn(e.getColIndex()).setSortable(true);
            this.sorter.setSortAuto(true);
            this.sorter.sort(e.getColIndex());
            this.table.repaint();
        }
    }

    private void loadBillEntryValue() throws Exception {
        this.table.removeRows();
        String[] columns = this.getColumns();
        Object[] objs = this.groupEntry().entrySet().toArray();
        for (int i = objs.length - 1; i >= 0; --i) {
            Map.Entry obj = (Map.Entry)objs[i];
            Object[] sum = (Object[])obj.getValue();
            IRow row = this.table.addRow();
            for (int m = 0; m < columns.length; ++m) {
                row.getCell(columns[m]).setValue(sum[m]);
            }
            this.entryEditTrigger(null, row);
        }
        this.calculateTotal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void entryEditTrigger(KDTEditEvent e, IRow row) throws Exception {
        if (!StringUtils.isEmpty((String)this.calcRowMethod)) {
            Method method = null;
            method = this.billEditUI.getClass().getMethod(this.calcRowMethod, KDTEditEvent.class, Map.class);
            Integer rowIndex = null;
            try {
                IRow entryRow = this.billEntry.addRow();
                rowIndex = entryRow.getRowIndex();
                if (e == null) {
                    ArApBillUIUtil.copyEntryRow(this.billEntry, row, entryRow, false);
                } else {
                    if (e.getValue() != null && e.getOldValue() != null) {
                        if (e.getValue().equals(e.getOldValue())) {
                            return;
                        }
                        if (e.getValue() instanceof BigDecimal && ((BigDecimal)e.getValue()).compareTo((BigDecimal)e.getOldValue()) == 0) {
                            return;
                        }
                    }
                    this.groupKeyMap.put(this.getKey(row), row);
                    ArApBillUIUtil.copyEntryRow(this.billEntry, row, entryRow, true);
                }
                entryRow.getCell(this.idField).setValue((Object)"quickInputFlag");
                if (e != null) {
                    e.setRowIndex(rowIndex.intValue());
                    int entryCol = this.billEntry.getColumnIndex(this.table.getColumnKey(e.getColIndex()));
                    e.setColIndex(entryCol);
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("row", entryRow);
                paramMap.put("table", this.table);
                paramMap.put("groupFields", this.groupFields);
                method.setAccessible(true);
                method.invoke((Object)this.billEditUI, e, paramMap);
                ArApBillUIUtil.copyEntryRow(this.billEntry, entryRow, row, true);
            }
            finally {
                for (int i = this.billEntry.getRowCount() - 1; i >= 0; --i) {
                    if (this.billEntry.getCell(i, this.idField) == null || !"quickInputFlag".equals(this.billEntry.getCell(i, this.idField).getValue())) continue;
                    this.billEntry.removeRow(i);
                    break;
                }
                row.getCell(this.idField).setValue(null);
            }
        }
    }

    public Map groupEntry() {
        String[] sumColumns = this.sumCols;
        String[] columns = this.getColumns();
        ArrayList<String> sumC = new ArrayList<String>();
        for (int i = 0; i < sumColumns.length; ++i) {
            sumC.add(sumColumns[i]);
        }
        LinkedHashMap<String, Object[]> keyMap = new LinkedHashMap<String, Object[]>();
        for (int i = this.billEntry.getRowCount() - 1; i >= 0; --i) {
            BigDecimal allocateFieldValue;
            String key = this.getKey(this.billEntry.getRow(i));
            Object[] totalRowValue = (Object[])keyMap.get(key);
            if (totalRowValue == null) {
                totalRowValue = new Object[columns.length];
            }
            if ((allocateFieldValue = this.getCellValue(this.billEntry, i, this.negativeField)).compareTo(this.ZERO) == 0) continue;
            for (int m = 0; m < columns.length; ++m) {
                if (this.nullValueCols != null && Arrays.asList(this.nullValueCols).contains(columns[m])) continue;
                if (sumC.contains(columns[m])) {
                    BigDecimal cellValue = this.getCellValue(this.billEntry, i, columns[m]);
                    totalRowValue[m] = totalRowValue[m] == null ? cellValue : ((BigDecimal)totalRowValue[m]).add(cellValue);
                    continue;
                }
                totalRowValue[m] = this.billEntry.getCell(i, columns[m]).getValue();
            }
            keyMap.put(key, totalRowValue);
        }
        return keyMap;
    }

    private BigDecimal getCellValue(KDTable tbl, int rowIndex, String colName) {
        Object obj = tbl.getCell(rowIndex, colName).getValue();
        int precision = KDTableUtils.getCellPrecision(tbl, rowIndex, colName);
        BigDecimal retVal = obj == null ? ArApBaseCalculate.ZERO : (BigDecimal)obj;
        return retVal.setScale(precision, 4);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.billEntry.getRowCount(); ++i) {
            String key = this.getKey(this.billEntry.getRow(i));
            BigDecimal allocateFieldValue = this.getCellValue(this.billEntry, i, this.negativeField);
            if (allocateFieldValue.compareTo(this.ZERO) == 0) continue;
            IRow sumRow = this.groupKeyMap.get(key);
            for (int j = 0; j < this.cellEditorFields.length; ++j) {
                String field = this.cellEditorFields[j];
                if (Arrays.asList(this.lockCols).contains(field) || this.groupFields.contains(field) || sumRow == null) continue;
                this.billEntry.getRow(i).getCell(field).setStyleAttributes(sumRow.getCell(field).getStyleAttributes());
                this.billEntry.getRow(i).getCell(field).setEditor(sumRow.getCell(field).getEditor());
                this.billEntry.getRow(i).getCell(field).setRenderer(sumRow.getCell(field).getRenderer());
            }
            if (this.entryKeyMap.containsKey(key)) {
                this.entryKeyMap.get(key).add(this.billEntry.getRow(i));
                continue;
            }
            LinkedList<IRow> entrySet = new LinkedList<IRow>();
            entrySet.add(this.billEntry.getRow(i));
            this.entryKeyMap.put(key, entrySet);
        }
        Method method = null;
        method = this.billEditUI.getClass().getMethod("allocateEntry", Map.class, Map.class, Integer.class);
        method.setAccessible(true);
        method.invoke((Object)this.billEditUI, this.groupKeyMap, this.entryKeyMap, this.cbAllocateType.getSelectedIndex());
        this.actionExitCurrent_actionPerformed(e);
    }

    private String getKey(IRow row) {
        String key = "";
        key = ArApBillUIUtil.getKeyByGroup(row, this.groupFields, this.negativeField);
        return key;
    }

    public void calculateTotal() {
        HashMap<String, BigDecimal> sumValueMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            for (int j = 0; j < this.sumCols.length; ++j) {
                Object cellValue;
                String fieldKey = this.sumCols[j];
                if (row.getCell(fieldKey) == null) continue;
                BigDecimal totalValue = this.ZERO;
                if (sumValueMap.get(fieldKey) != null) {
                    totalValue = (BigDecimal)sumValueMap.get(fieldKey);
                }
                if ((cellValue = row.getCell(fieldKey).getValue()) != null && cellValue instanceof BigDecimal) {
                    totalValue = totalValue.add((BigDecimal)cellValue);
                }
                sumValueMap.put(fieldKey, totalValue);
            }
        }
        for (String key : sumValueMap.keySet()) {
            this.footRow.getCell(key).setValue(sumValueMap.get(key));
        }
    }

    public String[] getColumns() {
        if (this.cols == null) {
            this.cols = new String[this.table.getColumnCount()];
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                this.cols[i] = this.table.getColumnKey(i);
            }
        }
        return this.cols;
    }

    @Override
    public void actionGroupFieldConfig_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> uiCtx = new HashMap<String, Object>();
        uiCtx.put("entityPK", this.entityPK);
        uiCtx.put("preSetFields", this.getUIContext().get("preSetFields"));
        uiCtx.put("notGroupFields", this.getUIContext().get("notGroupFields"));
        LinkedHashMap<String, Object> fieldMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (this.table.getColumn(i).getStyleAttributes().isHided()) continue;
            fieldMap.put(this.table.getColumnKey(i), this.table.getHead().getRow(0).getCell(i).getValue());
        }
        uiCtx.put("fieldMap", fieldMap);
        uiCtx.put("Owner", (Object)this);
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.arap.client.QuickInputConfigUI", uiCtx, null, OprtState.EDIT);
        uiWin.show();
    }
}

