/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.arap.BosTypeEnum;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class RelationShader {
    private int count = 0;
    private final Random random = new Random();
    private Map<String, Color> colorMap = new HashMap<String, Color>();
    private Color originColor;
    private Map<BosTypeEnum, Set<Integer>> recoverRowIndexes = new HashMap<BosTypeEnum, Set<Integer>>();
    private final Map<BosTypeEnum, KDTable> tableMap = new HashMap<BosTypeEnum, KDTable>();

    public void setOriginColor(Color color) {
        if (this.originColor == null) {
            this.originColor = color;
        }
    }

    public Color getOriginColor() {
        return this.originColor;
    }

    public Color generateColor(String sumKey) {
        Color backGroundColor = this.colorMap.get(sumKey);
        if (backGroundColor == null) {
            ++this.count;
            int areaNum = this.count % 4;
            int randInt1 = this.random.nextInt(127);
            int randInt2 = this.random.nextInt(127);
            if (areaNum == 2) {
                randInt1 += 128;
            } else if (areaNum == 3) {
                randInt1 += 128;
                randInt2 += 128;
            } else {
                randInt2 += 128;
            }
            backGroundColor = new Color(randInt1, randInt2, 255);
        }
        this.colorMap.put(sumKey, backGroundColor);
        return backGroundColor;
    }

    public void recoverTableColor() {
        this.colorMap.clear();
        if (this.recoverRowIndexes != null && this.getOriginColor() != null) {
            for (Map.Entry<BosTypeEnum, Set<Integer>> entry : this.recoverRowIndexes.entrySet()) {
                KDTable table = this.tableMap.get((Object)entry.getKey());
                if (entry.getValue() == null) continue;
                for (Integer rowIndex : entry.getValue()) {
                    table.getRow(rowIndex.intValue()).getStyleAttributes().setBackground(this.getOriginColor());
                }
            }
            this.recoverRowIndexes.clear();
        }
    }

    public void paintTable(BosTypeEnum bosTypeEnum, String sumKey, Set<Integer> rowIndexes) {
        Color backGroundColor = this.generateColor(sumKey);
        KDTable table = this.tableMap.get((Object)bosTypeEnum);
        for (Integer rowIndex : rowIndexes) {
            this.getRecoverRowIndexes(bosTypeEnum).add(rowIndex);
            table.getRow(rowIndex.intValue()).getStyleAttributes().setBackground(backGroundColor);
        }
    }

    private Set<Integer> getRecoverRowIndexes(BosTypeEnum bosType) {
        Set<Integer> recoverRowIndexes = this.recoverRowIndexes.get((Object)bosType);
        if (recoverRowIndexes == null) {
            recoverRowIndexes = new HashSet<Integer>();
            this.recoverRowIndexes.put(bosType, recoverRowIndexes);
        }
        return recoverRowIndexes;
    }

    public void recordRecoverRowIndexes(BosTypeEnum bosType, Set<Integer> rowIndexes) {
        this.getRecoverRowIndexes(bosType).addAll(rowIndexes);
    }

    public void recordTable(BosTypeEnum bosTypeEnum, KDTable kdTable) {
        this.tableMap.put(bosTypeEnum, kdTable);
    }

    public KDTable getTable(BosTypeEnum bosTypeEnum) {
        return this.tableMap.get((Object)bosTypeEnum);
    }
}

