/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.DataTable;
import com.kingdee.bos.ctrl.kdf.table.IDataConvert;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.StringTable;
import com.kingdee.bos.ctrl.kdf.table.event.DataActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.ImportDataActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellValueParse;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SCMPasteHelper {
    private static final Logger logger = LoggerFactory.getLogger(SCMPasteHelper.class);
    private String[] dateFiledColumns = new String[0];
    private String[] checkBoxFiledColumns = new String[0];
    private String[] textFiledColumns = new String[0];
    private String[] comboBoxColumns = new String[0];
    private String[] excludeFiledColumns = new String[0];
    private KDTable kdtable;
    private ImportDataActionListener importListner;
    private int pasteCol = -1;
    private int pasteRow = -1;
    private int firstPasteCol = -1;
    private int firstPasteRow = -1;
    private int lastPasteSuccessCol = -1;
    private int lastPasteSuccessRow = -1;
    private long startTime = 0L;
    private boolean ispasting = false;

    public SCMPasteHelper(KDTable kdtable) {
        this.kdtable = kdtable;
        this.kdtable.setPasteF7Block(true);
        this.init();
    }

    public void init() {
        this.dateFiledColumns = this.getDateFieldColumns();
        this.checkBoxFiledColumns = this.getCheckBoxFieldColumns();
        this.textFiledColumns = this.getTextFieldColumns();
        this.comboBoxColumns = this.getComboBoxColumns();
        this.excludeFiledColumns = this.getExcludeColumns();
        this.importListner = new ImportDataActionListener(){

            public void doImport(DataActionEvent e) {
                if (e.getType() == 0) {
                    SCMPasteHelper.this.startTime = System.currentTimeMillis();
                    if (e.getParMap().get("type").equals("string")) {
                        StringTable table = (StringTable)e.getParMap().get("stringTable");
                        table.setSaveConverter((IDataConvert)new IDataConvert<String, Object>(){

                            public Object convert(String value, int row, int col) {
                                SCMPasteHelper.this.pastePreProcess(row, col);
                                Object result = null;
                                try {
                                    result = SCMPasteHelper.this.transPasteValue(value, row, col);
                                }
                                catch (ParseException e) {
                                    SysUtil.abort();
                                }
                                return result;
                            }
                        });
                    } else if (e.getParMap().get("type").equals("xml")) {
                        DataTable dataTable = (DataTable)e.getParMap().get("dataTable");
                        dataTable.setSaveConverter((IDataConvert)new IDataConvert<Object, Object>(){

                            public Object convert(Object value, int row, int col) {
                                SCMPasteHelper.this.pastePreProcess(row, col);
                                return value;
                            }
                        });
                    }
                }
                if (e.getType() == 1) {
                    SCMPasteHelper.this.setPasteEnd();
                    try {
                        SCMPasteHelper.this.pasteAfterProcess();
                    }
                    finally {
                        SCMPasteHelper.this.resetPasteInfo();
                    }
                    SCMPasteHelper.this.lastPasteSuccessCol = -1;
                    SCMPasteHelper.this.lastPasteSuccessRow = -1;
                    SCMPasteHelper.this.kdtable.reLayoutAndPaint();
                }
            }
        };
        this.kdtable.getEditHelper().setCoypMode(2);
        this.kdtable.addImportActionListener(this.importListner);
    }

    public int getFirstPasteCol() {
        return this.firstPasteCol;
    }

    public int getFirstPasteRow() {
        return this.firstPasteRow;
    }

    public boolean indexInColumns(KDTable table, int colIndex, String[] columns) {
        if (columns == null) {
            return false;
        }
        return Arrays.asList((Object[])columns).contains(table.getColumnKey(colIndex));
    }

    public String transDateFiledValue(String dateStr) throws ParseException {
        String result = null;
        try {
            String splitChar = dateStr.substring(4, 5);
            String pattern = "yyyy" + splitChar + "MM" + splitChar + "dd";
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            result = BOSLocaleUtil.getDateFormat().format(df.parse(dateStr));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean transCheckBoxFieldValue(String select) {
        boolean result = false;
        result = select.equals("\u662f") ? true : Boolean.parseBoolean(select);
        return result;
    }

    private Object transPasteValue(String value, int row, int col) throws ParseException {
        Object result = value;
        if (this.indexInColumns(this.kdtable, col, this.dateFiledColumns)) {
            result = this.transDateFiledValue(value);
        }
        if (this.indexInColumns(this.kdtable, col, this.checkBoxFiledColumns)) {
            result = this.transCheckBoxFieldValue(value);
        }
        if (this.indexInColumns(this.kdtable, col, this.comboBoxColumns)) {
            result = this.transComboBoxFieldValue(value);
        }
        if (this.indexInColumns(this.kdtable, col, this.textFiledColumns)) {
            result = this.transStringFieldValue(value, col);
        }
        return result;
    }

    private String transStringFieldValue(String value, int col) {
        int maxLength = ((KDTextField)this.kdtable.getColumn(col).getEditor().getComponent()).getMaxLength();
        if (value != null && value.length() > maxLength) {
            value = value.substring(0, maxLength);
        }
        return value;
    }

    public Object transComboBoxFieldValue(String name) {
        return name;
    }

    public void pastePreProcess(int row, int col) {
        int i;
        if (this.pasteCol >= 0 && this.pasteCol != col) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.FRAMEWORKAutoGenerateResource", (String)"CANONLYPASTEONECOL"));
            this.resetPasteInfo();
            this.setPasteEnd();
            SysUtil.abort();
        }
        if (this.indexInColumns(this.kdtable, col, this.excludeFiledColumns)) {
            SysUtil.abort();
        }
        this.pasteRow = row;
        this.pasteCol = col;
        this.ispasting = true;
        if (this.firstPasteCol == -1 && this.firstPasteRow == -1) {
            this.setF7FieldCommitFormat();
            this.firstPasteRow = row;
            this.firstPasteCol = col;
        }
        if (this.kdtable.getRow(row) == null) {
            this.insertRow(row);
        }
        if (this.kdtable.getRow(row) == null) {
            return;
        }
        this.kdtable.getSelectManager().select(row, col);
        ICellEditor editor = this.kdtable.getCellEditor(row, col);
        if (editor instanceof ICellValueParse && editor.getComponent() instanceof KDPromptBox) {
            SelectorListener[] selectorListeners = ((KDPromptBox)editor.getComponent()).getSelectorListeners();
            SelectorEvent evt = new SelectorEvent((Object)editor.getComponent());
            for (i = 0; i < selectorListeners.length; ++i) {
                if (this.kdtable.getRow(row).getCell(col).getStyle().isLocked()) continue;
                selectorListeners[i].willShow(evt);
            }
        }
        KDTEditEvent event = new KDTEditEvent((Object)this.kdtable);
        event.setColIndex(col);
        event.setRowIndex(row);
        Object[] listeners = this.kdtable.getListenerList().getListenerList();
        try {
            for (i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != KDTEditListener.class || this.kdtable.getRow(row).getCell(col).getStyle().isLocked()) continue;
                ((KDTEditListener)listeners[i + 1]).editStarting(event);
            }
        }
        catch (Exception e) {
            this.resetPasteInfo();
            this.setPasteEnd();
            SysUtil.abort();
        }
        if (event.isCancel()) {
            this.resetPasteInfo();
            this.setPasteEnd();
            SysUtil.abort();
        }
        this.setCellF7FieldCommitFormat();
        this.lastPasteSuccessCol = col;
        this.lastPasteSuccessRow = row;
    }

    private void resetPasteInfo() {
        this.pasteRow = -1;
        this.pasteCol = -1;
        this.kdtable.getSelectManager().select(this.firstPasteRow, this.firstPasteCol);
        this.firstPasteCol = -1;
        this.firstPasteRow = -1;
    }

    public void setCellF7FieldCommitFormat() {
    }

    protected void setF7FieldCommitFormat() {
    }

    public void setPasteEnd() {
        this.ispasting = false;
    }

    public void setTableF7FieldCommitFormat(String field, String commitformat) {
        this.setTableF7FieldsCommitFormat(new String[]{field}, commitformat);
    }

    public void setTableF7FieldsCommitFormat(String[] fileds, String commitformat) {
        for (int i = 0; i < fileds.length; ++i) {
            ((KDBizPromptBox)this.kdtable.getColumn(fileds[i]).getEditor().getComponent()).setCommitFormat(commitformat);
        }
    }

    public int getPasteCol() {
        return this.pasteCol;
    }

    public int getPasteRow() {
        return this.pasteRow;
    }

    public int getLastPasteSuccessCol() {
        return this.lastPasteSuccessCol;
    }

    public int getLastPasteSuccessRow() {
        return this.lastPasteSuccessRow;
    }

    public boolean isPasteing() {
        return this.ispasting;
    }

    public String[] getDateFieldColumns() {
        return null;
    }

    public String[] getCheckBoxFieldColumns() {
        return null;
    }

    public String[] getTextFieldColumns() {
        return null;
    }

    public String[] getExcludeColumns() {
        return null;
    }

    public String[] getComboBoxColumns() {
        return null;
    }

    public abstract void insertRow(int var1);

    protected void pasteAfterProcess() {
    }

    public String getMaterialColName() {
        return null;
    }
}

