/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.arap.IInvoice;
import com.kingdee.eas.fi.arap.InvoiceException;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.client.InvoiceAutoGenBTPRulesUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class SrcBillAutoInvClntProcessor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.client.SrcBillAutoInvClntProcessor");

    public abstract IInvoice getInvoiceInterface() throws BOSException;

    public abstract BOSObjectType getSrcBosType();

    public abstract BOSObjectType getDestBosType();

    public abstract String getInvoiceEditUI();

    public void trans2VatInv(List srcBillIds, CompanyOrgUnitInfo companyInfo) throws Exception {
        if (srcBillIds == null || srcBillIds.size() == 0) {
            return;
        }
        CtrlUnitInfo cuInfo = companyInfo.getCU();
        IInvoice iInv = this.getInvoiceInterface();
        BOTMappingInfo mappingInfo = null;
        try {
            mappingInfo = iInv.getVatBotMapping();
        }
        catch (EASBizException e) {
            if (e instanceof InvoiceException && e.getSubCode().equals(InvoiceException.MANY_BOTMAPPINGS.getCode())) {
                mappingInfo = this.getSelectedMapping(cuInfo);
            }
            throw e;
        }
        if (mappingInfo == null) {
            logger.warn((Object)"no bot mapping!");
            return;
        }
        BTPTransformResult btpResult = iInv.transVatFromSrcBills(srcBillIds, mappingInfo.getId());
        boolean fShowEditUI = mappingInfo.getIsShowEditUI() == 1;
        IIDList idList = this.getNeedEditIds(btpResult.getBills(), fShowEditUI);
        this.showVatInvUI(idList);
    }

    private BOTMappingInfo getSelectedMapping(CtrlUnitInfo cuInfo) throws BOSException, UIException {
        HashMap<String, String> uiCtx = new HashMap<String, String>();
        uiCtx.put("isVAT", "true");
        uiCtx.put("destBillBOSTypeString", (String)this.getDestBosType());
        uiCtx.put("srcBosType", (String)this.getSrcBosType());
        uiCtx.put("cu", (String)cuInfo);
        IUIWindow btpRuleWin = null;
        btpRuleWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.arap.client.InvoiceAutoGenBTPRulesUI", uiCtx, null);
        btpRuleWin.show();
        InvoiceAutoGenBTPRulesUI ruleUI = (InvoiceAutoGenBTPRulesUI)btpRuleWin.getUIObject();
        return ruleUI.getSelectedMapping();
    }

    private void showVatInvUI(IIDList idList) throws UIException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        HashMap<String, Object> uiCtx = new HashMap<String, Object>();
        uiCtx.put("ID", idList.getCurrentID());
        uiCtx.put("IDList", idList);
        uiCtx.put("BOTPViewStatus", new Integer(1));
        String uiCls = this.getInvoiceEditUI();
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiCls, uiCtx, null, OprtState.EDIT);
        uiWin.show();
    }

    private IIDList getNeedEditIds(IObjectCollection destBills, boolean fShowUI) throws BOSException {
        if (destBills == null || destBills.size() == 0) {
            return null;
        }
        RealModeIDList idList = RealModeIDList.getEmptyIDList();
        if (!fShowUI) {
            IInvoice iInv = this.getInvoiceInterface();
            int n = destBills.size();
            for (int i = 0; i < n; ++i) {
                InvoiceInfo info = (InvoiceInfo)destBills.getObject(i);
                try {
                    iInv.transSubmit(info);
                    continue;
                }
                catch (EASBizException e) {
                    logger.error((Object)"submit failure", (Throwable)e);
                    idList.add(info.getId().toString());
                }
            }
        } else {
            int count = destBills.size();
            for (int i = 0; i < count; ++i) {
                idList.add(destBills.getObject(i).getString("id"));
            }
        }
        idList.setCurrentIndex(0);
        return idList;
    }
}

