/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.client.AbstractSubstituteRecPayUI;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.DataUtils;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubstituteRecPayUI
extends AbstractSubstituteRecPayUI {
    private static final Logger logger = CoreUIObject.getLogger(SubstituteRecPayUI.class);
    Map uiCtx = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        String permissionName = "";
        FullOrgUnitInfo orgUnitInfo = null;
        this.uiCtx = this.getUIContext();
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)this.uiCtx.get("curCompany");
        boolean isArSys = Boolean.valueOf(this.uiCtx.get("isArSys").toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        super.onLoad();
        if (isArSys) {
            permissionName = "cas_receivingbill_02addNew";
        } else {
            permissionName = "cas_paymentbill_02addNew";
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"SubstitutePay"));
            String companyText = EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"SubstitutePayComOrg");
            this.kDLabelContainer1.setToolTipText(companyText);
            this.kDLabelContainer1.setBoundLabelText(companyText);
        }
        ObjectUuidPK userID = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        IPermission permission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection fullOrgUnits = permission.getAuthorizedOrg((IObjectPK)userID, OrgType.Company, null, permissionName);
        if (fullOrgUnits != null && fullOrgUnits.size() > 0) {
            HashSet<String> idSet = new HashSet<String>();
            int size = fullOrgUnits.size();
            for (int i = 0; i < size; ++i) {
                orgUnitInfo = fullOrgUnits.get(i);
                if (orgUnitInfo == null || orgUnitInfo.getId().toString().equals(curCompany.getId().toString())) continue;
                idSet.add(orgUnitInfo.getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            if (coll != null && coll.size() > 0) {
                idSet.clear();
                int size2 = coll.size();
                for (int i = 0; i < size2; ++i) {
                    idSet.add(coll.get(i).getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"88888888"));
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"88888888"));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtCompanyOrgUnit.setEntityViewInfo(viewInfo);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ReceivingBillInfo destBillInfo;
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"CompanyCanNotNull"));
            SysUtil.abort();
        }
        this.actionExitCurrent_actionPerformed(e);
        boolean isArSys = Boolean.valueOf(this.uiCtx.get("isArSys").toString());
        BOSObjectType destBosType = (BOSObjectType)this.uiCtx.get("destBosType");
        BOSObjectType srcBosType = (BOSObjectType)this.uiCtx.get("srcBosType");
        CompanyOrgUnitInfo selectCompany = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("destBosType", destBosType);
        CoreBillBaseCollection coll = (CoreBillBaseCollection)this.uiCtx.get("srcBillInfos");
        paramMap.put("srcBillInfos", coll);
        paramMap.put("botpID", this.uiCtx.get("botpID").toString());
        HashMap hm = this.createSubstituteRecPayBill(paramMap);
        if (hm == null || hm.size() == 0) {
            return;
        }
        UIContext map = new UIContext((Object)this);
        map.put("Owner", this);
        map.put("BOTPViewStatus", new Integer(1));
        map.put("srcBillBOSTypeString", srcBosType.toString());
        String destBillEditUIClassName = (String)hm.get("destBillEditUIClassName");
        map.put("canResize", "true");
        if (isArSys) {
            destBillInfo = (ReceivingBillInfo)((BTPTransformResult)hm.get("btpResult")).getBills().getObject(0);
            destBillInfo.setCompany(selectCompany);
            destBillInfo.setCU(selectCompany.getCU());
            this.calRecLocalAmount(destBillInfo);
            map.put("InitDataObject", destBillInfo);
        } else {
            destBillInfo = (PaymentBillInfo)((BTPTransformResult)hm.get("btpResult")).getBills().getObject(0);
            destBillInfo.setCompany(selectCompany);
            this.calPayLocalAmount((PaymentBillInfo)destBillInfo);
            destBillInfo.setCU(selectCompany.getCU());
            map.put("InitDataObject", destBillInfo);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(destBillEditUIClassName, (Map)map, null, OprtState.ADDNEW);
        ((CoreBillEditUI)uiWindow.getUIObject()).setMakeRelations(((BTPTransformResult)hm.get("btpResult")).getBOTRelationCollection());
        uiWindow.show();
    }

    private ExchangeRateInfo getExgRateInfo(CurrencyInfo currency, Date billDate, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ExchangeRateInfo rateInfo = null;
        if (company != null && company.getBaseCurrency() != null && billDate != null) {
            if (!ArApBillHelper.idEquals((CoreBaseInfo)currency, (CoreBaseInfo)company.getBaseCurrency())) {
                rateInfo = BaseDataUtil.getExchangeRate(company, currency, billDate);
            } else {
                rateInfo = new ExchangeRateInfo();
                rateInfo.setConvertRate(DataUtils.ONE);
            }
        }
        return rateInfo;
    }

    private void calRecLocalAmount(ReceivingBillInfo billInfo) throws EASBizException, BOSException {
        CoreBillBaseCollection coll;
        ReceivingBillEntryInfo entryInfo = null;
        int localPrecision = 2;
        Date billDate = new Date();
        BigDecimal entryLocalAmt = DataUtils.ZERO;
        BigDecimal localAmt = DataUtils.ZERO;
        CurrencyInfo baseCurrency = null;
        CompanyOrgUnitInfo srcCompany = null;
        ExchangeRateInfo rateInfo = null;
        if (billInfo.getBizDate() != null) {
            billDate = billInfo.getBizDate();
        }
        if ((coll = (CoreBillBaseCollection)this.uiCtx.get("srcBillInfos")) != null && coll.get(0) != null && coll.get(0).get("company") != null) {
            srcCompany = (CompanyOrgUnitInfo)coll.get(0).get("company");
        }
        if (billInfo.getCurrency() != null && billInfo.getCompany() != null && billInfo.getCompany().getBaseCurrency() != null) {
            if (srcCompany != null && srcCompany.getBaseCurrency() != null && srcCompany.getBaseCurrency().getId().toString().equals(billInfo.getCompany().getBaseCurrency().getId().toString())) {
                rateInfo = new ExchangeRateInfo();
                if (coll.get(0).get("exchangeRate") != null) {
                    rateInfo.setConvertRate((BigDecimal)coll.get(0).get("exchangeRate"));
                } else {
                    rateInfo.setConvertRate(DataUtils.ONE);
                }
                billInfo.setBoolean("isEqualCurrency", true);
                billInfo.setExchangeRate(rateInfo.getConvertRate());
                return;
            }
            rateInfo = this.getExgRateInfo(billInfo.getCurrency(), billDate, billInfo.getCompany());
            if (billInfo.getCompany().getBaseCurrency() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("precision"));
                sic.add(new SelectorItemInfo("number"));
                baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(billInfo.getCompany().getBaseCurrency().getId().toString()), sic);
                localPrecision = baseCurrency.getPrecision();
            }
            if (rateInfo != null) {
                if (rateInfo.getId() == null) {
                    billInfo.setExchangeRate(rateInfo.getConvertRate());
                } else {
                    billInfo.setExchangeRate(rateInfo.getConvertRate().setScale(rateInfo.getPrecision(), 4));
                }
                if (DataUtils.ONE.compareTo(rateInfo.getConvertRate()) != 0) {
                    ConvertModeEnum convertMode = rateInfo.getConvertMode();
                    int size = billInfo.getEntries().size();
                    for (int i = 0; i < size; ++i) {
                        entryInfo = billInfo.getEntries().get(i);
                        if (entryInfo == null) continue;
                        entryLocalAmt = ConvertModeEnum.DIRECTEXCHANGERATE == convertMode ? entryInfo.getAmount().multiply(billInfo.getExchangeRate()).setScale(localPrecision, 4) : entryInfo.getAmount().divide(billInfo.getExchangeRate(), localPrecision, 4);
                        entryInfo.setLocalAmt(entryLocalAmt);
                        localAmt = localAmt.add(entryLocalAmt);
                    }
                    billInfo.setActRecLocAmt(localAmt);
                } else {
                    int size = billInfo.getEntries().size();
                    for (int i = 0; i < size; ++i) {
                        entryInfo = billInfo.getEntries().get(i);
                        if (entryInfo == null) continue;
                        entryLocalAmt = entryInfo.getAmount();
                        entryInfo.setLocalAmt(entryLocalAmt);
                        localAmt = localAmt.add(entryLocalAmt);
                    }
                    billInfo.setActRecLocAmt(localAmt);
                }
            } else {
                String msgInfo = EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"ExchangeRateNotExists");
                MsgBox.showInfo((String)MessageFormat.format(msgInfo, billInfo.getCurrency().getNumber(), baseCurrency == null ? "" : baseCurrency.getNumber()));
                SysUtil.abort();
            }
        }
    }

    private void calPayLocalAmount(PaymentBillInfo billInfo) throws EASBizException, BOSException {
        CoreBillBaseCollection coll;
        PaymentBillEntryInfo entryInfo = null;
        int localPrecision = 2;
        Date billDate = new Date();
        BigDecimal entryLocalAmt = DataUtils.ZERO;
        BigDecimal localAmt = DataUtils.ZERO;
        CurrencyInfo baseCurrency = null;
        CompanyOrgUnitInfo srcCompany = null;
        ExchangeRateInfo rateInfo = null;
        if (billInfo.getBizDate() != null) {
            billDate = billInfo.getBizDate();
        }
        if ((coll = (CoreBillBaseCollection)this.uiCtx.get("srcBillInfos")) != null && coll.get(0) != null && coll.get(0).get("company") != null) {
            srcCompany = (CompanyOrgUnitInfo)coll.get(0).get("company");
        }
        if (billInfo.getCurrency() != null && billInfo.getCompany() != null) {
            if (srcCompany != null && srcCompany.getBaseCurrency() != null && srcCompany.getBaseCurrency().getId().toString().equals(billInfo.getCompany().getBaseCurrency().getId().toString())) {
                rateInfo = new ExchangeRateInfo();
                if (coll.get(0).get("exchangeRate") != null) {
                    rateInfo.setConvertRate((BigDecimal)coll.get(0).get("exchangeRate"));
                } else {
                    rateInfo.setConvertRate(DataUtils.ONE);
                }
                billInfo.setBoolean("isEqualCurrency", true);
                billInfo.setExchangeRate(rateInfo.getConvertRate());
                return;
            }
            rateInfo = this.getExgRateInfo(billInfo.getCurrency(), billDate, billInfo.getCompany());
            if (billInfo.getCompany().getBaseCurrency() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("precision"));
                sic.add(new SelectorItemInfo("number"));
                baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(billInfo.getCompany().getBaseCurrency().getId().toString()), sic);
                localPrecision = baseCurrency.getPrecision();
            }
            if (rateInfo != null) {
                if (rateInfo.getId() == null) {
                    billInfo.setExchangeRate(rateInfo.getConvertRate());
                } else {
                    billInfo.setExchangeRate(rateInfo.getConvertRate().setScale(rateInfo.getPrecision(), 4));
                }
                if (DataUtils.ONE.compareTo(rateInfo.getConvertRate()) != 0) {
                    ConvertModeEnum convertMode = rateInfo.getConvertMode();
                    int size = billInfo.getEntries().size();
                    for (int i = 0; i < size; ++i) {
                        entryInfo = billInfo.getEntries().get(i);
                        if (entryInfo == null) continue;
                        entryLocalAmt = ConvertModeEnum.DIRECTEXCHANGERATE == convertMode ? entryInfo.getAmount().multiply(billInfo.getExchangeRate()).setScale(localPrecision, 4) : entryInfo.getAmount().divide(billInfo.getExchangeRate(), localPrecision, 4);
                        entryInfo.setLocalAmt(entryLocalAmt);
                        localAmt = localAmt.add(entryLocalAmt);
                    }
                    billInfo.setActPayLocAmt(localAmt);
                } else {
                    int size = billInfo.getEntries().size();
                    for (int i = 0; i < size; ++i) {
                        entryInfo = billInfo.getEntries().get(i);
                        if (entryInfo == null) continue;
                        entryLocalAmt = entryInfo.getAmount();
                        entryInfo.setLocalAmt(entryLocalAmt);
                        localAmt = localAmt.add(entryLocalAmt);
                    }
                    billInfo.setActPayLocAmt(localAmt);
                }
            } else {
                String msgInfo = EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"ExchangeRateNotExists");
                MsgBox.showInfo((String)MessageFormat.format(msgInfo, billInfo.getCurrency().getNumber(), baseCurrency == null ? "" : baseCurrency.getNumber()));
                SysUtil.abort();
            }
        }
    }

    protected HashMap createSubstituteRecPayBill(HashMap paramMap) throws BOSException, EASBizException {
        if (paramMap.get("destBosType") == null || paramMap.get("srcBillInfos") == null || paramMap.get("botpID") == null) {
            return new HashMap();
        }
        BOSObjectType destBosType = (BOSObjectType)paramMap.get("destBosType");
        String botpID = paramMap.get("botpID").toString();
        BOTMappingInfo botMappingInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)botpID));
        view.setFilter(filter);
        botMappingInfo = BOTMappingFactory.getRemoteInstance().getBOTMappingCollection(view).get(0);
        if (botMappingInfo == null || botMappingInfo.getExtRule() != null && !botMappingInfo.getExtRule().isIsEffected()) {
            throw new BTPException(BTPException.GETMAPPINGINFOERROR);
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        if (botMappingInfo != null && botMappingInfo.getId() != null) {
            CoreBillBaseCollection srcBillInfos = (CoreBillBaseCollection)paramMap.get("srcBillInfos");
            try {
                BTPTransformResult btpResult = BTPManagerFactory.getRemoteInstance().transformWithMutex(srcBillInfos, destBosType.toString(), (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()), true);
                String destBillEditUIClassName = BTPManagerFactory.getRemoteInstance().getEntityObjectInfoExtendPro(destBosType.toString(), "editUI");
                hm.put("btpResult", btpResult);
                hm.put("destBillEditUIClassName", destBillEditUIClassName);
            }
            catch (BOSException e) {
                MsgBox.showError((String)e.getMessage());
                SysUtil.abort();
            }
        }
        return hm;
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }
}

