/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.client.CSSPGroupPrompt;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.EntityViewHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.text.JTextComponent;

public class ArApQueryUIUtil {
    private static final ObjectUuidPK ORG_FIVIEW_ID = new ObjectUuidPK("00000000-0000-0000-0000-0000000000024F2827FD");

    private ArApQueryUIUtil() {
    }

    public static void setCsspGrpF7(IUIObject ui, KDBizPromptBox prmtCsspGrp, AsstActTypeInfo typeInfo) {
        boolean fCustSupp;
        String cussTable = typeInfo.getRealtionDataObject();
        boolean fCust = cussTable.equalsIgnoreCase("t_bd_customer");
        boolean fSupp = cussTable.equalsIgnoreCase("t_bd_supplier");
        boolean bl = fCustSupp = fCust || fSupp;
        if (fCustSupp) {
            String qryName = fCust ? "com.kingdee.eas.basedata.master.cssp.app.F7CustomerGroupQuery" : "com.kingdee.eas.basedata.master.cssp.app.F7SupplierGroupQuery";
            CSSPGroupPrompt csspGroupBox = new CSSPGroupPrompt(ui, fCust ? 1 : 2);
            prmtCsspGrp.setQueryInfo(qryName);
            prmtCsspGrp.setSelector((KDPromptSelector)csspGroupBox);
        }
        prmtCsspGrp.setEnabled(fCustSupp);
    }

    public static void setCompsCsspGrpF7(IUIObject ui, KDBizPromptBox prmtCsspGrp, AsstActTypeInfo typeInfo, boolean fSameCu) {
        boolean fCustSupp;
        String cussTable = typeInfo.getRealtionDataObject();
        boolean fCust = cussTable.equalsIgnoreCase("t_bd_customer");
        boolean fSupp = cussTable.equalsIgnoreCase("t_bd_supplier");
        boolean bl = fCustSupp = fCust || fSupp;
        if (fCustSupp) {
            String qryName = fCust ? "com.kingdee.eas.basedata.master.cssp.app.F7CustomerGroupQuery" : "com.kingdee.eas.basedata.master.cssp.app.F7SupplierGroupQuery";
            CSSPGroupPrompt csspGroupBox = new CSSPGroupPrompt(ui, fCust ? 1 : 2);
            prmtCsspGrp.setQueryInfo(qryName);
            prmtCsspGrp.setSelector((KDPromptSelector)csspGroupBox);
            if (prmtCsspGrp.isEnabled() && !fSameCu) {
                prmtCsspGrp.setValue(null);
            }
        }
        prmtCsspGrp.setEnabled(fCustSupp && fSameCu);
    }

    private static void removeCustSuppF7Selectors(KDBizPromptBox prmtCuss) {
        prmtCuss.setSelector(null);
        SelectorListener[] selectors = prmtCuss.getSelectorListeners();
        if (selectors.length != 0) {
            for (int i = 0; i < selectors.length; ++i) {
                prmtCuss.removeSelectorListener(selectors[i]);
            }
        }
    }

    public static void csspGrpValueChangeProcess(CoreUIObject ui, String companyId, AsstActTypeInfo asstActTypeInfo, KDBizPromptBox prmtCsspGrp, KDBizPromptBox prmtCussAcctFrom, KDBizPromptBox prmtCussAcctTo) throws Exception {
        if (asstActTypeInfo == null) {
            return;
        }
        prmtCussAcctFrom.setValue(null);
        prmtCussAcctTo.setValue(null);
        CSSPGroupInfo info = (CSSPGroupInfo)prmtCsspGrp.getValue();
        String realtionDataObject = asstActTypeInfo.getRealtionDataObject();
        if (!"T_BD_CUSTOMER".equals(realtionDataObject) && !"T_BD_SUPPLIER".equals(realtionDataObject)) {
            return;
        }
        if (info == null) {
            ArApBillUIUtil.setAsstActSelector(ui, prmtCussAcctFrom, asstActTypeInfo, companyId, true, true);
            ArApBillUIUtil.setAsstActSelector(ui, prmtCussAcctTo, asstActTypeInfo, companyId, false, true);
            return;
        }
        String stdId = null;
        if (info.getGroupStandard() != null) {
            stdId = info.getGroupStandard().getId().toString();
        }
        FilterInfo grpFilter = new FilterInfo();
        if (info.getLongNumber() != null) {
            grpFilter.getFilterItems().add(new FilterItemInfo("BROWSEGROUP.LongNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
            String maskString = "(#" + (grpFilter.getFilterItems().size() - 1);
            grpFilter.getFilterItems().add(new FilterItemInfo("BROWSEGROUP.LongNumber", (Object)info.getLongNumber(), CompareType.EQUALS));
            maskString = maskString + " or #" + (grpFilter.getFilterItems().size() - 1) + ")";
            grpFilter.setMaskString(maskString);
        } else {
            String maskString = "";
            CSSPGroupInfo gInfo = CSSPGroupFactory.getRemoteInstance().getCSSPGroupInfo("select longNumber where id='" + info.getId().toString() + "'");
            grpFilter.getFilterItems().add(new FilterItemInfo("BROWSEGROUP.LongNumber", (Object)(gInfo.getLongNumber() + "!%"), CompareType.LIKE));
            maskString = maskString + "(#" + (grpFilter.getFilterItems().size() - 1);
            grpFilter.getFilterItems().add(new FilterItemInfo("BROWSEGROUP.LongNumber", (Object)gInfo.getLongNumber(), CompareType.EQUALS));
            maskString = maskString + " or #" + (grpFilter.getFilterItems().size() - 1) + ")";
            grpFilter.setMaskString(maskString);
        }
        ArApQueryUIUtil.setPrmtGrpStdFilter(stdId, grpFilter, prmtCussAcctFrom);
        ArApQueryUIUtil.setPrmtGrpStdFilter(stdId, grpFilter, prmtCussAcctTo);
        ArApQueryUIUtil.removeCustSuppF7Selectors(prmtCussAcctFrom);
        ArApQueryUIUtil.removeCustSuppF7Selectors(prmtCussAcctTo);
    }

    private static void setPrmtGrpStdFilter(String stdId, FilterInfo grpFilter, KDBizPromptBox prmtCussAcct) throws BOSException {
        EntityViewInfo view = prmtCussAcct.getEntityViewInfo();
        if (view == null) {
            return;
        }
        String propGrpName = "browseGroup.id";
        String propGrpStdName = "browseGroup.groupStandard";
        String preGrpLongNumber = "BROWSEGROUP.LongNumber";
        if (!StringUtils.isEmpty((String)stdId)) {
            EntityViewHelper.replaceFilterWithNewVal(view, propGrpStdName, stdId);
        }
        if (grpFilter != null) {
            EntityViewHelper.deletFilter(view, propGrpName);
            FilterItemCollection items = view.getFilter().getFilterItems();
            FilterItemInfo itemInfo = null;
            Iterator it = items.iterator();
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            while (it.hasNext()) {
                itemInfo = (FilterItemInfo)it.next();
                if (preGrpLongNumber.equalsIgnoreCase(itemInfo.getPropertyName())) continue;
                filter.getFilterItems().add(itemInfo);
            }
            view.setFilter(filter);
            view.getFilter().mergeFilter(grpFilter, "AND");
        }
        prmtCussAcct.setEntityViewInfo(view);
    }

    public static void setQueryUIBizPromptData(KDBizPromptBox bizPrompt, String id, CustomerQueryPanel qryUI) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            String oql = "select id, name, number where id = '" + id + "' ";
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), oql);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            qryUI.handUIException((Throwable)e);
            SysUtil.abort();
        }
    }

    public static void setAsstActDataByNumber(KDBizPromptBox bizPrompt, Object compVal, CustomerQueryPanel qryUI) {
        try {
            ((JTextComponent)bizPrompt.getEditor()).setText((String)compVal);
            bizPrompt.commitEdit();
        }
        catch (Exception e) {
            qryUI.handUIException((Throwable)e);
            SysUtil.abort();
        }
    }

    public static void setCussTypebyCompanys(Set companyIds, boolean fArRpt, KDComboBox comboCussType) throws Exception {
        if (companyIds == null || companyIds.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("isDefaultAccountPayable");
        view.getSelector().add("isDefaultAccountReceivable");
        view.getSelector().add("asstActType.id");
        view.getSelector().add("asstActType.name");
        view.getSelector().add("asstActType.number");
        view.getSelector().add("asstActType.defaultQueryName");
        view.getSelector().add("asstActType.realtionDataObject");
        view.getSelector().add("asstActType.glAsstActTypeGrp.id");
        items.add(new FilterItemInfo("isAccountCussent", (Object)new Integer(1)));
        items.add(new FilterItemInfo("company.id", (Object)companyIds, CompareType.INCLUDE));
        IAsstActTypeDefault iAsstActTypeDflt = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActTypeDflt.getAsstActTypeDefaultCollection(view);
        int count = asstActTypeColl.size();
        ArrayList<AsstActTypeInfo> types = new ArrayList<AsstActTypeInfo>();
        int defaultIndex = 0;
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo typeDefaultInfo = asstActTypeColl.get(i);
            AsstActTypeInfo asstTypeInfo = typeDefaultInfo.getAsstActType();
            if (types.contains(asstTypeInfo)) continue;
            types.add(asstTypeInfo);
            if ((!fArRpt || !typeDefaultInfo.isIsDefaultAccountReceivable()) && (fArRpt || !typeDefaultInfo.isIsDefaultAccountPayable())) continue;
            defaultIndex = types.indexOf(asstTypeInfo);
        }
        Object[] asstTypes = new AsstActTypeInfo[types.size()];
        int n = types.size();
        for (int i = 0; i < n; ++i) {
            asstTypes[i] = (AsstActTypeInfo)types.get(i);
        }
        comboCussType.removeAllItems();
        comboCussType.addItems(asstTypes);
        comboCussType.setSelectedIndex(defaultIndex);
    }

    public static void objFromChanged(IUIObject ui, KDBizPromptBox prmtObjFrom, KDBizPromptBox prmtObjTo) {
        Object asstActFrom = prmtObjFrom.getData();
        prmtObjTo.setEnabled(prmtObjFrom.isEnabled());
        if (asstActFrom instanceof Object[]) {
            Object[] fromArr = (Object[])asstActFrom;
            prmtObjTo.setEnabled(fromArr.length == 1);
            if (fromArr.length > 1) {
                prmtObjTo.setValue(null);
            }
        }
    }

    public static List getInfoIds(Object[] infoArr) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < infoArr.length; ++i) {
            DataBaseInfo info = (DataBaseInfo)infoArr[i];
            if (info == null) continue;
            ids.add(info.getString("id"));
        }
        return ids;
    }

    public static CoreBaseCollection getInfos(IUIObject ui, List ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        CoreBaseCollection infos = null;
        String id = ids.get(0).toString();
        BOSObjectType bosType = BOSUuid.read((String)id).getType();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        FilterInfo filter = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(ids);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            IDynamicObject iDyn = DynamicObjectFactory.getRemoteInstance();
            infos = (CoreBaseCollection)iDyn.getCollection(bosType, view);
        }
        catch (Exception e) {
            ui.handUIException((Throwable)e);
        }
        return infos;
    }

    public static void loadInfos(IUIObject ui, KDBizPromptBox prmt, List ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        prmt.setValue((Object)ArApQueryUIUtil.getInfos(ui, ids).toArray());
    }

    public static void saveCurrency(KDComboBox comboCurrency, ArApQueryParam param) {
        CurrencyInfo currInfo = (CurrencyInfo)comboCurrency.getSelectedItem();
        param.setCurrencyId(currInfo.getString("id"));
        if (!"all".equals(currInfo.getString("id"))) {
            param.setCurrencyInfo(currInfo);
        }
    }

    public static void saveCussType(KDComboBox comboCussType, ArApQueryParam param) {
        AsstActTypeInfo cussTypeInfo = (AsstActTypeInfo)comboCussType.getSelectedItem();
        if (cussTypeInfo == null) {
            return;
        }
        param.setCussTypeId(cussTypeInfo.getString("id"));
        if (!"all".equals(cussTypeInfo.getString("id"))) {
            param.setCussAcctTypeInfo(cussTypeInfo);
            param.setCussTypeId(cussTypeInfo.getString("id"));
            param.setCussTable(cussTypeInfo.getRealtionDataObject());
        }
    }

    public static void saveCsspGrp(KDBizPromptBox prmtCsspGrp, ArApQueryParam param) {
        if (prmtCsspGrp.getValue() == null) {
            return;
        }
        CSSPGroupInfo info = (CSSPGroupInfo)prmtCsspGrp.getValue();
        if (info.getGroupStandard() != null) {
            String grpStdId = info.getGroupStandard().getId().toString();
            param.setCsspGrpStdId(grpStdId);
        }
        param.setCsspGrpId(info.getString("id"));
        param.setCsspGrpName(info.getName());
        param.setCsspGrpNum(info.getNumber());
    }

    public static void loadCsspGrp(KDBizPromptBox prmtCsspGrp, ArApQueryParam param) {
        if (param.getCsspGrpId() == null) {
            return;
        }
        CSSPGroupInfo info = new CSSPGroupInfo();
        info.put("id", (Object)param.getCsspGrpId());
        info.setNumber(param.getCsspGrpNum());
        info.setName(param.getCsspGrpName());
        String grpStdId = param.getCsspGrpStdId();
        if (!StringUtils.isEmpty((String)grpStdId)) {
            CSSPGroupStandardInfo grpStdInfo = new CSSPGroupStandardInfo();
            grpStdInfo.put("id", (Object)grpStdId);
            info.setGroupStandard(grpStdInfo);
        }
        prmtCsspGrp.setValue((Object)info);
    }

    public static void saveCussAcctRange(KDBizPromptBox prmtCussFrom, KDBizPromptBox prmtCussTo, ArApQueryParam param) {
        Object objBiz = prmtCussFrom.getValue();
        DataBaseInfo bizObjInfo = null;
        if (objBiz != null) {
            if (objBiz instanceof DataBaseInfo) {
                bizObjInfo = (DataBaseInfo)objBiz;
                param.setCussAcctFromId(bizObjInfo.getString("id"));
                param.setCussAcctFromName(bizObjInfo.getName());
                param.setCussAcctFromNum(bizObjInfo.getNumber());
            } else {
                Object[] infoArr = (Object[])objBiz;
                if (infoArr.length == 1) {
                    bizObjInfo = (DataBaseInfo)infoArr[0];
                    param.setCussAcctFromId(bizObjInfo.getString("id"));
                    param.setCussAcctFromName(bizObjInfo.getName());
                    param.setCussAcctFromNum(bizObjInfo.getNumber());
                } else {
                    param.setCussAcctFromIds(ArApQueryUIUtil.getInfoIds(infoArr));
                }
            }
        }
        if (prmtCussTo.getValue() != null) {
            Object toBizObj = prmtCussTo.getValue();
            if (toBizObj instanceof DataBaseInfo) {
                bizObjInfo = (DataBaseInfo)toBizObj;
                param.setCussAcctToId(bizObjInfo.getString("id"));
                param.setCussAcctToName(bizObjInfo.getName());
                param.setCussAcctToNum(bizObjInfo.getNumber());
            } else {
                Object[] infoArr = (Object[])toBizObj;
                if (infoArr.length == 1) {
                    bizObjInfo = (DataBaseInfo)infoArr[0];
                    param.setCussAcctToId(bizObjInfo.getString("id"));
                    param.setCussAcctToName(bizObjInfo.getName());
                    param.setCussAcctToNum(bizObjInfo.getNumber());
                }
            }
        }
    }

    public static void loadCussAcctRange(IUIObject ui, KDBizPromptBox prmtCussFrom, KDBizPromptBox prmtCussTo, ArApQueryParam param) {
        AsstActTypeInfo info;
        if (param.getCussAcctFromId() != null) {
            info = new AsstActTypeInfo();
            info.put("id", (Object)param.getCussAcctFromId());
            info.setNumber(param.getCussAcctFromNum());
            info.setName(param.getCussAcctFromName());
            prmtCussFrom.setValue((Object)info);
        }
        if (param.getCussAcctToId() != null) {
            info = new AsstActTypeInfo();
            info.put("id", (Object)param.getCussAcctToId());
            info.setNumber(param.getCussAcctToNum());
            info.setName(param.getCussAcctToName());
            prmtCussTo.setValue((Object)info);
        }
        ArApQueryUIUtil.loadInfos(ui, prmtCussFrom, param.getCussAcctFromIds());
    }

    public static boolean validDateRange(CoreUIObject ui, KDDatePicker pkDateFrom, KDDatePicker pkDateTo) {
        boolean fDateToNull;
        boolean retVal = true;
        boolean fDateFromNull = pkDateFrom.getValue() == null;
        boolean bl = fDateToNull = pkDateTo.getValue() == null;
        if (fDateFromNull || fDateToNull) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport.bill_date_not_null");
            MsgBox.showWarning((Component)ui, (String)msg);
            if (fDateFromNull && fDateToNull || fDateFromNull || !fDateToNull) {
                pkDateFrom.requestFocus();
            } else if (!fDateFromNull && fDateToNull) {
                pkDateTo.requestFocus();
            }
            retVal = false;
        }
        return retVal;
    }

    public static CompanyOrgUnitCollection getFullPermCompany(IObjectPK userPK, Object[] selectedComps, String permissionItem) throws Exception {
        if (selectedComps == null || selectedComps.length == 0) {
            return null;
        }
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        for (int i = 0; i < selectedComps.length; ++i) {
            CoreBaseInfo orgInfo = (CoreBaseInfo)selectedComps[i];
            ids.add(orgInfo.getId());
        }
        return ArApQueryUIUtil.getFullPermCompany(userPK, ids, permissionItem);
    }

    public static CompanyOrgUnitCollection getFullPermCompany(IObjectPK userPK, Set ids, String permissionItem) throws Exception {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        IPermission iPerm = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection orgs = iPerm.getAuthorizedOrg(userPK, OrgType.Company, (IObjectPK)ORG_FIVIEW_ID, permissionItem);
        HashSet<BOSUuid> withPermIds = new HashSet<BOSUuid>();
        int n = orgs.size();
        for (int i = 0; i < n; ++i) {
            withPermIds.add(orgs.get(i).getId());
        }
        ids.retainAll(withPermIds);
        if (ids == null || ids.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        view.setFilter(filter);
        items.add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("isCU");
        view.getSelector().add("isBizUnit");
        view.getSelector().add("isOnlyUnion");
        view.getSelector().add("cu.id");
        ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getRemoteInstance();
        return iComp.getCompanyOrgUnitCollection(view);
    }

    public static void setBizCompanyData(KDBizPromptBox bizPrompt, String id) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = new CompanyOrgUnitInfo();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)pk);
        bizPrompt.setData((Object)currentCompany);
    }
}

