/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.PermissionService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApReportUIUtil {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil");

    public static void removePermissionService(ItemAction action) {
        Map services = action.getServices();
        ArrayList<IBindService> removeServices = new ArrayList<IBindService>();
        String permClsName = PermissionService.class.getName();
        for (String key : services.keySet()) {
            if (key.indexOf(permClsName) == -1) continue;
            IBindService service = (IBindService)services.get(key);
            removeServices.add(service);
        }
        for (int i = 0; i < removeServices.size(); ++i) {
            action.removeServices((IBindService)removeServices.get(i));
        }
    }

    public static void checkCompanysPrintPermission(CoreUI ui, List qryCompanys, String printPermItem, OrgType mainBizOrgType) {
        if (StringUtils.isEmpty((String)printPermItem) || qryCompanys == null || qryCompanys.size() == 0) {
            return;
        }
        ArrayList companys = new ArrayList();
        companys.addAll(qryCompanys);
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        HashSet<String> authorizedIds = new HashSet<String>();
        String msg = null;
        try {
            FullOrgUnitCollection coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, mainBizOrgType, null, printPermItem);
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                authorizedIds.add(coll.get(i).getId().toString());
            }
            companys.removeAll(authorizedIds);
            if (companys.size() > 0) {
                msg = ArApReportUIUtil.getPrintPermWarningMsg(companys);
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception, getPrintPermission", (Throwable)e);
            ui.handUIException((Throwable)e);
        }
        if (!StringUtils.isEmpty(msg)) {
            MsgBox.showInfo((Component)ui, msg);
            SysUtil.abort();
        }
    }

    private static String getPrintPermWarningMsg(List qryCompanys) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("name");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(qryCompanys), CompareType.INCLUDE));
        view.setFilter(filter);
        ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitCollection companys = iComp.getCompanyOrgUnitCollection(view);
        StringBuffer compsName = new StringBuffer();
        int n = companys.size();
        for (int i = 0; i < n; ++i) {
            compsName.append(companys.get(i).getName());
            compsName.append(i + 1 < n ? ", " : "");
        }
        String msgPattern = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"companysNoPrintPerm");
        String msg = MessageFormat.format(msgPattern, compsName.toString());
        return msg;
    }

    public static String getPrintLogMsg(String uiTitle, boolean fPreview) {
        String pattern = EASResource.getString((String)"com.kingdee.eas.fi.arap.ArApRptResource", (String)(fPreview ? "LogPrintPreview" : "LogPrint"));
        return MessageFormat.format(pattern, uiTitle);
    }

    public static String getSelectedId(KDTable tblMain, String key) {
        if (tblMain.getColumn(key) == null) {
            return null;
        }
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return null;
        }
        int rowInd = selectBlock.getTop();
        String billId = (String)tblMain.getRow(rowInd).getCell(key).getValue();
        return billId;
    }

    public static IRow getSelectedRow(KDTable tblMain) {
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return null;
        }
        int rowInd = selectBlock.getTop();
        return tblMain.getRow(rowInd);
    }

    public static void checkCompany(Component uiComp, CompanyOrgUnitInfo companyInfo) {
        if (companyInfo == null || !companyInfo.isIsBizUnit()) {
            MsgBox.showInfo((Component)uiComp, (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"CompanyIsNull"));
            SysUtil.abort();
        }
    }

    public static String checkSystemIsStart(CompanyOrgUnitInfo company, SystemEnum systemEnum, SystemStatusCtrolInfo sysStatusCtrlInfo) {
        if (null == company) {
            return ArClientUtils.getArStringResource("checkCompanyIsNull");
        }
        if (sysStatusCtrlInfo == null || !sysStatusCtrlInfo.isIsStart()) {
            return ArClientUtils.getArStringResource("CompanyNotStart", company.getName(), systemEnum);
        }
        return "";
    }

    public static StringBuilder getCompanyPeriodInfo(Object[] companys, SystemEnum systemEnum, Map sysStatusCtrlMap) throws BOSException {
        SystemStatusCtrolInfo sysStatusCtrlInfo = null;
        StringBuilder buf = new StringBuilder(1024);
        CompanyOrgUnitInfo company = null;
        String errorMsg = null;
        String periodMsg = null;
        int len = companys.length;
        for (int i = 0; i < len; ++i) {
            company = (CompanyOrgUnitInfo)companys[i];
            sysStatusCtrlInfo = (SystemStatusCtrolInfo)sysStatusCtrlMap.get(String.valueOf(company.getId()) + systemEnum.getValue());
            errorMsg = ArApReportUIUtil.checkSystemIsStart(company, systemEnum, sysStatusCtrlInfo);
            if (!StringUtils.isEmpty((String)errorMsg)) continue;
            periodMsg = sysStatusCtrlInfo.getCurrentPeriod() != null ? sysStatusCtrlInfo.getCurrentPeriod().toString() : ArClientUtils.getArStringResource("notSetCurrentPeriod");
            buf.append(ArClientUtils.getArStringResource("CompanyPeriod", company.getName(), periodMsg)).append("\r\n");
        }
        return buf;
    }
}

