/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client.util;

import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.CAStmtQueryParam;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TablePrintUtil {
    public static final String RES = "com.kingdee.eas.fi.ar.client.ArResource";

    private TablePrintUtil() {
    }

    public static String getRangeDesc(String sFrom, String sTo) {
        String rangeDesc = EASResource.getString((String)RES, (String)"PRNT_Range");
        return MessageFormat.format(rangeDesc, sFrom, sTo);
    }

    public static String getPeriodRangeDesc(int startPeriodYear, int startPeriodNum, int endPeriodYear, int endPeriodNum) {
        String descPattern = EASResource.getString((String)RES, (String)"periodDesc");
        String sFrom = MessageFormat.format(descPattern, String.valueOf(startPeriodYear), String.valueOf(startPeriodNum));
        String sTo = MessageFormat.format(descPattern, String.valueOf(endPeriodYear), String.valueOf(endPeriodNum));
        return TablePrintUtil.getRangeDesc(sFrom, sTo);
    }

    public static String getDateRangeDesc(Date startDate, Date endDate) {
        DateFormat format = TablePrintUtil.getDateFormat();
        String sFrom = format.format(startDate);
        String sTo = format.format(endDate);
        return TablePrintUtil.getRangeDesc(sFrom, sTo);
    }

    public static DateFormat getDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format;
    }

    public static String getAsstActRangeDesc(ArApQueryParam param) {
        return TablePrintUtil.getInfoRangeDesc(param.getCussAcctFromNum(), param.getCussAcctToNum(), param.getCussAcctFromName(), param.getCussAcctToName());
    }

    public static String getAdminRangeDesc(CAStmtQueryParam param) {
        return TablePrintUtil.getInfoRangeDesc(param.getAdminOrgFromNum(), param.getAdminOrgToNum(), param.getAdminOrgFromName(), param.getAdminOrgToName());
    }

    public static String getInfoRangeDesc(String fromNum, String toNum, String fromName, String toName) {
        String infoRange = "";
        if (StringUtils.isEmpty((String)fromNum) && StringUtils.isEmpty((String)toNum)) {
            infoRange = EASResource.getString((String)RES, (String)"PRNT_All");
        } else {
            String sFrom = StringUtils.isEmpty((String)fromNum) ? " " : fromNum + " " + fromName;
            String sTo = StringUtils.isEmpty((String)toNum) ? " " : toNum + " " + toName;
            infoRange = TablePrintUtil.getRangeDesc(sFrom, sTo);
        }
        return infoRange;
    }

    public static String getAsstActMutilSelectedDesc(Object[] asstActs) {
        if (asstActs == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < asstActs.length; ++i) {
            if (!(asstActs[i] instanceof DataBaseInfo)) continue;
            DataBaseInfo asstActInfo = (DataBaseInfo)asstActs[i];
            sb.append(asstActInfo.getNumber());
            sb.append(" ");
            sb.append(asstActInfo.getName());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

