/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.client.BOTMappingSelectUI;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.IInvoiceMatchFacade;
import com.kingdee.eas.fi.arap.invoiceMatch.IMRecordSrcSystemEnum;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchFacadeFactory;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordCollection;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordEntryCollection;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordEntryInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.MatchBillConfigFactory;
import com.kingdee.eas.fi.arap.invoiceMatch.MatchBillConfigInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.MatchBillConfigType;
import com.kingdee.eas.fi.arap.invoiceMatch.client.AbstractInvoiceMatchUI;
import com.kingdee.eas.fi.arap.invoiceMatch.config.AbstractConfigHelper;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceClientUtils;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InvoiceMatchUI
extends AbstractInvoiceMatchUI {
    private static final Logger logger = CoreUIObject.getLogger(InvoiceMatchUI.class);
    private static final String BOTPUI = "com.kingdee.eas.base.botp.client.BOTMappingSelectUI";
    private static final String NUMFORMAT = "###,##0.##########";
    private static final Color EDITCOLOR = new Color(246, 246, 191);
    private static boolean isSupport = false;
    private static HashMap<String, ArrayList> stepMap = new HashMap();
    private static int stepSeq = 0;
    private static HashSet completelyMatch = new HashSet();
    private BOTMappingCollection botMappingColl = null;
    private IInvoiceMatchFacade instance;
    private AbstractConfigHelper bizConfigHelper = null;
    private AbstractConfigHelper invoiceConfigHelper = null;
    private AbstractConfigHelper recordConfigHelper = null;
    private KDTEditAdapter upAndDownTableChange = null;
    private KDTEditAdapter rightTableChange = null;
    private KDTSelectListener tableSelectChanged = null;
    private DataChangeListener prmtMatchBillConfigChange = null;
    private DataChangeListener prmtBotpChange = null;
    private SelectorListener prmtBotpSelectorListener = null;
    private CommonQueryDialog upDialog = null;
    private CommonQueryDialog downDialog = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.contUp.setContainerType(1);
        this.contDown.setContainerType(1);
        this.contRight.setContainerType(1);
        this.menuItemRefresh.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.chkIsCompletely.setVisible(false);
        this.menuView.setVisible(false);
    }

    private void removeListener() {
        if (this.upAndDownTableChange != null) {
            this.kdtUp.removeKDTEditListener((KDTEditListener)this.upAndDownTableChange);
            this.kdtDown.removeKDTEditListener((KDTEditListener)this.upAndDownTableChange);
        }
        if (this.rightTableChange != null) {
            this.kdtRight.removeKDTEditListener((KDTEditListener)this.rightTableChange);
        }
        if (this.tableSelectChanged != null) {
            this.kdtUp.removeKDTSelectListener(this.tableSelectChanged);
            this.kdtDown.removeKDTSelectListener(this.tableSelectChanged);
        }
        if (this.prmtMatchBillConfigChange != null) {
            this.prmtMatchBillConfig.removeDataChangeListener(this.prmtMatchBillConfigChange);
        }
        if (this.prmtBotpChange == null) {
            this.prmtBotp.removeDataChangeListener(this.prmtBotpChange);
        }
        if (this.prmtBotpSelectorListener != null) {
            this.prmtBotp.removeSelectorListener(this.prmtBotpSelectorListener);
        }
    }

    public void onLoad() throws Exception {
        this.removeListener();
        this.btnSetBotpID.setVisible(false);
        super.onLoad();
        this.instance = (IInvoiceMatchFacade)this.getRemoteInstance();
        this.initConfig();
        isSupport = IncomeInvoiceClientUtils.isSupport();
        IMainUIObject mainUI = this.getMainUIObject();
        this.kDSplitPane1.setDividerLocation((int)((double)mainUI.getBodyUI().getWidth() * 0.66));
        this.contUp.setTitle(this.bizConfigHelper.getConfig().getSrcBillName());
        this.btnQueryUp.setText(this.bizConfigHelper.getConfig().getSrcBillName() + this.getResource("Title_Query"));
        this.contDown.setTitle(this.invoiceConfigHelper.getConfig().getSrcBillName());
        this.btnQueryDown.setText(this.invoiceConfigHelper.getConfig().getSrcBillName() + this.getResource("Title_Query"));
        this.contRight.setTitle(this.recordConfigHelper.getConfig().getSrcBillName());
        this.initBotp();
        this.initTable(this.kdtUp);
        this.initTable(this.kdtDown);
        this.initTable(this.kdtRight);
        this.initListeners();
    }

    private void checkIsSupport() {
        if (!isSupport) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"LackTaxSupport"));
            this.abort();
        }
    }

    protected void initConfig() throws BOSException, EASBizException {
        Map result = MatchBillConfigFactory.getRemoteInstance().getDefaultConfig();
        MatchBillConfigInfo bizConfig = (MatchBillConfigInfo)result.get((Object)MatchBillConfigType.BIZ);
        MatchBillConfigInfo invoiceConfig = (MatchBillConfigInfo)result.get((Object)MatchBillConfigType.INVOICE);
        MatchBillConfigInfo recordConfig = (MatchBillConfigInfo)result.get((Object)MatchBillConfigType.RECORD);
        this.prmtMatchBillConfig.setValue((Object)bizConfig);
        if (this.params == null) {
            this.params = new RptParams();
        }
        this.bizConfigHelper = (AbstractConfigHelper)result.get(bizConfig.getId().toString());
        this.invoiceConfigHelper = (AbstractConfigHelper)result.get(invoiceConfig.getId().toString());
        this.invoiceConfigHelper.getOtherParams().put(MatchConstant.BIZDESTBOSTYPE, this.bizConfigHelper.getConfig().getDestBosType());
        this.recordConfigHelper = (AbstractConfigHelper)result.get(recordConfig.getId().toString());
    }

    protected void initTable(KDTable table) throws EASBizException, BOSException {
        table.removeHeadRows();
        table.removeColumns();
        table.checkParsed();
        table.getActionMap().remove("Paste");
        table.getActionMap().remove("Delete");
        table.getViewManager().setFreezeView(0, 1);
        AbstractConfigHelper configHelper = this.getHelperByTable(table);
        KDTableUtil.setHeader((RptTableHeader)configHelper.getTableHeader(), (KDTable)table);
        table.setColumnMoveable(true);
        KDTSortManager sort = new KDTSortManager(table);
        sort.setSortAuto(true);
        sort.setEnableSortable(true);
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setPrecision(4);
        formattedField.setRemoveingZeroInEdit(true);
        formattedField.setRemoveingZeroInDispaly(true);
        formattedField.setHorizontalAlignment(4);
        KDTDefaultCellEditor amtEditor = new KDTDefaultCellEditor((JTextField)formattedField);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            String fieldName = table.getColumn(i).getKey();
            if (MatchConstant.TB_FSELECTED.contains(fieldName)) {
                table.getColumn(i).getStyleAttributes().setLocked(false);
            } else if (this.kdtRight != table && (MatchConstant.TB_FQTYTOMATCH.equals(fieldName) || MatchConstant.TB_FAMTTOMATCH.equals(fieldName))) {
                table.getColumn(i).getStyleAttributes().setLocked(false);
                table.getColumn(i).getStyleAttributes().setBackground(EDITCOLOR);
                table.getColumn(i).setEditor((ICellEditor)amtEditor);
                table.getColumn(i).getStyleAttributes().setNumberFormat(NUMFORMAT);
            } else {
                if (MatchConstant.TB_FQTY.equals(fieldName) || MatchConstant.TB_FTaxPrice.equals(fieldName) || MatchConstant.TB_FTaxAmount.equals(fieldName) || MatchConstant.TB_FUNMATCHEDQTY.equals(fieldName) || "FTaxExcluded".equals(fieldName) || "FMoney".equals(fieldName) || "FTaxAmt".equals(fieldName) || "FTaxTotal".equals(fieldName) || MatchConstant.TB_FUNMATCHEDQTY.equals(fieldName) || MatchConstant.TB_FUNMATCHEDAMT.equals(fieldName) || MatchConstant.TB_FQTYTOMATCH.equals(fieldName) || MatchConstant.TB_FAMTTOMATCH.equals(fieldName) || MatchConstant.TB_FTaxPrice.equals(fieldName)) {
                    table.getColumn(i).getStyleAttributes().setNumberFormat(NUMFORMAT);
                }
                table.getColumn(i).getStyleAttributes().setLocked(true);
            }
            table.getColumn(i).setSortable(true);
        }
        this.kdtUp.setName(configHelper.getConfig().getSrcBosType());
        this.initUserConfig();
        this.appendFootRow(table, configHelper.getSumFields());
    }

    private void appendFootRow(KDTable table, String[] sumFields) {
        if (sumFields == null || sumFields.length == 0) {
            return;
        }
        IRow footRow = null;
        KDTFootManager footRowManager = table.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(table);
            footRowManager.addFootView();
            table.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            table.getIndexColumn().setWidthAdjustMode((short)1);
            table.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            footRow = footRowManager.getFootRow(0);
        }
        int columnCount = table.getColumnCount();
        for (int c = 0; c < columnCount; ++c) {
            String fieldName = table.getColumn(c).getKey();
            for (int i = 0; i < sumFields.length; ++i) {
                String name = sumFields[i];
                if (!name.equalsIgnoreCase(fieldName)) continue;
                ICell cell = footRow.getCell(c);
                cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                cell.getStyleAttributes().setFontColor(Color.BLACK);
                cell.setValue((Object)BigDecimal.ZERO);
            }
        }
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
    }

    private void initListeners() {
        if (this.upAndDownTableChange == null) {
            this.upAndDownTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    KDTable table = (KDTable)e.getSource();
                    String columnKey = table.getColumnKey(e.getColIndex());
                    IRow row = table.getRow(e.getRowIndex());
                    BigDecimal matchedQty = InvoiceMatchUI.this.getBigDecimal(row, MatchConstant.TB_FQTYTOMATCH);
                    BigDecimal matchedAmt = InvoiceMatchUI.this.getBigDecimal(row, MatchConstant.TB_FAMTTOMATCH);
                    if (MatchConstant.TB_FQTYTOMATCH.equals(columnKey)) {
                        if (matchedQty.signum() == 0 || matchedQty.signum() != matchedAmt.signum()) {
                            row.getCell(MatchConstant.TB_FQTYTOMATCH).setValue(e.getOldValue());
                            MsgBox.showInfo((String)InvoiceMatchUI.this.getResource("Error_EditQty", null));
                            return;
                        }
                    } else if (MatchConstant.TB_FAMTTOMATCH.equals(columnKey) && (matchedAmt.signum() == 0 || matchedAmt.signum() != new BigDecimal(e.getOldValue().toString()).signum())) {
                        row.getCell(MatchConstant.TB_FAMTTOMATCH).setValue(e.getOldValue());
                        MsgBox.showInfo((String)InvoiceMatchUI.this.getResource("Error_EditAmt", null));
                        return;
                    }
                    InvoiceMatchUI.this.doSumFields(table);
                }

                public void editValueChanged(KDTEditEvent e) {
                    KDTable table = (KDTable)e.getSource();
                    if (MatchConstant.TB_FSELECTED.equals(table.getColumnKey(e.getColIndex()))) {
                        table.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getValue());
                        InvoiceMatchUI.this.doSumFields(table);
                    }
                }
            };
        }
        this.kdtUp.addKDTEditListener((KDTEditListener)this.upAndDownTableChange);
        this.kdtDown.addKDTEditListener((KDTEditListener)this.upAndDownTableChange);
        if (this.tableSelectChanged == null) {
            this.tableSelectChanged = new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    KDTSelectBlock selectBlock = e.getSelectBlock();
                    KDTable table = (KDTable)e.getSource();
                    int selectCol = table.getColumnIndex(MatchConstant.TB_FSELECTED);
                    IRow iRow = null;
                    boolean isSelectedChange = false;
                    int size = table.getSelectManager().size();
                    for (int i = 0; i < size; ++i) {
                        selectBlock = table.getSelectManager().get(i);
                        int length = selectBlock.getBottom();
                        for (int j = selectBlock.getTop(); j <= length; ++j) {
                            iRow = table.getRow(j);
                            if (iRow == null) continue;
                            boolean isSelected = Boolean.TRUE.equals(iRow.getCell(MatchConstant.TB_FSELECTED).getValue());
                            int selectBeginCol = selectBlock.getBeginCol();
                            int selectEndCol = selectBlock.getEndCol();
                            int selectBiginRow = selectBlock.getBeginRow();
                            int selectEndRow = selectBlock.getEndRow();
                            if (selectCol != selectBeginCol || selectBeginCol != selectEndCol || selectBeginCol == -1 || selectBiginRow == selectEndRow) continue;
                            iRow.getCell(MatchConstant.TB_FSELECTED).setValue((Object)(!isSelected ? 1 : 0));
                            isSelectedChange = true;
                        }
                    }
                    if (isSelectedChange) {
                        InvoiceMatchUI.this.doSumFields(table);
                    }
                }
            };
        }
        this.kdtUp.addKDTSelectListener(this.tableSelectChanged);
        this.kdtDown.addKDTSelectListener(this.tableSelectChanged);
        if (this.rightTableChange == null) {
            this.rightTableChange = new KDTEditAdapter(){

                public void editValueChanged(KDTEditEvent e) {
                    KDTable table = (KDTable)e.getSource();
                    if (MatchConstant.TB_FSELECTED.equals(table.getColumnKey(e.getColIndex()))) {
                        IRow row = table.getRow(e.getRowIndex());
                        Integer step = Integer.valueOf(row.getCell(MatchConstant.TB_FSTEPSEQ).getValue().toString());
                        String companyId = row.getCell(MatchConstant.TB_FCOMPANYID).getValue().toString();
                        String supplierId = row.getCell(MatchConstant.TB_FSUPPLIERID).getValue().toString();
                        boolean isSelected = Boolean.TRUE.equals(row.getCell(MatchConstant.TB_FSELECTED).getValue());
                        Integer rowStep = -1;
                        String comId = "";
                        String supId = "";
                        for (int i = 0; i < table.getRowCount3(); ++i) {
                            rowStep = Integer.valueOf(table.getCell(i, MatchConstant.TB_FSTEPSEQ).getValue().toString());
                            comId = table.getCell(i, MatchConstant.TB_FCOMPANYID).getValue().toString();
                            supId = table.getCell(i, MatchConstant.TB_FSUPPLIERID).getValue().toString();
                            if (step != rowStep || !companyId.equals(comId) || !supplierId.equals(supId)) continue;
                            table.getCell(i, e.getColIndex()).setValue((Object)(!isSelected ? 1 : 0));
                        }
                        table.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getValue());
                    }
                }
            };
        }
        this.kdtRight.addKDTEditListener((KDTEditListener)this.rightTableChange);
        if (this.prmtMatchBillConfigChange == null) {
            this.prmtMatchBillConfigChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        if (e.getNewValue() == null) {
                            InvoiceMatchUI.this.prmtMatchBillConfig.setValue(e.getOldValue());
                            return;
                        }
                        InvoiceMatchUI.this.cleanRecordComfirm();
                        MatchBillConfigInfo bizConfig = (MatchBillConfigInfo)e.getNewValue();
                        HashSet<String> ids = new HashSet<String>();
                        ids.add(bizConfig.getId().toString());
                        Map configHelper = MatchBillConfigFactory.getRemoteInstance().getConfigHelper(ids);
                        InvoiceMatchUI.this.bizConfigHelper = (AbstractConfigHelper)configHelper.get(bizConfig.getId().toString());
                        InvoiceMatchUI.this.invoiceConfigHelper.getOtherParams().put(MatchConstant.BIZDESTBOSTYPE, InvoiceMatchUI.this.bizConfigHelper.getConfig().getDestBosType());
                        InvoiceMatchUI.this.initTable(InvoiceMatchUI.this.kdtUp);
                        InvoiceMatchUI.this.kdtUp.removeRows(false);
                        InvoiceMatchUI.this.kdtDown.removeRows(false);
                        InvoiceMatchUI.this.contUp.setTitle(InvoiceMatchUI.this.bizConfigHelper.getConfig().getSrcBillName());
                        InvoiceMatchUI.this.btnQueryUp.setText(InvoiceMatchUI.this.bizConfigHelper.getConfig().getSrcBillName() + InvoiceMatchUI.this.getResource("Title_Query"));
                        InvoiceMatchUI.this.initBotp();
                    }
                    catch (Exception ex) {
                        InvoiceMatchUI.this.prmtMatchBillConfig.setValue(e.getOldValue());
                        InvoiceMatchUI.this.handleException(ex);
                    }
                }
            };
        }
        this.prmtMatchBillConfig.addDataChangeListener(this.prmtMatchBillConfigChange);
        if (this.prmtBotpChange == null) {
            this.prmtBotpChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        if (e.getNewValue() == null) {
                            InvoiceMatchUI.this.prmtBotp.setValue(e.getOldValue());
                            return;
                        }
                    }
                    catch (Exception ex) {
                        InvoiceMatchUI.this.handleException(ex);
                    }
                }
            };
        }
        this.prmtBotp.addDataChangeListener(this.prmtBotpChange);
        if (this.prmtBotpSelectorListener == null) {
            this.prmtBotpSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        HashMap<String, Object> uiContext = new HashMap<String, Object>();
                        uiContext.put("isMultiDAPTrans", false);
                        uiContext.put("Owner", this);
                        uiContext.put("BOTMappings", InvoiceMatchUI.this.botMappingColl);
                        IUIWindow mappingSelecteWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvoiceMatchUI.BOTPUI, uiContext, null);
                        mappingSelecteWindow.show();
                        if (((BOTMappingSelectUI)mappingSelecteWindow.getUIObject()).isCanceled() || ((BOTMappingSelectUI)mappingSelecteWindow.getUIObject()).getSelectBotMappingInfo() == null) {
                            return;
                        }
                        BOTMappingInfo info = ((BOTMappingSelectUI)mappingSelecteWindow.getUIObject()).getSelectBotMappingInfo();
                        InvoiceMatchUI.this.prmtBotp.setValue((Object)info);
                        InvoiceMatchUI.this.bizConfigHelper.setBotpID(info.getId().toString());
                    }
                    catch (UIException err) {
                        InvoiceMatchUI.this.handleException((Exception)((Object)err));
                    }
                }
            };
        }
        this.prmtBotp.addSelectorListener(this.prmtBotpSelectorListener);
    }

    private void initBotp() throws EASBizException, BOSException {
        IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
        SelectorItemCollection botpSelectors = new SelectorItemCollection();
        botpSelectors.add("*");
        botpSelectors.add("rules.ruleSegments.*");
        MatchBillConfigInfo config = this.bizConfigHelper.getConfig();
        this.botMappingColl = iBOTMapping.getMappingCollectionForSelectUseRuleFilter(config.getSrcBosType(), config.getDestBosType(), DefineSysEnum.BTP, null, null, this.bizConfigHelper.getEntrieNames(), new ArrayList(), botpSelectors);
        if (this.botMappingColl == null || this.botMappingColl.size() == 0) {
            throw new BTPException(BTPException.GETMAPPINGINFOERROR);
        }
        HashMap<String, BOTMappingInfo> botpIDMap = new HashMap<String, BOTMappingInfo>();
        for (int i = 0; i < this.botMappingColl.size(); ++i) {
            botpIDMap.put(this.botMappingColl.get(i).getId().toString(), this.botMappingColl.get(i));
        }
        BOTMappingInfo mappingInfo = this.botMappingColl.get(0);
        if (this.bizConfigHelper.getConfig().getBotpID() != null && botpIDMap.containsKey(this.bizConfigHelper.getConfig().getBotpID())) {
            mappingInfo = (BOTMappingInfo)botpIDMap.get(this.bizConfigHelper.getConfig().getBotpID());
        }
        this.prmtBotp.setValue((Object)mappingInfo);
        this.bizConfigHelper.setBotpID(mappingInfo.getId().toString());
    }

    @Override
    public void actionSetBotpID_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsSupport();
        if (this.prmtBotp.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("BOTP_ISNULL"));
            return;
        }
        BOTMappingInfo mappingInfo = (BOTMappingInfo)this.prmtBotp.getValue();
        InvoiceMatchFacadeFactory.getRemoteInstance().updateConfigBotp(this.bizConfigHelper.getConfig().getId().toString(), mappingInfo.getId().toString());
    }

    public boolean destroyWindow() {
        try {
            this.actionSetBotpID_actionPerformed(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return super.destroyWindow();
    }

    @Override
    public void actionQueryUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsSupport();
        this.params.setObject(MatchConstant.CONFIGHELPER, (Object)this.bizConfigHelper);
        this.params.setObject(MatchConstant.QUERYTYPE, (Object)MatchConstant.KDTUP);
        this.cleanRecordComfirm();
        this.showQueryDialog(false);
    }

    @Override
    public void actionQueryDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsSupport();
        this.params.setObject(MatchConstant.CONFIGHELPER, (Object)this.invoiceConfigHelper);
        this.params.setObject(MatchConstant.QUERYTYPE, (Object)MatchConstant.KDTDOWN);
        this.cleanRecordComfirm();
        this.showQueryDialog(false);
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            if (this.params == null) {
                this.params = new RptParams();
                return true;
            }
            AbstractConfigHelper helper = (AbstractConfigHelper)this.params.getObject(MatchConstant.CONFIGHELPER);
            if (helper == null) {
                return true;
            }
            CommonQueryDialog dialog = null;
            if (this.params.getString(MatchConstant.QUERYTYPE).equals(MatchConstant.KDTUP)) {
                if (this.upDialog == null) {
                    this.upDialog = this.initQueryDialog(helper);
                }
                dialog = this.upDialog;
            } else if (this.params.getString(MatchConstant.QUERYTYPE).equals(MatchConstant.KDTDOWN)) {
                if (this.downDialog == null) {
                    this.downDialog = this.initQueryDialog(helper);
                }
                dialog = this.downDialog;
            }
            CustomerParams cp = new CustomerParams();
            if (useDefaultSolution) {
                QuerySolutionInfo solution;
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = this.getQueryMetaDataPK().getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName) && (solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName)).getQueryPanelInfo().get(0) != null && solution.getQueryPanelInfo().get(0).getCustomerParams() != null) {
                    try {
                        String customerParams = solution.getQueryPanelInfo().get(0).getCustomerParams();
                        if (customerParams != null) {
                            ArrayList al = new ArrayList();
                            al = XMLBean.TransStrToAL((String)customerParams);
                            Iterator j = al.iterator();
                            XMLBean xb = new XMLBean();
                            while (j.hasNext()) {
                                xb = (XMLBean)j.next();
                                cp.addCustomerParam(xb.getName(), xb.getValue());
                            }
                        }
                        this.params = new RptParams();
                        this.params.putAll((Map)cp.getCustomerParamsHashMap());
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        this.handUIExceptionAndAbort(e);
                    }
                }
            }
            if (dialog == null || !dialog.show()) {
                return false;
            }
            CommRptBaseConditionUI panel = (CommRptBaseConditionUI)dialog.getUserPanel(0);
            RptParams customCondition = panel.getCustomCondition();
            helper.setCondition(customCondition);
            this.params.setObject(MatchConstant.CONFIGHELPER, (Object)helper);
            this.params = this.instance.createTempTable(this.params);
            this.query();
            return true;
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
            return false;
        }
    }

    public CommonQueryDialog initQueryDialog(AbstractConfigHelper helper) throws Exception {
        CommonQueryDialog dialog = new CommonQueryDialog();
        String customerPanel = helper.getCustomerPanel();
        CustomerQueryPanel panel = (CustomerQueryPanel)Class.forName(customerPanel).newInstance();
        panel.setUITitle(helper.getConfig().getSrcBillName() + this.getResource("Title_Query"));
        panel.loadFields();
        panel.initLayout();
        dialog.setQueryObjectPK(helper.getQueryMetaDataPK());
        dialog.clearUserPanels();
        dialog.addUserPanel((KDPanel)panel);
        dialog.setHeight(panel.getHeight() + 30);
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.setTitle(panel.getUITitle());
        dialog.setShowDefaultSolution(true);
        dialog.setDisShowRowCount(true);
        dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        return dialog;
    }

    protected void query() {
        try {
            this.params = this.instance.query(this.params);
            AbstractConfigHelper helper = (AbstractConfigHelper)this.params.getObject(MatchConstant.CONFIGHELPER);
            RptRowSet rowSet = helper.getRowSet();
            if (MatchConstant.KDTUP.equals(this.params.getString(MatchConstant.QUERYTYPE))) {
                this.insertRows(rowSet, 0, this.kdtUp);
            } else if (MatchConstant.KDTDOWN.equals(this.params.getString(MatchConstant.QUERYTYPE))) {
                this.insertRows(rowSet, 0, this.kdtDown);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void insertRows(RptRowSet rs, int start, KDTable table) throws Exception {
        int i;
        table.removeRows();
        int count = 0;
        IRow row = null;
        Object obj = null;
        HashMap<String, Integer> columnIndex = new HashMap<String, Integer>();
        int len = table.getColumnCount();
        for (i = 0; i < len; ++i) {
            columnIndex.put(table.getColumn(i).getKey().toUpperCase(Locale.ENGLISH), i);
        }
        table.setRefresh(false);
        while (rs.next()) {
            row = table.addRow(start++);
            len = rs.getColumnCount();
            for (i = 0; i < len; ++i) {
                obj = rs.getObject(i);
                if (columnIndex.get(rs.getColumnName(i).toUpperCase(Locale.ENGLISH)) == null) continue;
                row.getCell(((Integer)columnIndex.get(rs.getColumnName(i).toUpperCase(Locale.ENGLISH))).intValue()).setValue(obj);
            }
            row.getCell(MatchConstant.TB_FSELECTED).setValue((Object)Boolean.FALSE);
            ++count;
        }
        AbstractConfigHelper helper = (AbstractConfigHelper)this.params.getObject(MatchConstant.CONFIGHELPER);
        Map enumFields = helper.getEnumFields();
        for (Object key : enumFields.keySet()) {
            Object cellValue;
            int i2;
            Method getEnumMethod;
            String enumName = (String)enumFields.get(key);
            int cellIndex = (Integer)columnIndex.get(((String)key).toUpperCase(Locale.ENGLISH));
            Class<?> enumClazz = Class.forName(enumName);
            if (enumClazz.getSuperclass().getName().equals("com.kingdee.util.enums.IntEnum")) {
                getEnumMethod = enumClazz.getMethod("getEnum", Integer.TYPE);
                for (i2 = 0; i2 < table.getRowCount(); ++i2) {
                    cellValue = Integer.parseInt((String)table.getCell(i2, cellIndex).getValue());
                    table.getCell(i2, cellIndex).setValue(getEnumMethod.invoke(null, cellValue));
                }
                continue;
            }
            getEnumMethod = enumClazz.getMethod("getEnum", String.class);
            for (i2 = 0; i2 < table.getRowCount(); ++i2) {
                cellValue = table.getCell(i2, cellIndex).getValue();
                table.getCell(i2, cellIndex).setValue(getEnumMethod.invoke(null, cellValue));
            }
        }
        table.setRefresh(true);
        if (count > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
        this.doSumFields(table);
    }

    @Override
    public void actionMoveRight_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsSupport();
        ArrayList supplierList = this.doMatchCheck();
        ++stepSeq;
        this.moveTableRow(this.kdtUp, this.kdtRight, this.bizConfigHelper.getConfig().getSrcBosType(), this.bizConfigHelper.getConfig().getSrcBillName(), supplierList);
        this.moveTableRow(this.kdtDown, this.kdtRight, this.invoiceConfigHelper.getConfig().getSrcBosType(), this.invoiceConfigHelper.getConfig().getSrcBillName(), supplierList);
        this.checkRows(this.kdtRight, false);
    }

    private ArrayList doMatchCheck() {
        int result;
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> billAmt = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> invoiceAmt = new HashMap<String, BigDecimal>();
        HashMap<String, Set<BigDecimal>> upTaxRate = new HashMap<String, Set<BigDecimal>>();
        HashMap<String, Set<BigDecimal>> downTaxRate = new HashMap<String, Set<BigDecimal>>();
        ArrayList<Object> invalidList = new ArrayList<Object>();
        ArrayList<String> warnidList = new ArrayList<String>();
        this.calculateAmt(aliasMap, billAmt, this.kdtUp);
        this.calculateAmt(aliasMap, invoiceAmt, this.kdtDown);
        this.countTaxRate(upTaxRate, this.kdtUp);
        this.countTaxRate(downTaxRate, this.kdtDown);
        StringBuffer error = new StringBuffer();
        for (Object key : billAmt.keySet()) {
            if (!invoiceAmt.containsKey(key)) {
                error.append(this.getResource("Error_NoInvoice", new Object[]{aliasMap.get(key)})).append("\r\n");
                invalidList.add(key);
            } else if (((BigDecimal)billAmt.get(key)).compareTo((BigDecimal)invoiceAmt.get(key)) != 0) {
                error.append(this.getResource("Error_AmtNotEquals", new Object[]{aliasMap.get(key)})).append("\r\n");
                invalidList.add(key);
            }
            if (!this.chkIsCompletely.isSelected()) continue;
            completelyMatch.add(key);
        }
        for (Object key : invoiceAmt.keySet()) {
            if (billAmt.containsKey(key)) continue;
            error.append(this.getResource("Error_NoBill", new Object[]{aliasMap.get(key)})).append("\r\n");
            invalidList.add(key);
        }
        if (error.length() > 0) {
            MsgBox.showInfo((String)error.toString());
        }
        StringBuffer warn = new StringBuffer();
        for (String key : upTaxRate.keySet()) {
            Set upTaxRateSet = (Set)upTaxRate.get(key);
            Set downTaxRateSet = (Set)downTaxRate.get(key);
            if (upTaxRateSet == null || downTaxRateSet == null) continue;
            upTaxRateSet.addAll(downTaxRateSet);
            if (upTaxRateSet.size() == 1 || invalidList.contains(key)) continue;
            warn.append((String)aliasMap.get(key) + this.getResource("TAXRATE_IS_DIFF")).append("\r\n");
            warnidList.add(key);
        }
        if (warn.length() > 0 && (result = MsgBox.showConfirm2((String)warn.toString())) != 0) {
            invalidList.addAll(warnidList);
        }
        return invalidList;
    }

    private void countTaxRate(Map<String, Set<BigDecimal>> taxRateMap, KDTable table) {
        int count = table.getRowCount3();
        for (int i = 0; i < count; ++i) {
            IRow row;
            if (!((Boolean)table.getCell(i, MatchConstant.TB_FSELECTED).getValue()).booleanValue() || (row = table.getRow(i)).getStyleAttributes().isHided()) continue;
            String key = row.getCell(MatchConstant.TB_FCOMPANYID).getValue().toString() + row.getCell(MatchConstant.TB_FSUPPLIERID).getValue().toString();
            Set<Object> taxRateSet = new HashSet();
            if (taxRateMap.containsKey(key)) {
                taxRateSet = taxRateMap.get(key);
            } else {
                taxRateSet = new HashSet();
                taxRateMap.put(key, taxRateSet);
            }
            BigDecimal taxRate = this.getBigDecimal(row, MatchConstant.TB_FTaxRate);
            taxRateSet.add(taxRate);
        }
    }

    private void calculateAmt(Map<String, String> supplierMap, Map<String, BigDecimal> amtMap, KDTable table) {
        int count = table.getRowCount3();
        for (int i = 0; i < count; ++i) {
            BigDecimal newAmt;
            IRow row;
            if (!((Boolean)table.getCell(i, MatchConstant.TB_FSELECTED).getValue()).booleanValue() || (row = table.getRow(i)).getStyleAttributes().isHided()) continue;
            String key = row.getCell(MatchConstant.TB_FCOMPANYID).getValue().toString() + row.getCell(MatchConstant.TB_FSUPPLIERID).getValue().toString();
            if (amtMap.containsKey(key)) {
                newAmt = amtMap.get(key);
            } else {
                newAmt = BigDecimal.ZERO;
                amtMap.put(key, newAmt);
                supplierMap.put(key, this.getGroupAlias(row));
            }
            amtMap.put(key, newAmt.add(this.getBigDecimal(row, MatchConstant.TB_FAMTTOMATCH)));
        }
    }

    private void moveTableRow(KDTable tableFrom, KDTable tableTo, String billBosType, String billName, ArrayList invalidList) {
        int count = tableFrom.getRowCount3();
        for (int i = 0; i < count; ++i) {
            IRow row;
            String key;
            if (!((Boolean)tableFrom.getCell(i, MatchConstant.TB_FSELECTED).getValue()).booleanValue() || invalidList.contains(key = (row = tableFrom.getRow(i)).getCell(MatchConstant.TB_FCOMPANYID).getValue().toString() + row.getCell(MatchConstant.TB_FSUPPLIERID).getValue().toString()) || row.getStyleAttributes().isHided()) continue;
            IRow toRow = tableTo.addRow();
            for (int j = 0; j < tableTo.getColumnCount(); ++j) {
                String colKey = tableTo.getColumnKey(j);
                if (row.getCell(colKey) == null) continue;
                toRow.getCell(colKey).setValue(row.getCell(colKey).getValue());
            }
            toRow.getCell(MatchConstant.TB_FBILLNAME).setValue((Object)billName);
            toRow.getCell(MatchConstant.TB_FSTEPSEQ).setValue((Object)stepSeq);
            if (stepMap.containsKey(key)) {
                if (!stepMap.get(key).contains(stepSeq)) {
                    stepMap.get(key).add(stepSeq);
                }
            } else {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(stepSeq);
                stepMap.put(key, list);
            }
            toRow.getCell(MatchConstant.TB_FBILLBOSTYPE).setValue((Object)billBosType);
            BigDecimal unMatchedAmt = this.getBigDecimal(row, MatchConstant.TB_FUNMATCHEDAMT).subtract(this.getBigDecimal(toRow, MatchConstant.TB_FAMTTOMATCH));
            BigDecimal unMatchedQty = this.getBigDecimal(row, MatchConstant.TB_FUNMATCHEDQTY).subtract(this.getBigDecimal(toRow, MatchConstant.TB_FQTYTOMATCH));
            row.getCell(MatchConstant.TB_FUNMATCHEDQTY).setValue((Object)unMatchedQty);
            row.getCell(MatchConstant.TB_FQTYTOMATCH).setValue((Object)unMatchedQty);
            row.getCell(MatchConstant.TB_FUNMATCHEDAMT).setValue((Object)unMatchedAmt);
            row.getCell(MatchConstant.TB_FAMTTOMATCH).setValue((Object)unMatchedAmt);
            if (this.kdtUp == tableFrom) {
                if (MatchConstant.CONFIG_PO_PQ_PREPAY.equals(this.bizConfigHelper.getConfig().getId().toString())) {
                    if (unMatchedAmt.compareTo(BigDecimal.ZERO) == 0) {
                        row.getStyleAttributes().setHided(true);
                    }
                } else if (unMatchedQty.compareTo(BigDecimal.ZERO) == 0) {
                    row.getStyleAttributes().setHided(true);
                }
            } else if (unMatchedAmt.compareTo(BigDecimal.ZERO) == 0) {
                row.getStyleAttributes().setHided(true);
            }
            row.getCell(MatchConstant.TB_FSELECTED).setValue((Object)false);
        }
        this.doSumFields(tableFrom);
    }

    @Override
    public void actionMoveLeft_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsSupport();
        this.removeRightRows();
    }

    private void removeRightRows() {
        int i;
        ArrayList<Integer> rowId = new ArrayList<Integer>();
        int count = this.kdtRight.getRowCount3();
        for (i = 0; i < count; ++i) {
            if (!((Boolean)this.kdtRight.getCell(i, MatchConstant.TB_FSELECTED).getValue()).booleanValue()) continue;
            rowId.add(i);
            IRow row = this.kdtRight.getRow(i);
            IRow toRow = this.getSrcRow(row);
            String companyId = row.getCell(MatchConstant.TB_FCOMPANYID).getValue().toString();
            String supplierId = row.getCell(MatchConstant.TB_FSUPPLIERID).getValue().toString();
            String key = companyId + supplierId;
            stepMap.get(key).remove(Integer.valueOf(row.getCell(MatchConstant.TB_FSTEPSEQ).getValue().toString()));
            BigDecimal unMatchedQty = this.getBigDecimal(toRow, MatchConstant.TB_FUNMATCHEDQTY).add(this.getBigDecimal(row, MatchConstant.TB_FQTYTOMATCH));
            toRow.getCell(MatchConstant.TB_FUNMATCHEDQTY).setValue((Object)unMatchedQty);
            toRow.getCell(MatchConstant.TB_FQTYTOMATCH).setValue((Object)unMatchedQty);
            BigDecimal unMatchedAmt = this.getBigDecimal(toRow, MatchConstant.TB_FUNMATCHEDAMT).add(this.getBigDecimal(row, MatchConstant.TB_FAMTTOMATCH));
            toRow.getCell(MatchConstant.TB_FUNMATCHEDAMT).setValue((Object)unMatchedAmt);
            toRow.getCell(MatchConstant.TB_FAMTTOMATCH).setValue((Object)unMatchedAmt);
            toRow.getStyleAttributes().setHided(false);
        }
        for (i = rowId.size() - 1; i >= 0; --i) {
            this.kdtRight.removeRow(((Integer)rowId.get(i)).intValue());
        }
    }

    private IRow getSrcRow(IRow row) {
        String billType = row.getCell(MatchConstant.TB_FBILLBOSTYPE).getValue().toString();
        String fid = row.getCell(MatchConstant.TB_FBILLENTRYID).getValue().toString();
        KDTable tableTo = MatchConstant.BOSTYPE_INCOMEINVOICE.equals(billType) ? this.kdtDown : this.kdtUp;
        int count = tableTo.getRowCount3();
        for (int i = 0; i < count; ++i) {
            if (!fid.equals(tableTo.getCell(i, MatchConstant.TB_FBILLENTRYID).getValue().toString())) continue;
            return tableTo.getRow(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionMatch_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsSupport();
        if (this.prmtBotp.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("BOTP_ISNULL"));
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        ArrayList<String> idList = new ArrayList<String>();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int count = this.kdtRight.getRowCount3();
        for (int i = 0; i < count; ++i) {
            IRow row = this.kdtRight.getRow(i);
            String bosType = row.getCell(MatchConstant.TB_FBILLBOSTYPE).getValue().toString();
            if (!this.invoiceConfigHelper.getConfig().getSrcBosType().equals(bosType)) continue;
            String id = row.getCell(MatchConstant.TB_FBILLID).getValue().toString();
            String number = row.getCell(MatchConstant.TB_FNUMBER).getValue().toString();
            numberMap.put(id, number);
            idList.add(id);
        }
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(idList);
            Set idSet = map.keySet();
            for (Object id : idSet) {
                if (((Boolean)map.get(id)).booleanValue()) continue;
                MsgBox.showInfo((String)this.getResource("Error_MatchLock", new Object[]{numberMap.get(id)}));
                return;
            }
            this.buildRecordsBySupplier();
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(idList);
        }
    }

    private Map buildRecordsBySupplier() throws BOSException, EASBizException {
        final LowTimer timer = new LowTimer();
        logger.error((Object)("[InvoiceMatch] Start : " + new Date()));
        HashMap<String, InvoiceMatchRecordInfo> records = new HashMap<String, InvoiceMatchRecordInfo>();
        HashMap<String, String> validInvMap = new HashMap<String, String>();
        HashMap<String, String> invalidInvMap = new HashMap<String, String>();
        HashSet<String> invalidKey = new HashSet<String>();
        int count = this.kdtRight.getRowCount3();
        for (int i = 0; i < count; ++i) {
            InvoiceMatchRecordInfo info;
            IRow row = this.kdtRight.getRow(i);
            Iterator companyId = row.getCell(MatchConstant.TB_FCOMPANYID).getValue().toString();
            String string = row.getCell(MatchConstant.TB_FCOMPANYNAME).getValue().toString();
            String supplierId = row.getCell(MatchConstant.TB_FSUPPLIERID).getValue().toString();
            String supplierName = row.getCell(MatchConstant.TB_FSUPPLIERNAME).getValue().toString();
            String key = companyId + supplierId;
            ArrayList stepList = stepMap.get(key);
            Collections.sort(stepList);
            String bosType = row.getCell(MatchConstant.TB_FBILLBOSTYPE).getValue().toString();
            if (bosType.equals(MatchConstant.BOSTYPE_INCOMEINVOICE)) {
                String invBillID = row.getCell(MatchConstant.TB_FBILLID).getValue().toString();
                if (invalidInvMap.containsKey(invBillID)) continue;
                if (!validInvMap.containsKey(invBillID)) {
                    if (!this.checkInvoiceAllMatched(invBillID)) {
                        invalidInvMap.put(invBillID, row.getCell(MatchConstant.TB_FNUMBER).getValue().toString());
                        invalidKey.add(key);
                        continue;
                    }
                    validInvMap.put(invBillID, row.getCell(MatchConstant.TB_FNUMBER).getValue().toString());
                }
            }
            if (invalidKey.contains(key)) continue;
            if (records.containsKey(key)) {
                info = (InvoiceMatchRecordInfo)records.get(key);
            } else {
                info = new InvoiceMatchRecordInfo();
                info.setId(BOSUuid.create((String)MatchConstant.BOSTYPE_INVOICEMATCHRECORD));
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read(companyId));
                company.setName(string);
                info.setCompany(company);
                SupplierInfo supplier = new SupplierInfo();
                supplier.setId(BOSUuid.read((String)supplierId));
                supplier.setName(supplierName);
                info.setSupplier(supplier);
                info.setBillQtyTotal(BigDecimal.ZERO);
                info.setBillAmtTotal(BigDecimal.ZERO);
                info.setInvoiceQtyTotal(BigDecimal.ZERO);
                info.setInvoiceAmtTotal(BigDecimal.ZERO);
                info.setSrcSystem(IMRecordSrcSystemEnum.MANUAL);
                if (completelyMatch.contains(key)) {
                    info.setIsCompletely(true);
                }
                records.put(key, info);
            }
            InvoiceMatchRecordEntryCollection entryColl = info.getEntry();
            InvoiceMatchRecordEntryInfo entryInfo = new InvoiceMatchRecordEntryInfo();
            entryInfo.setBillID(row.getCell(MatchConstant.TB_FBILLID).getValue().toString());
            entryInfo.setBillEntryID(row.getCell(MatchConstant.TB_FBILLENTRYID).getValue().toString());
            entryInfo.setBillBosType(row.getCell(MatchConstant.TB_FBILLBOSTYPE).getValue().toString());
            entryInfo.setBillName(row.getCell(MatchConstant.TB_FBILLNAME).getValue().toString());
            entryInfo.setBillNumber(row.getCell(MatchConstant.TB_FNUMBER).getValue().toString());
            entryInfo.setMatchedQty(this.getBigDecimal(row, MatchConstant.TB_FQTYTOMATCH));
            entryInfo.setMatchedAmt(this.getBigDecimal(row, MatchConstant.TB_FAMTTOMATCH));
            Integer step = Integer.valueOf(row.getCell(MatchConstant.TB_FSTEPSEQ).getValue().toString());
            entryInfo.setStepSeq(stepList.indexOf(step) + 1);
            entryColl.add(entryInfo);
        }
        InvoiceMatchRecordCollection coll = new InvoiceMatchRecordCollection();
        HashSet successKey = new HashSet();
        HashSet<String> successNum = new HashSet<String>();
        for (Object e : invalidKey) {
            if (!records.containsKey(e)) continue;
            records.remove(e);
        }
        for (Map.Entry entry : records.entrySet()) {
            successKey.add(entry.getKey());
            coll.add((InvoiceMatchRecordInfo)entry.getValue());
            InvoiceMatchRecordEntryCollection validEntry = ((InvoiceMatchRecordInfo)entry.getValue()).getEntry();
            for (int i = 0; i < validEntry.size(); ++i) {
                successNum.add(validEntry.get(i).getBillEntryID());
            }
        }
        final HashMap ret = new HashMap();
        ret.put(MatchConstant.SUCCESSKEY, successKey);
        ret.put(MatchConstant.SUCCESSNUM, successNum);
        logger.error((Object)("[InvoiceMatch] buildColl : " + timer.msValue() + " ms"));
        if (invalidInvMap.size() > 0) {
            MsgBox.showInfo((String)this.getResource("Error_InvalidNumber", new Object[]{Arrays.toString(invalidInvMap.values().toArray())}));
        }
        if (coll.size() > 0) {
            final Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            LongTimeDialog ltd = null;
            ltd = window instanceof Frame ? new LongTimeDialog((Frame)window) : (window instanceof Dialog ? new LongTimeDialog((Dialog)window) : new LongTimeDialog((Frame)new JFrame()));
            ltd.setTitle(this.getResource("Title_MappingToBills", null));
            final HashMap<String, Object> matchParams = new HashMap<String, Object>();
            matchParams.put(MatchConstant.MATCHRECORDCOLL, (Object)coll);
            matchParams.put(MatchConstant.CONFIGHELPER, this.bizConfigHelper);
            ltd.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Map result = InvoiceMatchFacadeFactory.getRemoteInstance().invoiceMatch(matchParams);
                    logger.error((Object)("[InvoiceMatch] invoiceMatch : " + timer.msValue() + " ms"));
                    return result;
                }

                public void afterExec(Object obj) throws Exception {
                    Map result = (Map)obj;
                    InvoiceMatchUI.this.afterMatchRecord(ret, result);
                    int errCount = (Integer)result.get(MatchConstant.ERRCOUNT);
                    if (errCount > 0) {
                        MsgBox.showDetailAndOK((Component)window, (String)InvoiceMatchUI.this.getResource("Msg_MatchPOK", new Object[]{result.get(MatchConstant.SUCCOUNT), errCount}), (String)((String)result.get(MatchConstant.ERRMSG)), (int)1);
                    } else {
                        MsgBox.showInfo((String)InvoiceMatchUI.this.getResource("Msg_MatchSuccess", new Object[]{result.get(MatchConstant.SUCCOUNT)}));
                    }
                }
            });
            ltd.show();
        }
        logger.error((Object)("[InvoiceMatch] End : " + timer.msValue() + " ms"));
        return ret;
    }

    private boolean checkInvoiceAllMatched(String number) {
        int count = this.kdtDown.getRowCount3();
        for (int i = 0; i < count; ++i) {
            BigDecimal unMatchedAmt;
            IRow row = this.kdtDown.getRow(i);
            if (!number.equals(row.getCell(MatchConstant.TB_FBILLID).getValue()) || (unMatchedAmt = this.getBigDecimal(row, MatchConstant.TB_FUNMATCHEDAMT)).compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private void afterMatchRecord(Map ret, Map result) {
        IRow row;
        int i;
        Set successKey = (Set)ret.get(MatchConstant.SUCCESSKEY);
        Set successNum = (Set)ret.get(MatchConstant.SUCCESSNUM);
        successKey.removeAll((Set)result.get(MatchConstant.FAILKEY));
        successNum.removeAll((Set)result.get(MatchConstant.FAILNUM));
        for (i = this.kdtRight.getRowCount3() - 1; i >= 0; --i) {
            if (!successNum.contains(this.kdtRight.getCell(i, MatchConstant.TB_FBILLENTRYID).getValue())) continue;
            this.kdtRight.removeRow(i);
        }
        for (i = this.kdtUp.getRowCount3() - 1; i >= 0; --i) {
            row = this.kdtUp.getRow(i);
            if (!row.getStyleAttributes().isHided() || !successNum.contains(row.getCell(MatchConstant.TB_FBILLENTRYID))) continue;
            this.kdtUp.removeRow(i);
        }
        for (i = this.kdtDown.getRowCount3() - 1; i >= 0; --i) {
            row = this.kdtDown.getRow(i);
            if (!row.getStyleAttributes().isHided() || !successNum.contains(row.getCell(MatchConstant.TB_FBILLENTRYID))) continue;
            this.kdtDown.removeRow(i);
        }
        for (Object key : successKey) {
            stepMap.remove(key);
            completelyMatch.remove(key);
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsSupport();
        this.checkRows(this.kdtUp, true);
        this.doSumFields(this.kdtUp);
        this.checkRows(this.kdtDown, true);
        this.doSumFields(this.kdtDown);
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsSupport();
        this.checkRows(this.kdtUp, false);
        this.doSumFields(this.kdtUp);
        this.checkRows(this.kdtDown, false);
        this.doSumFields(this.kdtDown);
    }

    protected void checkRows(KDTable table, boolean flag) {
        Boolean check = flag;
        int count = table.getRowCount3();
        for (int i = 0; i < count; ++i) {
            table.getCell(i, MatchConstant.TB_FSELECTED).setValue((Object)check);
        }
    }

    protected void doSumFields(KDTable table) {
        AbstractConfigHelper helper = this.getHelperByTable(table);
        String[] fieldSumList = helper.getSumFields();
        if (fieldSumList == null) {
            return;
        }
        BigDecimal[] result = new BigDecimal[fieldSumList.length];
        int count = table.getRowCount3();
        for (int i = 0; i < count; ++i) {
            if (!((Boolean)table.getCell(i, MatchConstant.TB_FSELECTED).getValue()).booleanValue()) continue;
            int len = fieldSumList.length;
            for (int j = 0; j < len; ++j) {
                if (result[j] == null) {
                    result[j] = BigDecimal.ZERO;
                }
                if (table.getCell(i, fieldSumList[j]) == null || table.getCell(i, fieldSumList[j]).getValue() == null) continue;
                result[j] = result[j].add(new BigDecimal(table.getCell(i, fieldSumList[j]).getValue().toString()));
            }
        }
        IRow footRow = table.getFootRow(0);
        int len = fieldSumList.length;
        for (int i = 0; i < len; ++i) {
            if (result[i] != null) {
                footRow.getCell(fieldSumList[i]).setValue((Object)result[i]);
                continue;
            }
            footRow.getCell(fieldSumList[i]).setValue((Object)SysConstant.BIGZERO);
        }
    }

    private void cleanRecordComfirm() {
        if (this.kdtRight.getRowCount3() > 0) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((String)this.getResource("Comfirm_Clean")))) {
                this.checkRows(this.kdtRight, true);
                this.removeRightRows();
            } else {
                this.abort();
            }
        }
    }

    @Override
    public void actionAutoMatch_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsSupport();
        this.checkRows(this.kdtUp, true);
        this.checkRows(this.kdtDown, true);
        this.actionMoveRight_actionPerformed(e);
        this.actionMatch_actionPerformed(e);
    }

    private String getGroupAlias(IRow row) {
        String company = row.getCell(MatchConstant.TB_FCOMPANYNAME).getValue().toString();
        String supplier = row.getCell(MatchConstant.TB_FSUPPLIERNAME).getValue().toString();
        return "[" + company + "_" + supplier + "]";
    }

    private AbstractConfigHelper getHelperByTable(KDTable table) {
        if (this.kdtUp == table) {
            return this.bizConfigHelper;
        }
        if (this.kdtDown == table) {
            return this.invoiceConfigHelper;
        }
        if (this.kdtRight == table) {
            return this.recordConfigHelper;
        }
        return this.bizConfigHelper;
    }

    private BigDecimal getBigDecimal(IRow row, String col) {
        Object value = row.getCell(col).getValue();
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(value.toString());
    }

    protected String getResource(String resName) {
        return EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)resName);
    }

    protected String getResource(String resName, Object[] params) {
        return EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)resName, (Object[])params);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return InvoiceMatchFacadeFactory.getRemoteInstance();
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected KDTable getTableForPrintSetting() {
        return null;
    }

    protected RptParams getParamsForInit() {
        return null;
    }
}

