/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.rptformula.calculater;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.arap.rptformula.calculater.ARAPAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.parambean.ARAPGetAmountParamBean;
import com.kingdee.eas.fi.arap.rptformula.parambean.AcctAPBalanceParamBean;
import com.kingdee.eas.fi.arap.rptformula.util.ARAPReportBatchUtils;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctAPBalanceAmountBatchCalculater
extends ARAPAmountBatchCalculater {
    private static final Logger logger = CoreUIObject.getLogger(AcctAPBalanceAmountBatchCalculater.class);
    private String[] canMutiSelect = new String[]{"Company", "AsstAct"};
    private String[] canMutiSelectSplit = new String[]{";", ";"};
    private String asstActType = " ";
    private String returnType = " ";
    private String returnField = " ";
    private String asstActTypeId = "";
    protected String asstActGroup = " ";
    private String currency = "";
    protected static final PeriodInfo periodInfo = new PeriodInfo();
    protected AsstActTypeInfo asstActTypeInfo = null;
    protected CompanyOrgUnitCollection cou = null;
    protected String periodSql = "";

    public AcctAPBalanceAmountBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block4: {
            EntityViewInfo ev;
            Context ctx;
            block3: {
                ctx = this.contextProvider.getServerContext();
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                if (index != 0) break block3;
                CompanyOrgUnitCollection ouc = ARAPReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
                if (ouc == null || ouc.size() <= 0) break block4;
                this.cou = ouc;
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    CompanyOrgUnitInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block4;
            }
            if (index == 1) {
                DataBaseCollection infoColl = ARAPReportBatchUtils.getAsstActCollection(ctx, this.asstActTypeInfo, ev);
                for (int i = 0; i < infoColl.size(); ++i) {
                    DataBaseInfo info = infoColl.get(i);
                    if (info == null || info.getId() == null) continue;
                    map.put(info.getNumber(), info.getId().toString());
                }
            }
        }
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        int querySize = paramArray.size();
        logger.info((Object)"execute is start!!  ");
        Context ctx = this.contextProvider.getServerContext();
        ReportVariables reportVariables = this.contextProvider.getReportVariables();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int i = 0;
        boolean j = false;
        for (int queryIndex = 0; i < 3000 && queryIndex < querySize; ++queryIndex) {
            this.params.clear();
            int lastQueryIndex = queryIndex;
            Parameter param = paramArray.getParameter(queryIndex);
            AcctAPBalanceParamBean formulaParam = new AcctAPBalanceParamBean(param);
            if ("BEFORETERM".equalsIgnoreCase(formulaParam.getApBalaceFetchType())) {
                this.setReturnType("FBeginBalanceFor");
                this.setReturnField("FBeginBalanceFor");
            } else if ("BEFORETERMLOCAL".equalsIgnoreCase(formulaParam.getApBalaceFetchType())) {
                this.setReturnType("FBeginBalanceLocal");
                this.setReturnField("FBeginBalanceLocal");
            } else if ("RECEIVINGAMOUNT".equalsIgnoreCase(formulaParam.getApBalaceFetchType())) {
                this.setReturnType("FDebitFor");
                this.setReturnField("FDebitFor");
            } else if ("RECEIVINGAMOUNTLOCAL".equalsIgnoreCase(formulaParam.getApBalaceFetchType())) {
                this.setReturnType("FDebitLocal");
                this.setReturnField("FDebitLocal");
            } else if ("ACTUALAMOUNT".equalsIgnoreCase(formulaParam.getApBalaceFetchType())) {
                this.setReturnType("FCreditFor");
                this.setReturnField("FCreditFor");
            } else if ("ACTUALAMOUNTLOCAL".equalsIgnoreCase(formulaParam.getApBalaceFetchType())) {
                this.setReturnType("FCreditLocal");
                this.setReturnField("FCreditLocal");
            } else if ("AFTERTERM".equalsIgnoreCase(formulaParam.getApBalaceFetchType())) {
                this.setReturnType("FEndBalanceFor");
                this.setReturnField("FEndBalanceFor");
            } else if ("AFTERTERMLOCAL".equalsIgnoreCase(formulaParam.getApBalaceFetchType())) {
                this.setReturnType("FEndBalanceLocal");
                this.setReturnField("FEndBalanceLocal");
            }
            periodInfo.setPeriodYear(formulaParam.getYear());
            periodInfo.setPeriodNumber(formulaParam.getPeriod());
            PeriodCollection periodCol = null;
            try {
                periodCol = ARAPReportBatchUtils.getPeriodCollection(ctx, this.getMultiEqualEntityView(periodInfo));
            }
            catch (BOSException e1) {
                logger.error((Object)e1);
            }
            this.setPeriodInfoId(periodCol);
            this.setCurrencyId(formulaParam.getCurrency());
            this.setAsstActTypeId(formulaParam.getAsstActType());
            this.setAsstActGroup(ctx, formulaParam.getAsstActGroup());
            formulaParam.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
            String sheetName = param.getSheetName();
            try {
                ARAPReportBatchUtils.reviseArApBalanceParameters(ctx, formulaParam, sheetName, reportVariables, reportAdapter);
                i += this.addParam(formulaParam);
            }
            catch (Exception e) {
                logger.info((Object)"for exception");
                logger.error((Object)e);
                FormulaValueBackfill.setException((Parameter)param, (Throwable)e);
            }
            try {
                this.innerExecute();
                continue;
            }
            catch (Exception e) {
                logger.info((Object)"innerExecute() is not execute");
                logger.error((Object)e);
                for (i = lastQueryIndex; i < queryIndex; ++i) {
                    FormulaValueBackfill.setException((Parameter)paramArray.getParameter(i), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected String getSql(int group) {
        return null;
    }

    @Override
    protected String getSqlByID(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getReturnType()).append(")").append(this.getReturnField());
        sql.append(" from t_ap_apbalance ").append(" BILL");
        sql.append(" left join ").append(this.asstActTypeInfo.getRealtionDataObject()).append(" AsstAct on AsstAct.fid = BILL.fasstactid ");
        sql.append(ARAPReportBatchUtils.getAsstActGroupSql(this.asstActTypeInfo, this.asstActGroup));
        sql.append(" where fbalType = 101 ");
        sql.append(this.getCompany(group));
        sql.append(this.getCurrencyId());
        sql.append(this.getPeriodInfoId());
        sql.append(this.getAsstActTypeId());
        sql.append(this.getAsstActGroup());
        sql.append(this.getAsstActId(group));
        return sql.toString();
    }

    @Override
    protected int setFixedSqlParams(PreparedStatement pstmt, ARAPGetAmountParamBean paramBean, int paramIndex) throws SQLException {
        return 1;
    }

    protected String getAsstActTypeId() {
        if (this.asstActTypeId != null && this.asstActTypeId.trim().length() > 0) {
            return " and bill.fasstActTypeId = '" + this.asstActTypeId + "'";
        }
        return " ";
    }

    protected void setAsstActTypeId(String number) {
        try {
            this.asstActTypeInfo = null;
            this.asstActTypeId = "";
            HashSet<String> numberSet = new HashSet<String>();
            EntityViewInfo ev = null;
            if (StringUtil.isEmpty((String)number)) {
                return;
            }
            numberSet.add(number);
            if (numberSet != null) {
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            }
            if (ev == null) {
                return;
            }
            IAsstActType iAsstActType = null;
            Context ctx = this.contextProvider.getServerContext();
            iAsstActType = ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)ctx);
            this.asstActTypeInfo = iAsstActType.getAsstActTypeCollection(ev).get(0);
            if (this.asstActTypeInfo != null && this.asstActTypeInfo.getId() != null) {
                this.asstActTypeId = this.asstActTypeInfo.getId().toString();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    protected void setCurrencyId(String currencyNumber) {
        try {
            this.currency = null;
            HashSet<String> numberSet = new HashSet<String>();
            EntityViewInfo ev = null;
            if (StringUtil.isEmpty((String)currencyNumber)) {
                return;
            }
            numberSet.add(currencyNumber);
            if (numberSet != null) {
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            }
            if (ev == null) {
                return;
            }
            Context ctx = this.contextProvider.getServerContext();
            ICurrency iCurrency = null;
            iCurrency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyInfo currencyInfo = iCurrency.getCurrencyCollection(ev).get(0);
            if (currencyInfo.getId() != null) {
                this.currency = currencyInfo.getId().toString();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    protected String getCurrencyId() {
        if (this.currency != null && this.currency.trim().length() > 0) {
            return " and Fcurrencyid  = '" + this.currency + "'";
        }
        return " ";
    }

    @Override
    protected String getHeadTableName() {
        return "";
    }

    @Override
    protected String getDetailTableName() {
        return "";
    }

    @Override
    protected String[] getCanMutiSelect() {
        return this.canMutiSelect;
    }

    @Override
    protected String[] getCanMutiSelectSplit() {
        return this.canMutiSelectSplit;
    }

    protected String getAsstActType() {
        return this.asstActType;
    }

    protected void setAsstActType(String asstActType) {
        this.asstActType = asstActType;
    }

    @Override
    protected String getReturnField() {
        return this.returnField.trim();
    }

    protected void setReturnField(String returnField) {
        this.returnField = returnField;
    }

    protected String getReturnType() {
        return this.returnType;
    }

    protected void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    protected String getCompany(int group) {
        if (AcctAPBalanceAmountBatchCalculater.checkBit(group, 0)) {
            return " and Fcompanyid = ? ";
        }
        return "";
    }

    protected String getAsstActId(int group) {
        if (AcctAPBalanceAmountBatchCalculater.checkBit(group, 1)) {
            return " and AsstAct.Fid = ? ";
        }
        return "";
    }

    protected void setAsstActGroup(Context ctx, String asstActGroup) {
        String groupTable = null;
        if (this.asstActTypeInfo != null) {
            groupTable = this.asstActTypeInfo.getGroupTableName();
        }
        try {
            this.asstActGroup = ARAPReportBatchUtils.getAsstActGroupIDByNumber(ctx, asstActGroup, groupTable, this.asstActTypeInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected String getAsstActGroup() {
        if (!StringUtil.isEmpty((String)this.asstActGroup) || this.asstActGroup != null) {
            return " and AsstActGroup.fid = '" + this.asstActGroup + "'";
        }
        return " ";
    }

    public EntityViewInfo getMultiEqualEntityView(PeriodInfo info) {
        EntityViewInfo ev = new EntityViewInfo();
        if (ev == null) {
            ev = new EntityViewInfo();
            ev.setFilter(new FilterInfo());
        } else if (ev.getFilter() == null) {
            ev.setFilter(new FilterInfo());
        }
        StringBuffer maskString = new StringBuffer();
        if (new Integer(info.getPeriodYear()) != null && new Integer(info.getPeriodNumber()) != null) {
            ev.getFilter().getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(info.getPeriodYear()), CompareType.EQUALS));
            ev.getFilter().getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(info.getPeriodNumber()), CompareType.EQUALS));
            maskString.append("#0 and #1");
            ev.getFilter().setMaskString(maskString.toString());
        }
        return ev;
    }

    public void setPeriodInfoId(PeriodCollection periodCol) {
        PeriodInfo info;
        if (periodCol == null) {
            this.periodSql = " ";
        }
        if (periodCol != null && periodCol.size() == 1 && (info = periodCol.get(0)) != null && info.getId() != null) {
            this.periodSql = " and fperiodid = '" + info.getId().toString() + "'";
        }
        if (periodCol != null && periodCol.size() > 1) {
            StringBuffer sb = new StringBuffer();
            PeriodInfo info2 = null;
            sb.append(" and (");
            for (int i = 0; i < periodCol.size(); ++i) {
                info2 = periodCol.get(i);
                if (info2 != null && info2.getId() != null) {
                    sb.append(" fperiodid = '" + info2.getId().toString() + "'");
                }
                if (info2 == null || info2.getId() == null || i >= periodCol.size() - 1) continue;
                sb.append(" or ");
            }
            sb.append(") ");
            this.periodSql = sb.toString();
        }
    }

    public String getPeriodInfoId() {
        return this.periodSql;
    }
}

