/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.rptformula.calculater;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.ar.app.ArApVirtualAgingRptHelper;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.rptformula.calculater.ARAPAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.calculater.ARAPBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.parambean.ArAgingBalanceParamBean;
import com.kingdee.eas.fi.arap.rptformula.util.ARAPReportBatchUtils;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctARAgingAmountBatchCalculater
extends ARAPAmountBatchCalculater {
    private static final Logger logger = CoreUIObject.getLogger(AcctARAgingAmountBatchCalculater.class);
    private static Integer MAX_DAY = 999999;
    private static final String conditionSplitSign = "-";
    private String[] CanMutiSelect = new String[]{"Company", "RecPayBillType", "AdminOrg", "Person", "AsstActType-AsstAct"};
    private String[] canMutiSelectSplit = new String[]{";", ";", ";", ";", ";"};
    private String returnType = " ";
    private String returnField = " ";
    private String asstActType = " ";
    protected HashMap<String, AsstActTypeInfo> asstActTypeInfoMap = new HashMap();
    protected HashMap<String, String> currencyIdMap = new HashMap();
    private HashMap<String, String> asstActGroupMap = new HashMap();
    private HashMap<String, String> cussAcctTempTblMap = new HashMap();
    protected static final PeriodInfo periodInfo = new PeriodInfo();
    protected CompanyOrgUnitCollection cou = null;
    protected String periodSql = "";
    protected Map<String, List<ArAgingBalanceParamBean>> groupParams = new HashMap<String, List<ArAgingBalanceParamBean>>();

    public AcctARAgingAmountBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected String getHeadTableName() {
        return null;
    }

    @Override
    protected String getDetailTableName() {
        return null;
    }

    @Override
    protected String[] getCanMutiSelect() {
        return this.CanMutiSelect;
    }

    @Override
    protected String[] getCanMutiSelectSplit() {
        return this.canMutiSelectSplit;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        Context ctx = this.contextProvider.getServerContext();
        int querySize = paramArray.size();
        int queryIndex = 0;
        ReportVariables reportVariables = this.contextProvider.getReportVariables();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        HashSet<String> currencyNumberSet = new HashSet<String>();
        HashSet<String> asstactTypeNumberSet = new HashSet<String>();
        queryIndex = 0;
        while (queryIndex < querySize) {
            int i;
            this.params.clear();
            this.groupParams.clear();
            for (i = 0; i < 3000 && queryIndex < querySize; ++queryIndex, ++i) {
                int lastQueryIndex = queryIndex;
                Parameter param = paramArray.getParameter(queryIndex);
                ArAgingBalanceParamBean formulaParam = new ArAgingBalanceParamBean(param);
                if (formulaParam.getCurrency() != null) {
                    currencyNumberSet.add(formulaParam.getCurrency());
                }
                if (formulaParam.getAsstActType() != null) {
                    asstactTypeNumberSet.add(formulaParam.getAsstActType());
                }
                formulaParam.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
                String sheetName = param.getSheetName();
                try {
                    ARAPReportBatchUtils.reviseAcctArAgingParameters(ctx, formulaParam, sheetName, reportVariables, reportAdapter);
                    this.params.add(formulaParam);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    FormulaValueBackfill.setException((Parameter)paramArray.getParameter(queryIndex), (Throwable)e);
                }
            }
            this.cacheAsstActTypeInfo(asstactTypeNumberSet);
            this.cacheCurrencyId(currencyNumberSet);
            try {
                this.groupByParam();
                this.loadNumberIDCacheData();
                for (i = 0; i < this.params.size(); ++i) {
                    ArAgingBalanceParamBean formulaParam = (ArAgingBalanceParamBean)this.params.get(i);
                    String groupKey = formulaParam.getGroupKey();
                    if (this.groupParams.containsKey(groupKey)) {
                        this.groupParams.get(groupKey).add(formulaParam);
                        continue;
                    }
                    ArrayList<ArAgingBalanceParamBean> paramsList = new ArrayList<ArAgingBalanceParamBean>();
                    this.groupParams.put(groupKey, paramsList);
                    paramsList.add(formulaParam);
                }
                Collection<List<ArAgingBalanceParamBean>> coll = this.groupParams.values();
                Iterator<List<ArAgingBalanceParamBean>> it = coll.iterator();
                logger.error((Object)("\u8c03\u7528\u53d6\u6570\u51fd\u6570\u6b21\u6570\uff1a" + coll.size()));
                while (it.hasNext()) {
                    this.params = (ArrayList)it.next();
                    this.innerExecute();
                }
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
        }
        if (!this.cussAcctTempTblMap.isEmpty()) {
            Collection<String> cussAcctTempTbls = this.cussAcctTempTblMap.values();
            Iterator<String> it = cussAcctTempTbls.iterator();
            while (it.hasNext()) {
                try {
                    TempTableUtil.releasTempTable((Context)ctx, (String)it.next());
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    @Override
    protected void innerExecute() throws Exception {
        Context ctx = this.contextProvider.getServerContext();
        String sql = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        logger.info((Object)"innerExecute method Start");
        AccountAgeQueryParam queryParam = null;
        ArAgingBalanceParamBean paramBean = null;
        queryParam = (AccountAgeQueryParam)this.getRptParam(this.params);
        HashMap<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>();
        try {
            String selectSql = ArApReportHelper.getCussAcctTempTblSelectSql((Context)ctx, (ArApQueryParam)queryParam);
            if (StringUtils.isEmpty((String)this.cussAcctTempTblMap.get(selectSql))) {
                ArApVirtualAgingRptHelper.fetchAgingRpt((Context)ctx, (AccountAgeQueryParam)queryParam);
                if (!StringUtils.isEmpty((String)queryParam.getCussAcctTempTable())) {
                    this.cussAcctTempTblMap.put(selectSql, queryParam.getCussAcctTempTable());
                }
            } else {
                queryParam.setCussAcctTempTable(this.cussAcctTempTblMap.get(selectSql));
                ArApVirtualAgingRptHelper.fetchAgingRpt((Context)ctx, (AccountAgeQueryParam)queryParam);
            }
            sql = "select sum(" + queryParam.getDueField() + ") " + queryParam.getDueField() + ",fAsstActId as asstActId from " + queryParam.getTempTable() + " where fIsSum = 0 group by fAsstActId";
            pstmt = this.conn.prepareStatement(sql);
            try {
                rs = pstmt.executeQuery();
                BigDecimal value = ARAPBatchCalculater.ZERO;
                while (rs.next()) {
                    valueMap.put(rs.getString("asstActId"), rs.getBigDecimal(queryParam.getDueField()));
                }
            }
            catch (SQLException e) {
                logger.info((Object)"innerExecute method sql(pstmt) Exception is happened");
                logger.error((Object)e);
                int count = this.params.size();
                for (int i = 0; i < count; ++i) {
                    paramBean = (ArAgingBalanceParamBean)this.params.get(i);
                    paramBean.getBackFiller().setException((Throwable)e);
                }
            }
            List tempList = new ArrayList();
            BigDecimal totalValue = null;
            for (int i = 0; i < this.params.size(); ++i) {
                BigDecimal value = ARAPBatchCalculater.ZERO;
                paramBean = (ArAgingBalanceParamBean)this.params.get(i);
                tempList = this.getCacheID("AsstActType", "AsstAct", paramBean);
                if (tempList != null && !tempList.isEmpty()) {
                    for (int j = 0; j < tempList.size(); ++j) {
                        if (valueMap.get(tempList.get(j)) == null) continue;
                        value = value.add((BigDecimal)valueMap.get(tempList.get(j)));
                    }
                } else if (totalValue == null) {
                    for (BigDecimal a : valueMap.values()) {
                        if (a == null) continue;
                        value = value.add(a);
                    }
                    totalValue = new BigDecimal(value.toString());
                } else {
                    value = new BigDecimal(totalValue.toString());
                }
                paramBean.getBackFiller().setValue((Object)value);
            }
        }
        catch (SQLException e) {
            try {
                logger.info((Object)"innerExecute method sql(pstmt) Exception is happened 2  ");
                logger.error((Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
    }

    @Override
    protected void groupByParam() {
        String[] properties = this.getCanMutiSelect();
        String[] split = this.getCanMutiSelectSplit();
        logger.info((Object)"groupByParam()  Exception is happened  ");
        if (properties != null && properties.length > 0) {
            int n = this.params.size();
            for (int i = 0; i < n; ++i) {
                ArAgingBalanceParamBean paramBean = (ArAgingBalanceParamBean)this.params.get(i);
                int group = 0;
                int m = properties.length;
                for (int j = 0; j < m; ++j) {
                    String[] splitArr;
                    String prePropertyValue = "";
                    String propertyValue = "";
                    String propertyName = properties[j];
                    String[] propertyNameArr = propertyName.split(conditionSplitSign);
                    if (propertyNameArr.length > 1) {
                        prePropertyValue = (String)this.invokeGetterMethod(paramBean, propertyNameArr[0]);
                        propertyValue = (String)this.invokeGetterMethod(paramBean, propertyNameArr[1]);
                    } else {
                        propertyValue = (String)this.invokeGetterMethod(paramBean, propertyName);
                    }
                    for (String splitVal : splitArr = propertyValue.split(split[j])) {
                        if (StringUtils.isEmpty((String)splitVal)) continue;
                        group |= 1 << j;
                        if (!StringUtils.isEmpty((String)prePropertyValue)) {
                            this.initLoadNumberID(propertyName, prePropertyValue.trim(), splitVal.trim());
                            continue;
                        }
                        this.initLoadNumberID(propertyName, splitVal.trim());
                    }
                }
            }
        }
    }

    protected void initLoadNumberID(String propertyName, String prePropertyValue, String propertyValue) {
        HashMap map = null;
        HashMap perMap = null;
        if (this.numberIDCache.containsKey(propertyName)) {
            map = (HashMap)this.numberIDCache.get(propertyName);
        } else {
            map = new HashMap();
            this.numberIDCache.put(propertyName, map);
        }
        if (map.containsKey(prePropertyValue)) {
            perMap = (HashMap)map.get(prePropertyValue);
        } else {
            perMap = new HashMap();
            map.put(prePropertyValue, perMap);
        }
        if (!perMap.containsKey(propertyValue)) {
            perMap.put(propertyValue, null);
        }
    }

    @Override
    protected void loadNumberIDCacheData() throws Exception {
        String[] properties = this.getCanMutiSelect();
        if (properties != null && properties.length > 0) {
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                String prePropertyValue = "";
                String propertyValue = "";
                HashMap map = (HashMap)this.numberIDCache.get(properties[j]);
                if (map == null || map.size() <= 0) continue;
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() instanceof Map) {
                        HashMap valueMap = (HashMap)entry.getValue();
                        Iterator valueitr = valueMap.entrySet().iterator();
                        HashSet numberSet = new HashSet();
                        while (valueitr.hasNext()) {
                            Map.Entry valueEntry = valueitr.next();
                            Object value = valueEntry.getValue();
                            if (value != null) continue;
                            Object key = valueEntry.getKey();
                            numberSet.add(key);
                        }
                        this.innerLoadNumberID(j, valueMap, (String)entry.getKey(), numberSet);
                        continue;
                    }
                    HashSet numberSet = new HashSet();
                    Object value = entry.getValue();
                    if (value == null) {
                        Object key = entry.getKey();
                        numberSet.add(key);
                    }
                    this.innerLoadNumberID(j, map, numberSet);
                }
            }
        }
    }

    @Override
    protected String getSqlByID(int group) {
        return null;
    }

    public IReportQueryParam getRptParam(List<ArAgingBalanceParamBean> formulaParams) throws BOSException, EASBizException {
        if (formulaParams == null || formulaParams.isEmpty()) {
            return null;
        }
        ArAgingBalanceParamBean formulaParam = formulaParams.get(0);
        ArAgingBalanceParamBean tempFormulaParam = null;
        AccountAgeQueryParam param = new AccountAgeQueryParam();
        List compIDList = this.getCacheID("Company", formulaParam);
        if (compIDList.size() == 1) {
            param.setCompanyId((String)compIDList.get(0));
        }
        param.setCompanyIds(compIDList);
        param.setIsArRpt(true);
        this.setCurrCussAcct2RptParam(param, formulaParam);
        formulaParam.setAsstAct(formulaParam.getAsstAct());
        ArrayList asstActFrom = new ArrayList();
        List tempList = null;
        for (int i = 0; i < formulaParams.size(); ++i) {
            tempFormulaParam = formulaParams.get(i);
            tempList = this.getCacheID("AsstActType", "AsstAct", tempFormulaParam);
            if (tempList == null || tempList.isEmpty()) {
                asstActFrom.clear();
                break;
            }
            asstActFrom.addAll(tempList);
        }
        param.setCussAcctFromIds(asstActFrom);
        param.setBeginDate(new Date(DateTimeUtils.truncateDate((java.util.Date)formulaParam.getBeginBillDate()).getTime()));
        param.setEndDate(new Date(DateTimeUtils.truncateDate((java.util.Date)formulaParam.getEndBillDate()).getTime()));
        param.setDirIndex(formulaParam.getAnalyseDir());
        param.setAnalyseObjIndex(formulaParam.getAnalyseObj());
        param.setAgingCompareDate(new Date(DateTimeUtils.truncateDate((java.util.Date)formulaParam.getAgingCompareDate()).getTime()));
        param.setDateFldIndex(formulaParam.getAgingDateFld());
        List adminOrg = this.getCacheID("AdminOrg", formulaParam);
        if (adminOrg.size() == 1) {
            param.setAdminOrgId((String)adminOrg.get(0));
        }
        param.setAdminOrgIds(adminOrg);
        param.setPersonIds(this.getCacheID("Person", formulaParam));
        param.setRecpayBillTypes(this.getCacheID("RecPayBillType", formulaParam));
        List<Object> billTypeList = new ArrayList();
        String billType = formulaParam.getBillType();
        if (!StringUtils.isEmpty((String)billType)) {
            String[] typeArr = billType.split(";");
            billTypeList = Arrays.asList(typeArr);
        }
        param.setArapBillTypes(billTypeList);
        param.setEndDateBal(formulaParam.isEndDateBal());
        param.setBizeCheckBox(formulaParam.getBizcheck() != 0);
        param.setBizeIndex(formulaParam.getBizcheck() == 0 ? -1 : formulaParam.getBizcheck() - 1);
        param.setPaymentTypeCheckBox(formulaParam.getPaymentType() != 0);
        param.setPaymentTypeIndex(formulaParam.getPaymentType() == 0 ? -1 : formulaParam.getPaymentType() - 1);
        int agingDue = formulaParam.getAgingDue();
        String agingdueGroup = formulaParam.getAgingDueGroup();
        ArrayList<Integer> dueList = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((String)agingdueGroup)) {
            String[] agingdue = agingdueGroup.split(",");
            boolean backTemp = false;
            int tt = Integer.parseInt(agingdue[0]);
            if (tt != 1 && Integer.parseInt(agingdue[1]) != MAX_DAY) {
                dueList.add(Integer.parseInt(agingdue[0]) - 1);
                dueList.add(Integer.parseInt(agingdue[1]));
                dueList.add(Integer.parseInt(agingdue[1]) + 1);
            } else if (Integer.parseInt(agingdue[1]) == MAX_DAY) {
                dueList.add(Integer.parseInt(agingdue[0]) - 1);
                dueList.add(Integer.parseInt(agingdue[0]));
            } else {
                dueList.add(Integer.parseInt(agingdue[1]));
                dueList.add(Integer.parseInt(agingdue[1]) + 1);
            }
        }
        if (dueList.size() > 0) {
            if (agingDue == 0) {
                param.setOverdueList(dueList);
            } else {
                param.setUndueList(dueList);
            }
        }
        this.setDateList(param, formulaParam);
        return param;
    }

    private List getCacheID(String field, ArAgingBalanceParamBean formulaParam) {
        ArrayList ids = new ArrayList();
        String[] splitArr = null;
        Map map = (Map)this.numberIDCache.get(field);
        String propertyValue = (String)this.invokeGetterMethod(formulaParam, field);
        if (!StringUtils.isEmpty((String)propertyValue)) {
            splitArr = propertyValue.split(";");
        }
        if (splitArr != null && splitArr.length > 0) {
            for (String split : splitArr) {
                ids.add(map.get(split.trim()));
            }
        }
        return ids;
    }

    private List getCacheID(String perField, String field, ArAgingBalanceParamBean formulaParam) {
        ArrayList ids = new ArrayList();
        String[] splitArr = null;
        Map map = (Map)this.numberIDCache.get(perField + conditionSplitSign + field);
        if (map != null) {
            String perPropertyValue = (String)this.invokeGetterMethod(formulaParam, perField);
            String propertyValue = (String)this.invokeGetterMethod(formulaParam, field);
            Map valueMap = (Map)map.get(perPropertyValue);
            if (valueMap != null) {
                if (!StringUtils.isEmpty((String)propertyValue)) {
                    splitArr = propertyValue.split(";");
                }
                if (splitArr != null && splitArr.length > 0) {
                    for (String split : splitArr) {
                        ids.add(valueMap.get(split.trim()));
                    }
                }
            }
        }
        return ids;
    }

    protected void setCurrCussAcct2RptParam(ArApQueryParam param, ArAgingBalanceParamBean formulaParam) throws BOSException, EASBizException {
        String asstActGroupId;
        AsstActTypeInfo asstActTypeInfo;
        String currencyID = this.currencyIdMap.get(formulaParam.getCurrency());
        if (!StringUtils.isEmpty((String)currencyID)) {
            param.setCurrencyId(currencyID);
        }
        if ((asstActTypeInfo = this.asstActTypeInfoMap.get(formulaParam.getAsstActType())) != null) {
            param.setCussAcctTypeInfo(asstActTypeInfo);
            param.setCussTypeId(asstActTypeInfo.getId().toString());
            param.setCussTable(asstActTypeInfo.getRealtionDataObject());
        }
        if (!StringUtils.isEmpty((String)(asstActGroupId = this.getAsstActGroup(asstActTypeInfo, formulaParam.getAsstActGroup())))) {
            param.setCsspGrpId(asstActGroupId);
            Context ctx = this.contextProvider.getServerContext();
            ICSSPGroup iCSSPGroup = CSSPGroupFactory.getLocalInstance((Context)ctx);
            CSSPGroupInfo cSSPGroupInfo = iCSSPGroup.getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(asstActGroupId));
            if (cSSPGroupInfo != null) {
                param.setCsspGrpStdId(cSSPGroupInfo.getGroupStandard().getId().toString());
            }
        }
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block7: {
            PersonCollection ouc;
            EntityViewInfo ev;
            Context ctx;
            block9: {
                block8: {
                    block6: {
                        if (numberSet == null || numberSet.isEmpty()) {
                            return;
                        }
                        ctx = this.contextProvider.getServerContext();
                        ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                        if (index != 0) break block6;
                        CompanyOrgUnitCollection ouc2 = ARAPReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
                        if (ouc2 == null || ouc2.size() <= 0) break block7;
                        int n = ouc2.size();
                        for (int i = 0; i < n; ++i) {
                            CompanyOrgUnitInfo info = ouc2.get(i);
                            String number = info.getNumber();
                            String id = info.getId().toString();
                            map.put(number, id);
                        }
                        break block7;
                    }
                    if (index != 1) break block8;
                    ReceivingBillTypeCollection ouc3 = ARAPReportBatchUtils.getReceivingBillTypeCollection(ctx, ev);
                    if (ouc3 == null || ouc3.size() <= 0) break block7;
                    int n = ouc3.size();
                    for (int i = 0; i < n; ++i) {
                        ReceivingBillTypeInfo info = ouc3.get(i);
                        String number = info.getNumber();
                        String id = info.getId().toString();
                        map.put(number, id);
                    }
                    break block7;
                }
                if (index != 2) break block9;
                AdminOrgUnitCollection ouc4 = ARAPReportBatchUtils.getAdminOrgUnitCollection(ctx, ev);
                if (ouc4 == null || ouc4.size() <= 0) break block7;
                int n = ouc4.size();
                for (int i = 0; i < n; ++i) {
                    AdminOrgUnitInfo info = ouc4.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block7;
            }
            if (index == 3 && (ouc = ARAPReportBatchUtils.getPersonCollection(ctx, ev)) != null && ouc.size() > 0) {
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    PersonInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    protected void innerLoadNumberID(int index, HashMap map, String asstactNumber, Set numberSet) throws Exception {
        Context ctx = this.contextProvider.getServerContext();
        EntityViewInfo ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
        if (index == 4) {
            AsstActTypeInfo asstActTypeInfo = this.asstActTypeInfoMap.get(asstactNumber);
            if (asstActTypeInfo == null) {
                return;
            }
            DataBaseCollection coll = ARAPReportBatchUtils.getAsstActCollection(ctx, asstActTypeInfo, ev);
            DataBaseInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (info == null || info.getId() == null) continue;
                map.put(info.getNumber(), info.getId().toString());
            }
        }
    }

    protected void cacheCurrencyId(Set numberSet) {
        try {
            if (numberSet == null || numberSet.isEmpty()) {
                return;
            }
            EntityViewInfo ev = null;
            ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            if (ev == null) {
                return;
            }
            Context ctx = this.contextProvider.getServerContext();
            ICurrency iCurrency = null;
            iCurrency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyCollection currencyColl = iCurrency.getCurrencyCollection(ev);
            for (int i = 0; i < currencyColl.size(); ++i) {
                CurrencyInfo currencyInfo = currencyColl.get(i);
                this.currencyIdMap.put(currencyInfo.getNumber(), currencyInfo.getId().toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    protected void cacheAsstActTypeInfo(Set numberSet) {
        try {
            if (numberSet == null || numberSet.isEmpty()) {
                return;
            }
            EntityViewInfo ev = null;
            ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            if (ev == null) {
                return;
            }
            IAsstActType iAsstActType = null;
            Context ctx = this.contextProvider.getServerContext();
            iAsstActType = ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)ctx);
            AsstActTypeCollection asstActTypeColl = iAsstActType.getAsstActTypeCollection(ev);
            AsstActTypeInfo asstActTypeInfo = null;
            for (int i = 0; i < asstActTypeColl.size(); ++i) {
                asstActTypeInfo = asstActTypeColl.get(i);
                if (asstActTypeInfo == null) continue;
                this.asstActTypeInfoMap.put(asstActTypeInfo.getNumber(), asstActTypeInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    protected String getAsstActGroup(AsstActTypeInfo asstActTypeInfo, String asstActGroup) {
        if (asstActTypeInfo == null || StringUtils.isEmpty((String)asstActGroup)) {
            return null;
        }
        String asstActGroupId = null;
        String key = asstActTypeInfo.getId().toString() + "," + asstActGroup;
        if (this.asstActGroupMap.get(key) != null) {
            asstActGroupId = this.asstActGroupMap.get(key);
        } else {
            String groupTable = null;
            if (asstActTypeInfo != null) {
                groupTable = asstActTypeInfo.getGroupTableName();
            }
            try {
                asstActGroupId = ARAPReportBatchUtils.getAsstActGroupIDByNumber(this.contextProvider.getServerContext(), asstActGroup, groupTable, asstActTypeInfo);
                this.asstActGroupMap.put(key, asstActGroupId);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return asstActGroupId;
    }

    private void setDateList(AccountAgeQueryParam param, ArAgingBalanceParamBean formulaParam) {
        List undues = param.getUndueList();
        Date agingDate = param.getAgingCompareDate();
        Date date = null;
        Integer oInt = 0;
        String field = "";
        if (undues != null && undues.size() > 0) {
            ArrayList<Date> undueDates = new ArrayList<Date>();
            int n = undues.size();
            for (int i = 0; i < n; ++i) {
                oInt = Integer.valueOf(String.valueOf(undues.get(i)));
                if (oInt.intValue() == MAX_DAY.intValue()) continue;
                date = new Date(agingDate.getTime() + (long)oInt.intValue() * 86400000L);
                undueDates.add(date);
            }
            if (undues.size() == 1) {
                undueDates.add(new Date(agingDate.getTime() + (long)(oInt + 1) * 86400000L));
            }
            param.setUndueDateList(undueDates);
            String[] agingdue = formulaParam.getAgingDueGroup().split(",");
            System.out.println();
            if (undues.size() > 1) {
                field = "FUL_" + undues.get(0) + "t" + undues.get(1);
                if (Integer.parseInt(agingdue[1]) == MAX_DAY) {
                    field = "FUL_t" + (Integer)undues.get(1);
                } else if (undues.size() > 2) {
                    field = "FUL_" + ((Integer)undues.get(0) + 1) + "t" + (Integer)undues.get(1);
                } else if (Integer.parseInt(agingdue[0]) == 1) {
                    field = "FUL_1t" + (Integer)undues.get(0);
                }
            } else if (undues.size() == 1) {
                field = "FUL_t" + undues.get(0);
            }
            System.out.println();
        }
        oInt = 0;
        List overdues = param.getOverdueList();
        if (overdues != null && overdues.size() > 0) {
            ArrayList<Date> overdueDates = new ArrayList<Date>();
            int n = overdues.size();
            for (int i = 0; i < n; ++i) {
                oInt = Integer.valueOf(String.valueOf(overdues.get(i)));
                if (oInt.intValue() == MAX_DAY.intValue()) continue;
                date = new Date(agingDate.getTime() - (long)oInt.intValue() * 86400000L);
                overdueDates.add(date);
            }
            param.setOverdueDateList(overdueDates);
            if (overdues.size() == 1) {
                overdueDates.add(new Date(agingDate.getTime() - (long)(oInt + 1) * 86400000L));
            }
            String[] agingdue = formulaParam.getAgingDueGroup().split(",");
            if (overdues.size() > 1) {
                field = "FOL_" + overdues.get(0) + "t" + overdues.get(1);
                if (Integer.parseInt(agingdue[1]) == MAX_DAY) {
                    field = "FOL_t" + (Integer)overdues.get(1);
                } else if (overdues.size() > 2) {
                    field = "FOL_" + ((Integer)overdues.get(0) + 1) + "t" + (Integer)overdues.get(1);
                } else if (Integer.parseInt(agingdue[0]) == 1) {
                    field = "FOL_1t" + (Integer)overdues.get(0);
                }
            } else {
                field = overdues.size() == 1 ? "FOL_t" + overdues.get(0) : "FOL_t" + overdues.get(0);
            }
        }
        if (StringUtils.isEmpty((String)field)) {
            field = "FBalance";
        }
        param.setDueField(field);
    }
}

