/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.rptformula.calculater;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.fi.arap.rptformula.calculater.AcctAPBalanceAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.parambean.AcctARBalanceParamBean;
import com.kingdee.eas.fi.arap.rptformula.util.ARAPReportBatchUtils;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;

public class AcctARBalanceAmountBatchCalculater
extends AcctAPBalanceAmountBatchCalculater {
    public AcctARBalanceAmountBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        int querySize = paramArray.size();
        Context ctx = this.contextProvider.getServerContext();
        ReportVariables reportVariables = this.contextProvider.getReportVariables();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int i = 0;
        boolean j = false;
        for (int queryIndex = 0; i < 3000 && queryIndex < querySize; ++queryIndex) {
            this.params.clear();
            int lastQueryIndex = queryIndex;
            Parameter param = paramArray.getParameter(queryIndex);
            AcctARBalanceParamBean formulaParam = new AcctARBalanceParamBean(param);
            if ("BEFORETERM".equalsIgnoreCase(formulaParam.getArBalaceFetchType())) {
                this.setReturnType("FBeginBalanceFor");
                this.setReturnField("FBeginBalanceFor");
            } else if ("BEFORETERMLOCAL".equalsIgnoreCase(formulaParam.getArBalaceFetchType())) {
                this.setReturnType("FBeginBalanceLocal");
                this.setReturnField("FBeginBalanceLocal");
            } else if ("RECEIVINGAMOUNT".equalsIgnoreCase(formulaParam.getArBalaceFetchType())) {
                this.setReturnType("FDebitFor");
                this.setReturnField("FDebitFor");
            } else if ("RECEIVINGAMOUNTLOCAL".equalsIgnoreCase(formulaParam.getArBalaceFetchType())) {
                this.setReturnType("FDebitLocal");
                this.setReturnField("FDebitLocal");
            } else if ("ACTUALAMOUNT".equalsIgnoreCase(formulaParam.getArBalaceFetchType())) {
                this.setReturnType("FCreditFor");
                this.setReturnField("FCreditFor");
            } else if ("ACTUALAMOUNTLOCAL".equalsIgnoreCase(formulaParam.getArBalaceFetchType())) {
                this.setReturnType("FCreditLocal");
                this.setReturnField("FCreditLocal");
            } else if ("AFTERTERM".equalsIgnoreCase(formulaParam.getArBalaceFetchType())) {
                this.setReturnType("FEndBalanceFor");
                this.setReturnField("FEndBalanceFor");
            } else if ("AFTERTERMLOCAL".equalsIgnoreCase(formulaParam.getArBalaceFetchType())) {
                this.setReturnType("FEndBalanceLocal");
                this.setReturnField("FEndBalanceLocal");
            }
            periodInfo.setPeriodYear(formulaParam.getYear());
            periodInfo.setPeriodNumber(formulaParam.getPeriod());
            PeriodCollection periodCol = null;
            try {
                periodCol = ARAPReportBatchUtils.getPeriodCollection(ctx, this.getMultiEqualEntityView(periodInfo));
            }
            catch (BOSException e1) {
                Logger.error((Throwable)e1);
            }
            this.setPeriodInfoId(periodCol);
            this.setCurrencyId(formulaParam.getCurrency());
            this.setAsstActTypeId(formulaParam.getAsstActType());
            this.setAsstActGroup(ctx, formulaParam.getAsstActGroup());
            formulaParam.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
            String sheetName = param.getSheetName();
            try {
                ARAPReportBatchUtils.reviseArApBalanceParameters(ctx, formulaParam, sheetName, reportVariables, reportAdapter);
                i += this.addParam(formulaParam);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                FormulaValueBackfill.setException((Parameter)param, (Throwable)e);
            }
            try {
                this.innerExecute();
                continue;
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                for (i = lastQueryIndex; i < queryIndex; ++i) {
                    FormulaValueBackfill.setException((Parameter)paramArray.getParameter(i), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected String getSqlByID(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getReturnType()).append(") ").append(this.getReturnField());
        sql.append(" from t_ar_arbalance ").append(" BILL");
        sql.append(" left join ").append(this.asstActTypeInfo.getRealtionDataObject()).append(" AsstAct on AsstAct.fid = BILL.fasstactid ");
        sql.append(ARAPReportBatchUtils.getAsstActGroupSql(this.asstActTypeInfo, this.asstActGroup));
        sql.append(" where fbalType = 101 ");
        sql.append(this.getCompany(group));
        sql.append(this.getCurrencyId());
        sql.append(this.getPeriodInfoId());
        sql.append(this.getAsstActTypeId());
        sql.append(this.getAsstActGroup());
        sql.append(this.getAsstActId(group));
        return sql.toString();
    }
}

