/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.IOtherBillentry;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.IPayRequestBillEntry;
import com.kingdee.eas.fi.ap.IPayRequestSumEntry;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryFactory;
import com.kingdee.eas.fi.ar.ArApBillBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IArApBillPlanBase;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillPlanFactory;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentBillEntry;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryFactory;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillEntryInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArApBillReverseHelper {
    public static final Logger logger = Logger.getLogger(ArApBillReverseHelper.class);
    public static final BigDecimal ZERO = SysConstant.BIGZERO;
    public static final BigDecimal ONE = new BigDecimal("1.00");
    private static final String RECBILL_BOSTYPE = "FA44FD5B";
    private static final String PAYBILL_BOSTYPE = "40284E81";
    private static final String ARBILL_BOSTYPE = "FC910EF3";
    private static final String APBILL_BOSTYPE = "48DA3A71";
    private static final String ARAP_RESOUREC = "com.kingdee.eas.fi.arap.ArapResource";

    private ArApBillReverseHelper() {
    }

    public static void reverseLockAmt(Context ctx, RecPayBillInfo recPayBillInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        int i;
        int k;
        FilterInfo entryFilter1;
        EntityViewInfo entryView1;
        BigDecimal thisLockAmt = ZERO;
        BigDecimal thisLockAmtLocal = ZERO;
        BigDecimal unLockAmt = ZERO;
        BigDecimal unLockAmtLocal = ZERO;
        AbstractObjectCollection entries = (AbstractObjectCollection)recPayBillInfo.get("entries");
        String destCompanyId = recPayBillInfo.getCompany().getId().toString();
        String srcCompanyId = "";
        boolean isSrcArApBill = false;
        IDynamicObject iDyna = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        HashMap<String, PayRequestBillEntryInfo> payRequestBillMap = new HashMap<String, PayRequestBillEntryInfo>();
        HashMap<String, ArApBillBaseInfo> sourceBillMap = new HashMap<String, ArApBillBaseInfo>();
        HashMap<String, String> sourceBillIDMap = new HashMap<String, String>();
        boolean isPayRequestBill = false;
        if (entries != null && entries.size() > 0 && entries.getObject(0).get("sourceBillId") != null) {
            if ("D001019A".equals(BOSUuid.read((String)entries.getObject(0).get("sourceBillId").toString()).getType().toString()) && !recPayBillInfo.isIsInitializeBill() && !recPayBillInfo.isIsTransBill()) {
                isPayRequestBill = true;
            }
            if (APBILL_BOSTYPE.equals(BOSUuid.read((String)entries.getObject(0).get("sourceBillId").toString()).getType().toString()) || ARBILL_BOSTYPE.equals(BOSUuid.read((String)entries.getObject(0).get("sourceBillId").toString()).getType().toString())) {
                isSrcArApBill = true;
            }
        }
        ArApBillReverseHelper.lockBillBeforeReverse(ctx, entries);
        if (isPayRequestBill) {
            ArApBillReverseHelper.reversePayreqBillLockAmt(ctx, (PaymentBillInfo)recPayBillInfo, bOTBillOperStateEnum);
            return;
        }
        if (isPayRequestBill) {
            HashSet<Object> entrysIDSet = new HashSet<Object>();
            int k2 = entries.size();
            for (int i2 = 0; i2 < k2; ++i2) {
                entrysIDSet.add(entries.getObject(i2).get("sourceBillEntryId"));
            }
            entryView1 = new EntityViewInfo();
            entryView1.getSelector().add(new SelectorItemInfo("id"));
            entryView1.getSelector().add(new SelectorItemInfo("number"));
            entryView1.getSelector().add(new SelectorItemInfo("sourceBillId"));
            entryView1.getSelector().add(new SelectorItemInfo("sourceBillEntryid"));
            entryFilter1 = new FilterInfo();
            entryFilter1.getFilterItems().add(new FilterItemInfo("id", entrysIDSet, CompareType.INCLUDE));
            entryView1.setFilter(entryFilter1);
            AbstractObjectCollection entryCollection1 = null;
            BOSObjectType srcEntryBosType1 = null;
            srcEntryBosType1 = BOSUuid.read((String)entries.getObject(0).get("sourceBillEntryId").toString()).getType();
            entryCollection1 = (AbstractObjectCollection)iDyna.getCollection(srcEntryBosType1, entryView1);
            k = entryCollection1.size();
            for (i = 0; i < k; ++i) {
                PayRequestBillEntryInfo destEntryInfo = (PayRequestBillEntryInfo)entryCollection1.getObject(i);
                payRequestBillMap.put(destEntryInfo.getId().toString(), destEntryInfo);
            }
            k = entries.size();
            for (i = 0; i < k; ++i) {
                PayRequestBillEntryInfo payRequestEntryInfo;
                RecPayBillEntryInfo recPayEntryInfo = (RecPayBillEntryInfo)entries.getObject(i);
                if (recPayEntryInfo.getSourceBillId() == null || recPayEntryInfo.getSourceBillEntryId() == null || (payRequestEntryInfo = (PayRequestBillEntryInfo)payRequestBillMap.get(recPayEntryInfo.getSourceBillEntryId().toString())) == null || payRequestEntryInfo.getId() == null || payRequestEntryInfo.getSourceBillId() == null || payRequestEntryInfo.getSourceBillEntryid() == null || !APBILL_BOSTYPE.equals(BOSUuid.read((String)payRequestEntryInfo.getSourceBillId().toString()).getType().toString()) || !recPayEntryInfo.getSourceBillEntryId().toString().equals(payRequestEntryInfo.getId().toString()) || sourceBillIDMap.containsKey(payRequestEntryInfo.getSourceBillId().toString())) continue;
                sourceBillIDMap.put(payRequestEntryInfo.getSourceBillId().toString(), recPayEntryInfo.getSourceBillId().toString());
            }
        }
        if (isSrcArApBill || isPayRequestBill) {
            HashSet<Object> idSet = new HashSet<Object>();
            int k3 = entries.size();
            for (int i3 = 0; i3 < k3; ++i3) {
                idSet.add(entries.getObject(i3).get("sourceBillId"));
            }
            entryView1 = new EntityViewInfo();
            entryView1.getSelector().add(new SelectorItemInfo("id"));
            entryView1.getSelector().add(new SelectorItemInfo("number"));
            entryView1.getSelector().add(new SelectorItemInfo("sourceBillId"));
            entryView1.getSelector().add(new SelectorItemInfo("sourceBillEntryid"));
            entryFilter1 = new FilterInfo();
            entryFilter1.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            entryView1.setFilter(entryFilter1);
            AbstractObjectCollection infoCollection1 = null;
            BOSObjectType srcBosType1 = null;
            srcBosType1 = BOSUuid.read((String)entries.getObject(0).get("sourceBillId").toString()).getType();
            if (srcBosType1.toString().equals(ARBILL_BOSTYPE) || srcBosType1.toString().equals(APBILL_BOSTYPE)) {
                infoCollection1 = (AbstractObjectCollection)iDyna.getCollection(srcBosType1, entryView1);
                k = infoCollection1.size();
                for (i = 0; i < k; ++i) {
                    ArApBillBaseInfo destInfo = (ArApBillBaseInfo)infoCollection1.getObject(i);
                    String payReqId = sourceBillIDMap.get(destInfo.getId().toString()) == null ? destInfo.getId().toString() : sourceBillIDMap.get(destInfo.getId().toString()).toString();
                    sourceBillMap.put(payReqId, destInfo);
                }
            }
        }
        HashSet<Object> entryIDSet = new HashSet<Object>();
        boolean isFromARAP = false;
        BOSObjectType srcEntryBosType = null;
        BOSObjectType destEntryBosType = null;
        for (int i4 = 0; i4 < entries.size(); ++i4) {
            entryIDSet.add(entries.getObject(i4).get("sourceBillEntryId"));
            if (!isFromARAP && (entries.getObject(i4).get("sourceBillEntryId") == null || !BOSUuid.isValidLength((String)entries.getObject(i4).get("sourceBillEntryId").toString()) || !"ED4DBC81".equals(BOSUuid.read((String)entries.getObject(i4).get("sourceBillEntryId").toString()).getType().toString()) && !"BC91693F".equals(BOSUuid.read((String)entries.getObject(i4).get("sourceBillEntryId").toString()).getType().toString()))) continue;
            isFromARAP = true;
            srcEntryBosType = BOSUuid.read((String)entries.getObject(i4).get("sourceBillEntryId").toString()).getType();
            destEntryBosType = entries.getObject(i4).getBOSType();
        }
        AbstractObjectCollection entryCollection = null;
        Connection conn = null;
        IORMappingDAO srcDAO = null;
        IORMappingDAO destDAO = null;
        try {
            if (isFromARAP) {
                conn = EJBFactory.getConnection((Context)ctx);
                EntityViewInfo entryView = new EntityViewInfo();
                entryView.getSelector().add(new SelectorItemInfo("*"));
                entryView.getSelector().add(new SelectorItemInfo("head.exchangeRate"));
                entryView.getSelector().add(new SelectorItemInfo("head.currency.*"));
                entryView.getSelector().add(new SelectorItemInfo("head.company.id"));
                FilterInfo entryFilter = new FilterInfo();
                entryFilter.getFilterItems().add(new FilterItemInfo("id", entryIDSet, CompareType.INCLUDE));
                entryView.setFilter(entryFilter);
                entryCollection = (AbstractObjectCollection)iDyna.getCollection(srcEntryBosType, entryView);
                srcDAO = ORMappingDAO.getInstance((BOSObjectType)srcEntryBosType, (Context)ctx, (Connection)conn);
                destDAO = ORMappingDAO.getInstance((BOSObjectType)destEntryBosType, (Context)ctx, (Connection)conn);
            }
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add(new SelectorItemInfo("precision"));
            selectorColl.add(new SelectorItemInfo("id"));
            selectorColl.add(new SelectorItemInfo("number"));
            selectorColl.add(new SelectorItemInfo("name"));
            CurrencyInfo baseCurrencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(recPayBillInfo.getCompany().getBaseCurrency().getId()), selectorColl);
            int locPrecision = baseCurrencyInfo.getPrecision();
            boolean isDirectExchange = true;
            if (entryCollection != null && entryCollection.size() > 0) {
                ArApBillEntryBaseInfo tempSrcEntryInfo = (ArApBillEntryBaseInfo)entryCollection.getObject(0);
                CurrencyInfo currcenyInfo = tempSrcEntryInfo.getParent().getCurrency();
                ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)recPayBillInfo.getCompany(), (CurrencyInfo)currcenyInfo, (Date)new Date());
                if (rateInfo != null) {
                    isDirectExchange = ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode());
                }
            }
            BigDecimal uValue = new BigDecimal("-1");
            String logSql = "insert into t_arap_log(fsrcbillid,fsrcbillentryid,FLOCKUNVERIFYAMT,FLOCKVERIFYAMT,FAmount,";
            logSql = logSql + "fdestbillid,fdestbillentryid,fremark)";
            logSql = logSql + "values(?,?,?,?,?,?,?,?)";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            int size = entries.size();
            for (int i5 = 0; i5 < size; ++i5) {
                BigDecimal srcExchangeRate;
                RecPayBillEntryInfo recPayEntryInfo = (RecPayBillEntryInfo)entries.getObject(i5);
                ObjectStringPK srcEntryPK = new ObjectStringPK(recPayEntryInfo.getSourceBillEntryId());
                if (recPayEntryInfo.getId() == null) continue;
                ObjectStringPK destEntryPK = new ObjectStringPK(recPayEntryInfo.getId().toString());
                if (entryCollection == null || !entryCollection.containsKey((Object)BOSUuid.read((String)recPayEntryInfo.getSourceBillEntryId()))) continue;
                ArApBillEntryBaseInfo srcEntryInfo = (ArApBillEntryBaseInfo)entryCollection.getObject((Object)BOSUuid.read((String)recPayEntryInfo.getSourceBillEntryId()));
                if (srcEntryInfo != null && srcEntryInfo.getParent() != null && srcEntryInfo.getParent().getCompany() != null && StringUtils.isEmpty((String)srcCompanyId)) {
                    srcCompanyId = srcEntryInfo.getParent().getCompany().getId().toString();
                }
                if ((srcExchangeRate = srcEntryInfo.getParent().getExchangeRate()) == null || srcExchangeRate != null && srcExchangeRate.compareTo(ZERO) == 0) {
                    srcExchangeRate = ONE;
                }
                BigDecimal preLockAmt = recPayEntryInfo.getLockAmt() == null ? ZERO : recPayEntryInfo.getLockAmt();
                BigDecimal preLockAmtLocal = recPayEntryInfo.getLockLocAmt();
                thisLockAmt = recPayEntryInfo.getAmount();
                thisLockAmtLocal = recPayEntryInfo.getLocalAmt();
                thisLockAmt = thisLockAmt == null ? ZERO : thisLockAmt;
                thisLockAmtLocal = thisLockAmtLocal == null ? ZERO : thisLockAmtLocal;
                unLockAmt = srcEntryInfo.getLockUnVerifyAmt();
                unLockAmtLocal = srcEntryInfo.getLockUnVerifyAmtLocal();
                unLockAmt = unLockAmt == null ? ZERO : unLockAmt;
                BigDecimal bigDecimal = unLockAmtLocal = unLockAmtLocal == null ? ZERO : unLockAmtLocal;
                if (unLockAmt.multiply(thisLockAmt).signum() < 0) {
                    logger.error((Object)"reverseLockAmtError: redBlueBill error");
                    boolean isAR = recPayBillInfo.getId().getType().toString().equalsIgnoreCase(RECBILL_BOSTYPE);
                    String writeBackErrorMsg = null;
                    ArApBillBaseInfo arApBillBaseInfo = (ArApBillBaseInfo)sourceBillMap.get(recPayEntryInfo.getSourceBillId().toString());
                    String number = arApBillBaseInfo == null ? "" : arApBillBaseInfo.getNumber();
                    Object[] param = new String[]{recPayBillInfo.getNumber(), String.valueOf(recPayEntryInfo.getSeq()), thisLockAmt.toString(), number, String.valueOf(srcEntryInfo.getSeq()), unLockAmt.toString()};
                    writeBackErrorMsg = isAR ? ArApBillHelper.getResourceStr(ctx, ARAP_RESOUREC, "AR_AMOUNT_SIGNUM_NOT_SAME", param) : ArApBillHelper.getResourceStr(ctx, ARAP_RESOUREC, "AP_AMOUNT_SIGNUM_NOT_SAME", param);
                    throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{writeBackErrorMsg});
                }
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                    if (unLockAmt.compareTo(thisLockAmt) == 0) {
                        srcEntryInfo.setLockUnVerifyAmt(ZERO);
                        srcEntryInfo.setLockUnVerifyAmtLocal(ZERO);
                    } else if (thisLockAmt.abs().compareTo(unLockAmt.abs()) < 0) {
                        srcEntryInfo.setLockUnVerifyAmt(unLockAmt.subtract(thisLockAmt));
                        if (srcExchangeRate.compareTo(ONE) == 0) {
                            srcEntryInfo.setLockUnVerifyAmtLocal(unLockAmtLocal.subtract(thisLockAmt));
                        } else {
                            BigDecimal thisLockAmtLocal_arap = ZERO;
                            thisLockAmtLocal_arap = isDirectExchange ? thisLockAmt.multiply(srcExchangeRate).setScale(locPrecision, 4) : thisLockAmt.divide(srcExchangeRate, locPrecision, 4);
                            srcEntryInfo.setLockUnVerifyAmtLocal(unLockAmtLocal.subtract(thisLockAmtLocal_arap));
                        }
                    } else {
                        logger.error((Object)("reverseLockAmtAddNewError: thisLockAmt:" + thisLockAmt + ",unLockAmt:" + unLockAmt));
                        boolean isAR = recPayBillInfo.getId().getType().toString().equalsIgnoreCase(RECBILL_BOSTYPE);
                        String writeBackErrorMsg = ArApBillReverseHelper.getWriteBackErrorMsg(ctx, recPayBillInfo, recPayEntryInfo, sourceBillMap, srcEntryInfo, thisLockAmt, unLockAmt);
                        throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{writeBackErrorMsg});
                    }
                    if (!isSrcArApBill || StringUtils.isEmpty((String)destCompanyId) || StringUtils.isEmpty((String)srcCompanyId) || destCompanyId.equals(srcCompanyId)) {
                        recPayEntryInfo.setLockAmt(thisLockAmt);
                        recPayEntryInfo.setLockLocAmt(thisLockAmtLocal);
                        recPayEntryInfo.setUnLockAmt(ZERO);
                        recPayEntryInfo.setUnLockLocAmt(ZERO);
                    }
                    paramList.add(new Object[]{srcEntryInfo.getParent().getId().toString(), srcEntryInfo.getId().toString(), thisLockAmt.multiply(uValue), thisLockAmt, srcEntryInfo.getAmount().add(srcEntryInfo.getTaxAmount()), recPayBillInfo.getId().toString(), recPayEntryInfo.getId().toString(), bOTBillOperStateEnum.getAlias()});
                } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                    if (isSrcArApBill && !StringUtils.isEmpty((String)destCompanyId) && !StringUtils.isEmpty((String)srcCompanyId) && !destCompanyId.equals(srcCompanyId)) {
                        preLockAmt = recPayEntryInfo.getAmount();
                        preLockAmtLocal = recPayEntryInfo.getLocalAmt();
                    }
                    if (preLockAmt.abs().compareTo(srcEntryInfo.getRecievePayAmount().abs()) > 0) {
                        logger.error((Object)("reverseLockAmtDeleteError: thisLockAmt:" + thisLockAmt + ",unLockAmt:" + unLockAmt));
                        String writeBackErrorMsg = ArApBillReverseHelper.getWriteBackErrorMsg(ctx, recPayBillInfo, recPayEntryInfo, sourceBillMap, srcEntryInfo, preLockAmt, srcEntryInfo.getRecievePayAmount());
                        throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{writeBackErrorMsg});
                    }
                    srcEntryInfo.setLockUnVerifyAmt(unLockAmt.add(preLockAmt));
                    if (srcEntryInfo.getRecievePayAmount().compareTo(srcEntryInfo.getLockUnVerifyAmt()) == 0) {
                        srcEntryInfo.setLockUnVerifyAmtLocal(srcEntryInfo.getRecievePayAmountLocal());
                    } else if (srcExchangeRate.compareTo(ONE) == 0) {
                        srcEntryInfo.setLockUnVerifyAmtLocal(unLockAmtLocal.add(preLockAmt));
                    } else {
                        preLockAmtLocal = isDirectExchange ? preLockAmt.multiply(srcExchangeRate).setScale(locPrecision, 4) : preLockAmt.divide(srcExchangeRate, locPrecision, 4);
                        srcEntryInfo.setLockUnVerifyAmtLocal(unLockAmtLocal.add(preLockAmtLocal));
                    }
                    if (!isSrcArApBill || StringUtils.isEmpty((String)destCompanyId) || StringUtils.isEmpty((String)srcCompanyId) || destCompanyId.equals(srcCompanyId)) {
                        recPayEntryInfo.setLockAmt(ZERO);
                        recPayEntryInfo.setLockLocAmt(ZERO);
                        recPayEntryInfo.setUnLockAmt(thisLockAmt);
                        recPayEntryInfo.setUnLockLocAmt(thisLockAmtLocal);
                        if (iDyna.exists(destEntryBosType, (IObjectPK)destEntryPK) && destDAO != null) {
                            destDAO.updateBatch((IObjectPK)destEntryPK, (IObjectValue)recPayEntryInfo);
                        }
                    }
                    paramList.add(new Object[]{srcEntryInfo.getParent().getId().toString(), srcEntryInfo.getId().toString(), preLockAmt, preLockAmt.multiply(uValue), srcEntryInfo.getAmount().add(srcEntryInfo.getTaxAmount()), recPayBillInfo.getId().toString(), recPayEntryInfo.getId().toString(), bOTBillOperStateEnum.getAlias()});
                }
                srcEntryInfo.setLockVerifyAmt(srcEntryInfo.getRecievePayAmount().subtract(srcEntryInfo.getLockUnVerifyAmt()));
                srcEntryInfo.setLockVerifyAmtLocal(srcEntryInfo.getRecievePayAmountLocal().subtract(srcEntryInfo.getLockUnVerifyAmtLocal()));
                if (srcDAO == null) continue;
                srcDAO.updateBatch((IObjectPK)srcEntryPK, (IObjectValue)srcEntryInfo);
            }
            if (paramList.size() > 0 && ArApBillReverseHelper.isWriteLog(ctx).booleanValue()) {
                DbUtil.executeBatch((Context)ctx, (String)logSql, paramList);
            }
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum) && destDAO != null) {
                destDAO.executeBatch();
            }
            if (srcDAO != null) {
                srcDAO.executeBatch();
                ArApBillReverseHelper.reversePlanAmount(ctx, null, entryCollection);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
    }

    public static void lockBillBeforeReverse(Context ctx, AbstractObjectCollection entries) throws BOSException {
        IObjectValue entryInfo = null;
        String sourceEntryId = null;
        String soureEntryIdStr = "";
        StringBuilder soureEntryIds = new StringBuilder();
        BOSObjectType type = null;
        int size = entries.size();
        for (int j = 0; j < size; ++j) {
            entryInfo = entries.getObject(0);
            String string = sourceEntryId = entryInfo.get("sourceBillEntryId") == null ? null : entryInfo.get("sourceBillEntryId").toString();
            if (StringUtils.isEmpty((String)sourceEntryId)) continue;
            type = BOSUuid.read((String)sourceEntryId).getType();
            soureEntryIds.append("'").append(sourceEntryId).append("'").append(",");
        }
        if (soureEntryIds.length() > 0) {
            soureEntryIdStr = soureEntryIds.substring(0, soureEntryIds.length() - 1);
            EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(type);
            String tableName = eoi.getTable().getName();
            String lockSql = "UPDATE " + tableName + " SET FID = FID WHERE FID IN (" + soureEntryIdStr + ")";
            DbUtil.execute((Context)ctx, (String)lockSql);
        }
    }

    public static void reversePlanAmount(Context ctx, ArApBillBaseInfo info, AbstractObjectCollection entryCollection) throws BOSException, EASBizException {
        if (entryCollection == null || entryCollection.size() == 0) {
            return;
        }
        ArApBillEntryBaseInfo entryInfo = null;
        HashSet<String> idSet = new HashSet<String>();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (ArApBillEntryBaseInfo)entryCollection.getObject(i);
            if (entryInfo.get("head") == null) {
                entryInfo.setParent(info);
            }
            if (entryInfo.get("head") instanceof ArApBillBaseInfo) {
                idSet.add(entryInfo.getParent().getId().toString());
                continue;
            }
            if (!(entryInfo.get("head") instanceof BOSUuid)) continue;
            idSet.add(entryInfo.get("head").toString());
        }
        IArApBillPlanBase iPlanBase = null;
        IArApBillBase iArApBillBase = null;
        boolean isAR = false;
        if (entryInfo instanceof com.kingdee.eas.fi.ap.OtherBillentryInfo) {
            iPlanBase = com.kingdee.eas.fi.ap.OtherBillPlanFactory.getLocalInstance(ctx);
            iArApBillBase = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
            isAR = false;
        } else if (entryInfo instanceof OtherBillentryInfo) {
            iPlanBase = OtherBillPlanFactory.getLocalInstance(ctx);
            iArApBillBase = OtherBillFactory.getLocalInstance(ctx);
            isAR = true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fiterInfo = new FilterInfo();
        FilterItemInfo idFilter = new FilterItemInfo("id", idSet, CompareType.INCLUDE);
        fiterInfo.getFilterItems().add(idFilter);
        view.setFilter(fiterInfo);
        view.setSelector(ArApBillReverseHelper.getSelector(isAR));
        ArApBillBaseCollection otherBillColl = iArApBillBase.getArApBillBaseCollection(view);
        ArApBillBaseInfo otherBillInfo = null;
        CoreBaseCollection coreBaseColl = new CoreBaseCollection();
        int size2 = otherBillColl.size();
        for (int i = 0; i < size2; ++i) {
            otherBillInfo = otherBillColl.get(i);
            otherBillInfo.lockPlans();
            coreBaseColl.addObjectCollection((IObjectCollection)otherBillInfo.getPlans());
        }
        if (iPlanBase != null) {
            iPlanBase.update(coreBaseColl);
        }
    }

    public static void reversePlanAmount(Context ctx, boolean isAR, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        IArApBillPlanBase iPlanBase = null;
        IArApBillBase iArApBillBase = null;
        if (isAR) {
            iPlanBase = OtherBillPlanFactory.getLocalInstance(ctx);
            iArApBillBase = OtherBillFactory.getLocalInstance(ctx);
        } else {
            iPlanBase = com.kingdee.eas.fi.ap.OtherBillPlanFactory.getLocalInstance(ctx);
            iArApBillBase = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fiterInfo = new FilterInfo();
        FilterItemInfo idFilter = new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE);
        fiterInfo.getFilterItems().add(idFilter);
        view.setFilter(fiterInfo);
        view.setSelector(ArApBillReverseHelper.getSelector(isAR));
        ArApBillBaseCollection otherBillColl = iArApBillBase.getArApBillBaseCollection(view);
        ArApBillBaseInfo otherBillInfo = null;
        CoreBaseCollection coreBaseColl = new CoreBaseCollection();
        int size = otherBillColl.size();
        for (int i = 0; i < size; ++i) {
            otherBillInfo = otherBillColl.get(i);
            otherBillInfo.lockPlans();
            coreBaseColl.addObjectCollection((IObjectCollection)otherBillInfo.getPlans());
        }
        iPlanBase.update(coreBaseColl);
    }

    private static boolean isRecReverseLockAmount(Context ctx, String id) throws BOSException, EASBizException {
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance((Context)ctx);
        return iReceivingBill.exists("SELECT isReverseLockAmount WHERE isReverseLockAmount = 1 AND id = '" + id + "'");
    }

    private static boolean isPayReverseLockAmount(Context ctx, String id) throws BOSException, EASBizException {
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        return iPaymentBill.exists("SELECT isReverseLockAmount WHERE isReverseLockAmount = 1 AND id = '" + id + "'");
    }

    protected static SelectorItemCollection getSelector(boolean isAR) {
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("entry.recievePayAmount"));
        selCol.add(new SelectorItemInfo("entry.recievePayAmountLocal"));
        selCol.add(new SelectorItemInfo("entry.amount"));
        selCol.add(new SelectorItemInfo("entry.taxAmount"));
        selCol.add(new SelectorItemInfo("entry.unVerifyAmount"));
        selCol.add(new SelectorItemInfo("entry.unVerifyAmountLocal"));
        selCol.add(new SelectorItemInfo("entry.verifyAmount"));
        selCol.add(new SelectorItemInfo("entry.verifyAmountLocal"));
        selCol.add(new SelectorItemInfo("entry.lockVerifyAmt"));
        selCol.add(new SelectorItemInfo("entry.lockVerifyAmtLocal"));
        selCol.add(new SelectorItemInfo("entry.lockUnVerifyAmt"));
        selCol.add(new SelectorItemInfo("entry.lockUnVerifyAmtLocal"));
        String planStr = isAR ? "recievePlan" : "payPlan";
        selCol.add(new SelectorItemInfo(planStr + ".recievePayAmount"));
        selCol.add(new SelectorItemInfo(planStr + ".recievePayAmountLocal"));
        selCol.add(new SelectorItemInfo(planStr + ".recievePayDate"));
        return selCol;
    }

    private static String getWriteBackErrorMsg(Context ctx, RecPayBillInfo recPayBillInfo, RecPayBillEntryInfo recPayEntryInfo, Map sourceBillMap, ArApBillEntryBaseInfo srcEntryInfo, BigDecimal thisLockAmt, BigDecimal unLockAmt) throws OtherBillBizException {
        boolean isRec = recPayBillInfo.getId().getType().toString().equalsIgnoreCase(RECBILL_BOSTYPE);
        String writeBackErrorMsg = null;
        ArApBillBaseInfo arApBillBaseInfo = (ArApBillBaseInfo)sourceBillMap.get(recPayEntryInfo.getSourceBillId().toString());
        String number = arApBillBaseInfo == null ? "" : arApBillBaseInfo.getNumber();
        Object[] param = new String[]{recPayBillInfo.getNumber(), String.valueOf(recPayEntryInfo.getSeq()), thisLockAmt.toString(), number, String.valueOf(srcEntryInfo.getSeq()), unLockAmt.toString()};
        writeBackErrorMsg = isRec ? ArApBillHelper.getResourceStr(ctx, ARAP_RESOUREC, "REC_AMOUNT_LITTER_UNLOCK_AMOUNT", param) : ArApBillHelper.getResourceStr(ctx, ARAP_RESOUREC, "PAY_AMOUNT_LITTER_UNLOCK_AMOUNT", param);
        return writeBackErrorMsg;
    }

    public static void reverseArApLockAmt4PayReq(Context ctx, PayRequestBillInfo payReqBillInfo, BizActionEnum bizAction) throws EASBizException, BOSException {
        FilterInfo entryFilter;
        IOtherBillentry iOtherbillEntry = null;
        IPayRequestBillEntry iPayRequestBillEntry = null;
        if (null == ctx) {
            iOtherbillEntry = OtherBillentryFactory.getRemoteInstance();
            iPayRequestBillEntry = PayRequestBillEntryFactory.getRemoteInstance();
        } else {
            iOtherbillEntry = OtherBillentryFactory.getLocalInstance(ctx);
            iPayRequestBillEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
        }
        PayRequestBillEntryInfo requestEntryInfo = null;
        String sourceEntryId = null;
        String destEntryId = null;
        HashSet<String> srcEntryIdSet = new HashSet<String>();
        HashSet<String> destEntryIdSet = new HashSet<String>();
        PayRequestBillEntryCollection requestEntryColl = payReqBillInfo.getEntrys();
        ArApBillReverseHelper.lockBillBeforeReverse(ctx, requestEntryColl);
        Iterator requestEntryCollIte = requestEntryColl.iterator();
        while (requestEntryCollIte.hasNext()) {
            requestEntryInfo = (PayRequestBillEntryInfo)requestEntryCollIte.next();
            sourceEntryId = requestEntryInfo.getSourceBillEntryId();
            if (null != requestEntryInfo.getId() && !StringUtils.isEmpty((String)requestEntryInfo.getId().toString())) {
                destEntryId = requestEntryInfo.getId().toString();
                destEntryIdSet.add(destEntryId);
            }
            if (StringUtils.isEmpty((String)sourceEntryId)) continue;
            srcEntryIdSet.add(sourceEntryId);
        }
        if (srcEntryIdSet.size() == 0) {
            return;
        }
        PayRequestBillEntryCollection destEntryColl = null;
        if (BizActionEnum.DELETE.equals((Object)bizAction)) {
            EntityViewInfo destEntryView = new EntityViewInfo();
            destEntryView.getSelector().add(new SelectorItemInfo("id"));
            destEntryView.getSelector().add(new SelectorItemInfo("auditAmount"));
            destEntryView.getSelector().add(new SelectorItemInfo("auditAmountLoc"));
            entryFilter = new FilterInfo();
            entryFilter.getFilterItems().add(new FilterItemInfo("id", destEntryIdSet, CompareType.INCLUDE));
            destEntryView.setFilter(entryFilter);
            destEntryColl = iPayRequestBillEntry.getPayRequestBillEntryCollection(destEntryView);
        }
        EntityViewInfo entryView = new EntityViewInfo();
        entryView.getSelector().add(new SelectorItemInfo("id"));
        entryView.getSelector().add(new SelectorItemInfo("head.id"));
        entryView.getSelector().add(new SelectorItemInfo("head.exchangeRate"));
        entryView.getSelector().add(new SelectorItemInfo("head.currency.id"));
        entryView.getSelector().add(new SelectorItemInfo("head.currency.precision"));
        entryView.getSelector().add(new SelectorItemInfo("head.company.id"));
        entryView.getSelector().add(new SelectorItemInfo("head.company.baseCurrency.precision"));
        entryView.getSelector().add(new SelectorItemInfo("head.billDate"));
        entryView.getSelector().add(new SelectorItemInfo("lockVerifyAmt"));
        entryView.getSelector().add(new SelectorItemInfo("lockVerifyAmtLocal"));
        entryView.getSelector().add(new SelectorItemInfo("lockUnVerifyAmt"));
        entryView.getSelector().add(new SelectorItemInfo("lockUnVerifyAmtLocal"));
        entryView.getSelector().add(new SelectorItemInfo("recievePayAmount"));
        entryView.getSelector().add(new SelectorItemInfo("recievePayAmountLocal"));
        entryView.getSelector().add(new SelectorItemInfo("amount"));
        entryView.getSelector().add(new SelectorItemInfo("taxAmount"));
        entryFilter = new FilterInfo();
        entryFilter.getFilterItems().add(new FilterItemInfo("id", srcEntryIdSet, CompareType.INCLUDE));
        entryView.setFilter(entryFilter);
        OtherBillentryCollection srcEntryColl = iOtherbillEntry.getOtherBillentryCollection(entryView);
        if (null == srcEntryColl || srcEntryColl.size() == 0) {
            return;
        }
        Integer entrySeq = null;
        BigDecimal auditAmt = null;
        BigDecimal thisLockAmt = null;
        BigDecimal thisLockAmtLoc = null;
        BigDecimal srcLockAmt = null;
        BigDecimal srcRecPayAmt = null;
        BigDecimal preLockAmt = null;
        BigDecimal preLockAmtLoc = null;
        PayRequestBillEntryInfo oldEntryInfo = null;
        com.kingdee.eas.fi.ap.OtherBillentryInfo srcEntryInfo = null;
        StringBuilder exceptionBuilder = new StringBuilder();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String lockSymbol = BizActionEnum.DELETE.equals((Object)bizAction) || BizActionEnum.CLOSE.equals((Object)bizAction) ? "-" : "+";
        String unlockSymbol = BizActionEnum.DELETE.equals((Object)bizAction) || BizActionEnum.CLOSE.equals((Object)bizAction) ? "+" : "-";
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("UPDATE T_AP_OTHERBILLENTRY ");
        updateSql.append(" SET FLOCKVERIFYAMT = FLOCKVERIFYAMT ").append(lockSymbol).append("? ,");
        updateSql.append("     FLOCKVERIFYAMTLOCAL = FLOCKVERIFYAMTLOCAL ").append(lockSymbol).append("? ,");
        updateSql.append("     FLOCKUNVERIFYAMT = FLOCKUNVERIFYAMT ").append(unlockSymbol).append("? ,");
        updateSql.append("     FLOCKUNVERIFYAMTLOCAL = FLOCKUNVERIFYAMTLOCAL ").append(unlockSymbol).append("?");
        updateSql.append(" WHERE FID = ?");
        String logSql = "insert into t_arap_log(fsrcbillid,fsrcbillentryid,FLOCKUNVERIFYAMT,FLOCKVERIFYAMT,FAmount,";
        logSql = logSql + "fdestbillid,fdestbillentryid,fremark)";
        logSql = logSql + "values(?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        BigDecimal uValue = new BigDecimal("-1");
        requestEntryCollIte = requestEntryColl.iterator();
        String srcBillID = null;
        boolean isDirectExchangeRate = true;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        int precision = 2;
        int originPrecision = 2;
        HashMap<String, BigDecimal> otherBillEntryAmtMap = new HashMap<String, BigDecimal>();
        while (requestEntryCollIte.hasNext()) {
            requestEntryInfo = (PayRequestBillEntryInfo)requestEntryCollIte.next();
            entrySeq = requestEntryInfo.getSeq();
            sourceEntryId = requestEntryInfo.getSourceBillEntryId();
            if (!srcEntryColl.contains(BOSUuid.read((String)sourceEntryId))) continue;
            srcEntryInfo = srcEntryColl.get(BOSUuid.read((String)sourceEntryId));
            if (null == srcBillID || !srcBillID.equals(srcEntryInfo.getParent().getId().toString())) {
                srcBillID = srcEntryInfo.getParent().getId().toString();
                isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate((ExchangeRateInfo)BaseDataUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)srcEntryInfo.getParent().getCompany(), (CurrencyInfo)srcEntryInfo.getParent().getCurrency(), (Date)srcEntryInfo.getParent().getBizDate()));
                exchangeRate = srcEntryInfo.getParent().getExchangeRate();
                precision = srcEntryInfo.getParent().getCompany().getBaseCurrency().getPrecision();
                originPrecision = srcEntryInfo.getParent().getCurrency().getPrecision();
                precision = precision == 0 ? 2 : precision;
                originPrecision = originPrecision == 0 ? 2 : originPrecision;
            }
            thisLockAmt = BizActionEnum.CLOSE.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction) ? requestEntryInfo.getAuditAmount().subtract(requestEntryInfo.getTotalPayAmt()) : requestEntryInfo.getAuditAmount();
            thisLockAmtLoc = srcEntryInfo.getLockUnVerifyAmt().compareTo(thisLockAmt) == 0 ? srcEntryInfo.getLockUnVerifyAmtLocal() : BaseDataUtil.caculateLocalAmount((BigDecimal)thisLockAmt, (BigDecimal)exchangeRate, (boolean)isDirectExchangeRate, (int)precision);
            auditAmt = requestEntryInfo.getAuditAmount();
            srcRecPayAmt = srcEntryInfo.getRecievePayAmount();
            srcLockAmt = (BigDecimal)otherBillEntryAmtMap.get(srcEntryInfo.getId().toString());
            if (srcLockAmt == null) {
                srcLockAmt = null == srcEntryInfo.getLockVerifyAmt() ? BigDecimal.ZERO : srcEntryInfo.getLockVerifyAmt();
                otherBillEntryAmtMap.put(srcEntryInfo.getId().toString(), srcLockAmt.add(auditAmt));
            }
            if (null != destEntryColl && destEntryColl.contains(requestEntryInfo.getId())) {
                oldEntryInfo = destEntryColl.get(requestEntryInfo.getId());
                preLockAmt = oldEntryInfo.getAuditAmount();
                preLockAmtLoc = srcEntryInfo.getLockVerifyAmt().compareTo(preLockAmt) == 0 ? srcEntryInfo.getLockVerifyAmtLocal() : BaseDataUtil.caculateLocalAmount((BigDecimal)oldEntryInfo.getAuditAmount(), (BigDecimal)exchangeRate, (boolean)isDirectExchangeRate, (int)precision);
            } else {
                preLockAmt = thisLockAmt;
                preLockAmtLoc = thisLockAmtLoc;
            }
            boolean checkPassed = true;
            if (srcRecPayAmt.multiply(thisLockAmt).signum() < 0) {
                exceptionBuilder.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"Entry_diff_symbol_msg", (Locale)ctx.getLocale(), (Object[])new Object[]{entrySeq, thisLockAmt, srcRecPayAmt})).append("\n");
                checkPassed = false;
            }
            if (BizActionEnum.DELETE.equals((Object)bizAction)) {
                if (preLockAmt.abs().compareTo(srcLockAmt.abs()) > 0) {
                    exceptionBuilder.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"Entry_lockAmt_gt_srcLockAmt_msg", (Locale)ctx.getLocale(), (Object[])new Object[]{entrySeq, thisLockAmt, srcLockAmt})).append("\n");
                    checkPassed = false;
                }
            } else if ((BizActionEnum.SAVE.equals((Object)bizAction) || BizActionEnum.SUBMIT.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction)) && srcLockAmt.add(thisLockAmt).abs().compareTo(srcRecPayAmt.abs()) > 0) {
                exceptionBuilder.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"Entry_amt_gt_srcAmt_msg", (Locale)ctx.getLocale(), (Object[])new Object[]{entrySeq, thisLockAmt, srcRecPayAmt, srcLockAmt})).append("\n");
                checkPassed = false;
            }
            if (!checkPassed) continue;
            String billId = BizActionEnum.CLOSE.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction) ? null : payReqBillInfo.getId().toString();
            String requestEntryId = requestEntryInfo.getId() == null ? null : requestEntryInfo.getId().toString();
            Object[] params = new Object[5];
            if (BizActionEnum.DELETE.equals((Object)bizAction)) {
                params[0] = preLockAmt;
                params[1] = preLockAmtLoc;
                params[2] = preLockAmt;
                params[3] = preLockAmtLoc;
                paramList.add(new Object[]{srcEntryInfo.getParent().getId().toString(), srcEntryInfo.getId().toString(), preLockAmt, preLockAmt.multiply(uValue), srcEntryInfo.getAmount().add(srcEntryInfo.getTaxAmount()), billId, requestEntryId, bizAction.getAlias()});
            } else {
                if (thisLockAmt != null && thisLockAmt.scale() == 0) {
                    thisLockAmt = thisLockAmt.setScale(originPrecision);
                }
                if (thisLockAmtLoc != null && thisLockAmtLoc.scale() == 0) {
                    thisLockAmtLoc = thisLockAmtLoc.setScale(precision);
                }
                params[0] = thisLockAmt;
                params[1] = thisLockAmtLoc;
                params[2] = thisLockAmt;
                params[3] = thisLockAmtLoc;
                paramList.add(new Object[]{srcEntryInfo.getParent().getId().toString(), srcEntryInfo.getId().toString(), thisLockAmt.multiply(uValue), thisLockAmt, srcEntryInfo.getAmount().add(srcEntryInfo.getTaxAmount()), billId, requestEntryId, bizAction.getAlias()});
            }
            params[4] = sourceEntryId;
            paramsList.add(params);
        }
        if (exceptionBuilder.length() > 0) {
            if (BizActionEnum.CLOSE.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction)) {
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{exceptionBuilder.toString()});
            }
            throw new com.kingdee.eas.fi.ap.OtherBillBizException(com.kingdee.eas.fi.ap.OtherBillBizException.WRITE_BACK_LOCK_AMT_ERROR, new Object[]{payReqBillInfo.getNumber(), exceptionBuilder.toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
        ArApBillReverseHelper.reversePlanAmount(ctx, null, srcEntryColl);
        if (paramList.size() > 0 && ArApBillReverseHelper.isWriteLog(ctx).booleanValue()) {
            DbUtil.executeBatch((Context)ctx, (String)logSql, paramList);
        }
    }

    @Deprecated
    public static void reverseArApLockAmt4PayReq(Context ctx, PayRequestBillInfo payReqBillInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        BizActionEnum bizAction = BizActionEnum.SAVE;
        if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            bizAction = BizActionEnum.DELETE;
        } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            bizAction = BizActionEnum.SAVE;
        }
        ArApBillReverseHelper.reverseArApLockAmt4PayReq(ctx, payReqBillInfo, bizAction);
    }

    public static void reversePayreqBillLockAmt(Context ctx, PaymentBillInfo payBillInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        FilterInfo entryFilter;
        IPaymentBillEntry iPaymentBillEntry = null;
        IPayRequestBillEntry iPayRequestBillEntry = null;
        IPayRequestBill iPayRequestBill = null;
        IPayRequestSumEntry iPayRequestSumEntry = null;
        if (null == ctx) {
            iPaymentBillEntry = PaymentBillEntryFactory.getRemoteInstance();
            iPayRequestBillEntry = PayRequestBillEntryFactory.getRemoteInstance();
            iPayRequestBill = PayRequestBillFactory.getRemoteInstance();
            iPayRequestSumEntry = PayRequestSumEntryFactory.getRemoteInstance();
        } else {
            iPaymentBillEntry = PaymentBillEntryFactory.getLocalInstance((Context)ctx);
            iPayRequestBillEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
            iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
            iPayRequestSumEntry = PayRequestSumEntryFactory.getLocalInstance(ctx);
        }
        PaymentBillEntryInfo paybillEntryInfo2 = null;
        String sourceEntryId = null;
        String sourceBillId = null;
        String destEntryId = null;
        HashSet<String> srcEntryIdSet = new HashSet<String>();
        HashSet<String> srcBillIdSet = new HashSet<String>();
        HashSet<String> destEntryIdSet = new HashSet<String>();
        PaymentBillEntryCollection payBillEntryColl = payBillInfo.getEntries();
        for (PaymentBillEntryInfo paybillEntryInfo2 : payBillEntryColl) {
            sourceEntryId = paybillEntryInfo2.getSourceBillEntryId();
            sourceBillId = paybillEntryInfo2.getSourceBillId();
            if (null != paybillEntryInfo2.getId() && !StringUtils.isEmpty((String)paybillEntryInfo2.getId().toString())) {
                destEntryId = paybillEntryInfo2.getId().toString();
                destEntryIdSet.add(destEntryId);
            }
            if (!StringUtils.isEmpty((String)sourceEntryId)) {
                srcEntryIdSet.add(sourceEntryId);
            }
            if (StringUtils.isEmpty((String)sourceBillId)) continue;
            srcBillIdSet.add(sourceBillId);
        }
        if (srcEntryIdSet.size() == 0) {
            return;
        }
        PaymentBillEntryCollection destEntryColl = null;
        if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            EntityViewInfo destEntryView = new EntityViewInfo();
            destEntryView.getSelector().add(new SelectorItemInfo("id"));
            destEntryView.getSelector().add(new SelectorItemInfo("amount"));
            destEntryView.getSelector().add(new SelectorItemInfo("localAmt"));
            entryFilter = new FilterInfo();
            entryFilter.getFilterItems().add(new FilterItemInfo("id", destEntryIdSet, CompareType.INCLUDE));
            destEntryView.setFilter(entryFilter);
            destEntryColl = iPaymentBillEntry.getPaymentBillEntryCollection(destEntryView);
        }
        EntityViewInfo entryView = new EntityViewInfo();
        entryView.getSelector().add(new SelectorItemInfo("id"));
        entryView.getSelector().add(new SelectorItemInfo("parent.id"));
        entryView.getSelector().add(new SelectorItemInfo("parent.exchange_rate"));
        entryView.getSelector().add(new SelectorItemInfo("parent.currency.id"));
        entryView.getSelector().add(new SelectorItemInfo("parent.company.id"));
        entryView.getSelector().add(new SelectorItemInfo("parent.company.baseCurrency.precision"));
        entryView.getSelector().add(new SelectorItemInfo("parent.bizDate"));
        entryView.getSelector().add(new SelectorItemInfo("lockAmount"));
        entryView.getSelector().add(new SelectorItemInfo("lockAmountLoc"));
        entryView.getSelector().add(new SelectorItemInfo("unLockAmount"));
        entryView.getSelector().add(new SelectorItemInfo("unLockAmountLoc"));
        entryView.getSelector().add(new SelectorItemInfo("auditAmount"));
        entryView.getSelector().add(new SelectorItemInfo("auditAmountLoc"));
        entryView.getSelector().add(new SelectorItemInfo("sumEntryID"));
        entryFilter = new FilterInfo();
        entryFilter.getFilterItems().add(new FilterItemInfo("id", srcEntryIdSet, CompareType.INCLUDE));
        entryView.setFilter(entryFilter);
        PayRequestBillEntryCollection srcEntryColl = iPayRequestBillEntry.getPayRequestBillEntryCollection(entryView);
        if (null == srcEntryColl || srcEntryColl.size() == 0) {
            return;
        }
        Integer entrySeq = null;
        BigDecimal payAmt = null;
        BigDecimal payAmtLoc = null;
        BigDecimal srcLockAmt = null;
        BigDecimal srcUnLockAmt = null;
        BigDecimal srcAuditAmt = null;
        BigDecimal preLockAmt = null;
        BigDecimal preLockAmtLoc = null;
        PaymentBillEntryInfo oldEntryInfo = null;
        PayRequestBillEntryInfo srcEntryInfo = null;
        StringBuilder exceptionBuilder = new StringBuilder();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String lockSymbol = BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum) ? "-" : "+";
        String unlockSymbol = BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum) ? "+" : "-";
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("UPDATE T_AP_PAYREQUESTBILLENTRY ");
        updateSql.append(" SET FLOCKAMOUNT = FLOCKAMOUNT ").append(lockSymbol).append("? ,");
        updateSql.append("     FLOCKAMOUNTLOC = FLOCKAMOUNTLOC ").append(lockSymbol).append("? ,");
        updateSql.append("     FUNLOCKAMOUNT = FUNLOCKAMOUNT ").append(unlockSymbol).append("? ,");
        updateSql.append("     FUNLOCKAMOUNTLOC = FUNLOCKAMOUNTLOC ").append(unlockSymbol).append("?");
        updateSql.append(" WHERE FID = ?");
        String logSql = "insert into t_arap_log(fsrcbillid,fsrcbillentryid,FLOCKUNVERIFYAMT,FLOCKVERIFYAMT,FAmount,";
        logSql = logSql + "fdestbillid,fdestbillentryid,fremark)";
        logSql = logSql + "values(?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        BigDecimal uValue = new BigDecimal("-1");
        Iterator payBillEntryCollIte = payBillEntryColl.iterator();
        String srcBillID = null;
        boolean isDirectExchangeRate = true;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        int precision = 0;
        HashMap<String, BigDecimal> payReqEntryAmtMap = new HashMap<String, BigDecimal>();
        while (payBillEntryCollIte.hasNext()) {
            paybillEntryInfo2 = (PaymentBillEntryInfo)payBillEntryCollIte.next();
            entrySeq = paybillEntryInfo2.getSeq();
            sourceEntryId = paybillEntryInfo2.getSourceBillEntryId();
            if (!srcEntryColl.contains(BOSUuid.read((String)sourceEntryId))) continue;
            srcEntryInfo = srcEntryColl.get(BOSUuid.read((String)sourceEntryId));
            if (null == srcBillID || !srcBillID.equals(srcEntryInfo.getParent().getId().toString())) {
                srcBillID = srcEntryInfo.getParent().getId().toString();
                isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate((ExchangeRateInfo)BaseDataUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)srcEntryInfo.getParent().getCompany(), (CurrencyInfo)srcEntryInfo.getParent().getCurrency(), (Date)srcEntryInfo.getParent().getBizDate()));
                exchangeRate = srcEntryInfo.getParent().getExchange_rate();
                precision = srcEntryInfo.getParent().getCompany().getBaseCurrency().getPrecision();
            }
            payAmt = paybillEntryInfo2.getAmount();
            payAmtLoc = srcEntryInfo.getUnLockAmount().equals(paybillEntryInfo2.getAmount()) ? srcEntryInfo.getUnLockAmountLoc() : BaseDataUtil.caculateLocalAmount((BigDecimal)payAmt, (BigDecimal)exchangeRate, (boolean)isDirectExchangeRate, (int)precision);
            srcAuditAmt = srcEntryInfo.getAuditAmount();
            srcLockAmt = (BigDecimal)payReqEntryAmtMap.get(srcEntryInfo.getId().toString());
            if (srcLockAmt == null) {
                srcLockAmt = null == srcEntryInfo.getLockAmount() ? BigDecimal.ZERO : srcEntryInfo.getLockAmount();
                payReqEntryAmtMap.put(srcEntryInfo.getId().toString(), srcLockAmt.add(payAmt));
            }
            srcUnLockAmt = srcAuditAmt.subtract(srcLockAmt);
            boolean checkPassed = true;
            if (srcAuditAmt.multiply(payAmt).signum() < 0) {
                exceptionBuilder.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"Entry_diEntry_diff_symbol_msg_pay_reqff_symbol_msg", (Locale)ctx.getLocale(), (Object[])new Object[]{entrySeq, payAmt, srcAuditAmt})).append("\n");
                checkPassed = false;
            }
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                if (payAmt.abs().compareTo(srcLockAmt.abs()) > 0) {
                    exceptionBuilder.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"Entry_lockAmt_gt_srcLockAmt_msg", (Locale)ctx.getLocale(), (Object[])new Object[]{entrySeq, payAmt, srcLockAmt})).append("\n");
                    checkPassed = false;
                }
            } else if (srcLockAmt.add(payAmt).abs().compareTo(srcAuditAmt.abs()) > 0) {
                exceptionBuilder.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"Entry_amt_gt_srcAmt_msg_pay_req", (Locale)ctx.getLocale(), (Object[])new Object[]{entrySeq, payAmt, srcUnLockAmt})).append("\n");
                checkPassed = false;
            }
            if (!checkPassed) continue;
            if (null != destEntryColl && destEntryColl.contains((Object)paybillEntryInfo2.getId())) {
                oldEntryInfo = destEntryColl.get((Object)paybillEntryInfo2.getId());
                preLockAmt = oldEntryInfo.getAmount();
                preLockAmtLoc = BaseDataUtil.caculateLocalAmount((BigDecimal)oldEntryInfo.getAmount(), (BigDecimal)exchangeRate, (boolean)isDirectExchangeRate, (int)precision);
            } else {
                preLockAmt = payAmt;
                preLockAmtLoc = BaseDataUtil.caculateLocalAmount((BigDecimal)payAmt, (BigDecimal)exchangeRate, (boolean)isDirectExchangeRate, (int)precision);
            }
            Object[] params = new Object[5];
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                params[0] = preLockAmt;
                params[1] = preLockAmtLoc;
                params[2] = preLockAmt;
                params[3] = preLockAmtLoc;
                paramList.add(new Object[]{srcEntryInfo.getParent().getId().toString(), srcEntryInfo.getId().toString(), preLockAmt, preLockAmt.multiply(uValue), srcEntryInfo.getAuditAmount(), payBillInfo.getId().toString(), paybillEntryInfo2.getId().toString(), bOTBillOperStateEnum.getAlias()});
            } else {
                params[0] = payAmt;
                params[1] = payAmtLoc;
                params[2] = payAmt;
                params[3] = payAmtLoc;
                paramList.add(new Object[]{srcEntryInfo.getParent().getId().toString(), srcEntryInfo.getId().toString(), payAmt.multiply(uValue), payAmt, srcEntryInfo.getAuditAmount(), payBillInfo.getId().toString(), paybillEntryInfo2.getId().toString(), bOTBillOperStateEnum.getAlias()});
            }
            params[4] = sourceEntryId;
            paramsList.add(params);
        }
        if (exceptionBuilder.length() > 0) {
            throw new com.kingdee.eas.fi.ap.OtherBillBizException(com.kingdee.eas.fi.ap.OtherBillBizException.PAYBILL_WRITE_BACK_LOCK_AMT_ERROR, new Object[]{payBillInfo.getNumber(), exceptionBuilder.toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
        ArApBillReverseHelper.writeBackSumEntry(iPayRequestBill, iPayRequestSumEntry, srcBillIdSet);
        if (paramList.size() > 0 && ArApBillReverseHelper.isWriteLog(ctx).booleanValue()) {
            DbUtil.executeBatch((Context)ctx, (String)logSql, paramList);
        }
    }

    public static void writeBackSumEntry(IPayRequestBill iPayRequestBill, IPayRequestSumEntry iPayRequestSumEntry, Set<String> srcBillIdSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fiterInfo = new FilterInfo();
        FilterItemInfo idFilter = new FilterItemInfo("id", srcBillIdSet, CompareType.INCLUDE);
        fiterInfo.getFilterItems().add(idFilter);
        view.setFilter(fiterInfo);
        view.setSelector(ArApBillReverseHelper.getPayReqSelector());
        PayRequestBillCollection payReqBillColl = iPayRequestBill.getPayRequestBillCollection(view);
        PayRequestBillInfo payrequestBillInfo = null;
        CoreBaseCollection coreBaseColl = new CoreBaseCollection();
        int size = payReqBillColl.size();
        for (int i = 0; i < size; ++i) {
            payrequestBillInfo = payReqBillColl.get(i);
            payrequestBillInfo.sumEntrys();
            coreBaseColl.addObjectCollection((IObjectCollection)payrequestBillInfo.getSumEntry());
        }
        iPayRequestSumEntry.update(coreBaseColl);
    }

    protected static SelectorItemCollection getPayReqSelector() {
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.addObjectCollection((IObjectCollection)ArApSelectorFactory.getPayRequestBillEntrySelector("entrys"));
        selCol.addObjectCollection((IObjectCollection)ArApSelectorFactory.getPayRequestBillSumEntrySelector("sumEntry"));
        return selCol;
    }

    protected static Boolean isWriteLog(Context ctx) throws BOSException {
        Boolean isWrite = false;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fvalue from t_dt_dttempparam where fkey = 'isWriteLog4ArApLockAmt'");
        try {
            if (rs.next() && rs.getInt("fvalue") == 1) {
                isWrite = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isWrite;
    }
}

