/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import java.util.HashMap;
import java.util.Map;

public class BaseDataValidator {
    private final String companyId;
    private final IQueryDataAccess queryDataAccess;
    private final BOSObjectType customerType = new CustomerInfo().getBOSType();
    private final BOSObjectType supplierType = new SupplierInfo().getBOSType();
    private final Map<String, Boolean> resultMap = new HashMap<String, Boolean>();

    public BaseDataValidator(String companyId, IQueryDataAccess queryDataAccess) {
        this.companyId = companyId;
        this.queryDataAccess = queryDataAccess;
    }

    public boolean validate(String asstActId) throws BOSException {
        if (this.resultMap.containsKey(asstActId)) {
            return this.resultMap.get(asstActId);
        }
        BOSUuid uuid = BOSUuid.read((String)asstActId);
        if (this.customerType.equals((Object)uuid.getType()) || this.supplierType.equals((Object)uuid.getType())) {
            MetaDataPK queryPk = null;
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            evi.setFilter(fi);
            fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.companyId));
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)asstActId));
            fi.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1));
            if (this.customerType.equals((Object)uuid.getType())) {
                queryPk = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery");
                fi.getFilterItems().add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)0));
            } else if (this.supplierType.equals((Object)uuid.getType())) {
                queryPk = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery");
                fi.getFilterItems().add(new FilterItemInfo("supplierCompany.usingStatus", (Object)0));
            }
            QueryExecuteOption qeo = new QueryExecuteOption();
            qeo.isIgnorePermissionCheck = true;
            boolean exists = this.queryDataAccess.hasResult((IMetaDataPK)queryPk, evi, new HashMap(), qeo);
            this.resultMap.put(asstActId, exists);
            return exists;
        }
        return true;
    }
}

