/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.arap.util.Constant;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.arap.util.QuantityMeasureUtils;
import java.math.BigDecimal;

public abstract class NumericBizCalculator {
    public static BigDecimal calculatePrice(BigDecimal taxPrice, BigDecimal taxRate, int scale) {
        BigDecimal tr;
        BigDecimal price = SysConstant.BIGZERO;
        if (!NumericBizCalculator.equalsZero(taxPrice) && !NumericBizCalculator.equalsZero(tr = Constant.BIGDECIMAL_ONE.add(NumericBizCalculator.calculateRate(taxRate)))) {
            price = NumericBizCalculator.effectualNumeric(taxPrice).divide(tr, 10, 4);
        }
        return price.setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculatePrice(BigDecimal taxprice, BigDecimal taxRate, MaterialInfo material) throws EASBizException, BOSException {
        return NumericBizCalculator.calculatePrice(taxprice, taxRate, PrecisionFormatUtils.getMaterialPricePrecision(material));
    }

    public static BigDecimal calculatePriceByAmount(BigDecimal amount, BigDecimal qty, BigDecimal discountRate, MaterialInfo material) throws EASBizException, BOSException {
        return NumericBizCalculator.calculatePriceByAmount(amount, qty, discountRate, PrecisionFormatUtils.getMaterialPricePrecision(material));
    }

    public static BigDecimal calculatePriceByAmount(BigDecimal amount, BigDecimal qty, BigDecimal discountRate, int scale) {
        BigDecimal price = SysConstant.BIGZERO;
        BigDecimal dr = Constant.BIGDECIMAL_ONE.subtract(NumericBizCalculator.effectualNumeric(NumericBizCalculator.calculateRate(discountRate)));
        if (!NumericBizCalculator.equalsZero(dr) && !NumericBizCalculator.equalsZero(qty)) {
            price = NumericBizCalculator.effectualNumeric(amount).divide(NumericBizCalculator.effectualNumeric(qty), 10, 4);
            price = price.divide(dr, PrecisionFormatUtils.effectualPrecision(scale), 4);
        }
        return price;
    }

    public static BigDecimal calculateTaxPrice(BigDecimal price, BigDecimal taxRate, int scale) {
        BigDecimal tr;
        BigDecimal taxPrice = SysConstant.BIGZERO;
        if (!NumericBizCalculator.equalsZero(price) && !NumericBizCalculator.equalsZero(tr = Constant.BIGDECIMAL_ONE.add(NumericBizCalculator.calculateRate(taxRate)))) {
            taxPrice = NumericBizCalculator.effectualNumeric(price).multiply(tr).setScale(10, 4);
        }
        return taxPrice.setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateTaxPrice(BigDecimal taxPrice, BigDecimal taxRate, MaterialInfo material) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateTaxPrice(taxPrice, taxRate, PrecisionFormatUtils.getMaterialPricePrecision(material));
    }

    public static BigDecimal calculateTaxPriceByRealPrice(BigDecimal realTaxPrice, BigDecimal discountRate, MaterialInfo material) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateTaxPriceByRealPrice(realTaxPrice, discountRate, PrecisionFormatUtils.getMaterialPricePrecision(material));
    }

    public static BigDecimal calculateTaxPriceByRealPrice(BigDecimal realTaxPrice, BigDecimal discountRate, int scale) {
        BigDecimal result = NumericBizCalculator.effectualNumeric(null);
        BigDecimal dr = Constant.BIGDECIMAL_ONE.subtract(NumericBizCalculator.calculateRate(discountRate));
        if (!NumericBizCalculator.equalsZero(dr) && !NumericBizCalculator.equalsZero(realTaxPrice)) {
            result = NumericBizCalculator.effectualNumeric(realTaxPrice).divide(dr, PrecisionFormatUtils.effectualPrecision(scale), 4);
        }
        return result;
    }

    public static BigDecimal calculateRealPriceByAmtAndQty(BigDecimal amount, BigDecimal qty, MaterialInfo material) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateRealPriceByAmtAndQty(amount, qty, PrecisionFormatUtils.getMaterialPricePrecision(material));
    }

    public static BigDecimal calculateRealPriceByAmtAndQty(BigDecimal amount, BigDecimal qty, int scale) {
        BigDecimal realPrice = NumericBizCalculator.effectualNumeric(amount);
        if (!NumericBizCalculator.equalsZero(amount) && !NumericBizCalculator.equalsZero(qty)) {
            realPrice = NumericBizCalculator.effectualNumeric(amount).divide(NumericBizCalculator.effectualNumeric(qty), PrecisionFormatUtils.effectualPrecision(scale), 4);
        }
        return realPrice;
    }

    public static BigDecimal calculateRealPrice(BigDecimal taxPrice, BigDecimal discountRate, int scale) {
        if (NumericBizCalculator.equalsZero(taxPrice)) {
            return SysConstant.BIGZERO;
        }
        BigDecimal realPrice = NumericBizCalculator.effectualNumeric(taxPrice).multiply(Constant.BIGDECIMAL_ONE.subtract(NumericBizCalculator.calculateRate(discountRate)));
        return realPrice.setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateRealPrice(BigDecimal taxPrice, BigDecimal discountRate, MaterialInfo material) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateRealPrice(taxPrice, discountRate, PrecisionFormatUtils.getMaterialPricePrecision(material));
    }

    public static BigDecimal calculateTotalAmount(BigDecimal amount, BigDecimal oldValue, BigDecimal newValue, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateTotalAmount(amount, oldValue, newValue, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateTotalAmount(BigDecimal amount, BigDecimal oldValue, BigDecimal newValue, int scale) {
        BigDecimal increase = NumericBizCalculator.effectualNumeric(newValue).subtract(NumericBizCalculator.effectualNumeric(oldValue));
        return NumericBizCalculator.effectualNumeric(amount).add(NumericBizCalculator.effectualNumeric(increase)).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateUnVerifyAmount(BigDecimal amountTax, BigDecimal verifyAmount, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateUnVerifyAmount(amountTax, verifyAmount, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateUnVerifyAmount(BigDecimal amountTax, BigDecimal verifyAmount, int scale) {
        return NumericBizCalculator.effectualNumeric(amountTax).subtract(NumericBizCalculator.effectualNumeric(verifyAmount)).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateDiscountAmount(BigDecimal taxPrice, BigDecimal qty, BigDecimal discountRate, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateDiscountAmount(taxPrice, qty, discountRate, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateDiscountAmount(BigDecimal taxPrice, BigDecimal qty, BigDecimal discountRate, int scale) {
        return NumericBizCalculator.effectualNumeric(taxPrice).multiply(NumericBizCalculator.effectualNumeric(qty)).multiply(NumericBizCalculator.calculateRate(discountRate)).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateAmountByPrice(BigDecimal price, BigDecimal qty, BigDecimal discountRate, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateAmountByPrice(price, qty, discountRate, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateAmountByPrice(BigDecimal price, BigDecimal qty, BigDecimal discountRate, int scale) {
        BigDecimal dr = Constant.BIGDECIMAL_ONE.subtract(NumericBizCalculator.calculateRate(discountRate));
        return NumericBizCalculator.effectualNumeric(price).multiply(NumericBizCalculator.effectualNumeric(qty)).multiply(dr).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateAmount(BigDecimal realTaxPrice, BigDecimal qty, int scale) {
        return NumericBizCalculator.effectualNumeric(realTaxPrice).multiply(NumericBizCalculator.effectualNumeric(qty)).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateAmount(BigDecimal realTaxPrice, BigDecimal qty, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateAmount(realTaxPrice, qty, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateAmountLocal(BigDecimal amount, BigDecimal exchangeRate, int convertMode, int scale) {
        switch (convertMode) {
            case 0: {
                return NumericBizCalculator.calculateAmountLocalByDirect(amount, exchangeRate, scale);
            }
            case 1: {
                return NumericBizCalculator.calculateAmountLocalByInDirect(amount, exchangeRate, scale);
            }
        }
        return NumericBizCalculator.calculateAmountLocalByDirect(amount, exchangeRate, scale);
    }

    public static BigDecimal calculateAmountByAmountTax(BigDecimal amountTax, BigDecimal tax, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateAmountByAmountTax(amountTax, tax, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateAmountByAmountTaxAndRate(BigDecimal amountTax, BigDecimal taxRate, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateAmountByAmountTaxAndRate(amountTax, taxRate, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateAmountByAmountTaxAndRate(BigDecimal amountTax, BigDecimal taxRate, int scale) {
        BigDecimal amount = SysConstant.BIGZERO;
        BigDecimal tr = Constant.BIGDECIMAL_ONE.add(NumericBizCalculator.calculateRate(taxRate));
        if (!NumericBizCalculator.equalsZero(amountTax) && !NumericBizCalculator.equalsZero(tr)) {
            amount = NumericBizCalculator.effectualNumeric(amountTax).divide(tr, PrecisionFormatUtils.effectualPrecision(scale), 4);
        }
        return amount;
    }

    public static BigDecimal calculateAmountByAmountTax(BigDecimal amountTax, BigDecimal tax, int scale) {
        return NumericBizCalculator.effectualNumeric(amountTax).add(NumericBizCalculator.effectualNumeric(tax).negate()).setScale(PrecisionFormatUtils.effectualPrecision(scale));
    }

    public static BigDecimal calculateAmountByTax(BigDecimal tax, BigDecimal taxRate, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateAmountByTax(tax, taxRate, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateAmountByTax(BigDecimal tax, BigDecimal taxRate, int scale) {
        BigDecimal amount = NumericBizCalculator.effectualNumeric(null);
        if (!NumericBizCalculator.equalsZero(taxRate) && !NumericBizCalculator.equalsZero(tax)) {
            amount = NumericBizCalculator.effectualNumeric(tax).divide(NumericBizCalculator.effectualNumeric(NumericBizCalculator.calculateRate(taxRate)), PrecisionFormatUtils.effectualPrecision(scale), 4);
        }
        return amount;
    }

    public static BigDecimal calculateAmountLocalByDirect(BigDecimal amount, BigDecimal exchangeRate, int scale) {
        return NumericBizCalculator.effectualNumeric(amount).multiply(NumericBizCalculator.effectualExchangeRate(exchangeRate)).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateAmountLocalByInDirect(BigDecimal amount, BigDecimal exchangeRate, int scale) {
        if (NumericBizCalculator.equalsZero(amount)) {
            return NumericBizCalculator.effectualNumeric(amount);
        }
        if (!NumericBizCalculator.isDistrustExchangeRate(exchangeRate)) {
            return NumericBizCalculator.effectualNumeric(amount).multiply(NumericBizCalculator.effectualExchangeRate(exchangeRate)).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
        }
        return SysConstant.BIGZERO;
    }

    public static BigDecimal calculateTax(BigDecimal amount, BigDecimal taxRate, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateTax(amount, taxRate, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateTax(BigDecimal amount, BigDecimal taxRate, int scale) {
        BigDecimal tax = NumericBizCalculator.effectualNumeric(null);
        if (!NumericBizCalculator.equalsZero(amount) && !NumericBizCalculator.equalsZero(taxRate)) {
            tax = NumericBizCalculator.effectualNumeric(amount).multiply(NumericBizCalculator.effectualNumeric(NumericBizCalculator.calculateRate(taxRate))).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
        }
        return tax;
    }

    public static BigDecimal calculateRate(BigDecimal rate) {
        BigDecimal tr = NumericBizCalculator.effectualNumeric(rate);
        if (!NumericBizCalculator.equalsZero(tr)) {
            tr = rate.divide(Constant.BIGDECIMAL_ONEHUNDRED, 10, 4);
        }
        return tr;
    }

    public static BigDecimal calculateAmountTax(BigDecimal amount, BigDecimal tax, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateAmountTax(amount, tax, PrecisionFormatUtils.getCurrencyPrecision(currency));
    }

    public static BigDecimal calculateAmountTax(BigDecimal amount, BigDecimal tax, int scale) {
        return NumericBizCalculator.effectualNumeric(amount).add(NumericBizCalculator.effectualNumeric(tax)).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateQtyByNewUnit(MaterialInfo material, MeasureUnitInfo oldUnit, MeasureUnitInfo newUnit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        BigDecimal[] rates = QuantityMeasureUtils.getMultiUnitBaseExchangeRates(material, oldUnit, newUnit);
        return NumericBizCalculator.calculateQtyByNewUnit(rates[0], rates[1], qty, scale);
    }

    public static BigDecimal calculateQtyByNewUnit(BigDecimal oldBaseRate, BigDecimal newBaseRate, BigDecimal qty, int scale) {
        BigDecimal baseQty = NumericBizCalculator.effectualNumeric(qty).multiply(oldBaseRate);
        return NumericBizCalculator.effectualNumeric(baseQty).divide(newBaseRate, PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal calculateQtyByAmount(MaterialInfo material, MeasureUnitInfo unit, BigDecimal amount, BigDecimal realTaxPrice) throws EASBizException, BOSException {
        if (NumericBizCalculator.equalsZero(realTaxPrice)) {
            return NumericBizCalculator.effectualNumeric(null);
        }
        return NumericBizCalculator.calculateQtyByAmount(amount, realTaxPrice, PrecisionFormatUtils.getQuantityPrecision(material, unit));
    }

    public static BigDecimal calculateQtyByAmount(BigDecimal amount, BigDecimal realTaxPrice, int scale) {
        BigDecimal qty = NumericBizCalculator.effectualNumeric(null);
        if (!NumericBizCalculator.equalsZero(realTaxPrice) && !NumericBizCalculator.equalsZero(amount)) {
            qty = NumericBizCalculator.effectualNumeric(amount).divide(realTaxPrice, PrecisionFormatUtils.effectualPrecision(scale), 4);
        }
        return qty;
    }

    public static BigDecimal calculateQtyByAmount(MaterialInfo material, MeasureUnitInfo unit, BigDecimal amount, BigDecimal price, BigDecimal discountRate) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateQtyByAmount(amount, price, discountRate, PrecisionFormatUtils.getQuantityPrecision(material, unit));
    }

    public static BigDecimal calculateQtyByAmount(BigDecimal amount, BigDecimal price, BigDecimal discountRate, int scale) {
        BigDecimal qty = SysConstant.BIGZERO;
        BigDecimal p = NumericBizCalculator.effectualNumeric(price).multiply(Constant.BIGDECIMAL_ONE.subtract(NumericBizCalculator.calculateRate(discountRate))).setScale(10, 4);
        if (!NumericBizCalculator.equalsZero(amount) && !NumericBizCalculator.equalsZero(p)) {
            qty = NumericBizCalculator.effectualNumeric(amount).divide(p, PrecisionFormatUtils.effectualPrecision(scale), 4);
        }
        return qty;
    }

    public static BigDecimal calculateBaseQty(MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty) throws EASBizException, BOSException {
        return NumericBizCalculator.calculateBaseQty(material, unit, qty, PrecisionFormatUtils.getQuantityPrecision(material, material.getBaseUnit()));
    }

    public static BigDecimal calculateBaseQty(MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        BigDecimal baseQty = NumericBizCalculator.effectualNumeric(null);
        if (material.getBaseUnit() != null) {
            baseQty = NumericBizCalculator.calculateQtyByNewUnit(material, unit, material.getBaseUnit(), qty, scale);
        }
        return baseQty;
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    public static BigDecimal toBigDecimal(Object o) {
        BigDecimal result = NumericBizCalculator.effectualNumeric(null);
        if (o != null) {
            String vString;
            if (o instanceof BigDecimal) {
                result = (BigDecimal)o;
            } else if ((o instanceof String || o instanceof StringBuffer) && (vString = o.toString().trim()).matches("-?\\d+\\.?\\d*")) {
                result = new BigDecimal(vString);
            }
        }
        return result;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return NumericBizCalculator.isDistrustExchangeRate(exchangeRate) ? exchangeRate : Constant.EXCHANGERATE_DEFAULT;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return NumericBizCalculator.equalsZero(v) ? SysConstant.BIGZERO : v;
    }
}

