/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PayConditionEntryCollection;
import com.kingdee.eas.basedata.assistant.PayConditionEntryInfo;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeEnum;
import com.kingdee.eas.basedata.assistant.StartStandardEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.InitialDayEnum;
import com.kingdee.eas.basedata.master.cssp.MonthOrDayEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillPlanBaseInfo;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanAgent;
import com.kingdee.eas.fi.ar.OtherBillPlanCollection;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.fi.arap.util.ArApBaseCalculate;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class PlanHelper {
    static final Logger logger = Logger.getLogger(PlanHelper.class);

    public static Date getPlanDate(Context ctx, BOSUuid asstActId, OrgUnitInfo orgUnitInfo, Date billDate) throws BOSException, EASBizException {
        return billDate;
    }

    private static Date calDate(InitialDayEnum initialDayEnum, int addXMonthOrDay, MonthOrDayEnum monthOrDayEnum, int whenXDay, Date billDate) {
        if (initialDayEnum == null) {
            return billDate;
        }
        Calendar start = GregorianCalendar.getInstance();
        billDate = DateTimeUtils.truncateDate((Date)billDate);
        start.setTime(billDate);
        if (InitialDayEnum.BILLENDOFMONTHDATE.equals((Object)initialDayEnum)) {
            int actualMaximum = start.getActualMaximum(5);
            start.set(5, actualMaximum);
        }
        if (MonthOrDayEnum.DAY.equals((Object)monthOrDayEnum)) {
            start.add(5, addXMonthOrDay);
        } else if (MonthOrDayEnum.Month.equals((Object)monthOrDayEnum)) {
            start.add(2, addXMonthOrDay);
        }
        if (whenXDay > start.getActualMaximum(5)) {
            whenXDay = start.getActualMaximum(5);
        }
        Calendar when = (Calendar)start.clone();
        when.set(5, whenXDay);
        Date date = null;
        if (start.after(when)) {
            when.add(2, 1);
        }
        date = new Date(when.getTimeInMillis());
        return date;
    }

    public static AbstractObjectCollection generatePlanCollection(Context ctx, ArApBillBaseInfo billInfo, PayConditionInfo pcInfo) throws BOSException {
        AbstractObjectCollection planColl = billInfo.getPlans();
        if (pcInfo == null || pcInfo.getEntries() == null) {
            return planColl;
        }
        planColl = billInfo instanceof OtherBillInfo ? new OtherBillPlanCollection() : new com.kingdee.eas.fi.ap.OtherBillPlanCollection();
        PayConditionEntryCollection pcEntryColl = pcInfo.getEntries();
        int size = pcEntryColl.size();
        for (int i = 0; i < size; ++i) {
            ArApBillPlanBaseInfo planInfo;
            PayConditionEntryInfo pcEntryInfo = pcEntryColl.get(i);
            Date recPayDate = PlanHelper.calPlanDate(ctx, billInfo, pcEntryInfo);
            BigDecimal rate = pcEntryInfo.getRate();
            if (rate == null) continue;
            rate = ArApBaseCalculate.calRate(rate, 2);
            BigDecimal recPayAmt = billInfo.getAmount().multiply(rate).setScale(billInfo.getAmount().scale(), 4);
            BigDecimal recPayAmtLocal = billInfo.getAmountLocal().multiply(rate).setScale(billInfo.getAmountLocal().scale(), 4);
            if (billInfo instanceof OtherBillInfo) {
                planInfo = null;
                planInfo = ctx == null ? OtherBillPlanAgent.create() : new OtherBillPlanInfo();
                planInfo.setRecievePayDate(recPayDate);
                planInfo.setRecievePayAmount(recPayAmt);
                planInfo.setRecievePayAmountLocal(recPayAmtLocal);
                planInfo.setVerifyAmount(ArApBaseCalculate.ZERO.setScale(billInfo.getAmount().scale(), 4));
                planInfo.setVerifyAmountLocal(ArApBaseCalculate.ZERO.setScale(billInfo.getAmountLocal().scale(), 4));
                planInfo.setUnVerifyAmount(recPayAmt);
                planInfo.setUnVerifyAmountLocal(recPayAmtLocal);
                planInfo.setLockAmount(ArApBaseCalculate.ZERO.setScale(billInfo.getAmount().scale(), 4));
                planInfo.setLockAmountLoc(ArApBaseCalculate.ZERO.setScale(billInfo.getAmount().scale(), 4));
                planInfo.setUnLockAmount(recPayAmt);
                planInfo.setUnLockAmountLoc(recPayAmtLocal);
                planColl.addObject((IObjectValue)planInfo);
                continue;
            }
            planInfo = null;
            planInfo = ctx == null ? com.kingdee.eas.fi.ap.OtherBillPlanAgent.create() : new com.kingdee.eas.fi.ap.OtherBillPlanInfo();
            planInfo.setRecievePayDate(recPayDate);
            planInfo.setRecievePayAmount(recPayAmt);
            planInfo.setRecievePayAmountLocal(recPayAmtLocal);
            planInfo.setVerifyAmount(ArApBaseCalculate.ZERO.setScale(billInfo.getAmount().scale(), 4));
            planInfo.setVerifyAmountLocal(ArApBaseCalculate.ZERO.setScale(billInfo.getAmountLocal().scale(), 4));
            planInfo.setUnVerifyAmount(recPayAmt);
            planInfo.setUnVerifyAmountLocal(recPayAmtLocal);
            planInfo.setLockAmount(ArApBaseCalculate.ZERO.setScale(billInfo.getAmount().scale(), 4));
            planInfo.setLockAmountLoc(ArApBaseCalculate.ZERO.setScale(billInfo.getAmount().scale(), 4));
            planInfo.setUnLockAmount(recPayAmt);
            planInfo.setUnLockAmountLoc(recPayAmtLocal);
            planColl.addObject((IObjectValue)planInfo);
        }
        return PlanHelper.handleMantissaDiff(billInfo, planColl);
    }

    private static AbstractObjectCollection handleMantissaDiff(ArApBillBaseInfo billInfo, AbstractObjectCollection planColl) {
        if (planColl == null || planColl.size() == 0) {
            return planColl;
        }
        Object[] plans = planColl.toArray();
        Arrays.sort(plans);
        BigDecimal totalRecPayAmt = ArApBaseCalculate.ZERO;
        BigDecimal totalRecPayAmtLocal = ArApBaseCalculate.ZERO;
        for (int i = 0; i < plans.length - 1; ++i) {
            ArApBillPlanBaseInfo planInfo = (ArApBillPlanBaseInfo)plans[i];
            totalRecPayAmt = totalRecPayAmt.add(planInfo.getRecievePayAmount());
            totalRecPayAmtLocal = totalRecPayAmtLocal.add(planInfo.getRecievePayAmountLocal());
        }
        ArApBillPlanBaseInfo lastRowPlanInfo = (ArApBillPlanBaseInfo)plans[plans.length - 1];
        lastRowPlanInfo.setRecievePayAmount(billInfo.getAmount().subtract(totalRecPayAmt));
        lastRowPlanInfo.setRecievePayAmountLocal(billInfo.getAmountLocal().subtract(totalRecPayAmtLocal));
        planColl.clear();
        for (int i = 0; i < plans.length; ++i) {
            planColl.addObject((IObjectValue)((ArApBillPlanBaseInfo)plans[i]));
        }
        return planColl;
    }

    private static Date getStartDate(Context ctx, ArApBillBaseInfo billInfo, PayConditionEntryInfo pcEntryInfo) {
        if (StartStandardEnum.BILL_DATE == pcEntryInfo.getStartStandard()) {
            return billInfo.getBillDate();
        }
        if (StartStandardEnum.BILL_MONTHEND_DATE == pcEntryInfo.getStartStandard()) {
            PeriodInfo periondInfo = PlanHelper.getPeriodInfo(ctx, billInfo, billInfo.getBillDate());
            return periondInfo.getEndDate();
        }
        if (StartStandardEnum.BIZ_DATE == pcEntryInfo.getStartStandard()) {
            return billInfo.getBizDate();
        }
        if (StartStandardEnum.BIZ_MONTHEND_DATE == pcEntryInfo.getStartStandard()) {
            PeriodInfo periondInfo = PlanHelper.getPeriodInfo(ctx, billInfo, billInfo.getBizDate());
            return periondInfo.getEndDate();
        }
        return null;
    }

    private static Date getMonthEndDate(Date date) {
        Calendar start = GregorianCalendar.getInstance();
        date = DateTimeUtils.truncateDate((Date)date);
        start.setTime(date);
        int actualMaximum = start.getActualMaximum(5);
        start.set(5, actualMaximum);
        return start.getTime();
    }

    private static Date calPlanDate(Context ctx, ArApBillBaseInfo billInfo, PayConditionEntryInfo pcEntryInfo) {
        Date recPayDate = null;
        if (SettlementTypeEnum.MONTH.equals((Object)pcEntryInfo.getSettlementType())) {
            Date starDate = PlanHelper.getStartDate(ctx, billInfo, pcEntryInfo);
            Calendar start = Calendar.getInstance();
            start.setTime(starDate);
            start.add(5, pcEntryInfo.getStartDeferDays());
            if (start.get(5) > pcEntryInfo.getDay()) {
                start.add(2, 1);
            }
            start.add(2, pcEntryInfo.getMonths());
            if (pcEntryInfo.getDay() > start.getActualMaximum(5)) {
                start.set(5, start.getActualMaximum(5));
            } else {
                start.set(5, pcEntryInfo.getDay());
            }
            start.add(5, pcEntryInfo.getCreditDays());
            recPayDate = start.getTime();
        } else if (SettlementTypeEnum.CREDIT.equals((Object)pcEntryInfo.getSettlementType())) {
            Calendar start = GregorianCalendar.getInstance();
            start.setTime(PlanHelper.getStartDate(ctx, billInfo, pcEntryInfo));
            start.add(5, pcEntryInfo.getStartDeferDays());
            start.add(5, pcEntryInfo.getCreditDays());
            recPayDate = start.getTime();
        } else if (SettlementTypeEnum.DATE.equals((Object)pcEntryInfo.getSettlementType())) {
            recPayDate = pcEntryInfo.getFicedDate();
        }
        return recPayDate;
    }

    public static PayConditionInfo getPayCondition(Context ctx, String asstActId, String sCompanyId) throws BOSException, EASBizException {
        PayConditionInfo pcInfo = null;
        BOSUuid asstActUuid = BOSUuid.read((String)asstActId);
        if (asstActUuid.getType().toString().equals(CustomerInfo.getBosType())) {
            ICustomerCompanyInfo iCustomerCompany = ctx == null ? CustomerCompanyInfoFactory.getRemoteInstance() : CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)asstActId));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)sCompanyId));
            filter.getFilterItems().add(new FilterItemInfo("payCondition.deletedStatus", (Object)1, CompareType.EQUALS));
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("payCondition.*");
            sic.add("payCondition.entries.*");
            ev.setSelector(sic);
            CustomerCompanyInfoCollection customerCompanyColl = iCustomerCompany.getCustomerCompanyInfoCollection(ev);
            if (customerCompanyColl.size() > 0) {
                CustomerCompanyInfoInfo customerCompanyInfo = customerCompanyColl.get(0);
                pcInfo = customerCompanyInfo.getPayCondition();
            }
        } else if (asstActUuid.getType().toString().equals(SupplierInfo.getBosType())) {
            ISupplierCompanyInfo iSupplierCompany = ctx == null ? SupplierCompanyInfoFactory.getRemoteInstance() : SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)asstActId));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)sCompanyId));
            filter.getFilterItems().add(new FilterItemInfo("payCondition.deletedStatus", (Object)1, CompareType.EQUALS));
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("payCondition.*");
            sic.add("payCondition.entries.*");
            ev.setSelector(sic);
            SupplierCompanyInfoCollection supplierCompanyColl = iSupplierCompany.getSupplierCompanyInfoCollection(ev);
            if (supplierCompanyColl.size() > 0) {
                SupplierCompanyInfoInfo supplierCompanyInfo = supplierCompanyColl.get(0);
                pcInfo = supplierCompanyInfo.getPayCondition();
            }
        }
        return pcInfo;
    }

    private static PeriodInfo getPeriodInfo(Context ctx, ArApBillBaseInfo billInfo, Date date) {
        PeriodInfo period = null;
        try {
            period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, (CompanyOrgUnitInfo)billInfo.getCompany());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return period;
    }
}

