/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util.cor;

import com.kingdee.eas.fi.arap.util.cor.AmountHandler;
import com.kingdee.eas.fi.arap.util.cor.AmountTaxHandler;
import com.kingdee.eas.fi.arap.util.cor.DiscountAmountHandler;
import com.kingdee.eas.fi.arap.util.cor.ExchangeRateHandler;
import com.kingdee.eas.fi.arap.util.cor.HandlerNode;
import com.kingdee.eas.fi.arap.util.cor.INumericChangedLinker;
import com.kingdee.eas.fi.arap.util.cor.LocalHandler;
import com.kingdee.eas.fi.arap.util.cor.PriceHandler;
import com.kingdee.eas.fi.arap.util.cor.QtyExchangeRateHandler;
import com.kingdee.eas.fi.arap.util.cor.QuantityHandler;
import com.kingdee.eas.fi.arap.util.cor.RealTaxPriceHandler;
import com.kingdee.eas.fi.arap.util.cor.RootNode;
import com.kingdee.eas.fi.arap.util.cor.TaxHandler;
import com.kingdee.eas.fi.arap.util.cor.TaxPriceHandler;
import com.kingdee.eas.fi.arap.util.cor.TotalHandler;
import com.kingdee.eas.fi.arap.util.cor.UnVerifyAmountHandler;

public final class CORLinkerFactory {
    public static final String LINKER_SPLIT = ",";
    private static CORLinkerFactory factory = new CORLinkerFactory();

    private CORLinkerFactory() {
    }

    public static final CORLinkerFactory getInstance() {
        return factory;
    }

    public final INumericChangedLinker getLinker(String linkString) {
        return this._getLingker(new RootNode(), linkString);
    }

    public static String[] getStringNodes(String linkString) {
        String[] nodes = null;
        if (linkString != null && linkString.trim().length() != 0) {
            nodes = linkString.trim().split(LINKER_SPLIT);
        }
        return nodes;
    }

    private INumericChangedLinker _getLingker(RootNode root, String linkString) {
        String[] nodes = CORLinkerFactory.getStringNodes(linkString);
        if (root != null && nodes != null) {
            String nodeKey2 = null;
            for (String nodeKey2 : nodes) {
                HandlerNode node;
                if (nodeKey2 == null || nodeKey2.trim().length() == 0 || (node = this.constructNode(nodeKey2)) == null) continue;
                root.osculumNode(node);
            }
        }
        return root;
    }

    protected HandlerNode constructNode(String nodeKey) {
        if (nodeKey.equalsIgnoreCase("discountamount")) {
            return new DiscountAmountHandler("discountamount");
        }
        if (nodeKey.equalsIgnoreCase("amount")) {
            return new AmountHandler("amount");
        }
        if (nodeKey.equalsIgnoreCase("amountlocal")) {
            LocalHandler n = new LocalHandler("amountlocal");
            n.setLocalLatitude("amount");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("amounttax")) {
            return new AmountTaxHandler("amounttax");
        }
        if (nodeKey.equalsIgnoreCase("amounttaxlocal")) {
            LocalHandler n = new LocalHandler("amounttaxlocal");
            n.setLocalLatitude("amounttax");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("exchangerate")) {
            return new ExchangeRateHandler("exchangerate");
        }
        if (nodeKey.equalsIgnoreCase("price")) {
            return new PriceHandler("price");
        }
        if (nodeKey.equalsIgnoreCase("qty_exchangerate")) {
            return new QtyExchangeRateHandler("qty_exchangerate");
        }
        if (nodeKey.equalsIgnoreCase("quantity")) {
            return new QuantityHandler("quantity");
        }
        if (nodeKey.equalsIgnoreCase("realtaxprice")) {
            return new RealTaxPriceHandler("realtaxprice");
        }
        if (nodeKey.equalsIgnoreCase("tax")) {
            return new TaxHandler("tax");
        }
        if (nodeKey.equalsIgnoreCase("taxlocal")) {
            LocalHandler n = new LocalHandler("taxlocal");
            n.setLocalLatitude("tax");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("taxprice")) {
            return new TaxPriceHandler("taxprice");
        }
        if (nodeKey.equalsIgnoreCase("amounttax_total")) {
            TotalHandler n = new TotalHandler("amounttax_total");
            n.setTotalLatitude("amounttax");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("amounttaxlocal_total")) {
            TotalHandler n = new TotalHandler("amounttaxlocal_total");
            n.setTotalLatitude("amounttaxlocal");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("verifyamountlocal")) {
            LocalHandler n = new LocalHandler("verifyamountlocal");
            n.setLocalLatitude("verifyamount");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("verifyamount_total")) {
            TotalHandler n = new TotalHandler("verifyamount_total");
            n.setTotalLatitude("verifyamount");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("verifyamountlocal_total")) {
            TotalHandler n = new TotalHandler("verifyamountlocal_total");
            n.setTotalLatitude("verifyamountlocal");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("unverifyamount")) {
            return new UnVerifyAmountHandler("unverifyamount");
        }
        if (nodeKey.equalsIgnoreCase("unverifyamountlocal")) {
            LocalHandler n = new LocalHandler("unverifyamountlocal");
            n.setLocalLatitude("unverifyamount");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("unverifyamount_total")) {
            TotalHandler n = new TotalHandler("unverifyamount_total");
            n.setTotalLatitude("unverifyamount");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("unverifyamountlocal_total")) {
            TotalHandler n = new TotalHandler("unverifyamountlocal_total");
            n.setTotalLatitude("unverifyamountlocal");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("badamountlocal")) {
            LocalHandler n = new LocalHandler("badamountlocal");
            n.setLocalLatitude("badamount");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("badamount_total")) {
            TotalHandler n = new TotalHandler("badamount_total");
            n.setTotalLatitude("badamount");
            return n;
        }
        if (nodeKey.equalsIgnoreCase("badamountlocal_total")) {
            TotalHandler n = new TotalHandler("badamountlocal_total");
            n.setTotalLatitude("badamountlocal");
            return n;
        }
        return null;
    }
}

