/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util.invoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.APBillFacadeFactory;
import com.kingdee.eas.fi.ap.IAPBillFacade;
import com.kingdee.eas.fi.ap.OtherBillInvoiceCollection;
import com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceClientUtils;
import com.kingdee.eas.fi.arap.util.invoice.InvoiceUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PwyRequestHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.util.invoice.PwyRequestHelper");

    public static OtherBillInvoiceCollection getInvoiceInfo(Context ctx, String invoiceNo, String invoiceCode, String companyId, Boolean isDownloadInvoice) throws EASBizException, BOSException, JSONException {
        OtherBillInvoiceCollection resColl = new OtherBillInvoiceCollection();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("invoiceNo", invoiceNo);
        if (StringUtils.isEmpty((String)invoiceCode) || "FULL".equalsIgnoreCase(invoiceCode)) {
            invoiceCode = null;
        }
        paramMap.put("invoiceCode", invoiceCode);
        paramMap.put("companyId", companyId);
        IAPBillFacade iapBillFacade = ctx == null ? APBillFacadeFactory.getRemoteInstance() : APBillFacadeFactory.getLocalInstance(ctx);
        try {
            Map res = iapBillFacade.baseInvoiceCallWithRes(paramMap, "/m6/bill/invoice/serialnos/query");
            String jsonStr = (String)res.get("result");
            if (isDownloadInvoice.booleanValue()) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("invoiceJson", jsonStr);
                params.put("companyId", companyId);
                params.put("ctx", (String)ctx);
                IncomeInvoiceClientUtils.downloadInvoiceFormAP(params);
            }
            JSONObject response = null;
            if (!StringUtils.isEmpty((String)jsonStr)) {
                response = new JSONObject(jsonStr);
            }
            resColl = InvoiceUtils.transJson2InvoiceCollection(ctx, response);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return resColl;
    }

    public static OtherBillInvoiceCollection getInvoiceInfo(Context ctx, String invoiceNo, String invoiceCode, String companyId) throws EASBizException, BOSException, JSONException {
        return PwyRequestHelper.getInvoiceInfo(ctx, invoiceNo, invoiceCode, companyId, false);
    }

    public static OtherBillInvoiceCollection getInvoiceInfoBySerialsNos(Context ctx, String serialNos, String companyId) throws EASBizException, BOSException, JSONException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("serialNos", serialNos);
        paramMap.put("companyId", companyId);
        IAPBillFacade iapBillFacade = ctx == null ? APBillFacadeFactory.getRemoteInstance() : APBillFacadeFactory.getLocalInstance(ctx);
        Map res = iapBillFacade.baseInvoiceCallWithRes(paramMap, "/m6/bill/invoice/serialnos/query");
        String jsonStr = (String)res.get("result");
        logger.error((Object)("com.kingdee.eas.fi.arap.util.invoice.PwyRequestHelper.getInvoiceInfoBySerialsNos:" + jsonStr));
        JSONObject response = new JSONObject(jsonStr);
        return InvoiceUtils.transJson2InvoiceCollection(ctx, response);
    }
}

