/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.client.ReceivingBillUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchFactory;
import com.kingdee.eas.scm.sd.sale.client.AbstractReceivingMatchListUI;
import com.kingdee.eas.scm.sd.sale.client.ReceivingMatchRecordUI;
import com.kingdee.eas.scm.sd.sale.client.SaleOrderEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReceivingMatchListUI
extends AbstractReceivingMatchListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivingMatchListUI.class);
    private static final String strTakeOutZeroFormat = "%{0.##########}f";

    public void onLoad() throws Exception {
        this.setIsCountAndSumRow(true);
        this.setIsNeedDefaultFilter(true);
        super.onLoad();
        this.boxShowSumRow.setEnabled(true);
        this.kDMenuShowSumRow.setEnabled(true);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.tblMain.getGroupManager().setGroup(true);
        String[] cols = new String[]{"audit", "matchDate", "matcher", "saleOrderNumber", "prepayment", "matched", "order.status", "order.amount"};
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            this.tblMain.getColumn(cols[i]).setGroup(true);
            this.tblMain.getColumn(cols[i]).setMergeable(true);
        }
        this.showSumAmount();
        this.actionTraceUp.setVisible(true);
        this.actionTraceDown.setVisible(true);
        this.actionCreateTo.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.setFunctionStatus();
        this.showDateTimeColumn();
    }

    private void showSumAmount() {
        String[] mcols = new String[]{"prepayment", "matched", "amount", "receiving.amount", "order.amount"};
        int n = mcols.length;
        for (int i = 0; i < n; ++i) {
            this.tblMain.getColumn(mcols[i]).getStyleAttributes().setNumberFormat(strTakeOutZeroFormat);
        }
    }

    private void showDateTimeColumn() {
        String[] mcols = new String[]{"matchDate", "order.bizDate", "bizDate"};
        int n = mcols.length;
        for (int i = 0; i < n; ++i) {
            this.tblMain.getColumn(mcols[i]).getStyleAttributes().setNumberFormat(ArApBillUtil.getDateFormatString());
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceivingMatchFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.setFunctionStatus();
    }

    private void setFunctionStatus() {
        int r = this.getSelectTop();
        boolean selected = r != -1;
        this.actionTraceUp.setEnabled(selected);
        this.actionTraceDown.setEnabled(selected);
        this.actionAudit.setEnabled(selected);
        this.actionAntiAudit.setEnabled(selected);
        this.actionView.setEnabled(selected);
        if (selected) {
            boolean audited = (Boolean)this.tblMain.getCell(r, "audit").getValue();
            this.actionAudit.setEnabled(!audited);
            this.actionAntiAudit.setEnabled(audited);
        } else {
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
        }
    }

    private int getSelectTop() {
        KDTSelectBlock b = this.tblMain.getSelectManager().get();
        if (b != null) {
            return b.getTop();
        }
        return -1;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo f = super.getDefaultFilterForQuery();
        f.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        return f;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock b = this.tblMain.getSelectManager().get();
        if (b != null) {
            int r = b.getTop();
            String orderId = (String)this.tblMain.getCell(r, "orderId").getValue();
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"orderId", (Object)orderId);
            ctx.put((Object)"forEdit", (Object)false);
            try {
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivingMatchRecordUI.class.getName(), (Map)ctx, this.dataObjects);
                ui.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String[] orderIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"orderId");
            try {
                ReceivingMatchFactory.getRemoteInstance().batchAudit(orderIDs);
                this.refreshList();
            }
            catch (Exception e1) {
                MsgBox.showWarning((Component)((Object)this), (String)(ReceivingMatchListUI.getUIResource("sync_audit_matchandsaleorder") + e1.getMessage()));
            }
        }
    }

    private static String getUIResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)key);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String[] orderIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"orderId");
            try {
                ReceivingMatchFactory.getRemoteInstance().batchAntiAudit(orderIDs);
                this.refreshList();
            }
            catch (Exception e1) {
                MsgBox.showWarning((Component)((Object)this), (String)(ReceivingMatchListUI.getUIResource("sync_antiaudit_matchandsaleorder") + e1.getMessage()));
            }
        }
    }

    @Override
    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String id = (String)this.tblMain.getCell(r, "orderId").getValue();
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"ID", (Object)id);
            try {
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SaleOrderEditUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
                ui.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String id = (String)this.tblMain.getCell(r, "receivingBillId").getValue();
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"ID", (Object)id);
            try {
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivingBillUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
                ui.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    protected boolean isFootVisible() {
        return true;
    }
}

