/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.PaymentBillUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.sm.pur.PaymentMatchFactory;
import com.kingdee.eas.scm.sm.pur.client.AbstractPaymentMatchListUI;
import com.kingdee.eas.scm.sm.pur.client.PaymentMatchRecordUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PaymentMatchListUI
extends AbstractPaymentMatchListUI {
    private static final Logger logger = CoreUIObject.getLogger(PaymentMatchListUI.class);
    private static final String strTakeOutZeroFormat = "%{0.##########}f";
    private static final String PURUIRESOURCE_PATH = "com.kingdee.eas.scm.sm.pur.PurUIResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.setIsCountAndSumRow(true);
        this.setIsNeedDefaultFilter(true);
        super.onLoad();
        this.boxShowSumRow.setEnabled(true);
        this.kDMenuShowSumRow.setEnabled(true);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.tblMain.getGroupManager().setGroup(true);
        String[] cols = new String[]{"isAudit", "matchDate", "matcher.name", "purOrder.number", "purOrder.prepayment", "amount", "purOrder.baseStatus", "purOrder.totalAmount"};
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            this.tblMain.getColumn(cols[i]).setGroup(true);
            this.tblMain.getColumn(cols[i]).setMergeable(true);
        }
        this.showSumAmount();
        this.actionTraceUp.setVisible(true);
        this.actionTraceDown.setVisible(true);
        this.actionCreateTo.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.setFunctionStatus();
    }

    private void showSumAmount() {
        String[] mcols = new String[]{"purOrder.prepayment", "amount", "entries.amount", "paymentBillEntry.amount", "purOrder.totalAmount"};
        int n = mcols.length;
        for (int i = 0; i < n; ++i) {
            this.tblMain.getColumn(mcols[i]).getStyleAttributes().setNumberFormat(strTakeOutZeroFormat);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PaymentMatchFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.setFunctionStatus();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo f = super.getDefaultFilterForQuery();
        f.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        return f;
    }

    private int getSelectTop() {
        KDTSelectBlock b = this.tblMain.getSelectManager().get();
        if (b != null) {
            return b.getTop();
        }
        return -1;
    }

    private void setFunctionStatus() {
        int r = this.getSelectTop();
        boolean selected = r != -1;
        this.actionTraceUp.setEnabled(selected);
        this.actionTraceDown.setEnabled(selected);
        this.actionAudit.setEnabled(selected);
        this.actionAntiAudit.setEnabled(selected);
        this.actionView.setEnabled(selected);
        if (selected) {
            boolean audited = (Boolean)this.tblMain.getCell(r, "isAudit").getValue();
            this.actionAudit.setEnabled(!audited);
            this.actionAntiAudit.setEnabled(audited);
        } else {
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock b = this.tblMain.getSelectManager().get();
        if (b != null) {
            int r = b.getTop();
            String orderId = (String)this.tblMain.getCell(r, "purOrder.id").getValue();
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"orderId", (Object)orderId);
            ctx.put((Object)"forEdit", (Object)false);
            try {
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PaymentMatchRecordUI.class.getName(), (Map)ctx, this.dataObjects);
                ui.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String id = (String)this.tblMain.getCell(r, "purOrder.id").getValue();
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"ID", (Object)id);
            try {
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI", (Map)ctx, null, OprtState.VIEW);
                ui.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String id = (String)this.tblMain.getCell(r, "paymentBill.id").getValue();
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"ID", (Object)id);
            try {
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PaymentBillUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
                ui.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    private static String[] filterDistnctID(String[] sourceArray) {
        if (sourceArray == null) {
            return null;
        }
        HashSet<String> setList = new HashSet<String>();
        for (int i = 0; i < sourceArray.length; ++i) {
            setList.add(sourceArray[i]);
        }
        String[] billIdlist = new String[setList.size()];
        billIdlist = setList.toArray(billIdlist);
        return billIdlist;
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String[] orderIDs = PaymentMatchListUI.filterDistnctID(KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"purOrder.id"));
            try {
                PaymentMatchFactory.getRemoteInstance().batchAntiAudit(orderIDs);
                this.refreshList();
            }
            catch (Exception e1) {
                MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)PURUIRESOURCE_PATH, (String)"sync_antiaudit_matchandpurorder") + e1.getMessage()));
            }
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String[] orderIDs = PaymentMatchListUI.filterDistnctID(KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"purOrder.id"));
            try {
                PaymentMatchFactory.getRemoteInstance().batchAudit(orderIDs);
                this.refreshList();
            }
            catch (Exception e1) {
                MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)PURUIRESOURCE_PATH, (String)"sync_audit_matchandpurorder") + e1.getMessage()));
            }
        }
    }

    protected boolean isFootVisible() {
        return true;
    }
}

