/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.arap.api.IMacthUiIsOK;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.PaymentBillUI;
import com.kingdee.eas.fi.cas.client.PaymentFilterUI;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.api.IPurCoreBillHeadInfo;
import com.kingdee.eas.scm.sm.pur.PaymentMatchEntryCollection;
import com.kingdee.eas.scm.sm.pur.PaymentMatchEntryInfo;
import com.kingdee.eas.scm.sm.pur.PaymentMatchFactory;
import com.kingdee.eas.scm.sm.pur.PaymentMatchInfo;
import com.kingdee.eas.scm.sm.pur.client.AbstractPaymentMatchRecordUI;
import com.kingdee.eas.scm.sm.pur.client.PaymentMatchRecordFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class PaymentMatchRecordUI
extends AbstractPaymentMatchRecordUI
implements IMacthUiIsOK {
    private static final long serialVersionUID = 1L;
    private boolean ok = false;
    private boolean forEdit = false;
    private IPurCoreBillHeadInfo order;
    private PaymentMatchInfo paymentMatchInfo;
    private PaymentFilterUI filterUI;
    private Color fullUsedColor = new Color(0xDDEEFF);
    private Color partUsedColor = new Color(0xEEDDFF);
    private Color normalColor = new Color(0xFFFFFF);
    private static final BigDecimal MAXVAL = new BigDecimal("999999999999.9999");
    private static final int DEFAULTRATE_PRICISION = 4;
    private static final BigDecimal MINVAL = new BigDecimal("-999999999999.9999");
    private static final String PURUIRESOURCE_PATH = "com.kingdee.eas.scm.sm.pur.PurUIResource";
    private static final String PURORDER_BILLTYPEID = "510b6503-0105-1000-e000-010bc0a812fd463ED552";
    private BigDecimal ZERO = new BigDecimal("0.00");
    private Color matchedColColor = new Color(0xFFFFF0);
    private boolean firstQuery = true;
    private String[] amountFields = new String[]{"actPayAmt", "actPayLocAmt", "verifiedAmt", "unVerifiedAmt", "entries.amount", "entries.amountVc", "entries.unVcAmount", "entries.rebate", "entries.actualAmt", "entries.actualAmtVc", "paymentMatchEntry.amount", "entries.unMatchedAmount"};
    FillListener fillListener = new FillListener();
    FilterParam param = null;
    boolean isQuerySourceContract = false;
    private static final String TXT_ALL_CONTRACT = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"TXT_ALL_CONTRACT");
    private static final String TXT_SRC_CONTRACT = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"TXT_SRC_CONTRACT");

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isShowQueryDialogOnLoad() {
        return this.forEdit;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number"};
    }

    private IColumn getMatchedCol() {
        return this.tblMain.getColumn("paymentMatchEntry.amount");
    }

    private IColumn getUnMatchedCol() {
        return this.tblMain.getColumn("entries.unMatchedAmount");
    }

    public void onLoad() throws Exception {
        int i;
        this.setIsCountAndSumRow(true);
        Map ctx = this.getUIContext();
        Boolean b = (Boolean)ctx.get("forEdit");
        this.forEdit = b == null ? false : b;
        String orderId = (String)ctx.get("orderId");
        this.loadInitData(orderId);
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tblMain.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.getMatchedCol().getStyleAttributes().setBackground(this.matchedColColor);
        this.getUnMatchedCol().getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.getMatchedCol().getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.txtUnMatched.setMaximumValue((Comparable)MAXVAL);
        this.txtUnMatched.setMinimumValue((Comparable)MINVAL);
        this.txtUnMatched.setDataType(1);
        this.txtUnMatched.setPrecision(4);
        this.txtMatched.setMaximumValue((Comparable)MAXVAL);
        this.txtMatched.setMinimumValue((Comparable)MINVAL);
        this.txtMatched.setDataType(1);
        this.txtMatched.setPrecision(4);
        this.txtUnMatched.setEditable(false);
        this.txtMatched.setEditable(false);
        this.actionSave.setEnabled(false);
        this.actionQuerySourceContract.setEnabled(true);
        HashMap map = this.getActionManager().getActionSet();
        for (String action : map.keySet()) {
            boolean visiable = "actionQuery".equals(action) || "actionExit".equals(action) || "actionTraceDown".equals(action) || "actionQuerySourceContract".equals(action) || this.forEdit && "actionSave".equals(action);
            ((ItemAction)map.get(action)).setVisible(visiable);
        }
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.tblMain.getColumn("currency.precision").getStyleAttributes().setHided(false);
        String[] dateCols = new String[]{"createTime", "auditDate"};
        int size = dateCols.length;
        for (i = 0; i < size; ++i) {
            this.tblMain.getColumn(dateCols[i]).getStyleAttributes().setNumberFormat(ArApBillUtil.getDateFormatString());
        }
        if (this.forEdit) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaymentMatchRecordUI.this.tblMain.requestFocus();
                }
            });
            this.getMatchedCol().getStyleAttributes().setLocked(false);
            this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopping(KDTEditEvent e) {
                    PaymentMatchRecordUI.this.onCellEditValueChanged(e);
                }
            });
        } else {
            this.actionQuerySourceContract.setVisible(false);
        }
        for (i = 0; i < this.amountFields.length; ++i) {
            this.tblMain.getColumn(this.amountFields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        this.btnQuerySourceContract.setEnabled(false);
        this.btnQuerySourceContract.setVisible(false);
        this.btnQueryContract.setSelected(true);
    }

    private static String getUIResource(String key) {
        return EASResource.getString((String)PURUIRESOURCE_PATH, (String)key);
    }

    private void loadInitData(String orderId) {
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("companyOrgUnit.*");
            selector.add("entries.*");
            selector.add("entries.paymentCustomer.*");
            this.order = (IPurCoreBillHeadInfo)BusinessProcessUtil.getValueByBosType(null, (IObjectPK)new ObjectUuidPK(orderId), (SelectorItemCollection)selector);
            if (this.forEdit && this.order.isIsMatched()) {
                MsgBox.showInfo((Component)((Object)this), (String)PaymentMatchRecordUI.getUIResource("PurOrder_Already_Match_PaymentBill"));
                SysUtil.abort();
            }
            this.paymentMatchInfo = PaymentMatchFactory.getRemoteInstance().getMatchInfo(this.order.getId().toString());
            this.paymentMatchInfo.setPurOrderID(this.order.getId().toString());
            if (this.forEdit) {
                this.paymentMatchInfo.setCompany(this.order.getCompanyOrgUnit());
            }
            this.setUITitle(this.getUITitle() + " - " + PaymentMatchRecordUI.getUIResource("F7Title_PurOrder") + this.order.getNumber());
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
    }

    public boolean isOK() {
        return this.ok;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    private void setListUITablePrecision(int start, int end) {
        for (int i = start; i <= end; ++i) {
            IRow row = this.tblMain.getRow(i);
            int precision = 2;
            ICell cell = row.getCell("currency.precision");
            if (cell != null && cell.getValue() != null) {
                precision = Integer.parseInt(cell.getValue().toString());
                row.getCell("paymentMatchEntry.amount").setEditor((ICellEditor)PaymentMatchRecordUI.createAmountEditor(precision, false));
            }
            for (int j = 0; j < this.amountFields.length; ++j) {
                ArApBillUIUtil.setPrecision(row.getCell(this.amountFields[j]), precision);
            }
        }
    }

    private static KDTDefaultCellEditor createAmountEditor(int i, boolean isNegatived) {
        KDFormattedTextField f = new KDFormattedTextField();
        f.setDataType(1);
        f.setPrecision(i % 11);
        f.setMaximumValue((Comparable)MAXVAL);
        f.setMinimumValue((Comparable)MINVAL);
        f.setHorizontalAlignment(4);
        f.setSupportedEmpty(true);
        f.setRemoveingZeroInDispaly(false);
        f.setNegatived(isNegatived);
        return new KDTDefaultCellEditor((JTextField)f);
    }

    private void onCellEditValueChanged(KDTEditEvent e) {
        int r = e.getRowIndex();
        BigDecimal unmatched = this.getCellDoubleValue(this.tblMain.getCell(r, this.getUnMatchedCol().getColumnIndex()));
        Object obj = e.getValue();
        if (obj instanceof BigDecimal) {
            BigDecimal matched = (BigDecimal)obj;
            if (matched.compareTo(unmatched) > 0) {
                e.setCancel(true);
            }
        } else if (obj == null) {
            obj = this.ZERO;
            e.setValue(obj);
        } else {
            e.setCancel(true);
        }
        if (!e.isCancel()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaymentMatchRecordUI.this.refreshMatchUI();
                }
            });
        }
    }

    private void refreshMatchUI() {
        this.actionSave.setEnabled(false);
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        int col_unmatched_index = this.getUnMatchedCol().getColumnIndex();
        if (this.forEdit) {
            BigDecimal total = this.ZERO;
            int n = this.tblMain.getRowCount3();
            for (int i = 0; i < n; ++i) {
                total = total.add(this.getCellDoubleValue(this.tblMain.getCell(i, col_matched_index)));
            }
            this.txtMatched.setValue((Object)total);
            this.actionSave.setEnabled(total.compareTo(this.ZERO) > 0);
        }
        int n = this.tblMain.getRowCount3();
        BigDecimal dd = this.ZERO;
        BigDecimal dt = this.ZERO;
        for (int i = 0; i < n; ++i) {
            dd = this.getCellDoubleValue(this.tblMain.getCell(i, col_matched_index));
            Color c = dd.compareTo(this.ZERO) > 0 ? (dd.compareTo(dt = this.getCellDoubleValue(this.tblMain.getCell(i, col_unmatched_index)).subtract(dd)) == 0 || dt.compareTo(this.ZERO) == 0 ? this.fullUsedColor : this.partUsedColor) : this.normalColor;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(c);
            this.tblMain.getCell(i, col_matched_index).getStyleAttributes().setBackground(this.matchedColColor);
        }
        BigDecimal d1 = this.txtUnMatched.getBigDecimalValue();
        BigDecimal d2 = this.txtMatched.getBigDecimalValue();
        if (d1 != null && d2 != null && d1.compareTo(d2) != 0) {
            BigDecimal v = d2.subtract(d1);
            String prefix = v.compareTo(this.ZERO) > 0 ? "+" : "";
            this.lblTip.setToolTipText(prefix + v);
            this.lblTip.setText(prefix + v);
            this.lblTip.setVisible(true);
            this.lblTip.setUserObject((Object)v);
        } else {
            this.clearMatchTip();
        }
        if (n < 0) {
            this.clearMatchTip();
        }
    }

    private void clearMatchTip() {
        this.lblTip.setText("");
        this.lblTip.setVisible(false);
        this.lblTip.setUserObject((Object)this.ZERO);
    }

    private BigDecimal getCellDoubleValue(ICell cell) {
        Object obj = cell.getValue();
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return this.ZERO;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo ff = new FilterInfo();
        FilterItemCollection fc = ff.getFilterItems();
        if (this.forEdit) {
            String contractBillId = "";
            contractBillId = this.order.getSourceBillId() != null ? this.order.getSourceBillId() : "123";
            if (this.order.getSourceBillId() != null) {
                fc.add(new FilterItemInfo("coreBillType.id", (Object)PURORDER_BILLTYPEID, CompareType.EQUALS));
                fc.add(new FilterItemInfo("entries.coreBillId", (Object)this.order.getId().toString(), CompareType.EQUALS));
                fc.add(new FilterItemInfo("entries.contractBillID", (Object)this.order.getSourceBillId().toString(), CompareType.EQUALS));
            }
            fc.add(new FilterItemInfo("entries.sourceBillId", null, CompareType.IS));
            fc.add(new FilterItemInfo("entries.sourceBillId in (select fid from T_AP_PayRequestBill )"));
            fc.add(new FilterItemInfo("entries.contractBillID", (Object)contractBillId, CompareType.EQUALS));
            fc.add(new FilterItemInfo("billStatus", (Object)new Integer(15)));
            fc.add(new FilterItemInfo("company.id", (Object)this.order.getCompanyOrgUnit().getId().toString()));
            fc.add(new FilterItemInfo("payBillType.number", (Object)new Integer(202)));
            fc.add(new FilterItemInfo("payBillType.preSetBillType.number", (Object)new Integer(202)));
            fc.add(new FilterItemInfo("currency.id", (Object)this.order.getCurrency().getId().toString()));
            if (this.order.getSupplier() != null && this.order.getSupplier().getId() != null) {
                fc.add(new FilterItemInfo("payeeID", (Object)this.order.getSupplier().getId().toString()));
            }
            fc.add(new FilterItemInfo("entries.unmatchedAmount", (Object)this.ZERO, CompareType.GREATER));
            if (this.order.getSourceBillId() != null && this.order.getSupplier() != null) {
                ff.setMaskString("((#0 and #1 and #2) or #3 or #4  or #5) and #6 and #7 and (#8 or #9) and #10 and #11 and #12");
            } else if (this.order.getSourceBillId() == null && this.order.getSupplier() != null) {
                ff.setMaskString("(#0 or #1 or #2) and #3 and #4 and (#5 or #6) and #7 and #8 and #9");
            }
        } else {
            fc.add(new FilterItemInfo("purOrder.id", (Object)this.order.getId().toString(), CompareType.EQUALS));
            PaymentMatchEntryCollection en = this.paymentMatchInfo.getEntries();
            HashSet<String> paymentBIllEntryIdSet = new HashSet<String>();
            if (en != null && en.size() > 0) {
                int n = en.size();
                for (int i = 0; i < n; ++i) {
                    paymentBIllEntryIdSet.add(en.get(i).getPaymentBillEntry().getId().toString());
                }
            }
            if (paymentBIllEntryIdSet != null && paymentBIllEntryIdSet.size() > 0) {
                fc.add(new FilterItemInfo("entries.id", paymentBIllEntryIdSet, CompareType.INCLUDE));
            }
        }
        return ff;
    }

    public void executeQuery(FilterParam param) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fc = filter.getFilterItems();
        if (param != null && param.getFilter() != null && param.getFilter().getFilterItems() != null) {
            FilterInfo defaultFilterForQuery = this.getDefaultFilterForQuery();
            if (defaultFilterForQuery != null && defaultFilterForQuery.getFilterItems().size() > 0) {
                if (this.mainQuery.getFilter().getFilterItems().size() == 0) {
                    this.mainQuery.setFilter(defaultFilterForQuery);
                } else {
                    this.mainQuery.getFilter().getFilterItems().clear();
                    this.mainQuery.setFilter(defaultFilterForQuery);
                }
            }
            fc.add(param.getFilter().getFilterItems().get(1));
            fc.add(param.getFilter().getFilterItems().get(2));
            this.mainQuery.getFilter().mergeFilter(filter, "AND");
            this.mainQuery.getSorter().addObjectCollection((IObjectCollection)param.getSorterItems());
        }
        this.execQuery();
        this.setParam(param);
    }

    private void setParam(FilterParam param) {
        this.param = param;
    }

    protected void execQuery() {
        super.execQuery();
        this.firstQuery = true;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.scm.sm.pur.PaymentMatchRecordQuery";
    }

    protected String getQueryUiName() {
        return this.getMetaDataPK().getFullName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return (ICoreBase)BusinessProcessUtil.getBizInteface(null, (BOSObjectType)new BOSObjectType("3171BFAD"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        if (e.getClickCount() >= 2) {
            if (this.forEdit && e.getColIndex() != col_matched_index) {
                int col_unmatched_index = this.getUnMatchedCol().getColumnIndex();
                KDTSelectBlock b = this.tblMain.getSelectManager().get();
                if (b != null) {
                    int r = b.getBeginRow();
                    if (r < 0) {
                        return;
                    }
                    IRow row = this.tblMain.getRow(r);
                    ICell cell = row.getCell(col_matched_index);
                    BigDecimal oldValue = this.getCellDoubleValue(cell);
                    BigDecimal fullValue = this.getCellDoubleValue(row.getCell(col_unmatched_index));
                    BigDecimal newValue = this.ZERO;
                    if (oldValue.compareTo(this.ZERO) == 0) {
                        BigDecimal total = this.ZERO;
                        int n = this.tblMain.getRowCount3();
                        for (int i = 0; i < n; ++i) {
                            if (i == r) continue;
                            total = total.add(this.getCellDoubleValue(this.tblMain.getCell(i, col_matched_index)));
                        }
                        BigDecimal dt = this.order.getUnPrepaidAmount().subtract(total);
                        newValue = dt.compareTo(fullValue) > 0 || dt.compareTo(this.ZERO) <= 0 ? fullValue : dt;
                    } else if (oldValue.compareTo(fullValue) < 0) {
                        newValue = fullValue;
                    } else {
                        newValue = this.ZERO;
                        cell.setValue((Object)this.ZERO);
                    }
                    if (oldValue != newValue) {
                        cell.setValue((Object)newValue);
                        this.refreshMatchUI();
                    }
                }
            } else if (!this.forEdit) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PaymentMatchRecordUI.this.setCursorOfWair();
                            PaymentMatchRecordUI.this.actionTraceDown_actionPerformed(null);
                        }
                        catch (Exception e) {
                            PaymentMatchRecordUI.this.handleException(e);
                        }
                        finally {
                            PaymentMatchRecordUI.this.setCursorOfDefault();
                        }
                    }
                });
            }
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.actionTraceDown.setEnabled(this.getSelectTop() != -1);
    }

    private int getSelectTop() {
        KDTSelectBlock b = this.tblMain.getSelectManager().get();
        if (b != null) {
            return b.getTop();
        }
        return -1;
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.ok = false;
        this.getUIWindow().hide();
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyTo_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String id = (String)this.tblMain.getCell(r, "id").getValue();
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"ID", (Object)id);
            ctx.put((Object)"openModel", (Object)"frame");
            try {
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(PaymentBillUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
                ui.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    private boolean save() throws EASBizException, BOSException {
        if (this.tblMain.getRowCount3() == 0) {
            return false;
        }
        BigDecimal dt = (BigDecimal)this.lblTip.getUserObject();
        if (dt.compareTo(this.ZERO) < 0) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)PaymentMatchRecordUI.getUIResource("confirm_save_match_lessthan")) != 0) {
                return false;
            }
        } else if (dt.compareTo(this.ZERO) > 0) {
            IParamControl ipc = null;
            ipc = ParamControlFactory.getRemoteInstance();
            boolean paramValue = false;
            ObjectUuidPK pk = new ObjectUuidPK(this.paymentMatchInfo.getCompany().getId());
            String strParamValue = ipc.getParamValue((IObjectPK)pk, "ORDERPAYMENT");
            if ("true".equalsIgnoreCase(strParamValue) || "1".equals(strParamValue)) {
                paramValue = true;
            } else if ("false".equalsIgnoreCase(strParamValue) || "0".equals(strParamValue)) {
                paramValue = false;
            }
            if (!paramValue) {
                MsgBox.showInfo((String)PaymentMatchRecordUI.getUIResource("confirm_save_match_largethan_orderunprepayment"));
                return false;
            }
        }
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        int col_entriesId_index = this.tblMain.getColumn("entries.id").getColumnIndex();
        PaymentMatchInfo mm = (PaymentMatchInfo)this.paymentMatchInfo.clone();
        PaymentMatchEntryCollection entries = mm.getEntries();
        BigDecimal matched = this.ZERO;
        int n = this.tblMain.getRowCount3();
        BigDecimal dd = this.ZERO;
        for (int i = 0; i < n; ++i) {
            dd = this.getCellDoubleValue(this.tblMain.getCell(i, col_matched_index));
            if (dd.compareTo(this.ZERO) <= 0) continue;
            matched = matched.add(dd);
            PaymentMatchEntryInfo item = new PaymentMatchEntryInfo();
            item.setAmount(dd);
            PaymentBillEntryInfo pbEntry = new PaymentBillEntryInfo();
            pbEntry.setId(BOSUuid.read((String)((String)this.tblMain.getCell(i, col_entriesId_index).getValue())));
            item.setPaymentBillEntry(pbEntry);
            entries.add(item);
        }
        mm.setAmount(matched);
        mm.setMatcher(SysContext.getSysContext().getCurrentUserInfo());
        PaymentMatchFactory.getRemoteInstance().match(this.order.getId().toString(), mm);
        return true;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.save()) {
            this.ok = true;
            this.getUIWindow().hide();
        }
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionSendSmsMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendSmsMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actoinViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actoinViewSignature_actionPerformed(e);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionPrecisionConfig_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionNoZero_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionIsShowSumRow_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PaymentMatchRecordFilterUI(false, SourceTypeEnum.AP, this.cache, this.order, this.paymentMatchInfo);
        }
        if (this.getBOTPViewStatus() == 1) {
            this.filterUI.getUIContext().put("TargetBillType", "ReceiptForm");
        }
        return this.filterUI;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog queryDlg = super.getQueryDlg();
        queryDlg.setWidth(424);
        queryDlg.setHeight(342);
        return queryDlg;
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        final boolean noResult = rowSet == null || rowSet.size() == 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaymentMatchRecordUI.this.data2UI(noResult);
                PaymentMatchRecordUI.this.firstQuery = false;
            }
        });
    }

    private void data2UI(boolean noResult) {
        this.txtUnMatched.setValue((Object)this.order.getUnPrepaidAmount());
        this.txtMatched.setValue((Object)this.paymentMatchInfo.getAmount());
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        if (noResult) {
            this.lblTip.setVisible(false);
            this.actionSave.setEnabled(false);
        } else {
            if (this.forEdit) {
                int n = this.tblMain.getRowCount3();
                for (int i = 0; i < n; ++i) {
                    this.tblMain.getRow(i).getCell(col_matched_index).setValue((Object)this.ZERO);
                }
                if (this.firstQuery) {
                    this.autoMatch();
                }
            } else {
                int col_entriesId_index = this.tblMain.getColumn("entries.id").getColumnIndex();
                int n = this.tblMain.getRowCount();
                for (int i = 0; i < n; ++i) {
                    String entriesId = (String)this.tblMain.getCell(i, col_entriesId_index).getValue();
                    String orderId = (String)this.tblMain.getCell(i, "order.id").getValue();
                    if (!StringUtils.isEmpty((String)orderId) && orderId.equals(this.order.getId().toString())) {
                        this.tblMain.getCell(i, "paymentMatchEntry.amount").setValue((Object)this.getMatchedAMountByPaymentBillEntryId(entriesId));
                        continue;
                    }
                    this.tblMain.getRow(i).getStyleAttributes().setHided(true);
                }
            }
            this.refreshMatchUI();
        }
    }

    private BigDecimal getMatchedAMountByPaymentBillEntryId(String id) {
        PaymentMatchEntryCollection mec = this.paymentMatchInfo.getEntries();
        int n = mec.size();
        for (int i = 0; i < n; ++i) {
            String matchedBillEntryId = mec.get(i).getPaymentBillEntry().getId().toString();
            if (!id.equals(matchedBillEntryId)) continue;
            return mec.get(i).getAmount();
        }
        return this.ZERO;
    }

    private void autoMatch() {
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        int col_unmatched_index = this.getUnMatchedCol().getColumnIndex();
        BigDecimal unmatched = this.order.getUnPrepaidAmount();
        BigDecimal matched = this.ZERO;
        int n = this.tblMain.getRowCount3();
        BigDecimal full = this.ZERO;
        BigDecimal curMatch = this.ZERO;
        for (int i = 0; i < n; ++i) {
            full = this.getCellDoubleValue(this.tblMain.getCell(i, col_unmatched_index));
            curMatch = matched.add(full).compareTo(unmatched) <= 0 ? full : unmatched.subtract(matched);
            this.tblMain.getCell(i, col_matched_index).setValue((Object)curMatch);
            matched = matched.add(curMatch);
            if (matched == unmatched) break;
        }
    }

    @Override
    public void actionQuerySourceContract_actionPerformed(ActionEvent e) throws Exception {
        if (this.isQuerySourceContract) {
            FilterInfo ff = new FilterInfo();
            FilterItemCollection fc = ff.getFilterItems();
            String contractBillId = "";
            contractBillId = this.order.getSourceBillId() != null ? this.order.getSourceBillId() : "123";
            fc.add(new FilterItemInfo("entries.contractBillID", (Object)contractBillId, CompareType.EQUALS));
            fc.add(new FilterItemInfo("billStatus", (Object)new Integer(15)));
            fc.add(new FilterItemInfo("company.id", (Object)this.order.getCompanyOrgUnit().getId().toString()));
            fc.add(new FilterItemInfo("payBillType.number", (Object)new Integer(202)));
            fc.add(new FilterItemInfo("payBillType.preSetBillType.number", (Object)new Integer(202)));
            fc.add(new FilterItemInfo("currency.id", (Object)this.order.getCurrency().getId().toString()));
            if (this.order.getSupplier() != null && this.order.getSupplier().getId() != null) {
                fc.add(new FilterItemInfo("payeeID", (Object)this.order.getSupplier().getId().toString(), CompareType.EQUALS));
            }
            if (!this.order.isIsMatched()) {
                fc.add(new FilterItemInfo("entries.unmatchedAmount", (Object)this.ZERO, CompareType.GREATER));
            }
            if (this.param != null) {
                fc.add(this.param.getFilter().getFilterItems().get(1));
                fc.add(this.param.getFilter().getFilterItems().get(2));
                if (this.order.getSourceBillId() != null) {
                    if (this.order.getSupplier() != null && !this.order.isIsMatched()) {
                        ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6 and #7 and #8 and #9");
                    } else if (this.order.getSupplier() == null && !this.order.isIsMatched()) {
                        ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6 and #7 and #8");
                    }
                } else if (this.order.getSupplier() != null && !this.order.isIsMatched()) {
                    ff.setMaskString("#0 and #1 and (#2 or #3) and #4 and #5 and #6 and #7 and #8");
                } else if (this.order.getSupplier() == null && !this.order.isIsMatched()) {
                    ff.setMaskString("#0 and #1 and (#2 or #3) and #4 and #5 and #6 and #7");
                }
                this.mainQuery.getFilter().mergeFilter(ff, "AND");
            } else {
                if (this.order.getSourceBillId() != null) {
                    if (this.order.getSupplier() != null && !this.order.isIsMatched()) {
                        ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6 and #7");
                    } else if (this.order.getSupplier() == null && !this.order.isIsMatched()) {
                        ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6");
                    }
                } else if (this.order.getSupplier() != null && !this.order.isIsMatched()) {
                    ff.setMaskString("#0 and #1 and (#2 or #3) and #4 and #5 and #6");
                } else if (this.order.getSupplier() == null && !this.order.isIsMatched()) {
                    ff.setMaskString("#0 and #1 and (#2 or #3) and #4 and #5");
                }
                this.mainQuery.getFilter().mergeFilter(ff, "AND");
            }
            this.mainQuery.setFilter(ff);
            this.execQuery();
            if (this.tblMain.getRowCount() == 0) {
                MsgBox.showInfo((String)PaymentMatchRecordUI.getUIResource("NO_CREATETO_PAYMENTBILL"));
                SysUtil.abort();
            }
        } else {
            FilterInfo ff = new FilterInfo();
            FilterItemCollection fc = ff.getFilterItems();
            fc.add(new FilterItemInfo("entries.contractBillID", null, CompareType.ISNOT));
            fc.add(new FilterItemInfo("billStatus", (Object)new Integer(15)));
            fc.add(new FilterItemInfo("company.id", (Object)this.order.getCompanyOrgUnit().getId().toString()));
            fc.add(new FilterItemInfo("payBillType.number", (Object)new Integer(202)));
            fc.add(new FilterItemInfo("payBillType.preSetBillType.number", (Object)new Integer(202)));
            fc.add(new FilterItemInfo("currency.id", (Object)this.order.getCurrency().getId().toString()));
            if (this.order.getSupplier() != null && this.order.getSupplier().getId() != null) {
                fc.add(new FilterItemInfo("payeeID", (Object)this.order.getSupplier().getId().toString(), CompareType.EQUALS));
            }
            if (!this.order.isIsMatched()) {
                fc.add(new FilterItemInfo("entries.unmatchedAmount", (Object)this.ZERO, CompareType.GREATER));
            }
            if (this.param != null) {
                fc.add(this.param.getFilter().getFilterItems().get(1));
                fc.add(this.param.getFilter().getFilterItems().get(2));
                if (this.order.getSupplier() != null && !this.order.isIsMatched()) {
                    ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6 and #7 and #8 and #9");
                } else if (this.order.getSupplier() == null && !this.order.isIsMatched()) {
                    ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6 and #7 and #8");
                }
                this.mainQuery.getFilter().mergeFilter(ff, "AND");
            } else {
                if (this.order.getSupplier() != null && !this.order.isIsMatched()) {
                    ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6 and #7");
                } else if (this.order.getSupplier() == null && !this.order.isIsMatched()) {
                    ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6");
                }
                this.mainQuery.getFilter().mergeFilter(ff, "AND");
            }
            this.mainQuery.setFilter(ff);
            this.execQuery();
        }
    }

    protected boolean isFootVisible() {
        return true;
    }

    public void actionQueryAllContract_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo ff = new FilterInfo();
        FilterItemCollection fc = ff.getFilterItems();
        fc.add(new FilterItemInfo("entries.contractBillID", null, CompareType.ISNOT));
        fc.add(new FilterItemInfo("billStatus", (Object)new Integer(15)));
        fc.add(new FilterItemInfo("company.id", (Object)this.order.getCompanyOrgUnit().getId().toString()));
        fc.add(new FilterItemInfo("payBillType.number", (Object)new Integer(202)));
        fc.add(new FilterItemInfo("payBillType.preSetBillType.number", (Object)new Integer(202)));
        fc.add(new FilterItemInfo("currency.id", (Object)this.order.getCurrency().getId().toString()));
        if (this.order.getSupplier() != null && this.order.getSupplier().getId() != null) {
            fc.add(new FilterItemInfo("payeeID", (Object)this.order.getSupplier().getId().toString(), CompareType.EQUALS));
        }
        if (!this.order.isIsMatched()) {
            fc.add(new FilterItemInfo("entries.unmatchedAmount", (Object)this.ZERO, CompareType.GREATER));
        }
        if (this.param != null) {
            fc.add(this.param.getFilter().getFilterItems().get(1));
            fc.add(this.param.getFilter().getFilterItems().get(2));
            if (this.order.getSupplier() != null && !this.order.isIsMatched()) {
                ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6 and #7 and #8 and #9");
            } else if (this.order.getSupplier() == null && !this.order.isIsMatched()) {
                ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6 and #7 and #8");
            }
            this.mainQuery.getFilter().mergeFilter(ff, "AND");
        } else {
            if (this.order.getSupplier() != null && !this.order.isIsMatched()) {
                ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6 and #7");
            } else if (this.order.getSupplier() == null && !this.order.isIsMatched()) {
                ff.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6");
            }
            this.mainQuery.getFilter().mergeFilter(ff, "AND");
        }
        this.mainQuery.setFilter(ff);
        this.execQuery();
    }

    @Override
    protected void btnQueryContract_stateChanged(ChangeEvent e) throws Exception {
        super.btnQueryContract_stateChanged(e);
    }

    @Override
    protected void btnQueryContract_itemStateChanged(ItemEvent e) throws Exception {
        super.btnQueryContract_itemStateChanged(e);
        this.isQuerySourceContract = !this.isQuerySourceContract;
        KDToggleButton btn = (KDToggleButton)e.getSource();
        if (this.isQuerySourceContract) {
            btn.setText(TXT_ALL_CONTRACT);
        } else {
            btn.setText(TXT_SRC_CONTRACT);
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            PaymentMatchRecordUI.this.setListUITablePrecision(e.getFirstRow(), e.getLastRow());
        }
    }
}

