/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFlowItemInfo;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.RecPayBookNotifyBuilder;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractRecPackageJournal {
    protected PeriodInfo currPeriodInfo;
    protected int cs104;
    protected boolean isMinusReverse;
    protected ReceivingBillInfo billInfo;
    protected Context ctx;
    protected String billId;
    protected RecPayBookNotifyBuilder builder;

    public abstract void bookReceivingBill(JournalCollection var1) throws BOSException, EASBizException;

    protected void bookOppAccount(Context ctx, String billId, JournalCollection journalCollection, ReceivingBillInfo billInfo) throws BOSException, EASBizException {
        AccountViewInfo oppAccount = this.getOppAccountView();
        if (oppAccount != null && (oppAccount.isIsBank() || oppAccount.isIsCash())) {
            JournalInfo journalInfo = this.createBaseJournal(ctx, billInfo);
            this.createJournalFundFlowItem(billInfo, journalInfo, false);
            journalInfo.setIsDebit(false);
            if (oppAccount.isIsBank()) {
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(this.getOppAccount_AccountBank());
            } else if (oppAccount.isIsCash()) {
                journalInfo.setType(JournalTypeEnum.CASH);
            }
            journalInfo.setAccountView(oppAccount);
            journalInfo.setOppAccountView(billInfo.getPayeeAccount());
            BigDecimal amount = this.getAmount();
            BigDecimal bigDecimal = amount = amount == null ? FMConstants.ZERO : amount;
            if (this.isMinusReverse && amount.compareTo(FMConstants.ZERO) < 0) {
                journalInfo.setCreditAmount(FMConstants.ZERO);
                journalInfo.setDebitAmount(amount.abs());
            } else {
                journalInfo.setDebitAmount(FMConstants.ZERO);
                journalInfo.setCreditAmount(amount);
            }
            if (null != billInfo.getVoucher() && billInfo.getVoucher().getBizStatus() != VoucherStatusEnum.TEMP) {
                journalInfo.setVoucherId(billInfo.getVoucher().getId().toString());
                journalInfo.setVoucherNumber(billInfo.getVoucherNumber());
                journalInfo.setVoucherType(billInfo.getVoucherType());
                if (EmptyUtil.isEmpty((CoreBaseInfo)journalInfo.getOppAccountView()) && billInfo.getVoucher().getEntries().size() > 0) {
                    VoucherEntryInfo oppVoucherInfo = null;
                    VoucherEntryCollection col = billInfo.getVoucher().getEntries();
                    for (int i = 0; i < col.size(); ++i) {
                        VoucherEntryInfo EntryInfo = col.get(i);
                        if (EntryDC.CREDIT != EntryInfo.getEntryDC()) continue;
                        oppVoucherInfo = EntryInfo;
                        break;
                    }
                    if (oppVoucherInfo != null && oppVoucherInfo.getAccount() != null) {
                        journalInfo.setOppAccountView(oppVoucherInfo.getAccount());
                    }
                }
            }
            if (!FMHelper.checkIsBooked((Context)ctx, (String)billInfo.getSourceBillId(), (BOSObjectType)new TimeDepositBillInfo().getBOSType(), (AccountBankInfo)journalInfo.getAccountBank())) {
                journalCollection.add(journalInfo);
                this.builder.CtrlOppAcctIDSet.add(billId);
            }
        }
    }

    protected void bookPayeeAccount(Context ctx, JournalCollection journalCollection, ReceivingBillInfo billInfo) throws BOSException, EASBizException {
        AccountViewInfo acct = billInfo.getPayeeAccount();
        if (acct != null && (acct.isIsBank() || acct.isIsCash())) {
            JournalInfo journalInfo = this.createBaseJournal(ctx, billInfo);
            this.createJournalFundFlowItem(billInfo, journalInfo, true);
            journalInfo.setIsDebit(true);
            if (acct.isIsBank()) {
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(billInfo.getPayeeAccountBank());
            } else if (acct.isIsCash()) {
                journalInfo.setType(JournalTypeEnum.CASH);
            }
            journalInfo.setAccountView(acct);
            journalInfo.setOppAccountView(this.getOppAccountView());
            BigDecimal amount = this.getAmount();
            BigDecimal bigDecimal = amount = amount == null ? FMConstants.ZERO : amount;
            if (this.isMinusReverse && amount.compareTo(FMConstants.ZERO) < 0) {
                journalInfo.setDebitAmount(FMConstants.ZERO);
                journalInfo.setCreditAmount(amount.abs());
            } else {
                journalInfo.setCreditAmount(FMConstants.ZERO);
                journalInfo.setDebitAmount(amount);
            }
            if (null != billInfo.getVoucher() && billInfo.getVoucher().getBizStatus() != VoucherStatusEnum.TEMP) {
                journalInfo.setVoucherId(billInfo.getVoucher().getId().toString());
                journalInfo.setVoucherNumber(billInfo.getVoucherNumber());
                journalInfo.setVoucherType(billInfo.getVoucherType());
                if (EmptyUtil.isEmpty((CoreBaseInfo)journalInfo.getOppAccountView()) && billInfo.getVoucher().getEntries().size() > 0) {
                    VoucherEntryInfo oppVoucherInfo = null;
                    VoucherEntryCollection col = billInfo.getVoucher().getEntries();
                    for (int i = 0; i < col.size(); ++i) {
                        VoucherEntryInfo EntryInfo = col.get(i);
                        if (EntryDC.CREDIT != EntryInfo.getEntryDC()) continue;
                        oppVoucherInfo = EntryInfo;
                        break;
                    }
                    if (oppVoucherInfo != null && oppVoucherInfo.getAccount() != null) {
                        journalInfo.setOppAccountView(oppVoucherInfo.getAccount());
                    }
                }
            }
            journalInfo.setOppAcctNumber(billInfo.getPayerAccountBank());
            journalInfo.setOppBank(billInfo.getPayerBank());
            if (!FMHelper.checkIsBooked((Context)ctx, (String)billInfo.getSourceBillId(), (BOSObjectType)new TimeDepositBillInfo().getBOSType(), (AccountBankInfo)journalInfo.getAccountBank())) {
                journalCollection.add(journalInfo);
            }
        }
    }

    protected abstract String getDescreption();

    protected abstract BigDecimal getAmount();

    protected abstract AccountViewInfo getOppAccountView();

    protected abstract AccountBankInfo getOppAccount_AccountBank() throws EASBizException, BOSException;

    private JournalInfo createBaseJournal(Context ctx, ReceivingBillInfo billInfo) throws BOSException, EASBizException {
        PeriodInfo temp;
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setAgentBook(billInfo.isAgentBook());
        journalInfo.setCompany(billInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(billInfo.getId().toString());
        journalInfo.setBillType(BillTypeEnum.receiveBill);
        journalInfo.setBillNumber(billInfo.getNumber());
        journalInfo.setBizDate(billInfo.getBizDate());
        CompanyOrgUnitInfo companyInfo1 = billInfo.getCompany();
        Date bookDate = this.getBookDate_cs104(ctx, billInfo.getBizDate(), companyInfo1);
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = null;
        if (this.builder.billPeriodCache != null && (temp = this.builder.billPeriodCache).getBeginDate().compareTo(bookDate) <= 0 && temp.getEndDate().compareTo(bookDate) >= 0 && companyInfo1.getAccountPeriodType().getId().toString().equals(temp.getPeriodType().getId().toString())) {
            bookPeriodInfo = temp;
        }
        if (bookPeriodInfo == null) {
            this.builder.billPeriodCache = bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo1);
        }
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setCurrency(billInfo.getCurrency());
        journalInfo.setPlanItem(billInfo.getFpItem());
        journalInfo.setSettlementType(billInfo.getSettlementType());
        journalInfo.setSettlementNumber(billInfo.getSettlementNumber());
        journalInfo.setDescription(this.getDescreption());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setOppUnit(billInfo.getPayerName());
        if (billInfo.getBankCheckFlag() != null) {
            journalInfo.setBankCheckFlag(billInfo.getBankCheckFlag());
        }
        return journalInfo;
    }

    protected Date getBookDate_cs104(Context ctx, Date bizDate, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
        }
        Date bookDate = bizDate;
        if (this.cs104 == 1) {
            bookDate = new Date();
        }
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    private void createJournalFundFlowItem(ReceivingBillInfo billInfo, JournalInfo journalInfo, boolean isOwn) {
        ReceivingBillEntryCollection receivingBillEntryCollection = billInfo.getEntries();
        if ("head".equals(this.getJournlType())) {
            for (int i = 0; i < receivingBillEntryCollection.size(); ++i) {
                ReceivingBillEntryInfo entryInfo = receivingBillEntryCollection.get(i);
                JournalFlowItemInfo flowItemInfo = new JournalFlowItemInfo();
                flowItemInfo.setFundFlowItem(entryInfo.getFundFlowItem());
                if (isOwn) {
                    if (entryInfo.getFundFlowItem() != null && entryInfo.getFundFlowItem().getDirection() == FundFlowDirection.OUT) {
                        flowItemInfo.setAmount(entryInfo.getActualAmt().negate());
                    } else {
                        flowItemInfo.setAmount(entryInfo.getActualAmt());
                    }
                } else if (entryInfo.getFundFlowItem() != null && entryInfo.getFundFlowItem().getDirection() == FundFlowDirection.IN) {
                    flowItemInfo.setAmount(entryInfo.getActualAmt().negate());
                } else {
                    flowItemInfo.setAmount(entryInfo.getActualAmt());
                }
                journalInfo.getFlowItemEntries().add(flowItemInfo);
            }
        } else {
            JournalFlowItemInfo flowItemInfo = new JournalFlowItemInfo();
            flowItemInfo.setFundFlowItem(this.getEntryFlowItem());
            if (isOwn) {
                if (this.getEntryFlowItem() != null && this.getEntryFlowItem().getDirection() == FundFlowDirection.OUT) {
                    flowItemInfo.setAmount(this.getAmount().negate());
                } else {
                    flowItemInfo.setAmount(this.getAmount());
                }
            } else if (this.getEntryFlowItem() != null && this.getEntryFlowItem().getDirection() == FundFlowDirection.IN) {
                flowItemInfo.setAmount(this.getAmount().negate());
            } else {
                flowItemInfo.setAmount(this.getAmount());
            }
            journalInfo.getFlowItemEntries().add(flowItemInfo);
        }
    }

    protected abstract String getJournlType();

    protected abstract FundFlowItemInfo getEntryFlowItem();
}

