/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.IAgentPayBill;
import com.kingdee.eas.fi.cas.IsMergencyEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryInfo;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.IBankAgentPayBillBuilder;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.framework.CoreBaseInfo;

public class BankAgentPayBillBuilder
implements IBankAgentPayBillBuilder {
    public BankAgentPayBillInfo getBankAgentPayBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        AgentPayBillInfo info = iAgentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        BankAgentPayBillInfo bankPayInfo = new BankAgentPayBillInfo();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType())) {
            bankPayInfo.setIsAgencyPersonPay(info.getSettlementType().isIsAgencyPersonPay());
        }
        bankPayInfo.setCompany(info.getCompany());
        bankPayInfo.setExpectTransTime(info.getExpectDealTime());
        bankPayInfo.setBizDate(info.getBizDate());
        bankPayInfo.setPayAccountBank(info.getPayBankAccount());
        bankPayInfo.setAgentNumber(info.getNumber());
        bankPayInfo.setCurrency(info.getCurrency());
        bankPayInfo.setAmount(info.getAmount());
        bankPayInfo.setCount(info.getCount());
        bankPayInfo.setConfigurAmount(FMConstants.ZERO);
        bankPayInfo.setConfigureCount(0);
        bankPayInfo.setUsage(info.getUsage());
        bankPayInfo.setIsBitBack(false);
        bankPayInfo.setSourceBillId(info.getId().toString());
        if (info.getSourceType() == SourceTypeEnum.SHR) {
            bankPayInfo.setSourceType(SourceTypeEnum.SHR);
        } else {
            bankPayInfo.setSourceType(SourceTypeEnum.CASH);
        }
        String[] serialNumbers = beServiceHelper.getSerialNumber((int)1);
        bankPayInfo.setSerialNumber(serialNumbers[0]);
        bankPayInfo.setIsEmergency(IsMergencyEnum.mergercy.equals((Object)info.getIsEmergency()));
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            AgentPayBillEntryInfo entryInfo = info.getEntrys().get(i);
            BankAgentPayBillEntryInfo bankEntryInfo = new BankAgentPayBillEntryInfo();
            bankEntryInfo.setSeq(entryInfo.getSeq());
            bankEntryInfo.setRecBankAccount(entryInfo.getRecBankAccount());
            bankEntryInfo.setRecBankName(entryInfo.getRecBankName());
            bankEntryInfo.setRecProvince(entryInfo.getRecProvince());
            bankEntryInfo.setRecCity(entryInfo.getRecCity());
            bankEntryInfo.setRecName(entryInfo.getRecName());
            bankEntryInfo.setCertNum(entryInfo.getCertNum());
            bankEntryInfo.setCertType(entryInfo.getCertType());
            bankEntryInfo.setDifferPlace(entryInfo.getDifferPalace());
            bankEntryInfo.setExpenseType(entryInfo.getExpenseType());
            bankEntryInfo.setAmount(entryInfo.getAmount());
            bankEntryInfo.setRemark(entryInfo.getRemark());
            bankEntryInfo.setSrcBillID(entryInfo.getId().toString());
            serialNumbers = beServiceHelper.getSerialNumber((int)1);
            bankEntryInfo.setSerialNumber(serialNumbers[0]);
            bankEntryInfo.setState(BankPayingBillStateEnum.OS);
            bankEntryInfo.setCBSPayType(entryInfo.getCBSPayType());
            bankEntryInfo.setServiceLevel(entryInfo.getServiceLevel());
            bankPayInfo.getEntrys().add(bankEntryInfo);
        }
        return bankPayInfo;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.ExpenseType"));
        sic.add(new SelectorItemInfo("entrys.RecBank.name"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("settlementType.*"));
        return sic;
    }
}

