/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.IBgCtrlHandler;

public class BgCtrlReceivingBillHandler
implements IBgCtrlHandler {
    public BgCtrlParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        ReceivingBillInfo info = this.getBillInfo(ctx, billId);
        return BgCtrlReceivingBillHandler.getParamColl(info);
    }

    public static BgCtrlParamCollection getParamColl(ReceivingBillInfo info) {
        BgCtrlParamCollection coll = new BgCtrlParamCollection();
        coll.add(BgCtrlReceivingBillHandler.getParam(info));
        if (info.getOppFpItem() != null) {
            BgCtrlParamInfo oppCtrlInfo = BgCtrlReceivingBillHandler.getParam(info);
            oppCtrlInfo.setItemCombinNumber(info.getOppFpItem().getNumber());
            oppCtrlInfo.setItemCombinName(info.getOppFpItem().getName());
            coll.add(oppCtrlInfo);
        }
        return coll;
    }

    private static BgCtrlParamInfo getParam(ReceivingBillInfo info) {
        BgCtrlParamInfo ctrlInfo = new BgCtrlParamInfo();
        if (info.getId() != null) {
            ctrlInfo.setSrcBillId(info.getId().toString());
        }
        ctrlInfo.setSrcBillNumber(info.getNumber());
        ctrlInfo.setOrgUnitId(info.getCompany().getId().toString());
        ctrlInfo.setBizDate(info.getBizDate());
        ctrlInfo.setCurrencyId(info.getCurrency().getId().toString());
        ctrlInfo.setCurrencyNumber(info.getCurrency().getNumber());
        if (info.getFpItem() != null) {
            ctrlInfo.setItemCombinNumber(info.getFpItem().getNumber());
            ctrlInfo.setItemCombinName(info.getFpItem().getName());
        }
        ctrlInfo.setAmount(info.getActRecAmt());
        return ctrlInfo;
    }

    private ReceivingBillInfo getBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        IReceivingBill iReceivingBill = null;
        iReceivingBill = ctx == null ? ReceivingBillFactory.getRemoteInstance() : ReceivingBillFactory.getLocalInstance(ctx);
        return iReceivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        return sic;
    }
}

