/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import org.apache.log4j.Logger;

public class CasContrastGLHelper {
    private static Logger logger = Logger.getLogger((String)CasContrastGLHelper.class.getName());
    public static final int BANKGL = 1;
    public static final int CASHGL = 2;
    public static final int BYDATE = 3;
    public static final int BYPERIOD = 4;
    public static final int BYYEAR = 5;
    public static final String BYGL = "byGL";
    public static final String BYCAS = "byCAS";
    public static final String BYDIFF = "byDiff";
    public static final String BYBAL = "byBal";
    public static final String resourcePath = "com.kingdee.eas.fi.cas.CashContrastGLResource";
    public static final String DATEBEGINBAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"dateBeginBal");
    public static final String DATEDEBITAMT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"dateDebitAmt");
    public static final String DATECREDITAMT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"dateCreditAmt");
    public static final String DATEENDBAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"dateEndBal");
    public static final String PERIODBEGINBAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"periodBeginBal");
    public static final String PERIODDEBITAMT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"periodDebitAmt");
    public static final String PERIODCREDITAMT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"periodCreditAmt");
    public static final String PERIODENDBAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"periodEndBal");
    public static final String YEARBEGINBAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"yearBeginBal");
    public static final String YEARDEBITAMT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"yearDebitAmt");
    public static final String YEARCREDITAMT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"yearCreditAmt");
    public static final String YEARDENDBAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"yearEndBal");
    public static final String YEAR = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"year");
    public static final String PERIOD = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"period");

    public static PeriodInfo getPeriodInfo(int periodYear, int periodNum) {
        PeriodInfo periodInfo = null;
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            periodInfo = PeriodUtils.getPeriodInfo((int)periodYear, (int)periodNum, (CompanyOrgUnitInfo)companyInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException ee) {
            logger.error((Object)ee);
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(int periodYear, int periodNum, CompanyOrgUnitInfo companyInfo) {
        PeriodInfo periodInfo = null;
        try {
            periodInfo = PeriodUtils.getPeriodInfo((int)periodYear, (int)periodNum, (CompanyOrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return periodInfo;
    }

    public static void initComboCurrency(KDComboBox comboCurrency, boolean isSelBaseCurr) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyCollection = iCurrency.getCurrencyCollection(true);
        comboCurrency.removeAllItems();
        if (currencyCollection == null || currencyCollection.size() == 0) {
            return;
        }
        comboCurrency.addItems(currencyCollection.toArray());
        if (isSelBaseCurr) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            CurrencyInfo currency = CasContrastGLHelper.getBaseCurrency(company);
            FMClientHelper.setSelectObject((KDComboBox)comboCurrency, (Object)currency);
        }
    }

    public static void initComboCurrency(KDComboBox comboCurrency, boolean isSelBaseCurr, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyCollection = iCurrency.getCurrencyCollection(true);
        comboCurrency.removeAllItems();
        if (currencyCollection == null || currencyCollection.size() == 0) {
            return;
        }
        comboCurrency.addItems(currencyCollection.toArray());
        if (isSelBaseCurr) {
            CurrencyInfo currency = CasContrastGLHelper.getBaseCurrency(company);
            FMClientHelper.setSelectObject((KDComboBox)comboCurrency, (Object)currency);
        }
    }

    public static void initComboCurrency(KDComboBox comboCurrency, CurrencyCollection currencyCollection, CurrencyInfo baseCurrency, boolean isSelBaseCurr) throws EASBizException, BOSException {
        comboCurrency.removeAllItems();
        if (currencyCollection == null || currencyCollection.size() == 0) {
            return;
        }
        comboCurrency.addItems(currencyCollection.toArray());
        if (isSelBaseCurr) {
            FMClientHelper.setSelectObject((KDComboBox)comboCurrency, (Object)baseCurrency);
        }
    }

    public static void periodNumChange(KDSpinner spinner, CompanyOrgUnitInfo companyInfo, int year) throws Exception {
        int periodNum = Integer.parseInt(spinner.getValue().toString());
        int maxNum = PeriodUtils.getMaxPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
        int minNum = PeriodUtils.getMinPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
        if (periodNum > maxNum) {
            spinner.setValue((Object)new Integer(maxNum));
        }
        if (periodNum < minNum) {
            spinner.setValue((Object)new Integer(minNum));
        }
    }

    public static CurrencyInfo getBaseCurrency(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company);
        return currency;
    }

    public static AccountBankCollection getAccountBankCollection(String strCompanyId) throws BOSException {
        IAccountBank iAcctBank = AccountBankFactory.getRemoteInstance();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bankaccountnumber");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (strCompanyId != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)strCompanyId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankColl = iAcctBank.getAccountBankCollection(viewInfo);
        for (int i = 0; i < acctBankColl.size(); ++i) {
            acctBankColl.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankColl;
    }

    public static AccountBankCollection getAccountBankCollection(String strCompanyId, boolean cancleAccountBank) throws BOSException {
        IAccountBank iAcctBank = AccountBankFactory.getRemoteInstance();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bankaccountnumber");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!cancleAccountBank) {
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)FMConstants.FALSE));
        }
        if (strCompanyId != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)strCompanyId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankColl = iAcctBank.getAccountBankCollection(viewInfo);
        for (int i = 0; i < acctBankColl.size(); ++i) {
            acctBankColl.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankColl;
    }

    public static AccountViewCollection getAccountViewCollection(AccountTypeEnum accountType, String strCompanyId, String strCurrencyId) throws BOSException {
        IAccountView iaccountview = AccountViewFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("companyID", (Object)strCompanyId));
        if (accountType.equals((Object)AccountTypeEnum.CASHACCOUNT)) {
            items.add(new FilterItemInfo("isCash", (Object)"1"));
        } else if (accountType.equals((Object)AccountTypeEnum.BANKACCOUNT) || accountType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
            items.add(new FilterItemInfo("isBank", (Object)"1"));
        }
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
        if (strCurrencyId != null) {
            items.add(new FilterItemInfo("currencyID", (Object)strCurrencyId));
            items.add(new FilterItemInfo("accountingcurrency", (Object)"2"));
            if (accountType.equals((Object)AccountTypeEnum.CASHACCOUNT)) {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and ( #5 or #6 )");
            }
        }
        view.getSorter().add(new SorterItemInfo("number"));
        AccountViewCollection acctViewCol = iaccountview.getAccountViewCollection(view);
        return acctViewCol;
    }
}

