/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.util.Hashtable;

public class CasReportHelper {
    public static final int DATA_YEARSTART = -1;
    public static final int DATA_PERIODSTART = 0;
    public static final int DATA_DATA = 1;
    public static final int DATA_DAYSUM = 2;
    public static final int DATA_PERIODSUM = 3;
    public static final int DATA_YEARSUM = 4;
    public static final String FORBIDDENACCT = "freezeAcctount_Cash";
    public static final BigDecimal ZERO = new BigDecimal("0");
    public static final long DAYMILLIS = 86400000L;

    public static Hashtable parseFilter(EntityViewInfo view) {
        if (view == null || view.getFilter() == null) {
            return null;
        }
        Hashtable<String, Object> filters = new Hashtable<String, Object>();
        FilterItemCollection items = view.getFilter().getFilterItems();
        if (items != null) {
            FilterItemInfo item = null;
            String sFilter = "";
            int n = items.size();
            for (int i = 0; i < n; ++i) {
                item = items.get(i);
                sFilter = item.getPropertyName();
                if (filters.get(sFilter) == null) {
                    filters.put(sFilter, item.getCompareValue());
                    continue;
                }
                filters.put(sFilter + i, item.getCompareValue());
            }
        }
        return filters;
    }

    public static String getLocaleFieldExt(Context ctx) {
        String sExt = "_" + ctx.getLocale().getLanguage();
        return sExt;
    }

    public static PeriodCollection getPeriodCollection(Context ctx, String companyId, Date startDate, Date endDate) throws BOSException, EASBizException {
        PeriodInfo periodInfo;
        if (StringUtils.isEmpty((String)companyId) || startDate == null && endDate == null) {
            return null;
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("Id"));
        selectors.add(new SelectorItemInfo("accountPeriodType"));
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)companyPK, selectors);
        if (companyInfo == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("beginDate", (Object)startDate, CompareType.GREATER_EQUALS));
        items.add(new FilterItemInfo("beginDate", (Object)endDate, CompareType.LESS_EQUALS));
        items.add(new FilterItemInfo("endDate", (Object)startDate, CompareType.GREATER_EQUALS));
        items.add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
        items.add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString()));
        items.add(new FilterItemInfo("isAdjustPeriod", (Object)"0"));
        filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 and #5 ");
        view.setFilter(filter);
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("periodYear"));
        sorters.add(new SorterItemInfo("periodQuarter"));
        sorters.add(new SorterItemInfo("periodNumber"));
        PeriodCollection periods = iPeriod.getPeriodCollection(view);
        if ((periods == null || periods.size() == 0) && (periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)startDate, (IObjectPK)companyPK)) != null) {
            periods = new PeriodCollection();
            periods.add(periodInfo);
        }
        return periods;
    }

    public static final String createTempTable(Context ctx, Connection con, String nameKey, String fieldsDefine) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(30);
        String tempTableName = null;
        tempTableName = ctx == null ? TableManagerFacadeFactory.getRemoteInstance().getTemporaryTableName(nameKey) : TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTemporaryTableName(nameKey);
        sql.append("CREATE TABLE ").append(tempTableName).append(fieldsDefine);
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTable(sql.toString());
        return tempTableName;
    }

    public static final void releasTempTable(Context ctx, String tmpTableName) throws BOSException {
        if (tmpTableName == null || tmpTableName.length() == 0) {
            return;
        }
        ITableManagerFacade iTblMgr = null;
        iTblMgr = ctx == null ? TableManagerFacadeFactory.getRemoteInstance() : TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        iTblMgr.releaseTableName(tmpTableName);
    }

    public static PeriodCollection getYearPeriodc(Context ctx, int year, String companyId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)companyId) || year < 0) {
            return null;
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("accountPeriodType.id"));
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selectors);
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("periodYear", (Object)new Integer(year)));
        items.add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString()));
        items.add(new FilterItemInfo("isAdjustPeriod", (Object)"0"));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("periodYear"));
        sorters.add(new SorterItemInfo("periodQuarter"));
        sorters.add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(view);
        return periodc;
    }
}

