/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fm.nt.BillDisposerAction;
import com.kingdee.eas.fm.nt.IChequeDisposer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;

public class Cheque2PaymentBillDisposer
implements IChequeDisposer {
    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        if (action == null) {
            throw new BOSException(Cheque2PaymentBillDisposer.class.getName() + " param is null");
        }
        String actionType = action.getActionType();
        IObjectPK srcPk = action.getSrcBillPk();
        if (actionType.equals("antiWriteOff")) {
            this.antiWriteOff(ctx, srcPk);
        }
    }

    private boolean canUnPay(Context ctx, String billid) throws BOSException, EASBizException {
        String sql = "SELECT top 1 fid FROM T_CAS_PaymentBill WHERE (FBillStatus = ?) and fid=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(15), billid});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void antiWriteOff(Context ctx, IObjectPK srcPk) throws BOSException, EASBizException {
        String id = srcPk.toString();
        if (this.canUnPay(ctx, id)) {
            IPaymentBill pay = PaymentBillFactory.getLocalInstance(ctx);
            HashSet<String> set = new HashSet<String>();
            set.add(id);
            pay.cancelPay(set);
        }
        String sql = "UPDATE T_CAS_PaymentBill SET FIsRelateCheque = ?, FChequeId = NULL WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0), id});
    }
}

