/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public abstract class DefaultBookNotifyBuilder
implements IBookNotifyBuilder {
    protected String companyId = null;
    protected int cs001 = 0;
    protected int cs072 = 0;
    protected int cs104 = 0;

    protected void updateParams(Context ctx) throws BOSException, EASBizException {
        HashMap param = new HashMap();
        param.put("CS001", this.getCompanyId());
        param.put("CS104", this.getCompanyId());
        param.put("CS072", this.getCompanyId());
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        param = pc.getParamHashMap(param);
        this.cs001 = Integer.parseInt((String)param.get("CS001"));
        if (param.get("CS072") != null) {
            this.cs072 = Integer.parseInt((String)param.get("CS072"));
        }
        if (param.get("CS104") != null) {
            this.cs104 = Integer.parseInt((String)param.get("CS104"));
        }
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        this.updateParams(ctx);
        return new JournalCollection();
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        this.updateParams(ctx);
        return new JournalCollection();
    }

    protected String getCompanyId() {
        return this.companyId;
    }

    protected void setCompanyId(String companyid) {
        this.companyId = companyid;
    }

    protected Date getBookDate_cs104(Context ctx, Date bizDate, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"current Period"});
        }
        Date bookDate = bizDate;
        if (this.cs001 == 0 && this.cs104 == 1) {
            bookDate = new Date();
        }
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }
}

