/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.util.AccountCurrencyVerifyUtil;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JournalVerify {
    public static void verifyJournalsForDelete(Context ctx, JournalCollection journals) throws BOSException, EASBizException, CasException {
        if (journals == null || journals.size() == 0) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = journals.get(0).getCompany();
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new CasException(CasException.NOSTARTPERIOD);
        }
        for (int i = 0; i < journals.size(); ++i) {
            JournalInfo journal = journals.get(i);
            Date createDate = journal.getCreateDate();
            if (createDate.before(currPeriodInfo.getBeginDate())) {
                throw new CasException(CasException.HASCHECKOUT);
            }
            if (!journal.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) {
                throw new CasException(CasException.HASVERIFY);
            }
            if (journal.isIsOnlineVCCheque() || BillTypeEnum.paymentBill.equals((Object)journal.getBillType()) || BillTypeEnum.Cheque.equals((Object)journal.getBillType()) || BillTypeEnum.TeleOrder.equals((Object)journal.getBillType()) || FMHelper.isEmpty((String)journal.getTicketNumber())) continue;
            throw new CasException(CasException.HASVC);
        }
    }

    public static void verifyJournalForAdd(Context ctx, JournalInfo journal) throws EASBizException, BOSException {
        AccountViewInfo accountView;
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)journal.getCompany());
        if (journal.getBillType() != null && journal.getBillType().getValue() == 0) {
            journal.setNull("billType");
        }
        if (journal.getDebitAmount() == null) {
            journal.setDebitAmount(FMConstants.ZERO);
        }
        if (journal.getCreditAmount() == null) {
            journal.setCreditAmount(FMConstants.ZERO);
        }
        if (journal.getDebitAmount().signum() != 0) {
            journal.setIsDebit(true);
        } else {
            journal.setIsDebit(false);
        }
        if (journal.getPeriod() == null) {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)journal.getCompany());
            if (!journal.getCreateDate().before(startPeriod.getBeginDate())) {
                throw new CasException(CasException.PERIODMUSTBEFORE);
            }
            if (journal.getType().equals((Object)JournalTypeEnum.CASH)) {
                throw new CasException(CasException.CASHJOURNALBEFORESTART);
            }
        } else {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)journal.getCreateDate(), (CompanyOrgUnitInfo)journal.getCompany());
            if (period == null || period.getId() == null) {
                throw new CasException(CasException.PERIODISNULL);
            }
            journal.setPeriod(period);
            if (!PeriodUtils.PeriodCompare((PeriodInfo)period, (PeriodInfo)currPeriodInfo)) {
                throw new CasException(CasException.BEFORECURRENTPERIOD);
            }
        }
        if ((accountView = journal.getAccountView()) == null) {
            throw new CasException(CasException.ACCT_NULL);
        }
        accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId()));
        if (!accountView.isIsBank() && !accountView.isIsCash()) {
            throw new CasException(CasException.ACCT_NOTCASBANK, new Object[]{accountView.getNumber()});
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journal, (String)"bizDate");
        if (journal.getBizDate().after(journal.getCreateDate())) {
            journal.setBizDate(journal.getCreateDate());
        }
        if (journal.getType().equals((Object)JournalTypeEnum.BANK)) {
            if (journal.getAccountBank() == null) {
                throw new CasException(CasException.BANKACCT_NULL);
            }
            String acctBankId = journal.getAccountBank().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isClosed"));
            sic.add(new SelectorItemInfo("account.id"));
            sic.add(new SelectorItemInfo("account.isCFreeze"));
            sic.add(new SelectorItemInfo("company.id"));
            AccountBankInfo acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)acctBankId)), sic);
            if (acctBank.isIsClosed()) {
                throw new CasException(CasException.ACCTBANKCLOSE);
            }
            if (acctBank.getAccount() == null) {
                throw new CasException(CasException.ACCT_NOTIDTIWITHBANK);
            }
            if (acctBank.getAccount().isIsCFreeze()) {
                throw new RecPayException(RecPayException.ACCT_IS_FREEZE);
            }
            if (!acctBank.getAccount().getId().equals((Object)accountView.getId())) {
                throw new CasException(CasException.ACCT_NOTIDTIWITHBANK);
            }
            if (!acctBank.getCompany().getId().equals((Object)journal.getCompany().getId())) {
                throw new CasException(CasException.COMPANY_NOTIDTIWITHBANK);
            }
        }
        AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)ctx, (String)accountView.getId().toString(), (String)journal.getCurrency().getId().toString(), (CompanyOrgUnitInfo)journal.getCompany());
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journal, (String)"company");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journal, (String)"verifyStatus");
        journal.setHasEffected(true);
    }

    public static void verifyJournalForAdd(Context ctx, IObjectCollection journalColl) throws EASBizException, BOSException {
        int i;
        HashSet<String> acctViewIdSet = new HashSet<String>();
        HashSet<String> acctBankIdSet = new HashSet<String>();
        JournalInfo journal = null;
        int size = journalColl.size();
        for (int i2 = 0; i2 < size; ++i2) {
            journal = (JournalInfo)journalColl.getObject(i2);
            if (journal.getAccountView() == null) {
                throw new CasException(CasException.ACCT_NULL);
            }
            acctViewIdSet.add(journal.getAccountView().getId().toString());
            if (!journal.getType().equals((Object)JournalTypeEnum.BANK)) continue;
            if (journal.getAccountBank() == null) {
                throw new CasException(CasException.BANKACCT_NULL);
            }
            acctBankIdSet.add(journal.getAccountBank().getId().toString());
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        AccountViewCollection acctViewColl = JournalVerify.getAcctViewColl(ctx, acctViewIdSet);
        AccountBankCollection acctBankColl = JournalVerify.getAcctBankColl(ctx, acctBankIdSet);
        AccountViewInfo acctView = null;
        AccountBankInfo acctBank = null;
        HashMap<String, AccountViewInfo> acctViewMap = new HashMap<String, AccountViewInfo>();
        int size2 = acctViewColl.size();
        for (int i3 = 0; i3 < size2; ++i3) {
            acctView = acctViewColl.get(i3);
            acctViewMap.put(acctView.getId().toString(), acctView);
        }
        HashMap<String, AccountBankInfo> acctBankMap = new HashMap<String, AccountBankInfo>();
        int size3 = acctBankColl.size();
        for (i = 0; i < size3; ++i) {
            acctBank = acctBankColl.get(i);
            acctBankMap.put(acctBank.getId().toString(), acctBank);
        }
        size3 = journalColl.size();
        for (i = 0; i < size3; ++i) {
            journal = (JournalInfo)journalColl.getObject(i);
            acctView = (AccountViewInfo)acctViewMap.get(journal.getAccountView().getId().toString());
            if (journal.getType().equals((Object)JournalTypeEnum.BANK)) {
                acctBank = (AccountBankInfo)acctBankMap.get(journal.getAccountBank().getId().toString());
            }
            JournalVerify.verifyJournalForAdd(ctx, journal, acctView, acctBank, startPeriod, currentCompany.getBaseCurrency().getId().toString());
        }
    }

    private static AccountViewCollection getAcctViewColl(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return new AccountViewCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.id"));
        sic.add(new SelectorItemInfo("accountCurrency.currency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        return AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(evi);
    }

    private static AccountBankCollection getAcctBankColl(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return new AccountBankCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.isCFreeze"));
        sic.add(new SelectorItemInfo("company.id"));
        return AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
    }

    public static void verifyJournalForAdd(Context ctx, JournalInfo journal, AccountViewInfo acctView, AccountBankInfo acctBank, PeriodInfo startPeriod, String baseCurrencyId) throws EASBizException, BOSException {
        AccountViewInfo accountView;
        if (journal.getBillType() != null && journal.getBillType().getValue() == 0) {
            journal.setNull("billType");
        }
        if (journal.getDebitAmount() == null) {
            journal.setDebitAmount(FMConstants.ZERO);
        }
        if (journal.getCreditAmount() == null) {
            journal.setCreditAmount(FMConstants.ZERO);
        }
        if (journal.getDebitAmount().signum() != 0) {
            journal.setIsDebit(true);
        } else {
            journal.setIsDebit(false);
        }
        if (journal.getPeriod() == null) {
            if (!journal.getCreateDate().before(startPeriod.getBeginDate())) {
                throw new BOSException("unreached journal's createDate must before startedperiod's beginDate");
            }
        } else {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)journal.getCreateDate(), (CompanyOrgUnitInfo)journal.getCompany());
            if (period == null || period.getId() == null) {
                throw new BOSException("period is not exist");
            }
            if (!period.getId().equals((Object)journal.getPeriod().getId())) {
                journal.setPeriod(period);
            }
        }
        if ((accountView = acctView) == null) {
            throw new CasException(CasException.ACCT_NULL);
        }
        if (!accountView.isIsBank() && !accountView.isIsCash()) {
            throw new CasException(CasException.ACCT_NOTCASBANK, new Object[]{accountView.getNumber()});
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journal, (String)"bizDate");
        if (journal.getBizDate().after(journal.getCreateDate())) {
            journal.setBizDate(journal.getCreateDate());
        }
        if (journal.getType().equals((Object)JournalTypeEnum.BANK)) {
            if (journal.getAccountBank() == null) {
                throw new CasException(CasException.BANKACCT_NULL);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isClosed"));
            sic.add(new SelectorItemInfo("account.id"));
            sic.add(new SelectorItemInfo("account.isCFreeze"));
            sic.add(new SelectorItemInfo("company.id"));
            if (acctBank.isIsClosed()) {
                throw new CasException(CasException.ACCTBANKCLOSE);
            }
            if (acctBank.getAccount() == null) {
                throw new CasException(CasException.ACCT_NOTIDTIWITHBANK);
            }
            if (acctBank.getAccount().isIsCFreeze()) {
                throw new RecPayException(RecPayException.ACCT_IS_FREEZE);
            }
            if (!acctBank.getAccount().getId().equals((Object)accountView.getId())) {
                throw new CasException(CasException.ACCT_NOTIDTIWITHBANK);
            }
            if (!acctBank.getCompany().getId().equals((Object)journal.getCompany().getId())) {
                throw new CasException(CasException.COMPANY_NOTIDTIWITHBANK);
            }
        }
        AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)ctx, (AccountViewInfo)acctView, (String)journal.getCurrency().getId().toString(), (String)baseCurrencyId);
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journal, (String)"company");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journal, (String)"verifyStatus");
        journal.setHasEffected(true);
    }
}

