/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IGenSettlementBillBuilder;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import java.sql.Timestamp;
import java.util.Set;

public class PayGenSettleBillBuilder
implements IGenSettlementBillBuilder {
    public SettlementBillCollection getSettlementBillColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            throw new NullPointerException("The Set of Bill ID is NULL!");
        }
        SettlementBillCollection destColl = new SettlementBillCollection();
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
        PaymentBillInfo srcInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("payerAccountBank.*");
        ev.getSelector().addObjectCollection((IObjectCollection)selector);
        PaymentBillCollection srcColl = iPaymentBill.getPaymentBillCollection(ev);
        for (int i = 0; i < srcColl.size(); ++i) {
            srcInfo = srcColl.get(i);
            SettlementBillInfo destInfo = this.trans2SettlementBill(ctx, srcInfo);
            destColl.add(destInfo);
        }
        return destColl;
    }

    private SettlementBillInfo trans2SettlementBill(Context ctx, PaymentBillInfo srcInfo) throws BOSException, EASBizException {
        UserInfo userInfo = null;
        CtrlUnitInfo cuInfo = null;
        userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        cuInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
        SettlementBillInfo destInfo = new SettlementBillInfo();
        destInfo.setId(BOSUuid.create((BOSObjectType)destInfo.getBOSType()));
        destInfo.setApplyUnit(srcInfo.getCompany());
        destInfo.setType(srcInfo.getSettleBizType());
        if (srcInfo.getPayerAccountBank() != null) {
            destInfo.setPayerInnerAcct(srcInfo.getPayerAccountBank().getInnerAcct());
        }
        if (destInfo.getPayerBankAcct() != null) {
            // empty if block
        }
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setAmount(srcInfo.getActPayAmt());
        destInfo.setExchange(FMConstants.ONE);
        String number = srcInfo.getNumber() == null ? "" : srcInfo.getNumber();
        String payeeBank = srcInfo.getPayeeBank() == null ? "" : srcInfo.getPayeeBank();
        String payeeAccountBank = srcInfo.getPayeeAccountBank() == null ? "" : srcInfo.getPayeeAccountBank();
        String description = srcInfo.getDescription() == null ? "" : srcInfo.getDescription();
        destInfo.setDescription(number + payeeBank + payeeAccountBank + description);
        destInfo.setSourceBillId(srcInfo.getId().toString());
        destInfo.setBizDate(srcInfo.getBizDate());
        destInfo.setFiVouchered(false);
        destInfo.setCreator(userInfo);
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        destInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        destInfo.setLastUpdateUser(userInfo);
        destInfo.setCU(cuInfo);
        destInfo.setCompany(FSHelper.getClearingHouseInfo((Context)ctx, null).getRelatedCompany());
        destInfo.setIsAccepted(false);
        destInfo.setHasEffected(false);
        destInfo.setIsGenPaymentBill(true);
        destInfo.setIsGenReceivingBill(false);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(srcInfo.getCompany().getId()));
        destInfo.setPayerFullName(company.getName());
        String payeeName = srcInfo.getPayeeName() == null ? "" : srcInfo.getPayeeName();
        destInfo.setPayeeFullName(payeeName);
        this.verifyInfo(ctx, destInfo);
        return destInfo;
    }

    private void verifyInfo(Context ctx, SettlementBillInfo info) throws EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"amount");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"applyUnit");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"type");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"exchange");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"description");
        if (info.getAmount().signum() <= 0) {
            throw new FSException(FSException.AMOUNTBIGGERZERO);
        }
        if (info.getPayeeBankAcct() != null && info.getPayeeInnerAcct() == null) {
            throw new FSException(FSException.BANKACCTNOINNERACCT);
        }
        if (info.getPayerBankAcct() != null && info.getPayerInnerAcct() == null) {
            throw new FSException(FSException.BANKACCTNOINNERACCT);
        }
    }
}

